/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.numeric;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import java.math.BigInteger;
import org.truffleruby.core.CoreLibrary;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.cast.FloatToIntegerNode;
import org.truffleruby.core.numeric.BigIntegerOps;
import org.truffleruby.core.numeric.FixnumOrBignumNode;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.control.RaiseException;

@GenerateInline
@GenerateCached(value=false)
public abstract class GeneralDivModNode
extends RubyBaseNode {
    public abstract RubyArray execute(Node var1, Object var2, Object var3);

    @Specialization
    static RubyArray doLongs(Node node, long a, long b, @Cached @Cached.Shared InlinedBranchProfile bZeroProfile, @Cached @Cached.Exclusive InlinedBranchProfile bMinusOneProfile, @Cached @Cached.Exclusive InlinedBranchProfile useFixnumPairProfile, @Cached @Cached.Exclusive InlinedBranchProfile useObjectPairProfile, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumQuotient) {
        long mod;
        Number integerDiv;
        if (b == 0L) {
            bZeroProfile.enter(node);
            throw new RaiseException(GeneralDivModNode.getContext(node), GeneralDivModNode.coreExceptions(node).zeroDivisionError(node));
        }
        if (b == -1L) {
            bMinusOneProfile.enter(node);
            integerDiv = a == Long.MIN_VALUE ? BigIntegerOps.negate(a) : Long.valueOf(-a);
            mod = 0L;
        } else {
            long div = a / b;
            mod = a - b * div;
            if (mod < 0L && b > 0L || mod > 0L && b < 0L) {
                --div;
                mod += b;
            }
            integerDiv = div;
        }
        if (integerDiv instanceof Long && CoreLibrary.fitsIntoInteger((Long)integerDiv) && CoreLibrary.fitsIntoInteger(mod)) {
            useFixnumPairProfile.enter(node);
            return GeneralDivModNode.createArray(node, new int[]{(int)((Long)integerDiv).longValue(), (int)mod});
        }
        if (integerDiv instanceof Long) {
            useObjectPairProfile.enter(node);
            return GeneralDivModNode.createArray(node, new long[]{(Long)integerDiv, mod});
        }
        useObjectPairProfile.enter(node);
        return GeneralDivModNode.createArray(node, new Object[]{fixnumOrBignumQuotient.execute(node, (BigInteger)integerDiv), mod});
    }

    @Specialization
    static RubyArray doLongAndBigInt(Node node, long a, BigInteger b, @Cached @Cached.Shared InlinedBranchProfile bZeroProfile, @Cached @Cached.Shared InlinedBranchProfile bigIntegerFixnumProfile, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumQuotient, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumRemainder) {
        return GeneralDivModNode.divMod(node, BigIntegerOps.valueOf(a), b, bZeroProfile, bigIntegerFixnumProfile, fixnumOrBignumQuotient, fixnumOrBignumRemainder);
    }

    @Specialization
    static RubyArray doLongAndDouble(Node node, long a, double b, @Cached @Cached.Shared InlinedBranchProfile bZeroProfile, @Cached @Cached.Shared InlinedBranchProfile nanProfile, @Cached @Cached.Shared FloatToIntegerNode floatToIntegerNode) {
        return GeneralDivModNode.divMod(node, a, b, bZeroProfile, nanProfile, floatToIntegerNode);
    }

    @Specialization
    static RubyArray doBigIntAndLong(Node node, BigInteger a, long b, @Cached @Cached.Shared InlinedBranchProfile bZeroProfile, @Cached @Cached.Shared InlinedBranchProfile bigIntegerFixnumProfile, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumQuotient, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumRemainder) {
        return GeneralDivModNode.divMod(node, a, BigIntegerOps.valueOf(b), bZeroProfile, bigIntegerFixnumProfile, fixnumOrBignumQuotient, fixnumOrBignumRemainder);
    }

    @Specialization
    static RubyArray doBigInts(Node node, BigInteger a, BigInteger b, @Cached @Cached.Shared InlinedBranchProfile bZeroProfile, @Cached @Cached.Shared InlinedBranchProfile bigIntegerFixnumProfile, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumQuotient, @Cached @Cached.Shared FixnumOrBignumNode fixnumOrBignumRemainder) {
        return GeneralDivModNode.divMod(node, a, b, bZeroProfile, bigIntegerFixnumProfile, fixnumOrBignumQuotient, fixnumOrBignumRemainder);
    }

    @Specialization
    static RubyArray doBigIntAndDouble(Node node, BigInteger a, double b, @Cached @Cached.Shared InlinedBranchProfile bZeroProfile, @Cached @Cached.Shared InlinedBranchProfile nanProfile, @Cached @Cached.Shared FloatToIntegerNode floatToIntegerNode) {
        return GeneralDivModNode.divMod(node, BigIntegerOps.doubleValue(a), b, bZeroProfile, nanProfile, floatToIntegerNode);
    }

    @Specialization
    static RubyArray doDoubleAndLong(Node node, double a, long b, @Cached @Cached.Shared InlinedBranchProfile bZeroProfile, @Cached @Cached.Shared InlinedBranchProfile nanProfile, @Cached @Cached.Shared FloatToIntegerNode floatToIntegerNode) {
        return GeneralDivModNode.divMod(node, a, b, bZeroProfile, nanProfile, floatToIntegerNode);
    }

    @Specialization
    static RubyArray doDoubleAndBigInt(Node node, double a, BigInteger b, @Cached @Cached.Shared InlinedBranchProfile bZeroProfile, @Cached @Cached.Shared InlinedBranchProfile nanProfile, @Cached @Cached.Shared FloatToIntegerNode floatToIntegerNode) {
        return GeneralDivModNode.divMod(node, a, BigIntegerOps.doubleValue(b), bZeroProfile, nanProfile, floatToIntegerNode);
    }

    @Specialization
    static RubyArray doDoubles(Node node, double a, double b, @Cached @Cached.Shared InlinedBranchProfile bZeroProfile, @Cached @Cached.Shared InlinedBranchProfile nanProfile, @Cached @Cached.Shared FloatToIntegerNode floatToIntegerNode) {
        return GeneralDivModNode.divMod(node, a, b, bZeroProfile, nanProfile, floatToIntegerNode);
    }

    @CompilerDirectives.TruffleBoundary
    private static RubyArray divMod(Node node, double a, double b, InlinedBranchProfile bZeroProfile, InlinedBranchProfile nanProfile, FloatToIntegerNode floatToIntegerNode) {
        if (b == 0.0) {
            bZeroProfile.enter(node);
            throw new RaiseException(GeneralDivModNode.getContext(node), GeneralDivModNode.coreExceptions(node).zeroDivisionError(node));
        }
        double mod = Math.IEEEremainder(a, b);
        if (Double.isNaN(mod)) {
            nanProfile.enter(node);
            throw new RaiseException(GeneralDivModNode.getContext(node), GeneralDivModNode.coreExceptions(node).floatDomainError("NaN", node));
        }
        double div = Math.floor(a / b);
        if (b * mod < 0.0) {
            mod += b;
        }
        return GeneralDivModNode.createArray(node, new Object[]{floatToIntegerNode.execute(node, div), mod});
    }

    @CompilerDirectives.TruffleBoundary
    private static RubyArray divMod(Node node, BigInteger a, BigInteger b, InlinedBranchProfile bZeroProfile, InlinedBranchProfile bigIntegerFixnumProfile, FixnumOrBignumNode fixnumOrBignumQuotient, FixnumOrBignumNode fixnumOrBignumRemainder) {
        if (b.signum() == 0) {
            bZeroProfile.enter(node);
            throw new RaiseException(GeneralDivModNode.getContext(node), GeneralDivModNode.coreExceptions(node).zeroDivisionError(node));
        }
        BigInteger[] bigIntegerResults = a.divideAndRemainder(b);
        if (a.signum() * b.signum() == -1 && bigIntegerResults[1].signum() != 0) {
            bigIntegerFixnumProfile.enter(node);
            bigIntegerResults[0] = bigIntegerResults[0].subtract(BigInteger.ONE);
            bigIntegerResults[1] = b.add(bigIntegerResults[1]);
        }
        return GeneralDivModNode.createArray(node, new Object[]{fixnumOrBignumQuotient.execute(node, bigIntegerResults[0]), fixnumOrBignumRemainder.execute(node, bigIntegerResults[1])});
    }
}

