/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.monitor;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.mutex.MutexOperations;
import org.truffleruby.core.mutex.RubyMutex;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.thread.RubyThread;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.yield.CallBlockNode;

@CoreModule(value="Truffle::MonitorOperations")
public abstract class TruffleMonitorNodes {

    @Primitive(name="monitor_exit")
    public static abstract class MonitorExit
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object exit(RubyMutex mutex, @Cached InlinedBranchProfile errorProfile) {
            RubyThread thread = this.getLanguage().getCurrentThread();
            MutexOperations.checkOwnedMutex(this.getContext(), mutex.lock, this, errorProfile);
            MutexOperations.unlock(mutex.lock, thread);
            return mutex;
        }
    }

    @Primitive(name="monitor_enter")
    public static abstract class MonitorEnter
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object enter(RubyMutex mutex) {
            RubyThread thread = this.getLanguage().getCurrentThread();
            MutexOperations.lock(this.getContext(), mutex.lock, thread, this);
            return nil;
        }
    }

    @Primitive(name="monitor_try_enter")
    public static abstract class MonitorTryEnter
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object tryEnter(RubyMutex mutex) {
            RubyThread thread = this.getLanguage().getCurrentThread();
            return MutexOperations.tryLock(mutex.lock, thread);
        }
    }

    @Primitive(name="monitor_synchronize")
    public static abstract class SynchronizeNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private CallBlockNode yieldNode = CallBlockNode.create();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        Object synchronizeOnMutex(RubyMutex mutex, RubyProc block, @Cached InlinedBranchProfile errorProfile) {
            RubyThread thread = this.getLanguage().getCurrentThread();
            MutexOperations.lock(this.getContext(), mutex.lock, thread, this);
            try {
                Object object = this.yieldNode.yield(block, new Object[0]);
                return object;
            }
            finally {
                MutexOperations.checkOwnedMutex(this.getContext(), mutex.lock, this, errorProfile);
                MutexOperations.unlock(mutex.lock, thread);
            }
        }

        @Specialization(guards={"!isRubyProc(block)"})
        Object synchronizeOnMutexNoBlock(RubyMutex mutex, Object block) {
            throw new RaiseException(this.getContext(), this.coreExceptions().localJumpError("no block given", this));
        }
    }
}

