/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.module;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Set;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.core.CoreLibrary;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.module.ModuleFields;
import org.truffleruby.core.module.ModuleOperations;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.objects.IsANode;
import org.truffleruby.language.objects.ObjectGraph;
import org.truffleruby.language.objects.ObjectGraphNode;
import org.truffleruby.language.objects.SingletonClassNode;

@ExportLibrary(value=InteropLibrary.class)
public class RubyModule
extends RubyDynamicObject
implements ObjectGraphNode {
    public static final RubyModule[] EMPTY_ARRAY = new RubyModule[0];
    public final ModuleFields fields;
    @DynamicObject.DynamicField
    private long primitive1;
    @DynamicObject.DynamicField
    private long primitive2;
    @DynamicObject.DynamicField
    private long primitive3;
    @DynamicObject.DynamicField
    private Object object1;
    @DynamicObject.DynamicField
    private Object object2;
    @DynamicObject.DynamicField
    private Object object3;
    @DynamicObject.DynamicField
    private Object object4;

    public RubyModule(RubyClass rubyClass, Shape shape, RubyLanguage language, SourceSection sourceSection, RubyModule lexicalParent, String givenBaseName) {
        super(rubyClass, shape);
        this.fields = new ModuleFields(language, sourceSection, lexicalParent, givenBaseName, this);
    }

    protected RubyModule(RubyLanguage language, Shape classShape, String constructorOnlyForClassClass) {
        super(classShape, constructorOnlyForClassClass);
        this.fields = new ModuleFields(language, null, null, "Class", this);
    }

    public String getName() {
        return this.fields.getName();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.fields.getName();
    }

    @CompilerDirectives.TruffleBoundary
    public void addMethodConsiderNameVisibility(RubyContext context, InternalMethod method, Visibility visibility, Node currentNode) {
        if (ModuleOperations.isMethodPrivateFromName(method.getName())) {
            visibility = Visibility.PRIVATE;
        }
        this.addMethodIgnoreNameVisibility(context, method, visibility, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public void addMethodIgnoreNameVisibility(RubyContext context, InternalMethod method, Visibility visibility, Node currentNode) {
        if (visibility == Visibility.MODULE_FUNCTION) {
            this.fields.addMethod(context, currentNode, method.withVisibility(Visibility.PRIVATE));
            RubyClass singletonClass = SingletonClassNode.getUncached().execute(this);
            singletonClass.fields.addMethod(context, currentNode, method.withDeclaringModule(singletonClass).withOwner(singletonClass).withVisibility(Visibility.PUBLIC));
        } else {
            this.fields.addMethod(context, currentNode, method.withVisibility(visibility));
        }
    }

    @Override
    public void getAdjacentObjects(Set<Object> reachable) {
        ObjectGraph.addProperty(reachable, this.fields);
    }

    @ExportMessage
    public boolean isMetaObject() {
        return true;
    }

    @ExportMessage
    public String getMetaQualifiedName() {
        return this.fields.getName();
    }

    @ExportMessage
    public String getMetaSimpleName() {
        return this.fields.getSimpleName();
    }

    @ExportMessage
    public boolean isMetaInstance(Object instance, @Cached IsANode isANode) {
        return isANode.executeIsA(instance, this);
    }

    @ExportMessage
    public boolean hasSourceLocation() {
        return true;
    }

    @ExportMessage
    public SourceSection getSourceLocation() {
        SourceSection sourceSection = this.fields.getSourceSection();
        if (sourceSection != null) {
            return sourceSection;
        }
        return CoreLibrary.UNAVAILABLE_SOURCE_SECTION;
    }
}

