/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.method;

import com.oracle.truffle.api.CompilerDirectives;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.language.methods.InternalMethod;

public abstract class MethodFilter {
    public static final MethodFilter PUBLIC = new MethodFilter(){

        @Override
        public boolean filter(InternalMethod method) {
            return method.getVisibility() == Visibility.PUBLIC;
        }
    };
    public static final MethodFilter PUBLIC_PROTECTED = new MethodFilter(){

        @Override
        public boolean filter(InternalMethod method) {
            return method.getVisibility() == Visibility.PUBLIC || method.getVisibility() == Visibility.PROTECTED;
        }
    };
    public static final MethodFilter PROTECTED = new MethodFilter(){

        @Override
        public boolean filter(InternalMethod method) {
            return method.getVisibility() == Visibility.PROTECTED;
        }
    };
    public static final MethodFilter PRIVATE = new MethodFilter(){

        @Override
        public boolean filter(InternalMethod method) {
            return method.getVisibility() == Visibility.PRIVATE;
        }
    };

    private MethodFilter() {
    }

    public abstract boolean filter(InternalMethod var1);

    public static MethodFilter by(Visibility visibility) {
        switch (visibility) {
            case PUBLIC: {
                return PUBLIC;
            }
            case PROTECTED: {
                return PROTECTED;
            }
            case PRIVATE: {
                return PRIVATE;
            }
        }
        throw CompilerDirectives.shouldNotReachHere((String)("unsupported visibility: " + visibility));
    }
}

