/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.kernel;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.IOException;
import org.graalvm.collections.Pair;
import org.truffleruby.Layouts;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Split;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.basicobject.RubyBasicObject;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.kernel.TruffleKernelNodesFactory;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.string.TStringWithEncoding;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.arguments.ReadCallerVariablesIfAvailableNode;
import org.truffleruby.language.arguments.ReadCallerVariablesNode;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.globals.ReadSimpleGlobalVariableNode;
import org.truffleruby.language.globals.WriteSimpleGlobalVariableNode;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.loader.CodeLoader;
import org.truffleruby.language.loader.FileLoader;
import org.truffleruby.language.locals.FindDeclarationVariableNodes;
import org.truffleruby.language.methods.DeclarationContext;
import org.truffleruby.language.threadlocal.SpecialVariableStorage;
import org.truffleruby.parser.ParserContext;
import org.truffleruby.parser.RubySource;

@CoreModule(value="Truffle::KernelOperations")
public abstract class TruffleKernelNodes {
    public static int declarationDepth(Frame topFrame) {
        MaterializedFrame nextFrame;
        MaterializedFrame frame = topFrame.materialize();
        int count = 0;
        while ((nextFrame = RubyArguments.getDeclarationFrame((Frame)frame)) != null) {
            frame = nextFrame;
            ++count;
        }
        return count;
    }

    @Primitive(name="io_last_line_get")
    public static abstract class GetLastIO
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object getLastIO(SpecialVariableStorage storage, @Cached InlinedConditionProfile unsetProfile, @Cached InlinedConditionProfile sameThreadProfile) {
            return storage.getLastLine(this, unsetProfile, sameThreadProfile);
        }
    }

    @Primitive(name="io_last_line_set")
    public static abstract class SetLastIO
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object setRegexpMatch(SpecialVariableStorage variables, Object lastIO, @Cached InlinedConditionProfile unsetProfile, @Cached InlinedConditionProfile sameThreadProfile) {
            variables.setLastLine(this, lastIO, this.getContext(), unsetProfile, sameThreadProfile);
            return lastIO;
        }
    }

    @Primitive(name="regexp_last_match_get")
    public static abstract class GetRegexpMatch
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object getRegexpMatch(SpecialVariableStorage variables, @Cached InlinedConditionProfile unsetProfile, @Cached InlinedConditionProfile sameThreadProfile) {
            return variables.getLastMatch(this, unsetProfile, sameThreadProfile);
        }
    }

    @Primitive(name="regexp_last_match_set")
    public static abstract class SetRegexpMatch
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object setRegexpMatch(SpecialVariableStorage variables, Object lastMatch, @Cached InlinedConditionProfile unsetProfile, @Cached InlinedConditionProfile sameThreadProfile) {
            variables.setLastMatch(this, lastMatch, this.getContext(), unsetProfile, sameThreadProfile);
            return lastMatch;
        }
    }

    @Primitive(name="share_special_variables")
    @ImportStatic(value={TruffleKernelNodes.class})
    public static abstract class ShareSpecialVariableStorage
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"frame.getFrameDescriptor() == descriptor"}, limit="1")
        Object shareSpecialVariable(VirtualFrame frame, SpecialVariableStorage storage, @Cached(value="frame.getFrameDescriptor()") FrameDescriptor descriptor, @Cached(value="declarationDepth(frame)") int declarationFrameDepth) {
            Frame storageFrame = RubyArguments.getDeclarationFrame((Frame)frame, declarationFrameDepth);
            SpecialVariableStorage.set(storageFrame, storage);
            return nil;
        }

        @Specialization(replaces={"shareSpecialVariable"})
        Object slowPath(VirtualFrame frame, SpecialVariableStorage storage) {
            return this.shareSlow(frame.materialize(), storage);
        }

        @CompilerDirectives.TruffleBoundary
        public Object shareSlow(MaterializedFrame aFrame, SpecialVariableStorage storage) {
            MaterializedFrame frame = FindDeclarationVariableNodes.getOuterDeclarationFrame(aFrame);
            SpecialVariableStorage.set((Frame)frame, storage);
            return nil;
        }

        public static GetSpecialVariableStorage create() {
            return TruffleKernelNodesFactory.GetSpecialVariableStorageNodeGen.create();
        }
    }

    @Primitive(name="proc_special_variables")
    public static abstract class GetProcSpecialVariableStorage
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object variables(RubyProc proc) {
            return proc.declarationVariables;
        }
    }

    @Primitive(name="get_original_require")
    @ImportStatic(value={Layouts.class})
    public static abstract class GetOriginalRequireNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private TruffleString.FromJavaStringNode fromJavaStringNode = TruffleString.FromJavaStringNode.create();

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object getOriginalRequire(Object string, @Cached RubyStringLibrary strings) {
            String originalRequire = (String)this.getContext().getCoreLibrary().getOriginalRequires().get(RubyGuards.getJavaString(string));
            if (originalRequire == null) {
                return Nil.INSTANCE;
            }
            return this.createString(this.fromJavaStringNode, originalRequire, Encodings.UTF_8);
        }
    }

    @Primitive(name="caller_special_variables_if_available")
    public static abstract class GetCallerSpecialVariableStorageIfFast
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        ReadCallerVariablesIfAvailableNode callerVariablesNode = new ReadCallerVariablesIfAvailableNode();

        @Specialization
        Object storage(VirtualFrame frame, @Cached InlinedConditionProfile nullProfile) {
            SpecialVariableStorage variables = this.callerVariablesNode.execute((Frame)frame);
            if (nullProfile.profile((Node)this, variables == null)) {
                return nil;
            }
            return variables;
        }
    }

    @Primitive(name="caller_special_variables")
    public static abstract class GetCallerSpecialVariableStorage
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        ReadCallerVariablesNode callerVariablesNode = new ReadCallerVariablesNode();

        @Specialization
        Object storage(VirtualFrame frame) {
            return this.callerVariablesNode.execute((Frame)frame);
        }
    }

    @ImportStatic(value={TruffleKernelNodes.class})
    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    public static abstract class GetSpecialVariableStorage
    extends RubyBaseNode {
        @NeverDefault
        public static GetSpecialVariableStorage create() {
            return TruffleKernelNodesFactory.GetSpecialVariableStorageNodeGen.create();
        }

        public final SpecialVariableStorage executeCached(Frame frame) {
            return this.execute(frame, this);
        }

        public static SpecialVariableStorage executeUncached(Frame frame) {
            return TruffleKernelNodesFactory.GetSpecialVariableStorageNodeGen.getUncached().execute(frame, null);
        }

        public abstract SpecialVariableStorage execute(Frame var1, Node var2);

        @Specialization(guards={"frame.getFrameDescriptor() == descriptor"}, limit="1")
        static SpecialVariableStorage getFromKnownFrameDescriptor(Frame frame, @Cached(value="frame.getFrameDescriptor()") FrameDescriptor descriptor, @Cached(value="declarationDepth(frame)") int declarationFrameDepth) {
            Object variables;
            Frame storageFrame = RubyArguments.getDeclarationFrame(frame, declarationFrameDepth);
            if (storageFrame == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                GetSpecialVariableStorage.noStorageFrameError(frame, declarationFrameDepth);
            }
            if ((variables = SpecialVariableStorage.get(storageFrame)) == nil) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                variables = GetSpecialVariableStorage.initializeSpecialVariablesSlot(storageFrame);
            }
            return (SpecialVariableStorage)variables;
        }

        @Specialization(replaces={"getFromKnownFrameDescriptor"})
        static SpecialVariableStorage slowPath(Frame frame) {
            return GetSpecialVariableStorage.getSlow(frame.materialize());
        }

        @CompilerDirectives.TruffleBoundary
        private static SpecialVariableStorage getSlow(MaterializedFrame aFrame) {
            MaterializedFrame frame = FindDeclarationVariableNodes.getOuterDeclarationFrame(aFrame);
            Object variables = SpecialVariableStorage.get((Frame)frame);
            if (variables == Nil.INSTANCE) {
                variables = GetSpecialVariableStorage.initializeSpecialVariablesSlot((Frame)frame);
            }
            return (SpecialVariableStorage)variables;
        }

        private static Object initializeSpecialVariablesSlot(Frame storageFrame) {
            SpecialVariableStorage variables = new SpecialVariableStorage();
            SpecialVariableStorage.set(storageFrame, variables);
            SpecialVariableStorage.getAssumption(storageFrame.getFrameDescriptor()).invalidate();
            return variables;
        }

        private static void noStorageFrameError(Frame frame, int declarationFrameDepth) {
            int depth = 0;
            MaterializedFrame currentFrame = RubyArguments.getDeclarationFrame(frame);
            while (currentFrame != null) {
                ++depth;
                currentFrame = RubyArguments.getDeclarationFrame((Frame)currentFrame);
            }
            String message = String.format("Expected %d declaration frames but only found %d frames.", declarationFrameDepth, depth);
            throw CompilerDirectives.shouldNotReachHere((String)message);
        }
    }

    @CoreMethod(names={"define_hooked_variable_with_is_defined"}, onSingleton=true, required=4)
    public static abstract class DefineHookedVariableInnerNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object defineHookedVariableInnerNode(RubySymbol name, RubyProc getter, RubyProc setter, RubyProc isDefined) {
            this.getContext().getCoreLibrary().globalVariables.define(name.getString(), getter, setter, isDefined, this);
            return nil;
        }
    }

    @Primitive(name="global_variable_get")
    @ImportStatic(value={Layouts.class})
    public static abstract class ReadGlobalVariableNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"name == cachedName"}, limit="1")
        Object read(RubySymbol name, @Cached(value="name") RubySymbol cachedName, @Cached(value="create(cachedName.getString())") ReadSimpleGlobalVariableNode readNode) {
            return readNode.execute();
        }
    }

    @Primitive(name="global_variable_set")
    @ImportStatic(value={Layouts.class})
    public static abstract class WriteGlobalVariableNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"name == cachedName"}, limit="1")
        Object write(RubySymbol name, Object value, @Cached(value="name") RubySymbol cachedName, @Cached(value="create(cachedName.getString())") WriteSimpleGlobalVariableNode writeNode) {
            return writeNode.execute(value);
        }
    }

    @Primitive(name="kernel_load")
    public static abstract class LoadNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"strings.isRubyString(file)"})
        boolean load(Object file, Nil wrapModule, @Cached @Cached.Shared RubyStringLibrary strings, @Cached @Cached.Shared IndirectCallNode callNode) {
            String feature = RubyGuards.getJavaString(file);
            Pair<Source, TStringWithEncoding> sourceTStringPair = this.getSourceTStringPair(feature);
            DeclarationContext declarationContext = DeclarationContext.topLevel(this.getContext());
            LexicalScope lexicalScope = this.getContext().getRootLexicalScope();
            RubyBasicObject self = this.getContext().getCoreLibrary().mainObject;
            RootCallTarget callTarget = this.getContext().getCodeLoader().parseTopLevelWithCache(sourceTStringPair, this);
            CodeLoader.DeferredCall deferredCall = this.getContext().getCodeLoader().prepareExecute(callTarget, ParserContext.TOP_LEVEL, declarationContext, null, (Object)self, lexicalScope);
            deferredCall.call(callNode);
            return true;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"strings.isRubyString(file)"})
        boolean load(Object file, RubyModule wrapModule, @Cached @Cached.Shared RubyStringLibrary strings, @Cached @Cached.Shared IndirectCallNode callNode) {
            String feature = RubyGuards.getJavaString(file);
            Pair<Source, TStringWithEncoding> sourceTStringPair = this.getSourceTStringPair(feature);
            DeclarationContext declarationContext = DeclarationContext.topLevel(wrapModule);
            LexicalScope lexicalScope = new LexicalScope(this.getContext().getRootLexicalScope(), wrapModule);
            RubyBasicObject mainObject = this.getContext().getCoreLibrary().mainObject;
            Object self = DispatchNode.getUncached().call((Object)mainObject, "clone");
            DispatchNode.getUncached().call(self, "extend", wrapModule);
            RubySource rubySource = new RubySource((Source)sourceTStringPair.getLeft(), feature, (TStringWithEncoding)sourceTStringPair.getRight());
            RootCallTarget callTarget = this.getContext().getCodeLoader().parse(rubySource, ParserContext.TOP_LEVEL, null, lexicalScope, this);
            CodeLoader.DeferredCall deferredCall = this.getContext().getCodeLoader().prepareExecute(callTarget, ParserContext.TOP_LEVEL, declarationContext, null, self, lexicalScope);
            deferredCall.call(callNode);
            return true;
        }

        private Pair<Source, TStringWithEncoding> getSourceTStringPair(String feature) {
            try {
                FileLoader fileLoader = new FileLoader(this.getContext(), this.getLanguage());
                return fileLoader.loadFile(feature);
            }
            catch (IOException e) {
                throw new RaiseException(this.getContext(), this.coreExceptions().loadErrorCannotLoad(feature, this));
            }
        }
    }

    @CoreMethod(names={"at_exit"}, onSingleton=true, needsBlock=true, required=1, split=Split.NEVER)
    public static abstract class AtExitSystemNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object atExit(boolean always, RubyProc block) {
            this.getContext().getAtExitManager().add(block, always);
            return nil;
        }
    }
}

