/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.inlined;

import com.oracle.truffle.api.Assumption;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.CoreLibrary;
import org.truffleruby.core.inlined.InlinedAddNodeGen;
import org.truffleruby.core.inlined.InlinedAtNodeGen;
import org.truffleruby.core.inlined.InlinedBitAndNodeGen;
import org.truffleruby.core.inlined.InlinedBitOrNodeGen;
import org.truffleruby.core.inlined.InlinedByteSizeNodeGen;
import org.truffleruby.core.inlined.InlinedCaseEqualNodeGen;
import org.truffleruby.core.inlined.InlinedDivNodeGen;
import org.truffleruby.core.inlined.InlinedEqualNodeGen;
import org.truffleruby.core.inlined.InlinedGreaterOrEqualNodeGen;
import org.truffleruby.core.inlined.InlinedGreaterThanNodeGen;
import org.truffleruby.core.inlined.InlinedIndexGetNodeGen;
import org.truffleruby.core.inlined.InlinedIndexSetNodeGen;
import org.truffleruby.core.inlined.InlinedIsANodeGen;
import org.truffleruby.core.inlined.InlinedIsNilNodeGen;
import org.truffleruby.core.inlined.InlinedKindOfNodeGen;
import org.truffleruby.core.inlined.InlinedLambdaNodeGen;
import org.truffleruby.core.inlined.InlinedLeftShiftNodeGen;
import org.truffleruby.core.inlined.InlinedLessOrEqualNodeGen;
import org.truffleruby.core.inlined.InlinedLessThanNodeGen;
import org.truffleruby.core.inlined.InlinedModNodeGen;
import org.truffleruby.core.inlined.InlinedMulNodeGen;
import org.truffleruby.core.inlined.InlinedNegNodeGen;
import org.truffleruby.core.inlined.InlinedNotNodeGen;
import org.truffleruby.core.inlined.InlinedRightShiftNodeGen;
import org.truffleruby.core.inlined.InlinedSubNodeGen;
import org.truffleruby.core.inlined.LambdaToProcNode;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.dispatch.RubyCallNode;
import org.truffleruby.language.dispatch.RubyCallNodeParameters;
import org.truffleruby.language.methods.BlockDefinitionNode;

public final class CoreMethodAssumptions {
    final RubyLanguage language;
    final Assumption integerNegAssumption;
    final Assumption floatNegAssumption;
    final Assumption integerAddAssumption;
    final Assumption floatAddAssumption;
    final Assumption integerSubAssumption;
    final Assumption floatSubAssumption;
    final Assumption integerMulAssumption;
    final Assumption floatMulAssumption;
    final Assumption integerDivAssumption;
    final Assumption floatDivAssumption;
    final Assumption integerModAssumption;
    final Assumption floatModAssumption;
    public final Assumption integerCmpAssumption;
    public final Assumption floatCmpAssumption;
    final Assumption integerLeftShiftAssumption;
    final Assumption integerRightShiftAssumption;
    final Assumption integerBitOrAssumption;
    final Assumption integerBitAndAssumption;
    final Assumption integerCaseEqualAssumption;
    final Assumption integerEqualAssumption;
    final Assumption floatEqualAssumption;
    final Assumption integerLessThanAssumption;
    final Assumption floatLessThanAssumption;
    final Assumption integerLessOrEqualAssumption;
    final Assumption floatLessOrEqualAssumption;
    final Assumption integerGreaterThanAssumption;
    final Assumption floatGreaterThanAssumption;
    final Assumption integerGreaterOrEqualAssumption;
    final Assumption floatGreaterOrEqualAssumption;
    final Assumption nilClassIsNilAssumption;
    public final Assumption symbolToProcAssumption;
    private final List<Consumer<CoreLibrary>> classAssumptionsToRegister;

    public CoreMethodAssumptions(RubyLanguage language) {
        this.language = language;
        this.classAssumptionsToRegister = new ArrayList<Consumer<CoreLibrary>>();
        this.integerNegAssumption = this.registerAssumption(cl -> cl.integerClass, "Integer", "-@");
        this.floatNegAssumption = this.registerAssumption(cl -> cl.floatClass, "Float", "-@");
        this.integerAddAssumption = this.registerAssumption(cl -> cl.integerClass, "Integer", "+");
        this.floatAddAssumption = this.registerAssumption(cl -> cl.floatClass, "Float", "+");
        this.integerSubAssumption = this.registerAssumption(cl -> cl.integerClass, "Integer", "-");
        this.floatSubAssumption = this.registerAssumption(cl -> cl.floatClass, "Float", "-");
        this.integerMulAssumption = this.registerAssumption(cl -> cl.integerClass, "Integer", "*");
        this.floatMulAssumption = this.registerAssumption(cl -> cl.floatClass, "Float", "*");
        this.integerDivAssumption = this.registerAssumption(cl -> cl.integerClass, "Integer", "/");
        this.floatDivAssumption = this.registerAssumption(cl -> cl.floatClass, "Float", "/");
        this.integerModAssumption = this.registerAssumption(cl -> cl.integerClass, "Integer", "%");
        this.floatModAssumption = this.registerAssumption(cl -> cl.floatClass, "Float", "%");
        this.integerCmpAssumption = this.registerAssumption(cl -> cl.integerClass, "Integer", "<=>");
        this.floatCmpAssumption = this.registerAssumption(cl -> cl.floatClass, "Float", "<=>");
        this.integerLeftShiftAssumption = this.registerAssumption(cl -> cl.integerClass, "Integer", "<<");
        this.integerRightShiftAssumption = this.registerAssumption(cl -> cl.integerClass, "Integer", ">>");
        this.integerBitOrAssumption = this.registerAssumption(cl -> cl.integerClass, "Integer", "|");
        this.integerBitAndAssumption = this.registerAssumption(cl -> cl.integerClass, "Integer", "&");
        this.integerCaseEqualAssumption = this.registerAssumption(cl -> cl.integerClass, "Integer", "===");
        this.integerEqualAssumption = this.registerAssumption(cl -> cl.integerClass, "Integer", "==");
        this.floatEqualAssumption = this.registerAssumption(cl -> cl.floatClass, "Float", "==");
        this.integerLessThanAssumption = this.registerAssumption(cl -> cl.integerClass, "Integer", "<");
        this.floatLessThanAssumption = this.registerAssumption(cl -> cl.floatClass, "Float", "<");
        this.integerLessOrEqualAssumption = this.registerAssumption(cl -> cl.integerClass, "Integer", "<=");
        this.floatLessOrEqualAssumption = this.registerAssumption(cl -> cl.floatClass, "Float", "<=");
        this.integerGreaterThanAssumption = this.registerAssumption(cl -> cl.integerClass, "Integer", ">");
        this.floatGreaterThanAssumption = this.registerAssumption(cl -> cl.floatClass, "Float", ">");
        this.integerGreaterOrEqualAssumption = this.registerAssumption(cl -> cl.integerClass, "Integer", ">=");
        this.floatGreaterOrEqualAssumption = this.registerAssumption(cl -> cl.floatClass, "Float", ">=");
        this.nilClassIsNilAssumption = this.registerAssumption(cl -> cl.nilClass, "Nil", "nil?");
        this.symbolToProcAssumption = this.registerAssumption(cl -> cl.symbolClass, "Symbol", "to_proc");
    }

    private Assumption registerAssumption(ContextGetClass classGetter, String className, String methodName) {
        Assumption assumption = Assumption.create((String)("inlined " + className + "#" + methodName));
        this.classAssumptionsToRegister.add(cl -> classGetter.apply((CoreLibrary)cl).fields.registerAssumption(methodName, assumption));
        return assumption;
    }

    public void registerAssumptions(CoreLibrary coreLibrary) {
        for (Consumer<CoreLibrary> registerers : this.classAssumptionsToRegister) {
            registerers.accept(coreLibrary);
        }
    }

    public RubyContextSourceNode createCallNode(RubyCallNodeParameters callParameters) {
        if (!this.language.options.BASICOPS_INLINE || callParameters.isSplatted() || callParameters.isSafeNavigation()) {
            return new RubyCallNode(callParameters);
        }
        RubyNode self = callParameters.getReceiver();
        RubyNode[] args = callParameters.getArguments();
        int n = 1 + args.length;
        if (callParameters.getBlock() != null) {
            if (callParameters.getMethodName().equals("lambda") && callParameters.getBlock() instanceof BlockDefinitionNode) {
                if (callParameters.isIgnoreVisibility() && n == 1) {
                    return InlinedLambdaNodeGen.create(this.language, callParameters, self, callParameters.getBlock());
                }
                LambdaToProcNode blockNode = new LambdaToProcNode((BlockDefinitionNode)callParameters.getBlock());
                return new RubyCallNode(callParameters.withBlock(blockNode));
            }
            return new RubyCallNode(callParameters);
        }
        if (n == 1) {
            switch (callParameters.getMethodName()) {
                case "!": {
                    return InlinedNotNodeGen.create(this.language, callParameters, self);
                }
                case "-@": {
                    return InlinedNegNodeGen.create(this.language, callParameters, self);
                }
                case "nil?": {
                    return InlinedIsNilNodeGen.create(this.language, callParameters, self);
                }
                case "bytesize": {
                    return InlinedByteSizeNodeGen.create(this.language, callParameters, self);
                }
            }
        } else if (n == 2) {
            switch (callParameters.getMethodName()) {
                case "+": {
                    return InlinedAddNodeGen.create(this.language, callParameters, self, args[0]);
                }
                case "-": {
                    return InlinedSubNodeGen.create(this.language, callParameters, self, args[0]);
                }
                case "*": {
                    return InlinedMulNodeGen.create(this.language, callParameters, self, args[0]);
                }
                case "/": {
                    return InlinedDivNodeGen.create(this.language, callParameters, self, args[0]);
                }
                case "%": {
                    return InlinedModNodeGen.create(this.language, callParameters, self, args[0]);
                }
                case "<<": {
                    return InlinedLeftShiftNodeGen.create(this.language, callParameters, self, args[0]);
                }
                case ">>": {
                    return InlinedRightShiftNodeGen.create(this.language, callParameters, self, args[0]);
                }
                case "&": {
                    return InlinedBitAndNodeGen.create(this.language, callParameters, self, args[0]);
                }
                case "|": {
                    return InlinedBitOrNodeGen.create(this.language, callParameters, self, args[0]);
                }
                case "==": {
                    return InlinedEqualNodeGen.create(this.language, callParameters, self, args[0]);
                }
                case "===": {
                    return InlinedCaseEqualNodeGen.create(this.language, callParameters, self, args[0]);
                }
                case "<": {
                    return InlinedLessThanNodeGen.create(this.language, callParameters, self, args[0]);
                }
                case "<=": {
                    return InlinedLessOrEqualNodeGen.create(this.language, callParameters, self, args[0]);
                }
                case ">": {
                    return InlinedGreaterThanNodeGen.create(this.language, callParameters, self, args[0]);
                }
                case ">=": {
                    return InlinedGreaterOrEqualNodeGen.create(this.language, callParameters, self, args[0]);
                }
                case "[]": {
                    return InlinedIndexGetNodeGen.create(this.language, callParameters, self, args[0]);
                }
                case "at": {
                    return InlinedAtNodeGen.create(this.language, callParameters, self, args[0]);
                }
                case "is_a?": {
                    return InlinedIsANodeGen.create(this.language, callParameters, self, args[0]);
                }
                case "kind_of?": {
                    return InlinedKindOfNodeGen.create(this.language, callParameters, self, args[0]);
                }
            }
        } else if (n == 3) {
            switch (callParameters.getMethodName()) {
                case "[]=": {
                    return InlinedIndexSetNodeGen.create(this.language, callParameters, self, args[0], args[1]);
                }
            }
        }
        return new RubyCallNode(callParameters);
    }

    @FunctionalInterface
    public static interface ContextGetClass {
        public RubyClass apply(CoreLibrary var1);
    }
}

