/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.hash.library;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.library.GenerateLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.truffleruby.collections.PEBiFunction;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.hash.HashGuards;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.core.hash.library.EmptyHashStore;
import org.truffleruby.core.hash.library.HashStoreLibraryFactory;
import org.truffleruby.core.hash.library.PackedHashStoreLibrary;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.yield.CallBlockNode;

@GenerateLibrary
@GenerateLibrary.DefaultExport(value=PackedHashStoreLibrary.class)
public abstract class HashStoreLibrary
extends Library {
    private static final LibraryFactory<HashStoreLibrary> FACTORY = LibraryFactory.resolve(HashStoreLibrary.class);

    public static HashStoreLibrary createDispatched() {
        return (HashStoreLibrary)FACTORY.createDispatched(HashGuards.hashStrategyLimit());
    }

    public static HashStoreLibrary getUncached(RubyHash hash) {
        CompilerAsserts.neverPartOfCompilation((String)"uncached libraries must not be used in PE code");
        Object store = hash.store;
        return (HashStoreLibrary)FACTORY.getUncached(store);
    }

    public static boolean verify(RubyHash hash) {
        Object store = hash.store;
        return HashStoreLibrary.getUncached(hash).verify(store, hash);
    }

    @GenerateLibrary.Abstract
    public abstract Object lookupOrDefault(Object var1, Frame var2, RubyHash var3, Object var4, PEBiFunction var5);

    @GenerateLibrary.Abstract
    public abstract boolean set(Object var1, RubyHash var2, Object var3, Object var4, boolean var5);

    public void clear(Object store, RubyHash hash) {
        hash.store = EmptyHashStore.NULL_HASH_STORE;
        hash.size = 0;
    }

    @GenerateLibrary.Abstract
    public abstract Object delete(Object var1, RubyHash var2, Object var3);

    @GenerateLibrary.Abstract
    public abstract Object deleteLast(Object var1, RubyHash var2, Object var3);

    @GenerateLibrary.Abstract
    public abstract Object eachEntry(Object var1, RubyHash var2, EachEntryCallback var3, Object var4);

    @GenerateLibrary.Abstract
    public abstract Object eachEntrySafe(Object var1, RubyHash var2, EachEntryCallback var3, Object var4);

    @GenerateLibrary.Abstract
    public abstract void replace(Object var1, RubyHash var2, RubyHash var3);

    @GenerateLibrary.Abstract
    public abstract RubyArray shift(Object var1, RubyHash var2);

    @GenerateLibrary.Abstract
    public abstract void rehash(Object var1, RubyHash var2);

    @GenerateLibrary.Abstract
    public abstract boolean verify(Object var1, RubyHash var2);

    public final Node getNode() {
        boolean adoptable = this.isAdoptable();
        CompilerAsserts.partialEvaluationConstant((boolean)adoptable);
        if (adoptable) {
            return this;
        }
        return EncapsulatingNodeReference.getCurrent().get();
    }

    @GenerateUncached
    public static abstract class YieldPairNode
    extends RubyBaseNode {
        public static YieldPairNode create() {
            return HashStoreLibraryFactory.YieldPairNodeGen.create();
        }

        public abstract Object execute(RubyProc var1, Object var2, Object var3);

        @Specialization
        Object yieldPair(RubyProc block, Object key, Object value, @Cached CallBlockNode yieldNode, @Cached InlinedConditionProfile arityMoreThanOne) {
            if (arityMoreThanOne.profile((Node)this, block.arity.getMethodArityNumber() > 1)) {
                return yieldNode.yield(block, key, value);
            }
            return yieldNode.yield(block, this.createArray(new Object[]{key, value}));
        }
    }

    public static interface EachEntryCallback {
        public void accept(int var1, Object var2, Object var3, Object var4);
    }
}

