/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.hash;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.hash.HashGuards;
import org.truffleruby.core.hash.HashNodes;
import org.truffleruby.core.hash.HashingNodes;
import org.truffleruby.core.hash.HashingNodesFactory;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.core.hash.library.HashStoreLibrary;
import org.truffleruby.core.kernel.KernelNodes;
import org.truffleruby.core.kernel.KernelNodesFactory;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.language.Nil;
import org.truffleruby.language.NotProvided;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.RubyTypes;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.objects.shared.PropagateSharingNode;
import org.truffleruby.language.objects.shared.PropagateSharingNodeGen;
import org.truffleruby.language.yield.CallBlockNode;

@GeneratedBy(value=HashNodes.class)
public final class HashNodesFactory {
    private static final LibraryFactory<HashStoreLibrary> HASH_STORE_LIBRARY_ = LibraryFactory.resolve(HashStoreLibrary.class);

    public static List<NodeFactory<? extends RubyContextSourceNode>> getFactories() {
        return Arrays.asList(AllocateNodeFactory.getInstance(), ConstructNodeFactory.getInstance(), IsRuby2KeywordsHashNodeFactory.getInstance(), HashCopyAndMarkAsRuby2KeywordsNodeFactory.getInstance(), GetIndexNodeFactory.getInstance(), GetOrUndefinedNodeFactory.getInstance(), SetIndexNodeFactory.getInstance(), StoreNodeFactory.getInstance(), ClearNodeFactory.getInstance(), CompareByIdentityNodeFactory.getInstance(), IsCompareByIdentityNodeFactory.getInstance(), DefaultProcNodeFactory.getInstance(), DefaultValueNodeFactory.getInstance(), DeleteNodeFactory.getInstance(), EachNodeFactory.getInstance(), EmptyNodeFactory.getInstance(), InitializeNodeFactory.getInstance(), InitializeCopyNodeFactory.getInstance(), MapNodeFactory.getInstance(), SetDefaultProcNodeFactory.getInstance(), SetDefaultValueNodeFactory.getInstance(), ShiftNodeFactory.getInstance(), SizeNodeFactory.getInstance(), RehashNodeFactory.getInstance());
    }

    @GeneratedBy(value=HashNodes.AllocateNode.class)
    public static final class AllocateNodeFactory
    implements NodeFactory<HashNodes.AllocateNode> {
        private static final AllocateNodeFactory ALLOCATE_NODE_FACTORY_INSTANCE = new AllocateNodeFactory();

        private AllocateNodeFactory() {
        }

        public Class<HashNodes.AllocateNode> getNodeClass() {
            return HashNodes.AllocateNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.AllocateNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return AllocateNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.AllocateNode> getInstance() {
            return ALLOCATE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static HashNodes.AllocateNode create(RubyNode[] argumentNodes) {
            return new AllocateNodeGen(argumentNodes);
        }

        @GeneratedBy(value=HashNodes.AllocateNode.class)
        public static final class AllocateNodeGen
        extends HashNodes.AllocateNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private AllocateNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyClass) {
                    RubyClass argumentNodes0Value__ = (RubyClass)argumentNodes0Value_;
                    return this.allocate(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private RubyHash executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyClass) {
                    RubyClass argumentNodes0Value_ = (RubyClass)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.allocate(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=HashNodes.ConstructNode.class)
    public static final class ConstructNodeFactory
    implements NodeFactory<HashNodes.ConstructNode> {
        private static final ConstructNodeFactory CONSTRUCT_NODE_FACTORY_INSTANCE = new ConstructNodeFactory();

        private ConstructNodeFactory() {
        }

        public Class<HashNodes.ConstructNode> getNodeClass() {
            return HashNodes.ConstructNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.ConstructNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ConstructNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.ConstructNode> getInstance() {
            return CONSTRUCT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static HashNodes.ConstructNode create(RubyNode[] argumentNodes) {
            return new ConstructNodeGen(argumentNodes);
        }

        @GeneratedBy(value=HashNodes.ConstructNode.class)
        public static final class ConstructNodeGen
        extends HashNodes.ConstructNode {
            private static final InlineSupport.StateField STATE_0_ConstructNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final HashingNodes.ToHashByHashCode INLINED_CONSTRUCT_HASH_NODE_ = HashingNodesFactory.ToHashByHashCodeNodeGen.inline(InlineSupport.InlineTarget.create(HashingNodes.ToHashByHashCode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ConstructNode_UPDATER.subUpdater(2, 14), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"construct_hashNode__field1_", Object.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"construct_hashNode__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"construct_hashNode__field3_", Object.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"construct_hashNode__field4_", Node.class)}));
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object construct_hashNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node construct_hashNode__field2_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object construct_hashNode__field3_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node construct_hashNode__field4_;

            private ConstructNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                if ((state_0 & 3) != 0 && argumentNodes0Value_ instanceof RubyClass) {
                    RubyClass argumentNodes0Value__ = (RubyClass)argumentNodes0Value_;
                    if (argumentNodes1Value_ instanceof Object[]) {
                        Object[] argumentNodes1Value__ = (Object[])argumentNodes1Value_;
                        if ((state_0 & 1) != 0 && this.isSmallArrayOfPairs(argumentNodes1Value__, this.getLanguage())) {
                            return this.construct(argumentNodes0Value__, argumentNodes1Value__, INLINED_CONSTRUCT_HASH_NODE_);
                        }
                        if ((state_0 & 2) != 0 && !this.isSmallArrayOfPairs(argumentNodes1Value__, this.getLanguage())) {
                            return this.constructFallback(argumentNodes0Value__, argumentNodes1Value__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyClass) {
                    RubyClass argumentNodes0Value_ = (RubyClass)argumentNodes0Value;
                    if (argumentNodes1Value instanceof Object[]) {
                        Object[] argumentNodes1Value_ = (Object[])argumentNodes1Value;
                        if (this.isSmallArrayOfPairs(argumentNodes1Value_, this.getLanguage())) {
                            this.state_0_ = state_0 |= 1;
                            return this.construct(argumentNodes0Value_, argumentNodes1Value_, INLINED_CONSTRUCT_HASH_NODE_);
                        }
                        if (!this.isSmallArrayOfPairs(argumentNodes1Value_, this.getLanguage())) {
                            this.state_0_ = state_0 |= 2;
                            return this.constructFallback(argumentNodes0Value_, argumentNodes1Value_);
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_}, new Object[]{argumentNodes0Value, argumentNodes1Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 3) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 3 & (state_0 & 3) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }
        }
    }

    @GeneratedBy(value=HashNodes.IsRuby2KeywordsHashNode.class)
    public static final class IsRuby2KeywordsHashNodeFactory
    implements NodeFactory<HashNodes.IsRuby2KeywordsHashNode> {
        private static final IsRuby2KeywordsHashNodeFactory IS_RUBY2_KEYWORDS_HASH_NODE_FACTORY_INSTANCE = new IsRuby2KeywordsHashNodeFactory();

        private IsRuby2KeywordsHashNodeFactory() {
        }

        public Class<HashNodes.IsRuby2KeywordsHashNode> getNodeClass() {
            return HashNodes.IsRuby2KeywordsHashNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.IsRuby2KeywordsHashNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return IsRuby2KeywordsHashNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.IsRuby2KeywordsHashNode> getInstance() {
            return IS_RUBY2_KEYWORDS_HASH_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static HashNodes.IsRuby2KeywordsHashNode create(RubyNode[] argumentNodes) {
            return new IsRuby2KeywordsHashNodeGen(argumentNodes);
        }

        @GeneratedBy(value=HashNodes.IsRuby2KeywordsHashNode.class)
        public static final class IsRuby2KeywordsHashNodeGen
        extends HashNodes.IsRuby2KeywordsHashNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private IsRuby2KeywordsHashNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyHash) {
                    RubyHash argumentNodes0Value__ = (RubyHash)argumentNodes0Value_;
                    return this.isRuby2KeywordsHash(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private boolean executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyHash) {
                    RubyHash argumentNodes0Value_ = (RubyHash)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.isRuby2KeywordsHash(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=HashNodes.HashCopyAndMarkAsRuby2KeywordsNode.class)
    public static final class HashCopyAndMarkAsRuby2KeywordsNodeFactory
    implements NodeFactory<HashNodes.HashCopyAndMarkAsRuby2KeywordsNode> {
        private static final HashCopyAndMarkAsRuby2KeywordsNodeFactory HASH_COPY_AND_MARK_AS_RUBY2_KEYWORDS_NODE_FACTORY_INSTANCE = new HashCopyAndMarkAsRuby2KeywordsNodeFactory();

        private HashCopyAndMarkAsRuby2KeywordsNodeFactory() {
        }

        public Class<HashNodes.HashCopyAndMarkAsRuby2KeywordsNode> getNodeClass() {
            return HashNodes.HashCopyAndMarkAsRuby2KeywordsNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.HashCopyAndMarkAsRuby2KeywordsNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return HashCopyAndMarkAsRuby2KeywordsNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.HashCopyAndMarkAsRuby2KeywordsNode> getInstance() {
            return HASH_COPY_AND_MARK_AS_RUBY2_KEYWORDS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static HashNodes.HashCopyAndMarkAsRuby2KeywordsNode create(RubyNode[] argumentNodes) {
            return new HashCopyAndMarkAsRuby2KeywordsNodeGen(argumentNodes);
        }

        @GeneratedBy(value=HashNodes.HashCopyAndMarkAsRuby2KeywordsNode.class)
        public static final class HashCopyAndMarkAsRuby2KeywordsNodeGen
        extends HashNodes.HashCopyAndMarkAsRuby2KeywordsNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private HashNodes.CopyHashAndSetRuby2KeywordsNode copyHashAndSetRuby2KeywordsNode_;

            private HashCopyAndMarkAsRuby2KeywordsNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyHash) {
                    RubyHash argumentNodes0Value__ = (RubyHash)argumentNodes0Value_;
                    HashNodes.CopyHashAndSetRuby2KeywordsNode copyHashAndSetRuby2KeywordsNode__ = this.copyHashAndSetRuby2KeywordsNode_;
                    if (copyHashAndSetRuby2KeywordsNode__ != null) {
                        return this.copyAndMarkAsRuby2Keywords(argumentNodes0Value__, copyHashAndSetRuby2KeywordsNode__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private RubyHash executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyHash) {
                    RubyHash argumentNodes0Value_ = (RubyHash)argumentNodes0Value;
                    HashNodes.CopyHashAndSetRuby2KeywordsNode copyHashAndSetRuby2KeywordsNode__ = (HashNodes.CopyHashAndSetRuby2KeywordsNode)this.insert(HashNodes.CopyHashAndSetRuby2KeywordsNode.create());
                    Objects.requireNonNull(copyHashAndSetRuby2KeywordsNode__, "Specialization 'copyAndMarkAsRuby2Keywords(RubyHash, CopyHashAndSetRuby2KeywordsNode)' cache 'copyHashAndSetRuby2KeywordsNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.copyHashAndSetRuby2KeywordsNode_ = copyHashAndSetRuby2KeywordsNode__;
                    this.state_0_ = state_0 |= 1;
                    return this.copyAndMarkAsRuby2Keywords(argumentNodes0Value_, copyHashAndSetRuby2KeywordsNode__);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=HashNodes.GetIndexNode.class)
    public static final class GetIndexNodeFactory
    implements NodeFactory<HashNodes.GetIndexNode> {
        private static final GetIndexNodeFactory GET_INDEX_NODE_FACTORY_INSTANCE = new GetIndexNodeFactory();

        private GetIndexNodeFactory() {
        }

        public Class<HashNodes.GetIndexNode> getNodeClass() {
            return HashNodes.GetIndexNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.GetIndexNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return GetIndexNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.GetIndexNode> getInstance() {
            return GET_INDEX_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static HashNodes.GetIndexNode create(RubyNode[] argumentNodes) {
            return new GetIndexNodeGen(argumentNodes);
        }

        @GeneratedBy(value=HashNodes.GetIndexNode.class)
        public static final class GetIndexNodeGen
        extends HashNodes.GetIndexNode {
            static final InlineSupport.ReferenceField<Get0Data> GET0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"get0_cache", Get0Data.class);
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Get0Data get0_cache;

            private GetIndexNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            @ExplodeLoop
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyHash) {
                    RubyHash argumentNodes0Value__ = (RubyHash)argumentNodes0Value_;
                    if ((state_0 & 1) != 0) {
                        Get0Data s0_ = this.get0_cache;
                        while (s0_ != null) {
                            if (s0_.hashes_.accepts(argumentNodes0Value__.store)) {
                                return this.get(argumentNodes0Value__, argumentNodes1Value_, s0_.hashes_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 2) != 0) {
                        return this.get1Boundary(state_0, argumentNodes0Value__, argumentNodes1Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            private Object get1Boundary(int state_0, RubyHash argumentNodes0Value__, Object argumentNodes1Value_) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    HashStoreLibrary hashes__ = (HashStoreLibrary)HASH_STORE_LIBRARY_.getUncached(argumentNodes0Value__.store);
                    Object object = this.get(argumentNodes0Value__, argumentNodes1Value_, hashes__);
                    return object;
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyHash) {
                    RubyHash argumentNodes0Value_ = (RubyHash)argumentNodes0Value;
                    if ((state_0 & 2) == 0) {
                        Get0Data s0_;
                        block8: {
                            Get0Data s0_original;
                            do {
                                int count0_ = 0;
                                s0_original = s0_ = (Get0Data)((Object)GET0_CACHE_UPDATER.getVolatile((Node)this));
                                while (s0_ != null && !s0_.hashes_.accepts(argumentNodes0Value_.store)) {
                                    ++count0_;
                                    s0_ = s0_.next_;
                                }
                                if (s0_ != null || count0_ >= HashGuards.hashStrategyLimit()) break block8;
                                s0_ = (Get0Data)this.insert(new Get0Data(s0_original));
                                HashStoreLibrary hashes__ = (HashStoreLibrary)s0_.insert((Node)((HashStoreLibrary)HASH_STORE_LIBRARY_.create(argumentNodes0Value_.store)));
                                Objects.requireNonNull(hashes__, "Specialization 'get(RubyHash, Object, HashStoreLibrary)' cache 'hashes' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s0_.hashes_ = hashes__;
                            } while (!GET0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                            this.state_0_ = state_0 |= 1;
                        }
                        if (s0_ != null) {
                            return this.get(argumentNodes0Value_, argumentNodes1Value, s0_.hashes_);
                        }
                    }
                    HashStoreLibrary hashes__ = null;
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set((Node)this);
                    try {
                        hashes__ = (HashStoreLibrary)HASH_STORE_LIBRARY_.getUncached(argumentNodes0Value_.store);
                        this.get0_cache = null;
                        state_0 &= 0xFFFFFFFE;
                        this.state_0_ = state_0 |= 2;
                        Object object = this.get(argumentNodes0Value_, argumentNodes1Value, hashes__);
                        return object;
                    }
                    finally {
                        encapsulating_.set(prev_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_}, new Object[]{argumentNodes0Value, argumentNodes1Value});
            }

            public NodeCost getCost() {
                Get0Data s0_;
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & state_0 - 1) == 0 && ((s0_ = this.get0_cache) == null || s0_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=HashNodes.GetIndexNode.class)
            @DenyReplace
            private static final class Get0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                Get0Data next_;
                @Node.Child
                HashStoreLibrary hashes_;

                Get0Data(Get0Data next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.GetOrUndefinedNode.class)
    public static final class GetOrUndefinedNodeFactory
    implements NodeFactory<HashNodes.GetOrUndefinedNode> {
        private static final GetOrUndefinedNodeFactory GET_OR_UNDEFINED_NODE_FACTORY_INSTANCE = new GetOrUndefinedNodeFactory();

        private GetOrUndefinedNodeFactory() {
        }

        public Class<HashNodes.GetOrUndefinedNode> getNodeClass() {
            return HashNodes.GetOrUndefinedNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.GetOrUndefinedNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return GetOrUndefinedNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.GetOrUndefinedNode> getInstance() {
            return GET_OR_UNDEFINED_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static HashNodes.GetOrUndefinedNode create(RubyNode[] argumentNodes) {
            return new GetOrUndefinedNodeGen(argumentNodes);
        }

        @GeneratedBy(value=HashNodes.GetOrUndefinedNode.class)
        public static final class GetOrUndefinedNodeGen
        extends HashNodes.GetOrUndefinedNode {
            static final InlineSupport.ReferenceField<GetOrUndefined0Data> GET_OR_UNDEFINED0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"getOrUndefined0_cache", GetOrUndefined0Data.class);
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private GetOrUndefined0Data getOrUndefined0_cache;

            private GetOrUndefinedNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_, this.argumentNodes1_};
            }

            @Override
            @ExplodeLoop
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyHash) {
                    RubyHash argumentNodes0Value__ = (RubyHash)argumentNodes0Value_;
                    if ((state_0 & 1) != 0) {
                        GetOrUndefined0Data s0_ = this.getOrUndefined0_cache;
                        while (s0_ != null) {
                            if (s0_.hashes_.accepts(argumentNodes0Value__.store)) {
                                return this.getOrUndefined(argumentNodes0Value__, argumentNodes1Value_, s0_.hashes_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 2) != 0) {
                        return this.getOrUndefined1Boundary(state_0, argumentNodes0Value__, argumentNodes1Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            private Object getOrUndefined1Boundary(int state_0, RubyHash argumentNodes0Value__, Object argumentNodes1Value_) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    HashStoreLibrary hashes__ = (HashStoreLibrary)HASH_STORE_LIBRARY_.getUncached(argumentNodes0Value__.store);
                    Object object = this.getOrUndefined(argumentNodes0Value__, argumentNodes1Value_, hashes__);
                    return object;
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyHash) {
                    RubyHash argumentNodes0Value_ = (RubyHash)argumentNodes0Value;
                    if ((state_0 & 2) == 0) {
                        GetOrUndefined0Data s0_;
                        block8: {
                            GetOrUndefined0Data s0_original;
                            do {
                                int count0_ = 0;
                                s0_original = s0_ = (GetOrUndefined0Data)((Object)GET_OR_UNDEFINED0_CACHE_UPDATER.getVolatile((Node)this));
                                while (s0_ != null && !s0_.hashes_.accepts(argumentNodes0Value_.store)) {
                                    ++count0_;
                                    s0_ = s0_.next_;
                                }
                                if (s0_ != null || count0_ >= HashGuards.hashStrategyLimit()) break block8;
                                s0_ = (GetOrUndefined0Data)this.insert(new GetOrUndefined0Data(s0_original));
                                HashStoreLibrary hashes__ = (HashStoreLibrary)s0_.insert((Node)((HashStoreLibrary)HASH_STORE_LIBRARY_.create(argumentNodes0Value_.store)));
                                Objects.requireNonNull(hashes__, "Specialization 'getOrUndefined(RubyHash, Object, HashStoreLibrary)' cache 'hashes' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s0_.hashes_ = hashes__;
                            } while (!GET_OR_UNDEFINED0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                            this.state_0_ = state_0 |= 1;
                        }
                        if (s0_ != null) {
                            return this.getOrUndefined(argumentNodes0Value_, argumentNodes1Value, s0_.hashes_);
                        }
                    }
                    HashStoreLibrary hashes__ = null;
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set((Node)this);
                    try {
                        hashes__ = (HashStoreLibrary)HASH_STORE_LIBRARY_.getUncached(argumentNodes0Value_.store);
                        this.getOrUndefined0_cache = null;
                        state_0 &= 0xFFFFFFFE;
                        this.state_0_ = state_0 |= 2;
                        Object object = this.getOrUndefined(argumentNodes0Value_, argumentNodes1Value, hashes__);
                        return object;
                    }
                    finally {
                        encapsulating_.set(prev_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_}, new Object[]{argumentNodes0Value, argumentNodes1Value});
            }

            public NodeCost getCost() {
                GetOrUndefined0Data s0_;
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & state_0 - 1) == 0 && ((s0_ = this.getOrUndefined0_cache) == null || s0_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=HashNodes.GetOrUndefinedNode.class)
            @DenyReplace
            private static final class GetOrUndefined0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                GetOrUndefined0Data next_;
                @Node.Child
                HashStoreLibrary hashes_;

                GetOrUndefined0Data(GetOrUndefined0Data next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.SetIndexNode.class)
    public static final class SetIndexNodeFactory
    implements NodeFactory<HashNodes.SetIndexNode> {
        private static final SetIndexNodeFactory SET_INDEX_NODE_FACTORY_INSTANCE = new SetIndexNodeFactory();

        private SetIndexNodeFactory() {
        }

        public Class<HashNodes.SetIndexNode> getNodeClass() {
            return HashNodes.SetIndexNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.SetIndexNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SetIndexNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.SetIndexNode> getInstance() {
            return SET_INDEX_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static HashNodes.SetIndexNode create(RubyNode[] argumentNodes) {
            return new SetIndexNodeGen(argumentNodes);
        }

        @GeneratedBy(value=HashNodes.SetIndexNode.class)
        public static final class SetIndexNodeGen
        extends HashNodes.SetIndexNode {
            static final InlineSupport.ReferenceField<Set0Data> SET0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"set0_cache", Set0Data.class);
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @Node.Child
            private RubyNode argumentNodes2_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Set0Data set0_cache;

            private SetIndexNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
                this.argumentNodes2_ = argumentNodes != null && 2 < argumentNodes.length ? argumentNodes[2] : null;
            }

            @Override
            @ExplodeLoop
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                Object argumentNodes2Value_ = this.argumentNodes2_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyHash) {
                    RubyHash argumentNodes0Value__ = (RubyHash)argumentNodes0Value_;
                    if ((state_0 & 1) != 0) {
                        Set0Data s0_ = this.set0_cache;
                        while (s0_ != null) {
                            if (s0_.hashes_.accepts(argumentNodes0Value__.store)) {
                                return this.set(argumentNodes0Value__, argumentNodes1Value_, argumentNodes2Value_, s0_.hashes_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 2) != 0) {
                        return this.set1Boundary(state_0, argumentNodes0Value__, argumentNodes1Value_, argumentNodes2Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_, argumentNodes2Value_);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            private Object set1Boundary(int state_0, RubyHash argumentNodes0Value__, Object argumentNodes1Value_, Object argumentNodes2Value_) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    HashStoreLibrary hashes__ = (HashStoreLibrary)HASH_STORE_LIBRARY_.getUncached(argumentNodes0Value__.store);
                    Object object = this.set(argumentNodes0Value__, argumentNodes1Value_, argumentNodes2Value_, hashes__);
                    return object;
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value, Object argumentNodes2Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyHash) {
                    RubyHash argumentNodes0Value_ = (RubyHash)argumentNodes0Value;
                    if ((state_0 & 2) == 0) {
                        Set0Data s0_;
                        block8: {
                            Set0Data s0_original;
                            do {
                                int count0_ = 0;
                                s0_original = s0_ = (Set0Data)((Object)SET0_CACHE_UPDATER.getVolatile((Node)this));
                                while (s0_ != null && !s0_.hashes_.accepts(argumentNodes0Value_.store)) {
                                    ++count0_;
                                    s0_ = s0_.next_;
                                }
                                if (s0_ != null || count0_ >= HashGuards.hashStrategyLimit()) break block8;
                                s0_ = (Set0Data)this.insert(new Set0Data(s0_original));
                                HashStoreLibrary hashes__ = (HashStoreLibrary)s0_.insert((Node)((HashStoreLibrary)HASH_STORE_LIBRARY_.create(argumentNodes0Value_.store)));
                                Objects.requireNonNull(hashes__, "Specialization 'set(RubyHash, Object, Object, HashStoreLibrary)' cache 'hashes' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s0_.hashes_ = hashes__;
                            } while (!SET0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                            this.state_0_ = state_0 |= 1;
                        }
                        if (s0_ != null) {
                            return this.set(argumentNodes0Value_, argumentNodes1Value, argumentNodes2Value, s0_.hashes_);
                        }
                    }
                    HashStoreLibrary hashes__ = null;
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set((Node)this);
                    try {
                        hashes__ = (HashStoreLibrary)HASH_STORE_LIBRARY_.getUncached(argumentNodes0Value_.store);
                        this.set0_cache = null;
                        state_0 &= 0xFFFFFFFE;
                        this.state_0_ = state_0 |= 2;
                        Object object = this.set(argumentNodes0Value_, argumentNodes1Value, argumentNodes2Value, hashes__);
                        return object;
                    }
                    finally {
                        encapsulating_.set(prev_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_, this.argumentNodes2_}, new Object[]{argumentNodes0Value, argumentNodes1Value, argumentNodes2Value});
            }

            public NodeCost getCost() {
                Set0Data s0_;
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & state_0 - 1) == 0 && ((s0_ = this.set0_cache) == null || s0_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=HashNodes.SetIndexNode.class)
            @DenyReplace
            private static final class Set0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                Set0Data next_;
                @Node.Child
                HashStoreLibrary hashes_;

                Set0Data(Set0Data next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.StoreNode.class)
    public static final class StoreNodeFactory
    implements NodeFactory<HashNodes.StoreNode> {
        private static final StoreNodeFactory STORE_NODE_FACTORY_INSTANCE = new StoreNodeFactory();

        private StoreNodeFactory() {
        }

        public Class<HashNodes.StoreNode> getNodeClass() {
            return HashNodes.StoreNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.StoreNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return StoreNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.StoreNode> getInstance() {
            return STORE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static HashNodes.StoreNode create(RubyNode[] argumentNodes) {
            return new StoreNodeGen(argumentNodes);
        }

        @GeneratedBy(value=HashNodes.StoreNode.class)
        public static final class StoreNodeGen
        extends HashNodes.StoreNode {
            static final InlineSupport.ReferenceField<Set0Data> SET0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"set0_cache", Set0Data.class);
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @Node.Child
            private RubyNode argumentNodes2_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Set0Data set0_cache;

            private StoreNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
                this.argumentNodes2_ = argumentNodes != null && 2 < argumentNodes.length ? argumentNodes[2] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_, this.argumentNodes1_, this.argumentNodes2_};
            }

            @Override
            @ExplodeLoop
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                Object argumentNodes2Value_ = this.argumentNodes2_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyHash) {
                    RubyHash argumentNodes0Value__ = (RubyHash)argumentNodes0Value_;
                    if ((state_0 & 1) != 0) {
                        Set0Data s0_ = this.set0_cache;
                        while (s0_ != null) {
                            if (s0_.hashes_.accepts(argumentNodes0Value__.store)) {
                                return this.set(argumentNodes0Value__, argumentNodes1Value_, argumentNodes2Value_, s0_.hashes_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 2) != 0) {
                        return this.set1Boundary(state_0, argumentNodes0Value__, argumentNodes1Value_, argumentNodes2Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_, argumentNodes2Value_);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            private Object set1Boundary(int state_0, RubyHash argumentNodes0Value__, Object argumentNodes1Value_, Object argumentNodes2Value_) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    HashStoreLibrary hashes__ = (HashStoreLibrary)HASH_STORE_LIBRARY_.getUncached(argumentNodes0Value__.store);
                    Object object = this.set(argumentNodes0Value__, argumentNodes1Value_, argumentNodes2Value_, hashes__);
                    return object;
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value, Object argumentNodes2Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyHash) {
                    RubyHash argumentNodes0Value_ = (RubyHash)argumentNodes0Value;
                    if ((state_0 & 2) == 0) {
                        Set0Data s0_;
                        block8: {
                            Set0Data s0_original;
                            do {
                                int count0_ = 0;
                                s0_original = s0_ = (Set0Data)((Object)SET0_CACHE_UPDATER.getVolatile((Node)this));
                                while (s0_ != null && !s0_.hashes_.accepts(argumentNodes0Value_.store)) {
                                    ++count0_;
                                    s0_ = s0_.next_;
                                }
                                if (s0_ != null || count0_ >= HashGuards.hashStrategyLimit()) break block8;
                                s0_ = (Set0Data)this.insert(new Set0Data(s0_original));
                                HashStoreLibrary hashes__ = (HashStoreLibrary)s0_.insert((Node)((HashStoreLibrary)HASH_STORE_LIBRARY_.create(argumentNodes0Value_.store)));
                                Objects.requireNonNull(hashes__, "Specialization 'set(RubyHash, Object, Object, HashStoreLibrary)' cache 'hashes' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s0_.hashes_ = hashes__;
                            } while (!SET0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                            this.state_0_ = state_0 |= 1;
                        }
                        if (s0_ != null) {
                            return this.set(argumentNodes0Value_, argumentNodes1Value, argumentNodes2Value, s0_.hashes_);
                        }
                    }
                    HashStoreLibrary hashes__ = null;
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set((Node)this);
                    try {
                        hashes__ = (HashStoreLibrary)HASH_STORE_LIBRARY_.getUncached(argumentNodes0Value_.store);
                        this.set0_cache = null;
                        state_0 &= 0xFFFFFFFE;
                        this.state_0_ = state_0 |= 2;
                        Object object = this.set(argumentNodes0Value_, argumentNodes1Value, argumentNodes2Value, hashes__);
                        return object;
                    }
                    finally {
                        encapsulating_.set(prev_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_, this.argumentNodes2_}, new Object[]{argumentNodes0Value, argumentNodes1Value, argumentNodes2Value});
            }

            public NodeCost getCost() {
                Set0Data s0_;
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & state_0 - 1) == 0 && ((s0_ = this.set0_cache) == null || s0_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=HashNodes.StoreNode.class)
            @DenyReplace
            private static final class Set0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                Set0Data next_;
                @Node.Child
                HashStoreLibrary hashes_;

                Set0Data(Set0Data next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.ClearNode.class)
    public static final class ClearNodeFactory
    implements NodeFactory<HashNodes.ClearNode> {
        private static final ClearNodeFactory CLEAR_NODE_FACTORY_INSTANCE = new ClearNodeFactory();

        private ClearNodeFactory() {
        }

        public Class<HashNodes.ClearNode> getNodeClass() {
            return HashNodes.ClearNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.ClearNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ClearNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.ClearNode> getInstance() {
            return CLEAR_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static HashNodes.ClearNode create(RubyNode[] argumentNodes) {
            return new ClearNodeGen(argumentNodes);
        }

        @GeneratedBy(value=HashNodes.ClearNode.class)
        public static final class ClearNodeGen
        extends HashNodes.ClearNode {
            static final InlineSupport.ReferenceField<Clear0Data> CLEAR0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"clear0_cache", Clear0Data.class);
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Clear0Data clear0_cache;

            private ClearNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            @ExplodeLoop
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyHash) {
                    RubyHash argumentNodes0Value__ = (RubyHash)argumentNodes0Value_;
                    if ((state_0 & 1) != 0) {
                        Clear0Data s0_ = this.clear0_cache;
                        while (s0_ != null) {
                            if (s0_.hashes_.accepts(argumentNodes0Value__.store)) {
                                return this.clear(argumentNodes0Value__, s0_.hashes_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 2) != 0) {
                        return this.clear1Boundary(state_0, argumentNodes0Value__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            private Object clear1Boundary(int state_0, RubyHash argumentNodes0Value__) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    HashStoreLibrary hashes__ = (HashStoreLibrary)HASH_STORE_LIBRARY_.getUncached(argumentNodes0Value__.store);
                    RubyHash rubyHash = this.clear(argumentNodes0Value__, hashes__);
                    return rubyHash;
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private RubyHash executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyHash) {
                    RubyHash argumentNodes0Value_ = (RubyHash)argumentNodes0Value;
                    if ((state_0 & 2) == 0) {
                        Clear0Data s0_;
                        block8: {
                            Clear0Data s0_original;
                            do {
                                int count0_ = 0;
                                s0_original = s0_ = (Clear0Data)((Object)CLEAR0_CACHE_UPDATER.getVolatile((Node)this));
                                while (s0_ != null && !s0_.hashes_.accepts(argumentNodes0Value_.store)) {
                                    ++count0_;
                                    s0_ = s0_.next_;
                                }
                                if (s0_ != null || count0_ >= HashGuards.hashStrategyLimit()) break block8;
                                s0_ = (Clear0Data)this.insert(new Clear0Data(s0_original));
                                HashStoreLibrary hashes__ = (HashStoreLibrary)s0_.insert((Node)((HashStoreLibrary)HASH_STORE_LIBRARY_.create(argumentNodes0Value_.store)));
                                Objects.requireNonNull(hashes__, "Specialization 'clear(RubyHash, HashStoreLibrary)' cache 'hashes' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s0_.hashes_ = hashes__;
                            } while (!CLEAR0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                            this.state_0_ = state_0 |= 1;
                        }
                        if (s0_ != null) {
                            return this.clear(argumentNodes0Value_, s0_.hashes_);
                        }
                    }
                    HashStoreLibrary hashes__ = null;
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set((Node)this);
                    try {
                        hashes__ = (HashStoreLibrary)HASH_STORE_LIBRARY_.getUncached(argumentNodes0Value_.store);
                        this.clear0_cache = null;
                        state_0 &= 0xFFFFFFFE;
                        this.state_0_ = state_0 |= 2;
                        RubyHash rubyHash = this.clear(argumentNodes0Value_, hashes__);
                        return rubyHash;
                    }
                    finally {
                        encapsulating_.set(prev_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }

            public NodeCost getCost() {
                Clear0Data s0_;
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & state_0 - 1) == 0 && ((s0_ = this.clear0_cache) == null || s0_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=HashNodes.ClearNode.class)
            @DenyReplace
            private static final class Clear0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                Clear0Data next_;
                @Node.Child
                HashStoreLibrary hashes_;

                Clear0Data(Clear0Data next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.CompareByIdentityNode.class)
    public static final class CompareByIdentityNodeFactory
    implements NodeFactory<HashNodes.CompareByIdentityNode> {
        private static final CompareByIdentityNodeFactory COMPARE_BY_IDENTITY_NODE_FACTORY_INSTANCE = new CompareByIdentityNodeFactory();

        private CompareByIdentityNodeFactory() {
        }

        public Class<HashNodes.CompareByIdentityNode> getNodeClass() {
            return HashNodes.CompareByIdentityNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.CompareByIdentityNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return CompareByIdentityNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.CompareByIdentityNode> getInstance() {
            return COMPARE_BY_IDENTITY_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static HashNodes.CompareByIdentityNode create(RubyNode[] argumentNodes) {
            return new CompareByIdentityNodeGen(argumentNodes);
        }

        @GeneratedBy(value=HashNodes.CompareByIdentityNode.class)
        public static final class CompareByIdentityNodeGen
        extends HashNodes.CompareByIdentityNode {
            static final InlineSupport.ReferenceField<CompareByIdentity0Data> COMPARE_BY_IDENTITY0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"compareByIdentity0_cache", CompareByIdentity0Data.class);
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private CompareByIdentity0Data compareByIdentity0_cache;

            private CompareByIdentityNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            @ExplodeLoop
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyHash) {
                    RubyHash argumentNodes0Value__ = (RubyHash)argumentNodes0Value_;
                    if ((state_0 & 1) != 0) {
                        CompareByIdentity0Data s0_ = this.compareByIdentity0_cache;
                        while (s0_ != null) {
                            if (s0_.hashes_.accepts(argumentNodes0Value__.store) && !HashGuards.isCompareByIdentity(argumentNodes0Value__)) {
                                return this.compareByIdentity(argumentNodes0Value__, s0_.hashes_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 2) != 0 && !HashGuards.isCompareByIdentity(argumentNodes0Value__)) {
                        return this.compareByIdentity1Boundary(state_0, argumentNodes0Value__);
                    }
                    if ((state_0 & 4) != 0 && HashGuards.isCompareByIdentity(argumentNodes0Value__)) {
                        return this.alreadyCompareByIdentity(argumentNodes0Value__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            private Object compareByIdentity1Boundary(int state_0, RubyHash argumentNodes0Value__) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    HashStoreLibrary hashes__ = (HashStoreLibrary)HASH_STORE_LIBRARY_.getUncached(argumentNodes0Value__.store);
                    RubyHash rubyHash = this.compareByIdentity(argumentNodes0Value__, hashes__);
                    return rubyHash;
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private RubyHash executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyHash) {
                    RubyHash argumentNodes0Value_ = (RubyHash)argumentNodes0Value;
                    if ((state_0 & 2) == 0) {
                        CompareByIdentity0Data s0_;
                        block10: {
                            CompareByIdentity0Data s0_original;
                            do {
                                int count0_ = 0;
                                s0_original = s0_ = (CompareByIdentity0Data)((Object)COMPARE_BY_IDENTITY0_CACHE_UPDATER.getVolatile((Node)this));
                                while (s0_ != null && (!s0_.hashes_.accepts(argumentNodes0Value_.store) || HashGuards.isCompareByIdentity(argumentNodes0Value_))) {
                                    ++count0_;
                                    s0_ = s0_.next_;
                                }
                                if (s0_ != null || HashGuards.isCompareByIdentity(argumentNodes0Value_) || count0_ >= HashGuards.hashStrategyLimit()) break block10;
                                s0_ = (CompareByIdentity0Data)this.insert(new CompareByIdentity0Data(s0_original));
                                HashStoreLibrary hashes__ = (HashStoreLibrary)s0_.insert((Node)((HashStoreLibrary)HASH_STORE_LIBRARY_.create(argumentNodes0Value_.store)));
                                Objects.requireNonNull(hashes__, "Specialization 'compareByIdentity(RubyHash, HashStoreLibrary)' cache 'hashes' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s0_.hashes_ = hashes__;
                            } while (!COMPARE_BY_IDENTITY0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                            this.state_0_ = state_0 |= 1;
                        }
                        if (s0_ != null) {
                            return this.compareByIdentity(argumentNodes0Value_, s0_.hashes_);
                        }
                    }
                    HashStoreLibrary hashes__ = null;
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set((Node)this);
                    try {
                        if (!HashGuards.isCompareByIdentity(argumentNodes0Value_)) {
                            hashes__ = (HashStoreLibrary)HASH_STORE_LIBRARY_.getUncached(argumentNodes0Value_.store);
                            this.compareByIdentity0_cache = null;
                            state_0 &= 0xFFFFFFFE;
                            this.state_0_ = state_0 |= 2;
                            RubyHash rubyHash = this.compareByIdentity(argumentNodes0Value_, hashes__);
                            return rubyHash;
                        }
                    }
                    finally {
                        encapsulating_.set(prev_);
                    }
                    if (HashGuards.isCompareByIdentity(argumentNodes0Value_)) {
                        this.state_0_ = state_0 |= 4;
                        return this.alreadyCompareByIdentity(argumentNodes0Value_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }

            public NodeCost getCost() {
                CompareByIdentity0Data s0_;
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & state_0 - 1) == 0 && ((s0_ = this.compareByIdentity0_cache) == null || s0_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=HashNodes.CompareByIdentityNode.class)
            @DenyReplace
            private static final class CompareByIdentity0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                CompareByIdentity0Data next_;
                @Node.Child
                HashStoreLibrary hashes_;

                CompareByIdentity0Data(CompareByIdentity0Data next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.IsCompareByIdentityNode.class)
    public static final class IsCompareByIdentityNodeFactory
    implements NodeFactory<HashNodes.IsCompareByIdentityNode> {
        private static final IsCompareByIdentityNodeFactory IS_COMPARE_BY_IDENTITY_NODE_FACTORY_INSTANCE = new IsCompareByIdentityNodeFactory();

        private IsCompareByIdentityNodeFactory() {
        }

        public Class<HashNodes.IsCompareByIdentityNode> getNodeClass() {
            return HashNodes.IsCompareByIdentityNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.IsCompareByIdentityNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return IsCompareByIdentityNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.IsCompareByIdentityNode> getInstance() {
            return IS_COMPARE_BY_IDENTITY_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static HashNodes.IsCompareByIdentityNode create(RubyNode[] argumentNodes) {
            return new IsCompareByIdentityNodeGen(argumentNodes);
        }

        @GeneratedBy(value=HashNodes.IsCompareByIdentityNode.class)
        public static final class IsCompareByIdentityNodeGen
        extends HashNodes.IsCompareByIdentityNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private IsCompareByIdentityNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyHash) {
                    RubyHash argumentNodes0Value__ = (RubyHash)argumentNodes0Value_;
                    return this.compareByIdentity(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private boolean executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyHash) {
                    RubyHash argumentNodes0Value_ = (RubyHash)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.compareByIdentity(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=HashNodes.DefaultProcNode.class)
    public static final class DefaultProcNodeFactory
    implements NodeFactory<HashNodes.DefaultProcNode> {
        private static final DefaultProcNodeFactory DEFAULT_PROC_NODE_FACTORY_INSTANCE = new DefaultProcNodeFactory();

        private DefaultProcNodeFactory() {
        }

        public Class<HashNodes.DefaultProcNode> getNodeClass() {
            return HashNodes.DefaultProcNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.DefaultProcNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return DefaultProcNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.DefaultProcNode> getInstance() {
            return DEFAULT_PROC_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static HashNodes.DefaultProcNode create(RubyNode[] argumentNodes) {
            return new DefaultProcNodeGen(argumentNodes);
        }

        @GeneratedBy(value=HashNodes.DefaultProcNode.class)
        public static final class DefaultProcNodeGen
        extends HashNodes.DefaultProcNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private DefaultProcNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyHash) {
                    RubyHash argumentNodes0Value__ = (RubyHash)argumentNodes0Value_;
                    return this.defaultProc(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyHash) {
                    RubyHash argumentNodes0Value_ = (RubyHash)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.defaultProc(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=HashNodes.DefaultValueNode.class)
    public static final class DefaultValueNodeFactory
    implements NodeFactory<HashNodes.DefaultValueNode> {
        private static final DefaultValueNodeFactory DEFAULT_VALUE_NODE_FACTORY_INSTANCE = new DefaultValueNodeFactory();

        private DefaultValueNodeFactory() {
        }

        public Class<HashNodes.DefaultValueNode> getNodeClass() {
            return HashNodes.DefaultValueNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.DefaultValueNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return DefaultValueNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.DefaultValueNode> getInstance() {
            return DEFAULT_VALUE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static HashNodes.DefaultValueNode create(RubyNode[] argumentNodes) {
            return new DefaultValueNodeGen(argumentNodes);
        }

        @GeneratedBy(value=HashNodes.DefaultValueNode.class)
        public static final class DefaultValueNodeGen
        extends HashNodes.DefaultValueNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private DefaultValueNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyHash) {
                    RubyHash argumentNodes0Value__ = (RubyHash)argumentNodes0Value_;
                    return this.defaultValue(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyHash) {
                    RubyHash argumentNodes0Value_ = (RubyHash)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.defaultValue(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=HashNodes.DeleteNode.class)
    public static final class DeleteNodeFactory
    implements NodeFactory<HashNodes.DeleteNode> {
        private static final DeleteNodeFactory DELETE_NODE_FACTORY_INSTANCE = new DeleteNodeFactory();

        private DeleteNodeFactory() {
        }

        public Class<HashNodes.DeleteNode> getNodeClass() {
            return HashNodes.DeleteNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.DeleteNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return DeleteNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.DeleteNode> getInstance() {
            return DELETE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static HashNodes.DeleteNode create(RubyNode[] argumentNodes) {
            return new DeleteNodeGen(argumentNodes);
        }

        @GeneratedBy(value=HashNodes.DeleteNode.class)
        public static final class DeleteNodeGen
        extends HashNodes.DeleteNode {
            private static final InlineSupport.StateField STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            static final InlineSupport.ReferenceField<Delete0Data> DELETE0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"delete0_cache", Delete0Data.class);
            private static final InlinedConditionProfile INLINED_HAS_VALUE = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_UPDATER.subUpdater(2, 2)}));
            private static final InlinedConditionProfile INLINED_HAS_BLOCK = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_UPDATER.subUpdater(4, 2)}));
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @Node.Child
            private RubyNode argumentNodes2_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Delete0Data delete0_cache;
            @Node.Child
            private CallBlockNode delete1_yieldNode_;

            private DeleteNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
                this.argumentNodes2_ = argumentNodes != null && 2 < argumentNodes.length ? argumentNodes[2] : null;
            }

            @Override
            @ExplodeLoop
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                Object argumentNodes2Value_ = this.argumentNodes2_.execute(frameValue);
                if ((state_0 & 3) != 0 && argumentNodes0Value_ instanceof RubyHash) {
                    CallBlockNode yieldNode__;
                    RubyHash argumentNodes0Value__ = (RubyHash)argumentNodes0Value_;
                    if ((state_0 & 1) != 0) {
                        Delete0Data s0_ = this.delete0_cache;
                        while (s0_ != null) {
                            if (s0_.hashes_.accepts(argumentNodes0Value__.store)) {
                                return this.delete(argumentNodes0Value__, argumentNodes1Value_, argumentNodes2Value_, s0_.hashes_, s0_.yieldNode_, INLINED_HAS_VALUE, INLINED_HAS_BLOCK);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 2) != 0 && (yieldNode__ = this.delete1_yieldNode_) != null) {
                        return this.delete1Boundary(state_0, argumentNodes0Value__, argumentNodes1Value_, argumentNodes2Value_, yieldNode__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_, argumentNodes2Value_);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            private Object delete1Boundary(int state_0, RubyHash argumentNodes0Value__, Object argumentNodes1Value_, Object argumentNodes2Value_, CallBlockNode yieldNode__) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    HashStoreLibrary hashes__ = (HashStoreLibrary)HASH_STORE_LIBRARY_.getUncached(argumentNodes0Value__.store);
                    Object object = this.delete(argumentNodes0Value__, argumentNodes1Value_, argumentNodes2Value_, hashes__, yieldNode__, INLINED_HAS_VALUE, INLINED_HAS_BLOCK);
                    return object;
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value, Object argumentNodes2Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyHash) {
                    RubyHash argumentNodes0Value_ = (RubyHash)argumentNodes0Value;
                    if ((state_0 & 2) == 0) {
                        Delete0Data s0_;
                        block8: {
                            Delete0Data s0_original;
                            do {
                                int count0_ = 0;
                                s0_original = s0_ = (Delete0Data)((Object)DELETE0_CACHE_UPDATER.getVolatile((Node)this));
                                while (s0_ != null && !s0_.hashes_.accepts(argumentNodes0Value_.store)) {
                                    ++count0_;
                                    s0_ = s0_.next_;
                                }
                                if (s0_ != null || count0_ >= HashGuards.hashStrategyLimit()) break block8;
                                s0_ = (Delete0Data)this.insert(new Delete0Data(s0_original));
                                HashStoreLibrary hashes__ = (HashStoreLibrary)s0_.insert((Node)((HashStoreLibrary)HASH_STORE_LIBRARY_.create(argumentNodes0Value_.store)));
                                Objects.requireNonNull(hashes__, "Specialization 'delete(RubyHash, Object, Object, HashStoreLibrary, CallBlockNode, InlinedConditionProfile, InlinedConditionProfile)' cache 'hashes' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s0_.hashes_ = hashes__;
                                CallBlockNode yieldNode__ = (CallBlockNode)s0_.insert(CallBlockNode.create());
                                Objects.requireNonNull(yieldNode__, "Specialization 'delete(RubyHash, Object, Object, HashStoreLibrary, CallBlockNode, InlinedConditionProfile, InlinedConditionProfile)' cache 'yieldNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s0_.yieldNode_ = yieldNode__;
                            } while (!DELETE0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                            this.state_0_ = state_0 |= 1;
                        }
                        if (s0_ != null) {
                            return this.delete(argumentNodes0Value_, argumentNodes1Value, argumentNodes2Value, s0_.hashes_, s0_.yieldNode_, INLINED_HAS_VALUE, INLINED_HAS_BLOCK);
                        }
                    }
                    HashStoreLibrary hashes__ = null;
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set((Node)this);
                    try {
                        hashes__ = (HashStoreLibrary)HASH_STORE_LIBRARY_.getUncached(argumentNodes0Value_.store);
                        CallBlockNode yieldNode__ = (CallBlockNode)this.insert(CallBlockNode.create());
                        Objects.requireNonNull(yieldNode__, "Specialization 'delete(RubyHash, Object, Object, HashStoreLibrary, CallBlockNode, InlinedConditionProfile, InlinedConditionProfile)' cache 'yieldNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.delete1_yieldNode_ = yieldNode__;
                        this.delete0_cache = null;
                        state_0 &= 0xFFFFFFFE;
                        this.state_0_ = state_0 |= 2;
                        Object object = this.delete(argumentNodes0Value_, argumentNodes1Value, argumentNodes2Value, hashes__, yieldNode__, INLINED_HAS_VALUE, INLINED_HAS_BLOCK);
                        return object;
                    }
                    finally {
                        encapsulating_.set(prev_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_, this.argumentNodes2_}, new Object[]{argumentNodes0Value, argumentNodes1Value, argumentNodes2Value});
            }

            public NodeCost getCost() {
                Delete0Data s0_;
                int state_0 = this.state_0_;
                if ((state_0 & 3) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 3 & (state_0 & 3) - 1) == 0 && ((s0_ = this.delete0_cache) == null || s0_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=HashNodes.DeleteNode.class)
            @DenyReplace
            private static final class Delete0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                Delete0Data next_;
                @Node.Child
                HashStoreLibrary hashes_;
                @Node.Child
                CallBlockNode yieldNode_;

                Delete0Data(Delete0Data next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.EachNode.class)
    public static final class EachNodeFactory
    implements NodeFactory<HashNodes.EachNode> {
        private static final EachNodeFactory EACH_NODE_FACTORY_INSTANCE = new EachNodeFactory();

        private EachNodeFactory() {
        }

        public Class<HashNodes.EachNode> getNodeClass() {
            return HashNodes.EachNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.EachNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return EachNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.EachNode> getInstance() {
            return EACH_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static HashNodes.EachNode create(RubyNode[] argumentNodes) {
            return new EachNodeGen(argumentNodes);
        }

        @GeneratedBy(value=HashNodes.EachNode.class)
        public static final class EachNodeGen
        extends HashNodes.EachNode {
            static final InlineSupport.ReferenceField<Each0Data> EACH0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"each0_cache", Each0Data.class);
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Each0Data each0_cache;

            private EachNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            @ExplodeLoop
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyHash) {
                    RubyHash argumentNodes0Value__ = (RubyHash)argumentNodes0Value_;
                    if (argumentNodes1Value_ instanceof RubyProc) {
                        RubyProc argumentNodes1Value__ = (RubyProc)argumentNodes1Value_;
                        if ((state_0 & 1) != 0) {
                            Each0Data s0_ = this.each0_cache;
                            while (s0_ != null) {
                                if (s0_.hashes_.accepts(argumentNodes0Value__.store)) {
                                    return this.each(argumentNodes0Value__, argumentNodes1Value__, s0_.hashes_);
                                }
                                s0_ = s0_.next_;
                            }
                        }
                        if ((state_0 & 2) != 0) {
                            return this.each1Boundary(state_0, argumentNodes0Value__, argumentNodes1Value__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            private Object each1Boundary(int state_0, RubyHash argumentNodes0Value__, RubyProc argumentNodes1Value__) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    HashStoreLibrary hashes__ = (HashStoreLibrary)HASH_STORE_LIBRARY_.getUncached(argumentNodes0Value__.store);
                    RubyHash rubyHash = this.each(argumentNodes0Value__, argumentNodes1Value__, hashes__);
                    return rubyHash;
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private RubyHash executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyHash) {
                    RubyHash argumentNodes0Value_ = (RubyHash)argumentNodes0Value;
                    if (argumentNodes1Value instanceof RubyProc) {
                        RubyProc argumentNodes1Value_ = (RubyProc)argumentNodes1Value;
                        if ((state_0 & 2) == 0) {
                            Each0Data s0_;
                            block9: {
                                Each0Data s0_original;
                                do {
                                    int count0_ = 0;
                                    s0_original = s0_ = (Each0Data)((Object)EACH0_CACHE_UPDATER.getVolatile((Node)this));
                                    while (s0_ != null && !s0_.hashes_.accepts(argumentNodes0Value_.store)) {
                                        ++count0_;
                                        s0_ = s0_.next_;
                                    }
                                    if (s0_ != null || count0_ >= HashGuards.hashStrategyLimit()) break block9;
                                    s0_ = (Each0Data)this.insert(new Each0Data(s0_original));
                                    HashStoreLibrary hashes__ = (HashStoreLibrary)s0_.insert((Node)((HashStoreLibrary)HASH_STORE_LIBRARY_.create(argumentNodes0Value_.store)));
                                    Objects.requireNonNull(hashes__, "Specialization 'each(RubyHash, RubyProc, HashStoreLibrary)' cache 'hashes' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s0_.hashes_ = hashes__;
                                } while (!EACH0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                                this.state_0_ = state_0 |= 1;
                            }
                            if (s0_ != null) {
                                return this.each(argumentNodes0Value_, argumentNodes1Value_, s0_.hashes_);
                            }
                        }
                        HashStoreLibrary hashes__ = null;
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set((Node)this);
                        try {
                            hashes__ = (HashStoreLibrary)HASH_STORE_LIBRARY_.getUncached(argumentNodes0Value_.store);
                            this.each0_cache = null;
                            state_0 &= 0xFFFFFFFE;
                            this.state_0_ = state_0 |= 2;
                            RubyHash rubyHash = this.each(argumentNodes0Value_, argumentNodes1Value_, hashes__);
                            return rubyHash;
                        }
                        finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_}, new Object[]{argumentNodes0Value, argumentNodes1Value});
            }

            public NodeCost getCost() {
                Each0Data s0_;
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & state_0 - 1) == 0 && ((s0_ = this.each0_cache) == null || s0_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=HashNodes.EachNode.class)
            @DenyReplace
            private static final class Each0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                Each0Data next_;
                @Node.Child
                HashStoreLibrary hashes_;

                Each0Data(Each0Data next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.EmptyNode.class)
    public static final class EmptyNodeFactory
    implements NodeFactory<HashNodes.EmptyNode> {
        private static final EmptyNodeFactory EMPTY_NODE_FACTORY_INSTANCE = new EmptyNodeFactory();

        private EmptyNodeFactory() {
        }

        public Class<HashNodes.EmptyNode> getNodeClass() {
            return HashNodes.EmptyNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.EmptyNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return EmptyNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.EmptyNode> getInstance() {
            return EMPTY_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static HashNodes.EmptyNode create(RubyNode[] argumentNodes) {
            return new EmptyNodeGen(argumentNodes);
        }

        @GeneratedBy(value=HashNodes.EmptyNode.class)
        public static final class EmptyNodeGen
        extends HashNodes.EmptyNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private EmptyNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyHash) {
                    RubyHash argumentNodes0Value__ = (RubyHash)argumentNodes0Value_;
                    return this.isEmpty(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private boolean executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyHash) {
                    RubyHash argumentNodes0Value_ = (RubyHash)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.isEmpty(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=HashNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    implements NodeFactory<HashNodes.InitializeNode> {
        private static final InitializeNodeFactory INITIALIZE_NODE_FACTORY_INSTANCE = new InitializeNodeFactory();

        private InitializeNodeFactory() {
        }

        public Class<HashNodes.InitializeNode> getNodeClass() {
            return HashNodes.InitializeNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.InitializeNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return InitializeNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.InitializeNode> getInstance() {
            return INITIALIZE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static HashNodes.InitializeNode create(RubyNode[] argumentNodes) {
            return new InitializeNodeGen(argumentNodes);
        }

        @GeneratedBy(value=HashNodes.InitializeNode.class)
        public static final class InitializeNodeGen
        extends HashNodes.InitializeNode {
            private static final InlineSupport.StateField STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PropagateSharingNode INLINED_PROPAGATE_SHARING_NODE = PropagateSharingNodeGen.inline(InlineSupport.InlineTarget.create(PropagateSharingNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_UPDATER.subUpdater(4, 10), STATE_0_UPDATER.subUpdater(14, 3), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"propagateSharingNode_field2_", Object.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"propagateSharingNode_field3_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"propagateSharingNode_field4_", Object.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"propagateSharingNode_field5_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"propagateSharingNode_field6_", Node.class)}));
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @Node.Child
            private RubyNode argumentNodes2_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object propagateSharingNode_field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node propagateSharingNode_field3_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object propagateSharingNode_field4_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node propagateSharingNode_field5_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node propagateSharingNode_field6_;

            private InitializeNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
                this.argumentNodes2_ = argumentNodes != null && 2 < argumentNodes.length ? argumentNodes[2] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                Object argumentNodes2Value_ = this.argumentNodes2_.execute(frameValue);
                if ((state_0 & 0xF) != 0 && argumentNodes0Value_ instanceof RubyHash) {
                    RubyHash argumentNodes0Value__ = (RubyHash)argumentNodes0Value_;
                    if ((state_0 & 3) != 0 && RubyTypes.isNotProvided(argumentNodes1Value_)) {
                        NotProvided argumentNodes1Value__ = RubyTypes.asNotProvided(argumentNodes1Value_);
                        if ((state_0 & 1) != 0 && RubyTypes.isNil(argumentNodes2Value_)) {
                            Nil argumentNodes2Value__ = RubyTypes.asNil(argumentNodes2Value_);
                            return this.initialize(argumentNodes0Value__, argumentNodes1Value__, argumentNodes2Value__);
                        }
                        if ((state_0 & 2) != 0 && argumentNodes2Value_ instanceof RubyProc) {
                            RubyProc argumentNodes2Value__ = (RubyProc)argumentNodes2Value_;
                            return this.initialize(argumentNodes0Value__, argumentNodes1Value__, argumentNodes2Value__, INLINED_PROPAGATE_SHARING_NODE);
                        }
                    }
                    if ((state_0 & 0xC) != 0) {
                        Object argumentNodes2Value__;
                        if ((state_0 & 4) != 0 && RubyTypes.isNil(argumentNodes2Value_)) {
                            argumentNodes2Value__ = RubyTypes.asNil(argumentNodes2Value_);
                            if (RubyGuards.wasProvided(argumentNodes1Value_)) {
                                return this.initialize(argumentNodes0Value__, argumentNodes1Value_, (Nil)argumentNodes2Value__, INLINED_PROPAGATE_SHARING_NODE);
                            }
                        }
                        if ((state_0 & 8) != 0 && argumentNodes2Value_ instanceof RubyProc) {
                            argumentNodes2Value__ = (RubyProc)argumentNodes2Value_;
                            if (RubyGuards.wasProvided(argumentNodes1Value_)) {
                                return this.initialize(argumentNodes0Value__, argumentNodes1Value_, (RubyProc)argumentNodes2Value__);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_, argumentNodes2Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value, Object argumentNodes2Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyHash) {
                    Object argumentNodes2Value_;
                    RubyHash argumentNodes0Value_ = (RubyHash)argumentNodes0Value;
                    if (RubyTypes.isNotProvided(argumentNodes1Value)) {
                        NotProvided argumentNodes1Value_ = RubyTypes.asNotProvided(argumentNodes1Value);
                        if (RubyTypes.isNil(argumentNodes2Value)) {
                            Nil argumentNodes2Value_2 = RubyTypes.asNil(argumentNodes2Value);
                            this.state_0_ = state_0 |= 1;
                            return this.initialize(argumentNodes0Value_, argumentNodes1Value_, argumentNodes2Value_2);
                        }
                        if (argumentNodes2Value instanceof RubyProc) {
                            RubyProc argumentNodes2Value_3 = (RubyProc)argumentNodes2Value;
                            this.state_0_ = state_0 |= 2;
                            return this.initialize(argumentNodes0Value_, argumentNodes1Value_, argumentNodes2Value_3, INLINED_PROPAGATE_SHARING_NODE);
                        }
                    }
                    if (RubyTypes.isNil(argumentNodes2Value)) {
                        argumentNodes2Value_ = RubyTypes.asNil(argumentNodes2Value);
                        if (RubyGuards.wasProvided(argumentNodes1Value)) {
                            this.state_0_ = state_0 |= 4;
                            return this.initialize(argumentNodes0Value_, argumentNodes1Value, (Nil)argumentNodes2Value_, INLINED_PROPAGATE_SHARING_NODE);
                        }
                    }
                    if (argumentNodes2Value instanceof RubyProc) {
                        argumentNodes2Value_ = (RubyProc)argumentNodes2Value;
                        if (RubyGuards.wasProvided(argumentNodes1Value)) {
                            this.state_0_ = state_0 |= 8;
                            return this.initialize(argumentNodes0Value_, argumentNodes1Value, (RubyProc)argumentNodes2Value_);
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_, this.argumentNodes2_}, new Object[]{argumentNodes0Value, argumentNodes1Value, argumentNodes2Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }
        }
    }

    @GeneratedBy(value=HashNodes.InitializeCopyNode.class)
    public static final class InitializeCopyNodeFactory
    implements NodeFactory<HashNodes.InitializeCopyNode> {
        private static final InitializeCopyNodeFactory INITIALIZE_COPY_NODE_FACTORY_INSTANCE = new InitializeCopyNodeFactory();

        private InitializeCopyNodeFactory() {
        }

        public Class<HashNodes.InitializeCopyNode> getNodeClass() {
            return HashNodes.InitializeCopyNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.InitializeCopyNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return InitializeCopyNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.InitializeCopyNode> getInstance() {
            return INITIALIZE_COPY_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static HashNodes.InitializeCopyNode create(RubyNode[] argumentNodes) {
            return new InitializeCopyNodeGen(argumentNodes);
        }

        @GeneratedBy(value=HashNodes.InitializeCopyNode.class)
        public static final class InitializeCopyNodeGen
        extends HashNodes.InitializeCopyNode {
            static final InlineSupport.ReferenceField<Replace0Data> REPLACE0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"replace0_cache", Replace0Data.class);
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Replace0Data replace0_cache;
            @Node.Child
            private DispatchNode replaceCoerce_coerceNode_;
            @Node.Child
            private HashNodes.InitializeCopyNode replaceCoerce_initializeCopy_;

            private InitializeCopyNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            @ExplodeLoop
            public RubyHash execute(RubyHash argumentNodes0Value, RubyHash argumentNodes1Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0) {
                    HashNodes.InitializeCopyNode initializeCopy__;
                    DispatchNode coerceNode__;
                    if ((state_0 & 3) != 0) {
                        if ((state_0 & 1) != 0) {
                            Replace0Data s0_ = this.replace0_cache;
                            while (s0_ != null) {
                                if (s0_.hashes_.accepts(argumentNodes1Value.store)) {
                                    return this.replace(argumentNodes0Value, argumentNodes1Value, s0_.hashes_);
                                }
                                s0_ = s0_.next_;
                            }
                        }
                        if ((state_0 & 2) != 0) {
                            return this.replace1Boundary(state_0, argumentNodes0Value, argumentNodes1Value);
                        }
                    }
                    if ((state_0 & 4) != 0 && (coerceNode__ = this.replaceCoerce_coerceNode_) != null && (initializeCopy__ = this.replaceCoerce_initializeCopy_) != null && !RubyGuards.isRubyHash(argumentNodes1Value)) {
                        return this.replaceCoerce(argumentNodes0Value, argumentNodes1Value, coerceNode__, initializeCopy__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value, argumentNodes1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            private RubyHash replace1Boundary(int state_0, RubyHash argumentNodes0Value, RubyHash argumentNodes1Value) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    HashStoreLibrary hashes__ = (HashStoreLibrary)HASH_STORE_LIBRARY_.getUncached(argumentNodes1Value.store);
                    RubyHash rubyHash = this.replace(argumentNodes0Value, argumentNodes1Value, hashes__);
                    return rubyHash;
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }

            @Override
            @ExplodeLoop
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyHash) {
                    HashNodes.InitializeCopyNode initializeCopy__;
                    DispatchNode coerceNode__;
                    RubyHash argumentNodes0Value__ = (RubyHash)argumentNodes0Value_;
                    if ((state_0 & 3) != 0 && argumentNodes1Value_ instanceof RubyHash) {
                        RubyHash argumentNodes1Value__ = (RubyHash)argumentNodes1Value_;
                        if ((state_0 & 1) != 0) {
                            Replace0Data s0_ = this.replace0_cache;
                            while (s0_ != null) {
                                if (s0_.hashes_.accepts(argumentNodes1Value__.store)) {
                                    return this.replace(argumentNodes0Value__, argumentNodes1Value__, s0_.hashes_);
                                }
                                s0_ = s0_.next_;
                            }
                        }
                        if ((state_0 & 2) != 0) {
                            return this.replace1Boundary0(state_0, argumentNodes0Value__, argumentNodes1Value__);
                        }
                    }
                    if ((state_0 & 4) != 0 && (coerceNode__ = this.replaceCoerce_coerceNode_) != null && (initializeCopy__ = this.replaceCoerce_initializeCopy_) != null && !RubyGuards.isRubyHash(argumentNodes1Value_)) {
                        return this.replaceCoerce(argumentNodes0Value__, argumentNodes1Value_, coerceNode__, initializeCopy__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            private Object replace1Boundary0(int state_0, RubyHash argumentNodes0Value__, RubyHash argumentNodes1Value__) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    HashStoreLibrary hashes__ = (HashStoreLibrary)HASH_STORE_LIBRARY_.getUncached(argumentNodes1Value__.store);
                    RubyHash rubyHash = this.replace(argumentNodes0Value__, argumentNodes1Value__, hashes__);
                    return rubyHash;
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private RubyHash executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyHash) {
                    RubyHash argumentNodes0Value_ = (RubyHash)argumentNodes0Value;
                    if (argumentNodes1Value instanceof RubyHash) {
                        RubyHash argumentNodes1Value_ = (RubyHash)argumentNodes1Value;
                        if ((state_0 & 2) == 0) {
                            Replace0Data s0_;
                            block10: {
                                Replace0Data s0_original;
                                do {
                                    int count0_ = 0;
                                    s0_original = s0_ = (Replace0Data)((Object)REPLACE0_CACHE_UPDATER.getVolatile((Node)this));
                                    while (s0_ != null && !s0_.hashes_.accepts(argumentNodes1Value_.store)) {
                                        ++count0_;
                                        s0_ = s0_.next_;
                                    }
                                    if (s0_ != null || count0_ >= HashGuards.hashStrategyLimit()) break block10;
                                    s0_ = (Replace0Data)this.insert(new Replace0Data(s0_original));
                                    HashStoreLibrary hashes__ = (HashStoreLibrary)s0_.insert((Node)((HashStoreLibrary)HASH_STORE_LIBRARY_.create(argumentNodes1Value_.store)));
                                    Objects.requireNonNull(hashes__, "Specialization 'replace(RubyHash, RubyHash, HashStoreLibrary)' cache 'hashes' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s0_.hashes_ = hashes__;
                                } while (!REPLACE0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                                this.state_0_ = state_0 |= 1;
                            }
                            if (s0_ != null) {
                                return this.replace(argumentNodes0Value_, argumentNodes1Value_, s0_.hashes_);
                            }
                        }
                        HashStoreLibrary hashes__ = null;
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set((Node)this);
                        try {
                            hashes__ = (HashStoreLibrary)HASH_STORE_LIBRARY_.getUncached(argumentNodes1Value_.store);
                            this.replace0_cache = null;
                            state_0 &= 0xFFFFFFFE;
                            this.state_0_ = state_0 |= 2;
                            RubyHash rubyHash = this.replace(argumentNodes0Value_, argumentNodes1Value_, hashes__);
                            return rubyHash;
                        }
                        finally {
                            encapsulating_.set(prev_);
                        }
                    }
                    if (!RubyGuards.isRubyHash(argumentNodes1Value)) {
                        DispatchNode coerceNode__ = (DispatchNode)this.insert(DispatchNode.create());
                        Objects.requireNonNull(coerceNode__, "Specialization 'replaceCoerce(RubyHash, Object, DispatchNode, InitializeCopyNode)' cache 'coerceNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.replaceCoerce_coerceNode_ = coerceNode__;
                        HashNodes.InitializeCopyNode initializeCopy__ = (HashNodes.InitializeCopyNode)this.insert(HashNodes.InitializeCopyNode.create());
                        Objects.requireNonNull(initializeCopy__, "Specialization 'replaceCoerce(RubyHash, Object, DispatchNode, InitializeCopyNode)' cache 'initializeCopy' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.replaceCoerce_initializeCopy_ = initializeCopy__;
                        this.state_0_ = state_0 |= 4;
                        return this.replaceCoerce(argumentNodes0Value_, argumentNodes1Value, coerceNode__, initializeCopy__);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_}, new Object[]{argumentNodes0Value, argumentNodes1Value});
            }

            public NodeCost getCost() {
                Replace0Data s0_;
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & state_0 - 1) == 0 && ((s0_ = this.replace0_cache) == null || s0_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=HashNodes.InitializeCopyNode.class)
            @DenyReplace
            private static final class Replace0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                Replace0Data next_;
                @Node.Child
                HashStoreLibrary hashes_;

                Replace0Data(Replace0Data next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.MapNode.class)
    public static final class MapNodeFactory
    implements NodeFactory<HashNodes.MapNode> {
        private static final MapNodeFactory MAP_NODE_FACTORY_INSTANCE = new MapNodeFactory();

        private MapNodeFactory() {
        }

        public Class<HashNodes.MapNode> getNodeClass() {
            return HashNodes.MapNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.MapNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return MapNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.MapNode> getInstance() {
            return MAP_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static HashNodes.MapNode create(RubyNode[] argumentNodes) {
            return new MapNodeGen(argumentNodes);
        }

        @GeneratedBy(value=HashNodes.MapNode.class)
        public static final class MapNodeGen
        extends HashNodes.MapNode {
            static final InlineSupport.ReferenceField<Map0Data> MAP0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"map0_cache", Map0Data.class);
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Map0Data map0_cache;

            private MapNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_, this.argumentNodes1_};
            }

            @Override
            @ExplodeLoop
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyHash) {
                    RubyHash argumentNodes0Value__ = (RubyHash)argumentNodes0Value_;
                    if (argumentNodes1Value_ instanceof RubyProc) {
                        RubyProc argumentNodes1Value__ = (RubyProc)argumentNodes1Value_;
                        if ((state_0 & 1) != 0) {
                            Map0Data s0_ = this.map0_cache;
                            while (s0_ != null) {
                                if (s0_.hashes_.accepts(argumentNodes0Value__.store)) {
                                    return this.map(argumentNodes0Value__, argumentNodes1Value__, s0_.hashes_);
                                }
                                s0_ = s0_.next_;
                            }
                        }
                        if ((state_0 & 2) != 0) {
                            return this.map1Boundary(state_0, argumentNodes0Value__, argumentNodes1Value__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            private Object map1Boundary(int state_0, RubyHash argumentNodes0Value__, RubyProc argumentNodes1Value__) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    HashStoreLibrary hashes__ = (HashStoreLibrary)HASH_STORE_LIBRARY_.getUncached(argumentNodes0Value__.store);
                    RubyArray rubyArray = this.map(argumentNodes0Value__, argumentNodes1Value__, hashes__);
                    return rubyArray;
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private RubyArray executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyHash) {
                    RubyHash argumentNodes0Value_ = (RubyHash)argumentNodes0Value;
                    if (argumentNodes1Value instanceof RubyProc) {
                        RubyProc argumentNodes1Value_ = (RubyProc)argumentNodes1Value;
                        if ((state_0 & 2) == 0) {
                            Map0Data s0_;
                            block9: {
                                Map0Data s0_original;
                                do {
                                    int count0_ = 0;
                                    s0_original = s0_ = (Map0Data)((Object)MAP0_CACHE_UPDATER.getVolatile((Node)this));
                                    while (s0_ != null && !s0_.hashes_.accepts(argumentNodes0Value_.store)) {
                                        ++count0_;
                                        s0_ = s0_.next_;
                                    }
                                    if (s0_ != null || count0_ >= HashGuards.hashStrategyLimit()) break block9;
                                    s0_ = (Map0Data)this.insert(new Map0Data(s0_original));
                                    HashStoreLibrary hashes__ = (HashStoreLibrary)s0_.insert((Node)((HashStoreLibrary)HASH_STORE_LIBRARY_.create(argumentNodes0Value_.store)));
                                    Objects.requireNonNull(hashes__, "Specialization 'map(RubyHash, RubyProc, HashStoreLibrary)' cache 'hashes' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                    s0_.hashes_ = hashes__;
                                } while (!MAP0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                                this.state_0_ = state_0 |= 1;
                            }
                            if (s0_ != null) {
                                return this.map(argumentNodes0Value_, argumentNodes1Value_, s0_.hashes_);
                            }
                        }
                        HashStoreLibrary hashes__ = null;
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set((Node)this);
                        try {
                            hashes__ = (HashStoreLibrary)HASH_STORE_LIBRARY_.getUncached(argumentNodes0Value_.store);
                            this.map0_cache = null;
                            state_0 &= 0xFFFFFFFE;
                            this.state_0_ = state_0 |= 2;
                            RubyArray rubyArray = this.map(argumentNodes0Value_, argumentNodes1Value_, hashes__);
                            return rubyArray;
                        }
                        finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_}, new Object[]{argumentNodes0Value, argumentNodes1Value});
            }

            public NodeCost getCost() {
                Map0Data s0_;
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & state_0 - 1) == 0 && ((s0_ = this.map0_cache) == null || s0_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=HashNodes.MapNode.class)
            @DenyReplace
            private static final class Map0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                Map0Data next_;
                @Node.Child
                HashStoreLibrary hashes_;

                Map0Data(Map0Data next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.SetDefaultProcNode.class)
    public static final class SetDefaultProcNodeFactory
    implements NodeFactory<HashNodes.SetDefaultProcNode> {
        private static final SetDefaultProcNodeFactory SET_DEFAULT_PROC_NODE_FACTORY_INSTANCE = new SetDefaultProcNodeFactory();

        private SetDefaultProcNodeFactory() {
        }

        public Class<HashNodes.SetDefaultProcNode> getNodeClass() {
            return HashNodes.SetDefaultProcNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.SetDefaultProcNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SetDefaultProcNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.SetDefaultProcNode> getInstance() {
            return SET_DEFAULT_PROC_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static HashNodes.SetDefaultProcNode create(RubyNode[] argumentNodes) {
            return new SetDefaultProcNodeGen(argumentNodes);
        }

        @GeneratedBy(value=HashNodes.SetDefaultProcNode.class)
        public static final class SetDefaultProcNodeGen
        extends HashNodes.SetDefaultProcNode {
            private static final InlineSupport.StateField STATE_0_SetDefaultProcNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PropagateSharingNode INLINED_SET_DEFAULT_PROC0_PROPAGATE_SHARING_NODE_ = PropagateSharingNodeGen.inline(InlineSupport.InlineTarget.create(PropagateSharingNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_SetDefaultProcNode_UPDATER.subUpdater(2, 10), STATE_0_SetDefaultProcNode_UPDATER.subUpdater(12, 3), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"setDefaultProc0_propagateSharingNode__field2_", Object.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"setDefaultProc0_propagateSharingNode__field3_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"setDefaultProc0_propagateSharingNode__field4_", Object.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"setDefaultProc0_propagateSharingNode__field5_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"setDefaultProc0_propagateSharingNode__field6_", Node.class)}));
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object setDefaultProc0_propagateSharingNode__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node setDefaultProc0_propagateSharingNode__field3_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object setDefaultProc0_propagateSharingNode__field4_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node setDefaultProc0_propagateSharingNode__field5_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node setDefaultProc0_propagateSharingNode__field6_;

            private SetDefaultProcNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            public RubyNode[] getArgumentNodes() {
                return new RubyNode[]{this.argumentNodes0_, this.argumentNodes1_};
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                if ((state_0 & 3) != 0 && argumentNodes0Value_ instanceof RubyHash) {
                    RubyHash argumentNodes0Value__ = (RubyHash)argumentNodes0Value_;
                    if ((state_0 & 1) != 0 && argumentNodes1Value_ instanceof RubyProc) {
                        RubyProc argumentNodes1Value__ = (RubyProc)argumentNodes1Value_;
                        return this.setDefaultProc(argumentNodes0Value__, argumentNodes1Value__, INLINED_SET_DEFAULT_PROC0_PROPAGATE_SHARING_NODE_);
                    }
                    if ((state_0 & 2) != 0 && RubyTypes.isNil(argumentNodes1Value_)) {
                        Nil argumentNodes1Value__ = RubyTypes.asNil(argumentNodes1Value_);
                        return this.setDefaultProc(argumentNodes0Value__, argumentNodes1Value__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyHash) {
                    RubyHash argumentNodes0Value_ = (RubyHash)argumentNodes0Value;
                    if (argumentNodes1Value instanceof RubyProc) {
                        RubyProc argumentNodes1Value_ = (RubyProc)argumentNodes1Value;
                        this.state_0_ = state_0 |= 1;
                        return this.setDefaultProc(argumentNodes0Value_, argumentNodes1Value_, INLINED_SET_DEFAULT_PROC0_PROPAGATE_SHARING_NODE_);
                    }
                    if (RubyTypes.isNil(argumentNodes1Value)) {
                        Nil argumentNodes1Value_ = RubyTypes.asNil(argumentNodes1Value);
                        this.state_0_ = state_0 |= 2;
                        return this.setDefaultProc(argumentNodes0Value_, argumentNodes1Value_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_}, new Object[]{argumentNodes0Value, argumentNodes1Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 3) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 3 & (state_0 & 3) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }
        }
    }

    @GeneratedBy(value=HashNodes.SetDefaultValueNode.class)
    public static final class SetDefaultValueNodeFactory
    implements NodeFactory<HashNodes.SetDefaultValueNode> {
        private static final SetDefaultValueNodeFactory SET_DEFAULT_VALUE_NODE_FACTORY_INSTANCE = new SetDefaultValueNodeFactory();

        private SetDefaultValueNodeFactory() {
        }

        public Class<HashNodes.SetDefaultValueNode> getNodeClass() {
            return HashNodes.SetDefaultValueNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.SetDefaultValueNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SetDefaultValueNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.SetDefaultValueNode> getInstance() {
            return SET_DEFAULT_VALUE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static HashNodes.SetDefaultValueNode create(RubyNode[] argumentNodes) {
            return new SetDefaultValueNodeGen(argumentNodes);
        }

        @GeneratedBy(value=HashNodes.SetDefaultValueNode.class)
        public static final class SetDefaultValueNodeGen
        extends HashNodes.SetDefaultValueNode {
            private static final InlineSupport.StateField STATE_0_SetDefaultValueNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PropagateSharingNode INLINED_PROPAGATE_SHARING_NODE_ = PropagateSharingNodeGen.inline(InlineSupport.InlineTarget.create(PropagateSharingNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_SetDefaultValueNode_UPDATER.subUpdater(1, 10), STATE_0_SetDefaultValueNode_UPDATER.subUpdater(11, 3), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"propagateSharingNode__field2_", Object.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"propagateSharingNode__field3_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"propagateSharingNode__field4_", Object.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"propagateSharingNode__field5_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"propagateSharingNode__field6_", Node.class)}));
            @Node.Child
            private RubyNode argumentNodes0_;
            @Node.Child
            private RubyNode argumentNodes1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object propagateSharingNode__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node propagateSharingNode__field3_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object propagateSharingNode__field4_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node propagateSharingNode__field5_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node propagateSharingNode__field6_;

            private SetDefaultValueNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
                this.argumentNodes1_ = argumentNodes != null && 1 < argumentNodes.length ? argumentNodes[1] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                Object argumentNodes1Value_ = this.argumentNodes1_.execute(frameValue);
                if ((state_0 & 1) != 0 && argumentNodes0Value_ instanceof RubyHash) {
                    RubyHash argumentNodes0Value__ = (RubyHash)argumentNodes0Value_;
                    return this.setDefault(argumentNodes0Value__, argumentNodes1Value_, INLINED_PROPAGATE_SHARING_NODE_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_, argumentNodes1Value_);
            }

            private Object executeAndSpecialize(Object argumentNodes0Value, Object argumentNodes1Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyHash) {
                    RubyHash argumentNodes0Value_ = (RubyHash)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.setDefault(argumentNodes0Value_, argumentNodes1Value, INLINED_PROPAGATE_SHARING_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_, this.argumentNodes1_}, new Object[]{argumentNodes0Value, argumentNodes1Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=HashNodes.ShiftNode.class)
    public static final class ShiftNodeFactory
    implements NodeFactory<HashNodes.ShiftNode> {
        private static final ShiftNodeFactory SHIFT_NODE_FACTORY_INSTANCE = new ShiftNodeFactory();

        private ShiftNodeFactory() {
        }

        public Class<HashNodes.ShiftNode> getNodeClass() {
            return HashNodes.ShiftNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.ShiftNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ShiftNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.ShiftNode> getInstance() {
            return SHIFT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static HashNodes.ShiftNode create(RubyNode[] argumentNodes) {
            return new ShiftNodeGen(argumentNodes);
        }

        @GeneratedBy(value=HashNodes.ShiftNode.class)
        public static final class ShiftNodeGen
        extends HashNodes.ShiftNode {
            static final InlineSupport.ReferenceField<Shift0Data> SHIFT0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"shift0_cache", Shift0Data.class);
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private DispatchNode shiftEmpty_callDefault_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Shift0Data shift0_cache;

            private ShiftNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            @ExplodeLoop
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyHash) {
                    DispatchNode callDefault__;
                    RubyHash argumentNodes0Value__ = (RubyHash)argumentNodes0Value_;
                    if ((state_0 & 1) != 0 && (callDefault__ = this.shiftEmpty_callDefault_) != null && argumentNodes0Value__.empty()) {
                        return this.shiftEmpty(argumentNodes0Value__, callDefault__);
                    }
                    if ((state_0 & 2) != 0) {
                        Shift0Data s1_ = this.shift0_cache;
                        while (s1_ != null) {
                            if (s1_.hashes_.accepts(argumentNodes0Value__.store) && !argumentNodes0Value__.empty()) {
                                return this.shift(argumentNodes0Value__, s1_.hashes_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 4) != 0 && !argumentNodes0Value__.empty()) {
                        return this.shift1Boundary(state_0, argumentNodes0Value__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            private Object shift1Boundary(int state_0, RubyHash argumentNodes0Value__) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    HashStoreLibrary hashes__ = (HashStoreLibrary)HASH_STORE_LIBRARY_.getUncached(argumentNodes0Value__.store);
                    RubyArray rubyArray = this.shift(argumentNodes0Value__, hashes__);
                    return rubyArray;
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private TruffleObject executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyHash) {
                    RubyHash argumentNodes0Value_ = (RubyHash)argumentNodes0Value;
                    if (argumentNodes0Value_.empty()) {
                        DispatchNode callDefault__ = (DispatchNode)this.insert(DispatchNode.create());
                        Objects.requireNonNull(callDefault__, "Specialization 'shiftEmpty(RubyHash, DispatchNode)' cache 'callDefault' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.shiftEmpty_callDefault_ = callDefault__;
                        this.state_0_ = state_0 |= 1;
                        return this.shiftEmpty(argumentNodes0Value_, callDefault__);
                    }
                    if ((state_0 & 4) == 0) {
                        Shift0Data s1_;
                        block10: {
                            Shift0Data s1_original;
                            do {
                                int count1_ = 0;
                                s1_original = s1_ = (Shift0Data)((Object)SHIFT0_CACHE_UPDATER.getVolatile((Node)this));
                                while (s1_ != null && (!s1_.hashes_.accepts(argumentNodes0Value_.store) || argumentNodes0Value_.empty())) {
                                    ++count1_;
                                    s1_ = s1_.next_;
                                }
                                if (s1_ != null || argumentNodes0Value_.empty() || count1_ >= HashGuards.hashStrategyLimit()) break block10;
                                s1_ = (Shift0Data)this.insert(new Shift0Data(s1_original));
                                HashStoreLibrary hashes__ = (HashStoreLibrary)s1_.insert((Node)((HashStoreLibrary)HASH_STORE_LIBRARY_.create(argumentNodes0Value_.store)));
                                Objects.requireNonNull(hashes__, "Specialization 'shift(RubyHash, HashStoreLibrary)' cache 'hashes' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s1_.hashes_ = hashes__;
                            } while (!SHIFT0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s1_original, (Object)s1_));
                            this.state_0_ = state_0 |= 2;
                        }
                        if (s1_ != null) {
                            return this.shift(argumentNodes0Value_, s1_.hashes_);
                        }
                    }
                    HashStoreLibrary hashes__ = null;
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set((Node)this);
                    try {
                        if (!argumentNodes0Value_.empty()) {
                            hashes__ = (HashStoreLibrary)HASH_STORE_LIBRARY_.getUncached(argumentNodes0Value_.store);
                            this.shift0_cache = null;
                            state_0 &= 0xFFFFFFFD;
                            this.state_0_ = state_0 |= 4;
                            RubyArray rubyArray = this.shift(argumentNodes0Value_, hashes__);
                            return rubyArray;
                        }
                    }
                    finally {
                        encapsulating_.set(prev_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }

            public NodeCost getCost() {
                Shift0Data s1_;
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & state_0 - 1) == 0 && ((s1_ = this.shift0_cache) == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=HashNodes.ShiftNode.class)
            @DenyReplace
            private static final class Shift0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                Shift0Data next_;
                @Node.Child
                HashStoreLibrary hashes_;

                Shift0Data(Shift0Data next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.SizeNode.class)
    public static final class SizeNodeFactory
    implements NodeFactory<HashNodes.SizeNode> {
        private static final SizeNodeFactory SIZE_NODE_FACTORY_INSTANCE = new SizeNodeFactory();

        private SizeNodeFactory() {
        }

        public Class<HashNodes.SizeNode> getNodeClass() {
            return HashNodes.SizeNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.SizeNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SizeNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.SizeNode> getInstance() {
            return SIZE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static HashNodes.SizeNode create(RubyNode[] argumentNodes) {
            return new SizeNodeGen(argumentNodes);
        }

        @GeneratedBy(value=HashNodes.SizeNode.class)
        public static final class SizeNodeGen
        extends HashNodes.SizeNode {
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private SizeNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyHash) {
                    RubyHash argumentNodes0Value__ = (RubyHash)argumentNodes0Value_;
                    return this.size(argumentNodes0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            private int executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyHash) {
                    RubyHash argumentNodes0Value_ = (RubyHash)argumentNodes0Value;
                    this.state_0_ = state_0 |= 1;
                    return this.size(argumentNodes0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }
        }
    }

    @GeneratedBy(value=HashNodes.RehashNode.class)
    public static final class RehashNodeFactory
    implements NodeFactory<HashNodes.RehashNode> {
        private static final RehashNodeFactory REHASH_NODE_FACTORY_INSTANCE = new RehashNodeFactory();

        private RehashNodeFactory() {
        }

        public Class<HashNodes.RehashNode> getNodeClass() {
            return HashNodes.RehashNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.RehashNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return RehashNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.RehashNode> getInstance() {
            return REHASH_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static HashNodes.RehashNode create(RubyNode[] argumentNodes) {
            return new RehashNodeGen(argumentNodes);
        }

        @GeneratedBy(value=HashNodes.RehashNode.class)
        public static final class RehashNodeGen
        extends HashNodes.RehashNode {
            static final InlineSupport.ReferenceField<RehashNotIdentity0Data> REHASH_NOT_IDENTITY0_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"rehashNotIdentity0_cache", RehashNotIdentity0Data.class);
            @Node.Child
            private RubyNode argumentNodes0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private RehashNotIdentity0Data rehashNotIdentity0_cache;

            private RehashNodeGen(RubyNode[] argumentNodes) {
                this.argumentNodes0_ = argumentNodes != null && 0 < argumentNodes.length ? argumentNodes[0] : null;
            }

            @Override
            @ExplodeLoop
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object argumentNodes0Value_ = this.argumentNodes0_.execute(frameValue);
                if (state_0 != 0 && argumentNodes0Value_ instanceof RubyHash) {
                    RubyHash argumentNodes0Value__ = (RubyHash)argumentNodes0Value_;
                    if ((state_0 & 1) != 0 && HashGuards.isCompareByIdentity(argumentNodes0Value__)) {
                        return this.rehashIdentity(argumentNodes0Value__);
                    }
                    if ((state_0 & 2) != 0) {
                        RehashNotIdentity0Data s1_ = this.rehashNotIdentity0_cache;
                        while (s1_ != null) {
                            if (s1_.hashes_.accepts(argumentNodes0Value__.store) && !HashGuards.isCompareByIdentity(argumentNodes0Value__)) {
                                return this.rehashNotIdentity(argumentNodes0Value__, s1_.hashes_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 4) != 0 && !HashGuards.isCompareByIdentity(argumentNodes0Value__)) {
                        return this.rehashNotIdentity1Boundary(state_0, argumentNodes0Value__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(argumentNodes0Value_);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            private Object rehashNotIdentity1Boundary(int state_0, RubyHash argumentNodes0Value__) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    HashStoreLibrary hashes__ = (HashStoreLibrary)HASH_STORE_LIBRARY_.getUncached(argumentNodes0Value__.store);
                    RubyHash rubyHash = this.rehashNotIdentity(argumentNodes0Value__, hashes__);
                    return rubyHash;
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private RubyHash executeAndSpecialize(Object argumentNodes0Value) {
                int state_0 = this.state_0_;
                if (argumentNodes0Value instanceof RubyHash) {
                    RubyHash argumentNodes0Value_ = (RubyHash)argumentNodes0Value;
                    if (HashGuards.isCompareByIdentity(argumentNodes0Value_)) {
                        this.state_0_ = state_0 |= 1;
                        return this.rehashIdentity(argumentNodes0Value_);
                    }
                    if ((state_0 & 4) == 0) {
                        RehashNotIdentity0Data s1_;
                        block10: {
                            RehashNotIdentity0Data s1_original;
                            do {
                                int count1_ = 0;
                                s1_original = s1_ = (RehashNotIdentity0Data)((Object)REHASH_NOT_IDENTITY0_CACHE_UPDATER.getVolatile((Node)this));
                                while (s1_ != null && (!s1_.hashes_.accepts(argumentNodes0Value_.store) || HashGuards.isCompareByIdentity(argumentNodes0Value_))) {
                                    ++count1_;
                                    s1_ = s1_.next_;
                                }
                                if (s1_ != null || HashGuards.isCompareByIdentity(argumentNodes0Value_) || count1_ >= HashGuards.hashStrategyLimit()) break block10;
                                s1_ = (RehashNotIdentity0Data)this.insert(new RehashNotIdentity0Data(s1_original));
                                HashStoreLibrary hashes__ = (HashStoreLibrary)s1_.insert((Node)((HashStoreLibrary)HASH_STORE_LIBRARY_.create(argumentNodes0Value_.store)));
                                Objects.requireNonNull(hashes__, "Specialization 'rehashNotIdentity(RubyHash, HashStoreLibrary)' cache 'hashes' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                                s1_.hashes_ = hashes__;
                            } while (!REHASH_NOT_IDENTITY0_CACHE_UPDATER.compareAndSet((Node)this, (Object)s1_original, (Object)s1_));
                            this.state_0_ = state_0 |= 2;
                        }
                        if (s1_ != null) {
                            return this.rehashNotIdentity(argumentNodes0Value_, s1_.hashes_);
                        }
                    }
                    HashStoreLibrary hashes__ = null;
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set((Node)this);
                    try {
                        if (!HashGuards.isCompareByIdentity(argumentNodes0Value_)) {
                            hashes__ = (HashStoreLibrary)HASH_STORE_LIBRARY_.getUncached(argumentNodes0Value_.store);
                            this.rehashNotIdentity0_cache = null;
                            state_0 &= 0xFFFFFFFD;
                            this.state_0_ = state_0 |= 4;
                            RubyHash rubyHash = this.rehashNotIdentity(argumentNodes0Value_, hashes__);
                            return rubyHash;
                        }
                    }
                    finally {
                        encapsulating_.set(prev_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.argumentNodes0_}, new Object[]{argumentNodes0Value});
            }

            public NodeCost getCost() {
                RehashNotIdentity0Data s1_;
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & state_0 - 1) == 0 && ((s1_ = this.rehashNotIdentity0_cache) == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(value=HashNodes.RehashNode.class)
            @DenyReplace
            private static final class RehashNotIdentity0Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                RehashNotIdentity0Data next_;
                @Node.Child
                HashStoreLibrary hashes_;

                RehashNotIdentity0Data(RehashNotIdentity0Data next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.CopyHashAndSetRuby2KeywordsNode.class)
    public static final class CopyHashAndSetRuby2KeywordsNodeGen
    extends HashNodes.CopyHashAndSetRuby2KeywordsNode {
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private KernelNodes.CopyInstanceVariablesNode copyInstanceVariablesNode_;
        @Node.Child
        private DispatchNode initializeDupNode_;

        private CopyHashAndSetRuby2KeywordsNodeGen() {
        }

        @Override
        public RubyHash execute(RubyHash arg0Value, boolean arg1Value) {
            DispatchNode initializeDupNode__;
            KernelNodes.CopyInstanceVariablesNode copyInstanceVariablesNode__;
            int state_0 = this.state_0_;
            if (state_0 != 0 && (copyInstanceVariablesNode__ = this.copyInstanceVariablesNode_) != null && (initializeDupNode__ = this.initializeDupNode_) != null) {
                return this.copyAndSetRuby2Keywords(arg0Value, arg1Value, copyInstanceVariablesNode__, initializeDupNode__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private RubyHash executeAndSpecialize(RubyHash arg0Value, boolean arg1Value) {
            int state_0 = this.state_0_;
            KernelNodes.CopyInstanceVariablesNode copyInstanceVariablesNode__ = (KernelNodes.CopyInstanceVariablesNode)this.insert(KernelNodesFactory.CopyInstanceVariablesNodeGen.create());
            Objects.requireNonNull(copyInstanceVariablesNode__, "Specialization 'copyAndSetRuby2Keywords(RubyHash, boolean, CopyInstanceVariablesNode, DispatchNode)' cache 'copyInstanceVariablesNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.copyInstanceVariablesNode_ = copyInstanceVariablesNode__;
            DispatchNode initializeDupNode__ = (DispatchNode)this.insert(DispatchNode.create());
            Objects.requireNonNull(initializeDupNode__, "Specialization 'copyAndSetRuby2Keywords(RubyHash, boolean, CopyInstanceVariablesNode, DispatchNode)' cache 'initializeDupNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.initializeDupNode_ = initializeDupNode__;
            this.state_0_ = state_0 |= 1;
            return this.copyAndSetRuby2Keywords(arg0Value, arg1Value, copyInstanceVariablesNode__, initializeDupNode__);
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        @NeverDefault
        public static HashNodes.CopyHashAndSetRuby2KeywordsNode create() {
            return new CopyHashAndSetRuby2KeywordsNodeGen();
        }
    }
}

