/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.hash;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.dispatch.DispatchNode;

@GenerateUncached
public abstract class FreezeHashKeyIfNeededNode
extends RubyBaseNode {
    public abstract Object executeFreezeIfNeeded(Object var1, boolean var2);

    @Specialization
    Object immutable(ImmutableRubyString string, boolean compareByIdentity) {
        return string;
    }

    @Specialization(guards={"string.isFrozen()"})
    Object alreadyFrozen(RubyString string, boolean compareByIdentity) {
        return string;
    }

    @Specialization(guards={"!string.isFrozen()", "!compareByIdentity"})
    Object dupAndFreeze(RubyString string, boolean compareByIdentity, @Cached DispatchNode dupNode) {
        RubyString copy = (RubyString)((Object)dupNode.call((Object)string, "dup"));
        copy.freeze();
        return copy;
    }

    @Specialization(guards={"!string.isFrozen()", "compareByIdentity"})
    Object compareByIdentity(RubyString string, boolean compareByIdentity) {
        return string;
    }

    @Specialization(guards={"isNotRubyString(value)"})
    Object passThrough(Object value, boolean compareByIdentity) {
        return value;
    }
}

