/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.write.bytes;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.language.library.RubyStringLibrary;

@NodeChildren(value={@NodeChild(value="width"), @NodeChild(value="precision"), @NodeChild(value="value")})
public abstract class WritePaddedBytesNode
extends FormatNode {
    private final ConditionProfile leftJustifiedProfile = ConditionProfile.create();
    private final ConditionProfile paddingProfile = ConditionProfile.create();
    private final ConditionProfile precisionProfile = ConditionProfile.create();
    private final boolean leftJustified;

    public WritePaddedBytesNode(boolean leftJustified) {
        this.leftJustified = leftJustified;
    }

    @Specialization(guards={"libString.isRubyString(string)"}, limit="1")
    Object write(VirtualFrame frame, int padding, int precision, Object string, @Cached RubyStringLibrary libString, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.CodePointIndexToByteIndexNode codePointIndexToByteIndexNode, @Cached TruffleString.GetInternalByteArrayNode byteArrayNode) {
        if (padding == Integer.MIN_VALUE) {
            padding = 0;
        }
        AbstractTruffleString tstring = libString.getTString(string);
        RubyEncoding encoding = libString.getEncoding(string);
        if (this.leftJustifiedProfile.profile(this.leftJustified || padding < 0)) {
            this.writeStringBytes(frame, precision, tstring, encoding, codePointIndexToByteIndexNode, byteArrayNode);
            this.writePaddingBytes(frame, Math.abs(padding), precision, tstring, encoding, codePointLengthNode);
        } else {
            this.writePaddingBytes(frame, padding, precision, tstring, encoding, codePointLengthNode);
            this.writeStringBytes(frame, precision, tstring, encoding, codePointIndexToByteIndexNode, byteArrayNode);
        }
        return null;
    }

    private void writeStringBytes(VirtualFrame frame, int precision, AbstractTruffleString tstring, RubyEncoding encoding, TruffleString.CodePointIndexToByteIndexNode codePointIndexToByteIndexNode, TruffleString.GetInternalByteArrayNode byteArrayNode) {
        int index;
        InternalByteArray byteArray = byteArrayNode.execute(tstring, encoding.tencoding);
        int length = this.precisionProfile.profile(precision >= 0 && byteArray.getLength() > precision) ? ((index = codePointIndexToByteIndexNode.execute(tstring, 0, precision, encoding.tencoding)) >= 0 ? index : byteArray.getLength()) : byteArray.getLength();
        this.writeBytes(frame, byteArray.getArray(), byteArray.getOffset(), length);
    }

    private void writePaddingBytes(VirtualFrame frame, int padding, int precision, AbstractTruffleString tstring, RubyEncoding encoding, TruffleString.CodePointLengthNode codePointLengthNode) {
        if (this.paddingProfile.profile(padding > 0)) {
            int codePointLength = codePointLengthNode.execute(tstring, encoding.tencoding);
            int padBytes = precision > 0 && codePointLength > precision ? padding - precision : (padding > 0 && padding > codePointLength ? padding - codePointLength : 0);
            for (int n = 0; n < padBytes; ++n) {
                this.writeByte(frame, (byte)32);
            }
        }
    }
}

