/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.read.bytes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.core.format.MissingValue;
import org.truffleruby.core.format.exceptions.InvalidFormatException;
import org.truffleruby.core.format.read.SourceNode;
import org.truffleruby.core.string.StringUtils;

@NodeChild(value="source", type=SourceNode.class)
public abstract class ReadUTF8CharacterNode
extends FormatNode {
    @Specialization(guards={"isNull(source)"})
    void read(VirtualFrame frame, Object source) {
        this.advanceSourcePosition(frame, 1);
        throw new IllegalStateException();
    }

    @Specialization
    Object read(VirtualFrame frame, byte[] source, @Cached InlinedBranchProfile errorProfile, @Cached InlinedConditionProfile rangeProfile) {
        int length;
        int index = this.getSourcePosition(frame);
        int end = this.getSourceEnd(frame);
        assert (index != -1);
        if (rangeProfile.profile((Node)this, index >= end)) {
            return MissingValue.INSTANCE;
        }
        long codepoint = source[index] & 0xFF;
        if (codepoint >> 7 == 0L) {
            length = 1;
            codepoint &= 0x7FL;
        } else if (codepoint >> 5 == 6L) {
            length = 2;
            codepoint &= 0x1FL;
        } else if (codepoint >> 4 == 14L) {
            length = 3;
            codepoint &= 0xFL;
        } else if (codepoint >> 3 == 30L) {
            length = 4;
            codepoint &= 7L;
        } else if (codepoint >> 2 == 62L) {
            length = 5;
            codepoint &= 3L;
        } else if (codepoint >> 1 == 126L) {
            length = 6;
            codepoint &= 1L;
        } else {
            length = 1;
        }
        if (index + length > end) {
            errorProfile.enter((Node)this);
            throw new InvalidFormatException(this.formatError(index, end, length));
        }
        for (int n = 1; n < length; ++n) {
            codepoint <<= 6;
            codepoint |= (long)(source[index + n] & 0x3F);
        }
        this.setSourcePosition(frame, index + length);
        return codepoint;
    }

    @CompilerDirectives.TruffleBoundary
    private String formatError(int index, int end, int length) {
        return StringUtils.format("malformed UTF-8 character (expected %d bytes, given %d bytes)", length, end - index);
    }
}

