/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.read.bytes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.core.format.exceptions.InvalidFormatException;
import org.truffleruby.core.format.read.SourceNode;
import org.truffleruby.core.format.write.bytes.EncodeUM;

@NodeChild(value="source", type=SourceNode.class)
public abstract class ReadBase64StringNode
extends FormatNode {
    @Node.Child
    private TruffleString.FromByteArrayNode fromByteArrayNode = TruffleString.FromByteArrayNode.create();
    private final int count;

    public ReadBase64StringNode(int count) {
        this.count = count;
    }

    @Specialization
    Object read(VirtualFrame frame, byte[] source) {
        ByteBuffer encode = this.wrapByteBuffer(frame, source);
        byte[] result = this.read(encode);
        this.setSourcePosition(frame, encode.position());
        return this.createString(this.fromByteArrayNode, result, Encodings.BINARY);
    }

    @CompilerDirectives.TruffleBoundary
    private byte[] read(ByteBuffer encode) {
        int length = encode.remaining() * 3 / 4;
        byte[] lElem = new byte[length];
        int a = -1;
        int b = -1;
        int c = 0;
        int index = 0;
        int s = -1;
        if (this.count == 0) {
            if (encode.remaining() % 4 != 0) {
                throw new InvalidFormatException("invalid base64");
            }
            while (encode.hasRemaining()) {
                s = ReadBase64StringNode.safeGet(encode);
                a = EncodeUM.b64_xtable[s];
                if (a == -1) {
                    throw new InvalidFormatException("invalid base64");
                }
                s = ReadBase64StringNode.safeGet(encode);
                b = EncodeUM.b64_xtable[s];
                if (b == -1) {
                    throw new InvalidFormatException("invalid base64");
                }
                s = ReadBase64StringNode.safeGet(encode);
                c = EncodeUM.b64_xtable[s];
                if (s == 61) {
                    if (ReadBase64StringNode.safeGet(encode) == 61) break;
                    throw new InvalidFormatException("invalid base64");
                }
                if (c == -1) {
                    throw new InvalidFormatException("invalid base64");
                }
                s = ReadBase64StringNode.safeGet(encode);
                int d = EncodeUM.b64_xtable[s];
                if (s == 61) break;
                if (d == -1) {
                    throw new InvalidFormatException("invalid base64");
                }
                lElem[index++] = (byte)((a << 2 | b >> 4) & 0xFF);
                lElem[index++] = (byte)((b << 4 | c >> 2) & 0xFF);
                lElem[index++] = (byte)((c << 6 | d) & 0xFF);
            }
            if (encode.hasRemaining()) {
                throw new InvalidFormatException("invalid base64");
            }
            if (a != -1) {
                if (c == -1 && s == 61) {
                    if ((b & 0xF) != 0) {
                        throw new InvalidFormatException("invalid base64");
                    }
                    lElem[index++] = (byte)((a << 2 | b >> 4) & 0xFF);
                } else if (c != -1 && s == 61) {
                    if ((c & 3) != 0) {
                        throw new InvalidFormatException("invalid base64");
                    }
                    lElem[index++] = (byte)((a << 2 | b >> 4) & 0xFF);
                    lElem[index++] = (byte)((b << 4 | c >> 2) & 0xFF);
                }
            }
        } else {
            while (encode.hasRemaining()) {
                int d;
                c = -1;
                b = -1;
                s = ReadBase64StringNode.safeGet(encode);
                while ((a = EncodeUM.b64_xtable[s]) == -1 && encode.hasRemaining()) {
                    s = ReadBase64StringNode.safeGet(encode);
                }
                if (a == -1) break;
                s = ReadBase64StringNode.safeGet(encode);
                while ((b = EncodeUM.b64_xtable[s]) == -1 && encode.hasRemaining()) {
                    s = ReadBase64StringNode.safeGet(encode);
                }
                if (b == -1) break;
                s = ReadBase64StringNode.safeGet(encode);
                while ((c = EncodeUM.b64_xtable[s]) == -1 && encode.hasRemaining() && s != 61) {
                    s = ReadBase64StringNode.safeGet(encode);
                }
                if (s == 61 || c == -1) {
                    if (s != 61) break;
                    encode.position(encode.position() - 1);
                    break;
                }
                s = ReadBase64StringNode.safeGet(encode);
                while ((d = EncodeUM.b64_xtable[s]) == -1 && encode.hasRemaining() && s != 61) {
                    s = ReadBase64StringNode.safeGet(encode);
                }
                if (s == 61 || d == -1) {
                    if (s != 61) break;
                    encode.position(encode.position() - 1);
                    break;
                }
                lElem[index++] = (byte)((a << 2 | b >> 4) & 0xFF);
                lElem[index++] = (byte)((b << 4 | c >> 2) & 0xFF);
                lElem[index++] = (byte)((c << 6 | d) & 0xFF);
                a = -1;
            }
            if (a != -1 && b != -1) {
                if (c == -1) {
                    lElem[index++] = (byte)((a << 2 | b >> 4) & 0xFF);
                } else {
                    lElem[index++] = (byte)((a << 2 | b >> 4) & 0xFF);
                    lElem[index++] = (byte)((b << 4 | c >> 2) & 0xFF);
                }
            }
        }
        return Arrays.copyOfRange(lElem, 0, index);
    }
}

