/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.printf;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import java.util.List;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.format.FormatEncoding;
import org.truffleruby.core.format.FormatRootNode;
import org.truffleruby.core.format.printf.PrintfSimpleParser;
import org.truffleruby.core.format.printf.PrintfSimpleTreeBuilder;
import org.truffleruby.core.format.printf.SprintfConfig;
import org.truffleruby.core.string.StringSupport;

public final class PrintfCompiler {
    private final RubyLanguage language;
    private final Node currentNode;

    public PrintfCompiler(RubyLanguage language, Node currentNode) {
        this.language = language;
        this.currentNode = currentNode;
    }

    @CompilerDirectives.TruffleBoundary
    public RootCallTarget compile(AbstractTruffleString tstring, RubyEncoding encoding, Object[] arguments, boolean isDebug) {
        InternalByteArray byteArray = tstring.getInternalByteArrayUncached(encoding.tencoding);
        PrintfSimpleParser parser = new PrintfSimpleParser(StringSupport.bytesToChars(byteArray), arguments, isDebug);
        List<SprintfConfig> configs = parser.parse();
        PrintfSimpleTreeBuilder builder = new PrintfSimpleTreeBuilder(this.language, configs, encoding);
        return new FormatRootNode(this.language, this.currentNode.getEncapsulatingSourceSection(), new FormatEncoding(encoding), builder.getNode()).getCallTarget();
    }
}

