/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.pack;

import java.nio.ByteOrder;
import org.truffleruby.core.format.pack.SimplePackListener;
import org.truffleruby.language.control.DeferredRaiseException;

public final class SimplePackParser {
    public static final int COUNT_NONE = -1;
    public static final int COUNT_STAR = -2;
    public static final int SIZE_NATIVE = -1;
    private final SimplePackListener listener;
    private final byte[] bytes;
    private int n;

    public SimplePackParser(SimplePackListener listener, byte[] bytes) {
        this.listener = listener;
        this.bytes = bytes;
    }

    public void parse() throws DeferredRaiseException {
        block66: while (this.n < this.bytes.length) {
            byte b = this.bytes[this.n];
            switch (b) {
                case 67: 
                case 73: 
                case 74: 
                case 76: 
                case 78: 
                case 81: 
                case 83: 
                case 86: 
                case 99: 
                case 105: 
                case 106: 
                case 108: 
                case 110: 
                case 113: 
                case 115: 
                case 118: {
                    ++this.n;
                    int size = switch (b) {
                        case 67, 99 -> 8;
                        case 83, 110, 115, 118 -> 16;
                        case 73, 78, 86, 105 -> 32;
                        case 74, 81, 106, 113 -> 64;
                        case 76, 108 -> -1;
                        default -> throw new UnsupportedOperationException(Character.toString((char)b));
                    };
                    boolean signed = switch (b) {
                        case 99, 105, 106, 108, 113, 115 -> true;
                        case 67, 73, 74, 76, 78, 81, 83, 86, 110, 118 -> false;
                        default -> throw new UnsupportedOperationException(Character.toString((char)b));
                    };
                    ByteOrder byteOrder = null;
                    switch (b) {
                        case 86: 
                        case 118: {
                            byteOrder = ByteOrder.LITTLE_ENDIAN;
                            break;
                        }
                        case 78: 
                        case 110: {
                            byteOrder = ByteOrder.BIG_ENDIAN;
                            break;
                        }
                        case 74: 
                        case 106: {
                            byteOrder = ByteOrder.nativeOrder();
                        }
                    }
                    block67: while (this.n < this.bytes.length) {
                        byte m = this.bytes[this.n];
                        switch (m) {
                            case 60: 
                            case 62: {
                                ++this.n;
                                switch (m) {
                                    case 60: {
                                        byteOrder = ByteOrder.LITTLE_ENDIAN;
                                        continue block67;
                                    }
                                    case 62: {
                                        byteOrder = ByteOrder.BIG_ENDIAN;
                                        continue block67;
                                    }
                                }
                                throw new UnsupportedOperationException(Character.toString((char)m));
                            }
                            case 33: 
                            case 95: {
                                ++this.n;
                                switch (b) {
                                    case 73: 
                                    case 74: 
                                    case 76: 
                                    case 81: 
                                    case 83: 
                                    case 105: 
                                    case 106: 
                                    case 108: 
                                    case 113: 
                                    case 115: {
                                        if (byteOrder != null) break;
                                        byteOrder = ByteOrder.nativeOrder();
                                        break;
                                    }
                                    default: {
                                        this.listener.error(String.format("'%c' allowed only after types sSiIlLqQjJ", Character.valueOf((char)m)));
                                    }
                                }
                                if (size != -1) continue block67;
                                size = 64;
                                continue block67;
                            }
                            case 0: 
                            case 9: 
                            case 10: 
                            case 11: 
                            case 12: 
                            case 13: 
                            case 32: {
                                ++this.n;
                                continue block67;
                            }
                        }
                        break;
                    }
                    if (size == -1) {
                        size = 32;
                    }
                    if (byteOrder == null) {
                        byteOrder = ByteOrder.nativeOrder();
                    }
                    int count = this.count();
                    this.listener.integer(size, signed, byteOrder, count);
                    continue block66;
                }
                case 85: {
                    ++this.n;
                    this.disallowNative(b);
                    this.listener.utf8Character(this.count());
                    continue block66;
                }
                case 119: {
                    ++this.n;
                    this.disallowNative(b);
                    this.listener.berInteger(this.count());
                    continue block66;
                }
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 100: 
                case 101: 
                case 102: 
                case 103: {
                    ++this.n;
                    int size = switch (b) {
                        case 70, 101, 102, 103 -> 32;
                        case 68, 69, 71, 100 -> 64;
                        default -> throw new UnsupportedOperationException(Character.toString((char)b));
                    };
                    ByteOrder byteOrder = switch (b) {
                        case 68, 70, 100, 102 -> ByteOrder.nativeOrder();
                        case 69, 101 -> ByteOrder.LITTLE_ENDIAN;
                        case 71, 103 -> ByteOrder.BIG_ENDIAN;
                        default -> throw new UnsupportedOperationException(Character.toString((char)b));
                    };
                    this.disallowNative(b);
                    int count = this.count();
                    this.listener.floatingPoint(size, byteOrder, count);
                    continue block66;
                }
                case 65: {
                    ++this.n;
                    this.disallowNative(b);
                    this.listener.binaryStringSpacePadded(this.count());
                    continue block66;
                }
                case 97: {
                    ++this.n;
                    this.disallowNative(b);
                    this.listener.binaryStringNullPadded(this.count());
                    continue block66;
                }
                case 90: {
                    ++this.n;
                    this.disallowNative(b);
                    this.listener.binaryStringNullStar(this.count());
                    continue block66;
                }
                case 98: {
                    ++this.n;
                    this.disallowNative(b);
                    this.listener.bitStringMSBLast(this.count());
                    continue block66;
                }
                case 66: {
                    ++this.n;
                    this.disallowNative(b);
                    this.listener.bitStringMSBFirst(this.count());
                    continue block66;
                }
                case 72: {
                    ++this.n;
                    this.disallowNative(b);
                    this.listener.hexStringHighFirst(this.count());
                    continue block66;
                }
                case 104: {
                    ++this.n;
                    this.disallowNative(b);
                    this.listener.hexStringLowFirst(this.count());
                    continue block66;
                }
                case 117: {
                    ++this.n;
                    this.disallowNative(b);
                    this.listener.uuString(this.count());
                    continue block66;
                }
                case 77: {
                    ++this.n;
                    this.disallowNative(b);
                    this.listener.mimeString(this.count());
                    continue block66;
                }
                case 109: {
                    ++this.n;
                    this.disallowNative(b);
                    this.listener.base64String(this.count());
                    continue block66;
                }
                case 80: {
                    ++this.n;
                    this.disallowNative(b);
                    int bigPCount = this.count();
                    this.listener.pointer(1, bigPCount == -1 ? Integer.MAX_VALUE : bigPCount);
                    continue block66;
                }
                case 112: {
                    ++this.n;
                    this.disallowNative(b);
                    int littlePCount = this.count();
                    this.listener.pointer(littlePCount == -1 ? 1 : littlePCount, Integer.MAX_VALUE);
                    continue block66;
                }
                case 64: {
                    ++this.n;
                    this.disallowNative(b);
                    this.listener.at(this.count());
                    continue block66;
                }
                case 88: {
                    ++this.n;
                    this.disallowNative(b);
                    this.listener.back(this.count());
                    continue block66;
                }
                case 120: {
                    ++this.n;
                    this.disallowNative(b);
                    this.listener.nullByte(this.count());
                    continue block66;
                }
                case 37: {
                    ++this.n;
                    this.listener.error("% is not supported");
                    continue block66;
                }
                case 40: {
                    ++this.n;
                    this.listener.startSubSequence();
                    continue block66;
                }
                case 41: {
                    ++this.n;
                    this.listener.finishSubSequence(this.count());
                    continue block66;
                }
                case 0: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 32: {
                    ++this.n;
                    continue block66;
                }
                case 35: {
                    ++this.n;
                    while (this.n < this.bytes.length) {
                        switch (this.bytes[this.n]) {
                            case 10: 
                            case 13: {
                                ++this.n;
                                continue block66;
                            }
                        }
                        ++this.n;
                    }
                    continue block66;
                }
            }
            ++this.n;
            this.listener.warn(String.format("unknown pack directive '%c'", Character.valueOf((char)b)));
        }
    }

    private int count() {
        int count = -1;
        block4: while (this.n < this.bytes.length) {
            byte b = this.bytes[this.n];
            switch (b) {
                case 42: {
                    ++this.n;
                    return -2;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    if (count == -1) {
                        count = 0;
                    }
                    count *= 10;
                    count += this.bytes[this.n] - 48;
                    ++this.n;
                    continue block4;
                }
            }
            break;
        }
        return count;
    }

    private void disallowNative(byte b) throws DeferredRaiseException {
        byte m;
        if (this.n < this.bytes.length && ((m = this.bytes[this.n]) == 33 || m == 95)) {
            ++this.n;
            this.listener.error(String.format("'%c' allowed only after types sSiIlLqQjJ", Character.valueOf((char)b)));
        }
    }
}

