/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.format;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import java.math.BigInteger;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.core.numeric.RubyBignum;
import org.truffleruby.core.string.StringOperations;

@NodeChildren(value={@NodeChild(value="width"), @NodeChild(value="precision"), @NodeChild(value="value")})
public abstract class FormatIntegerBinaryNode
extends FormatNode {
    private final char format;
    private final boolean hasPlusFlag;
    private final boolean useAlternativeFormat;
    private final boolean hasMinusFlag;
    private final boolean hasSpaceFlag;
    private final boolean hasZeroFlag;

    public FormatIntegerBinaryNode(char format, boolean hasPlusFlag, boolean useAlternativeFormat, boolean hasMinusFlag, boolean hasSpaceFlag, boolean hasZeroFlag) {
        this.format = format;
        this.hasPlusFlag = hasPlusFlag;
        this.useAlternativeFormat = useAlternativeFormat;
        this.hasMinusFlag = hasMinusFlag;
        this.hasSpaceFlag = hasSpaceFlag;
        this.hasZeroFlag = hasZeroFlag;
    }

    @Specialization
    byte[] format(int width, int precision, int value) {
        boolean isNegative = value < 0;
        boolean negativeAndPadded = isNegative && (this.hasSpaceFlag || this.hasPlusFlag);
        String formatted = negativeAndPadded ? Integer.toBinaryString(-value) : Integer.toBinaryString(value);
        return FormatIntegerBinaryNode.getFormattedString(formatted, width, precision, isNegative, this.hasSpaceFlag, this.hasPlusFlag, this.hasZeroFlag, this.useAlternativeFormat, this.hasMinusFlag, this.format);
    }

    @Specialization
    byte[] format(int width, int precision, long value) {
        boolean isNegative = value < 0L;
        boolean negativeAndPadded = isNegative && (this.hasSpaceFlag || this.hasPlusFlag);
        String formatted = negativeAndPadded ? Long.toBinaryString(-value) : Long.toBinaryString(value);
        return FormatIntegerBinaryNode.getFormattedString(formatted, width, precision, isNegative, this.hasSpaceFlag, this.hasPlusFlag, this.hasZeroFlag, this.useAlternativeFormat, this.hasMinusFlag, this.format);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization
    byte[] format(int width, int precision, RubyBignum value) {
        String formatted;
        boolean negativeAndPadded;
        BigInteger bigInteger = value.value;
        boolean isNegative = bigInteger.signum() == -1;
        boolean bl = negativeAndPadded = isNegative && (this.hasSpaceFlag || this.hasPlusFlag);
        if (negativeAndPadded) {
            formatted = bigInteger.abs().toString(2);
        } else if (!isNegative) {
            formatted = bigInteger.toString(2);
        } else {
            byte[] bytes;
            StringBuilder builder = new StringBuilder();
            for (byte b : bytes = bigInteger.toByteArray()) {
                builder.append(Integer.toBinaryString(b & 0xFF));
            }
            formatted = builder.toString();
        }
        return FormatIntegerBinaryNode.getFormattedString(formatted, width, precision, isNegative, this.hasSpaceFlag, this.hasPlusFlag, this.hasZeroFlag, this.useAlternativeFormat, this.hasMinusFlag, this.format);
    }

    @CompilerDirectives.TruffleBoundary
    private static byte[] getFormattedString(String formatted, int width, int precision, boolean isNegative, boolean isSpacePadded, boolean hasPlusFlag, boolean hasZeroFlag, boolean useAlternativeFormat, boolean hasMinusFlag, char format) {
        if (width < 0 && width != Integer.MIN_VALUE) {
            width = -width;
            hasMinusFlag = true;
        }
        if (isNegative && !isSpacePadded && !hasPlusFlag) {
            if (((String)formatted).contains("0")) {
                formatted = ((String)formatted).substring(((String)formatted).indexOf(48), ((String)formatted).length());
                int desiredLength = Math.max(precision, width);
                if (((String)formatted).length() + 3 < desiredLength) {
                    int addOnes;
                    for (int i = addOnes = desiredLength - (((String)formatted).length() + 3); i > 0; --i) {
                        formatted = "1" + (String)formatted;
                    }
                }
                formatted = "..1" + (String)formatted;
            } else {
                formatted = "..1";
            }
        } else if ((hasZeroFlag || precision != Integer.MIN_VALUE) && !hasMinusFlag) {
            int padZeros;
            int n = padZeros = precision != Integer.MIN_VALUE ? precision : width;
            while (((String)formatted).length() < padZeros) {
                formatted = "0" + (String)formatted;
            }
        }
        while (((String)formatted).length() < width) {
            if (!hasMinusFlag) {
                formatted = " " + (String)formatted;
                continue;
            }
            formatted = (String)formatted + " ";
        }
        if (useAlternativeFormat) {
            formatted = format == 'B' ? "0B" + (String)formatted : "0b" + (String)formatted;
        }
        if (isSpacePadded || hasPlusFlag) {
            formatted = isNegative ? "-" + (String)formatted : (hasPlusFlag ? "+" + (String)formatted : " " + (String)formatted);
        }
        return StringOperations.encodeAsciiBytes((String)formatted);
    }
}

