/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.format;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.core.string.StringOperations;

@NodeChild(value="value")
public abstract class FormatFloatHumanReadableNode
extends FormatNode {
    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isIntegerValue(value)"})
    byte[] formatInteger(double value) {
        return StringOperations.encodeAsciiBytes(String.valueOf((long)value));
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"!isIntegerValue(value)"})
    byte[] format(double value) {
        return StringOperations.encodeAsciiBytes(String.valueOf(value));
    }

    protected boolean isIntegerValue(double value) {
        return value - Math.rint(value) == 0.0;
    }
}

