/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.format;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import java.math.BigInteger;
import org.truffleruby.collections.ByteArrayBuilder;
import org.truffleruby.core.format.format.FormatFloatGenericNode;
import org.truffleruby.core.string.StringOperations;

@ImportStatic(value={Double.class})
public abstract class FormatAFloatNode
extends FormatFloatGenericNode {
    private static final long SIGN_MASK = Long.MIN_VALUE;
    private static final long BIASED_EXP_MASK = 0x7FF0000000000000L;
    private static final long MANTISSA_MASK = 0xFFFFFFFFFFFFFL;
    private static final byte[] HEX_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static final byte[] HEX_DIGITS_UPPER_CASE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private final char expSeparator;

    public FormatAFloatNode(char expSeparator, boolean hasSpaceFlag, boolean hasZeroFlag, boolean hasPlusFlag, boolean hasMinusFlag, boolean hasFSharpFlag) {
        super(hasSpaceFlag, hasZeroFlag, hasPlusFlag, hasMinusFlag, hasFSharpFlag);
        this.expSeparator = expSeparator;
    }

    @Specialization(guards={"nonSpecialValue(dval)"})
    byte[] formatFGeneric(int width, int precision, Object dval) {
        return this.formatNumber(width, precision, dval);
    }

    @Override
    protected int prefixBytes() {
        return 2;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    protected byte[] doFormat(int precision, Object value) {
        ByteArrayBuilder buf = new ByteArrayBuilder();
        boolean positive = this.isPositive(value);
        long exponent = this.getExponent(value);
        byte[] mantissaBytes = this.getMantissaBytes(value);
        if (!positive) {
            buf.append(45);
        } else if (this.hasPlusFlag) {
            buf.append(43);
        } else if (this.hasSpaceFlag) {
            buf.append(32);
        }
        buf.append(48);
        buf.append(this.expSeparator == 'a' ? 120 : 88);
        if (mantissaBytes[0] == 0) {
            exponent = 0L;
            buf.append(48);
            if (precision > 0 || this.hasFSharpFlag) {
                buf.append(46);
                while (precision > 0) {
                    buf.append(48);
                    --precision;
                }
            }
        } else {
            byte digit;
            int i = 0;
            if ((digit = this.getDigit(i++, mantissaBytes)) == 0) {
                digit = this.getDigit(i++, mantissaBytes);
            }
            assert (digit == 1);
            buf.append(49);
            int digits = this.getNumberOfDigits(mantissaBytes);
            if (i < digits || this.hasFSharpFlag || precision > 0) {
                buf.append(46);
            }
            if (precision == Integer.MIN_VALUE) {
                precision = -1;
            }
            while (precision < 0 && i < digits || precision > 0) {
                digit = this.getDigit(i++, mantissaBytes);
                buf.append((this.expSeparator == 'a' ? HEX_DIGITS : HEX_DIGITS_UPPER_CASE)[digit]);
                --precision;
            }
        }
        buf.append(this.expSeparator == 'a' ? 112 : 80);
        if (exponent >= 0L) {
            buf.append(43);
        }
        buf.append(StringOperations.encodeAsciiBytes(Long.toString(exponent)));
        return buf.getBytes();
    }

    private int getNumberOfDigits(byte[] bytes) {
        int digits = bytes.length * 2;
        if (this.getDigit(digits - 1, bytes) == 0) {
            --digits;
        }
        return digits;
    }

    private byte getDigit(int position, byte[] bytes) {
        int index = position / 2;
        if (index < bytes.length) {
            byte twoDigits = bytes[index];
            if (position % 2 == 0) {
                return (byte)(twoDigits >> 4 & 0xF);
            }
            return (byte)(twoDigits & 0xF);
        }
        return 0;
    }

    private boolean isPositive(Object value) {
        if (value instanceof Double) {
            long bits = Double.doubleToRawLongBits((Double)value);
            return (bits & Long.MIN_VALUE) == 0L;
        }
        if (value instanceof Long) {
            return 0L <= (Long)value;
        }
        if (value instanceof Integer) {
            return 0 <= (Integer)value;
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).signum() >= 0;
        }
        return true;
    }

    private byte[] getMantissaBytes(Object value) {
        BigInteger bi;
        if (value instanceof Double) {
            long bits = Double.doubleToRawLongBits((Double)value);
            long biasedExp = (bits & 0x7FF0000000000000L) >> 52;
            long mantissaBits = bits & 0xFFFFFFFFFFFFFL;
            if (biasedExp > 0L) {
                mantissaBits |= 0x10000000000000L;
            }
            bi = BigInteger.valueOf(mantissaBits);
        } else {
            bi = value instanceof BigInteger ? (BigInteger)value : (value instanceof Long ? BigInteger.valueOf((Long)value) : (value instanceof Integer ? BigInteger.valueOf(((Integer)value).intValue()) : BigInteger.ZERO));
        }
        bi = bi.abs();
        if (BigInteger.ZERO.equals(bi)) {
            return new byte[1];
        }
        int bitLength = (bi = bi.shiftRight(bi.getLowestSetBit() - 1)).bitLength() % 4;
        if (bitLength != 1) {
            bi = bi.shiftLeft(5 - bitLength);
        }
        return bi.toByteArray();
    }

    private long getExponent(Object value) {
        if (value instanceof BigInteger) {
            return ((BigInteger)value).abs().bitLength() - 1;
        }
        if (value instanceof Long) {
            long lval = (Long)value;
            return lval == Long.MIN_VALUE ? 63L : (long)(63 - Long.numberOfLeadingZeros(Math.abs(lval)));
        }
        if (value instanceof Integer) {
            long lval = ((Integer)value).intValue();
            return 63 - Long.numberOfLeadingZeros(Math.abs(lval));
        }
        if (value instanceof Double) {
            long bits = Double.doubleToRawLongBits((Double)value);
            long biasedExp = (bits & 0x7FF0000000000000L) >> 52;
            long mantissaBits = bits & 0xFFFFFFFFFFFFFL;
            if (biasedExp == 0L) {
                int lz = Long.numberOfLeadingZeros(mantissaBits);
                biasedExp -= (long)(lz - 12);
            }
            return biasedExp - 1023L;
        }
        return 0L;
    }
}

