/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.exception;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.Shape;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.exception.RubyNoMethodError;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.language.Nil;
import org.truffleruby.language.objects.AllocationTracing;

@CoreModule(value="NoMethodError", isClass=true)
public abstract class NoMethodErrorNodes {

    @Primitive(name="no_method_error_set_args")
    public static abstract class ArgsSetNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object setArgs(RubyNoMethodError error, Object args) {
            assert (args == Nil.INSTANCE || args instanceof RubyArray);
            error.args = args;
            return args;
        }
    }

    @CoreMethod(names={"args"})
    public static abstract class ArgsNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object args(RubyNoMethodError self) {
            return self.args;
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyNoMethodError allocateNoMethodError(RubyClass rubyClass) {
            Shape shape = this.getLanguage().noMethodErrorShape;
            RubyNoMethodError instance = new RubyNoMethodError(rubyClass, shape, nil, null, nil, null, nil, nil);
            AllocationTracing.trace(instance, this);
            return instance;
        }
    }
}

