/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.exception;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.SuppressFBWarnings;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveNode;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.exception.ErrnoErrorNode;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.exception.RubyNameError;
import org.truffleruby.core.exception.RubyNoMethodError;
import org.truffleruby.core.exception.RubySystemCallError;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.language.Nil;
import org.truffleruby.language.NotProvided;
import org.truffleruby.language.backtrace.Backtrace;
import org.truffleruby.language.backtrace.BacktraceFormatter;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.methods.LookupMethodOnSelfNode;
import org.truffleruby.language.objects.AllocationTracing;

@CoreModule(value="Exception", isClass=true)
public abstract class ExceptionNodes {

    @Primitive(name="exception_get_raise_exception")
    public static abstract class GetRaiseExceptionNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object getRaiseException(RubyException exception) {
            RaiseException raiseException = exception.backtrace.getRaiseException();
            if (raiseException != null) {
                return raiseException;
            }
            return nil;
        }
    }

    @Primitive(name="exception_backtrace_limit")
    public static abstract class BacktraceLimitNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        int limit() {
            return this.getContext().getOptions().BACKTRACE_LIMIT;
        }
    }

    @Primitive(name="java_breakpoint")
    public static abstract class Breakpoint
    extends PrimitiveNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        @SuppressFBWarnings(value={"DLS"})
        boolean breakpoint() {
            String printableRubyBacktrace = BacktraceFormatter.printableRubyBacktrace((Object)this);
            return true;
        }
    }

    @Primitive(name="exception_errno_error", lowerFixnum={2})
    public static abstract class ExceptionErrnoErrorPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        ErrnoErrorNode errnoErrorNode = ErrnoErrorNode.create();

        @Specialization
        RubySystemCallError exceptionErrnoError(RubyClass errorClass, Object message, int errno) {
            return this.errnoErrorNode.execute(errorClass, errno, message, null);
        }
    }

    @Primitive(name="exception_set_cause")
    public static abstract class ExceptionSetCauseNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyException setCause(RubyException exception, Object cause) {
            exception.cause = cause;
            return exception;
        }

        @Specialization(guards={"!isRubyException(exception)"})
        Object foreignExceptionNoCause(Object exception, Nil cause) {
            return exception;
        }

        @Specialization(guards={"!isRubyException(exception)", "!isNil(cause)"})
        Object foreignExceptionWithCause(Object exception, Object cause) {
            RubyException exc = this.coreExceptions().runtimeError("Cannot set the cause of a foreign exception", this);
            exc.cause = cause;
            throw new RaiseException(this.getContext(), exc);
        }
    }

    @CoreMethod(names={"cause"})
    public static abstract class CauseNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object cause(RubyException exception) {
            return exception.cause;
        }
    }

    @Primitive(name="exception_formatter")
    public static abstract class FormatterPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object formatter(RubyException exception) {
            RubyProc formatter = exception.formatter;
            if (formatter == null) {
                return nil;
            }
            return formatter;
        }
    }

    @Primitive(name="exception_set_custom_backtrace")
    public static abstract class SetCustomBacktrace
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object set(RubyException exception, Object customBacktrace) {
            exception.customBacktrace = customBacktrace;
            return customBacktrace;
        }
    }

    @Primitive(name="exception_set_message")
    public static abstract class MessageSetNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object setMessage(RubyException exception, Object message) {
            exception.message = message;
            return nil;
        }
    }

    @Primitive(name="exception_message")
    public static abstract class MessagePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object message(RubyException exception) {
            Object message = exception.message;
            if (message == null) {
                return nil;
            }
            return message;
        }
    }

    @Primitive(name="exception_capture_backtrace", lowerFixnum={1})
    public static abstract class CaptureBacktraceNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object captureBacktrace(RubyException exception, int offset) {
            exception.backtrace = this.getContext().getCallStack().getBacktrace(this, offset);
            return nil;
        }
    }

    @Primitive(name="exception_backtrace?")
    public static abstract class BacktraceQueryPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        protected static final String METHOD = "backtrace";

        @Specialization(guards={"lookupNode.lookupProtected(frame, exception, METHOD) == getContext().getCoreMethods().EXCEPTION_BACKTRACE"}, limit="1")
        boolean backtraceQuery(VirtualFrame frame, RubyException exception, @Cached LookupMethodOnSelfNode lookupNode) {
            return exception.customBacktrace != null || exception.backtrace != null;
        }

        @Specialization
        Object fallback(RubyException exception) {
            return FAILURE;
        }

        @Specialization(guards={"!isRubyException(exception)"}, limit="getInteropCacheLimit()")
        boolean foreignException(Object exception, @CachedLibrary(value="exception") InteropLibrary interopLibrary) {
            return interopLibrary.hasExceptionStackTrace(exception);
        }
    }

    @CoreMethod(names={"backtrace_locations"})
    public static abstract class BacktraceLocationsNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object backtraceLocations(RubyException exception, @Cached InlinedConditionProfile hasBacktraceProfile, @Cached InlinedConditionProfile hasLocationsProfile) {
            if (hasBacktraceProfile.profile((Node)this, exception.backtrace != null)) {
                Object backtraceLocations = exception.backtraceLocations;
                if (hasLocationsProfile.profile((Node)this, backtraceLocations == null)) {
                    Backtrace backtrace = exception.backtrace;
                    exception.backtraceLocations = backtraceLocations = backtrace.getBacktraceLocations(this.getContext(), this.getLanguage(), -1, null);
                }
                return backtraceLocations;
            }
            return nil;
        }
    }

    @CoreMethod(names={"backtrace"})
    public static abstract class BacktraceNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object backtrace(RubyException exception, @Cached InlinedConditionProfile hasCustomBacktraceProfile, @Cached InlinedConditionProfile hasBacktraceProfile) {
            Object customBacktrace = exception.customBacktrace;
            if (hasCustomBacktraceProfile.profile((Node)this, customBacktrace != null)) {
                return customBacktrace;
            }
            if (hasBacktraceProfile.profile((Node)this, exception.backtrace != null)) {
                RubyArray backtraceStringArray = exception.backtraceStringArray;
                if (backtraceStringArray == null) {
                    exception.backtraceStringArray = backtraceStringArray = this.getContext().getUserBacktraceFormatter().formatBacktraceAsRubyStringArray(exception, exception.backtrace);
                }
                return backtraceStringArray;
            }
            return nil;
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1)
    public static abstract class InitializeCopyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"self == from"})
        RubyException initializeCopySelfIsSameAsFrom(RubyException self, RubyException from) {
            return self;
        }

        @Specialization(guards={"self != from", "!isNameError(from)", "!isSystemCallError(from)"})
        RubyException initializeCopy(RubyException self, RubyException from) {
            this.initializeExceptionCopy(self, from);
            return self;
        }

        @Specialization(guards={"self != from"})
        RubyException initializeSystemCallErrorCopy(RubySystemCallError self, RubySystemCallError from) {
            this.initializeExceptionCopy(self, from);
            self.errno = from.errno;
            return self;
        }

        @Specialization(guards={"self != from"})
        RubyException initializeCopyNoMethodError(RubyNoMethodError self, RubyNoMethodError from) {
            this.initializeExceptionCopy(self, from);
            this.initializeNameErrorCopy(self, from);
            self.args = from.args;
            return self;
        }

        @Specialization(guards={"self != from", "!isNoMethodError(from)"})
        RubyException initializeCopyNameError(RubyNameError self, RubyNameError from) {
            this.initializeExceptionCopy(self, from);
            this.initializeNameErrorCopy(self, from);
            return self;
        }

        protected boolean isNameError(RubyException object) {
            return object instanceof RubyNameError;
        }

        protected boolean isNoMethodError(RubyException object) {
            return object instanceof RubyNoMethodError;
        }

        protected boolean isSystemCallError(RubyException object) {
            return object instanceof RubySystemCallError;
        }

        private void initializeNameErrorCopy(RubyNameError self, RubyNameError from) {
            self.name = from.name;
            self.receiver = from.receiver;
        }

        private void initializeExceptionCopy(RubyException self, RubyException from) {
            Backtrace backtrace = from.backtrace;
            self.backtrace = backtrace != null ? backtrace.copy(self) : null;
            self.formatter = from.formatter;
            self.message = from.message;
            self.cause = from.cause;
            self.backtraceStringArray = from.backtraceStringArray;
            self.backtraceLocations = from.backtraceLocations;
            self.customBacktrace = from.customBacktrace;
        }
    }

    @CoreMethod(names={"initialize"}, optional=1)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyException initialize(RubyException exception, NotProvided message) {
            exception.message = nil;
            return exception;
        }

        @Specialization(guards={"wasProvided(message)"})
        RubyException initialize(RubyException exception, Object message) {
            exception.message = message;
            return exception;
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyException allocateException(RubyClass rubyClass) {
            Shape shape = this.getLanguage().exceptionShape;
            RubyException instance = new RubyException(rubyClass, shape, nil, null, nil);
            AllocationTracing.trace(instance, this);
            return instance;
        }
    }
}

