/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.exception;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.exception.ErrnoErrorNodeGen;
import org.truffleruby.core.exception.ExceptionOperations;
import org.truffleruby.core.exception.RubySystemCallError;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.backtrace.Backtrace;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.platform.ErrnoDescriptions;

public abstract class ErrnoErrorNode
extends RubyBaseNode {
    @Node.Child
    private DispatchNode formatMessageNode;

    @NeverDefault
    public static ErrnoErrorNode create() {
        return ErrnoErrorNodeGen.create();
    }

    public abstract RubySystemCallError execute(RubyClass var1, int var2, Object var3, Backtrace var4);

    @Specialization
    RubySystemCallError errnoError(RubyClass rubyClass, int errno, Object extraMessage, Backtrace backtrace, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
        Object errnoDescription;
        RubyClass errnoClass;
        String errnoName = this.getContext().getCoreLibrary().getErrnoName(errno);
        if (errnoName == null) {
            errnoClass = this.getContext().getCoreLibrary().systemCallErrorClass;
            errnoDescription = nil;
        } else {
            errnoClass = rubyClass != null && rubyClass != this.getContext().getCoreLibrary().systemCallErrorClass ? rubyClass : this.getContext().getCoreLibrary().getErrnoClass(errnoName);
            errnoDescription = this.createString(fromJavaStringNode, ErrnoDescriptions.getDescription(errnoName), Encodings.UTF_8);
        }
        RubyString errorMessage = this.formatMessage(errnoDescription, errno, extraMessage);
        return ExceptionOperations.createSystemCallError(this.getContext(), errnoClass, (Object)errorMessage, errno, backtrace);
    }

    private RubyString formatMessage(Object errnoDescription, int errno, Object extraMessage) {
        assert (extraMessage instanceof RubyString || extraMessage instanceof ImmutableRubyString);
        if (this.formatMessageNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.formatMessageNode = (DispatchNode)this.insert(DispatchNode.create());
        }
        return (RubyString)((Object)this.formatMessageNode.call(this.getContext().getCoreLibrary().truffleExceptionOperationsModule, "format_errno_error_message", errnoDescription, (Object)errno, extraMessage));
    }
}

