/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.exception;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnknownKeyException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.source.SourceSection;
import java.io.IOException;
import java.util.EnumSet;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.array.ArrayHelpers;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.binding.RubyBinding;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.exception.ExceptionOperations;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.exception.RubyFrozenError;
import org.truffleruby.core.exception.RubyNameError;
import org.truffleruby.core.exception.RubyNoMethodError;
import org.truffleruby.core.exception.RubySyntaxError;
import org.truffleruby.core.exception.RubySystemExit;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.module.ModuleOperations;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.string.CoreStrings;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.StringOperations;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.core.thread.ThreadNodes;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.backtrace.Backtrace;
import org.truffleruby.language.backtrace.BacktraceFormatter;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.objects.LogicalClassNode;

public final class CoreExceptions {
    private final RubyLanguage language;
    private final RubyContext context;
    private final BacktraceFormatter debugBacktraceFormatter;

    public CoreExceptions(RubyContext context, RubyLanguage language) {
        this.language = language;
        this.context = context;
        this.debugBacktraceFormatter = new BacktraceFormatter(context, language, EnumSet.of(BacktraceFormatter.FormattingFlags.OMIT_EXCEPTION));
    }

    public void showExceptionIfDebug(RubyException exception) {
        this.showExceptionIfDebug(exception.getLogicalClass(), exception.message, exception.backtrace);
    }

    @CompilerDirectives.TruffleBoundary
    public void showExceptionIfDebug(RubyException rubyException, Backtrace backtrace) {
        if (this.context.getCoreLibrary().getDebug() == Boolean.TRUE) {
            RubyClass rubyClass = rubyException.getLogicalClass();
            Object message = DispatchNode.getUncached().call(rubyException, "to_s");
            this.showExceptionIfDebug(rubyClass, message, backtrace);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void showExceptionIfDebug(RubyClass rubyClass, Object message, Backtrace backtrace) {
        if (this.context.getCoreLibrary().getDebug() == Boolean.TRUE) {
            String exceptionClass = rubyClass.fields.getName();
            Object from = "";
            if (backtrace != null && backtrace.getStackTrace().length > 0) {
                from = " at " + this.debugBacktraceFormatter.formatLine(backtrace.getStackTrace(), 0, null);
            }
            if (RubyStringLibrary.getUncached().isRubyString(message)) {
                message = RubyGuards.getJavaString(message);
            }
            String output = "Exception `" + exceptionClass + "'" + (String)from + " - " + message + "\n";
            if (this.context.getCoreLibrary().isLoaded()) {
                RubyString outputString = StringOperations.createUTF8String(this.context, this.language, output);
                Object stderr = this.context.getCoreLibrary().getStderr();
                DispatchNode.getUncached().call(stderr, "write", (Object)outputString);
            } else {
                this.context.getEnvErrStream().println(output);
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    public String inspect(Object value) {
        Object rubyString = DispatchNode.getUncached().call((Object)this.context.getCoreLibrary().truffleTypeModule, "rb_inspect", value);
        return RubyGuards.getJavaString(rubyString);
    }

    @CompilerDirectives.TruffleBoundary
    public String inspectReceiver(Object receiver) {
        Object rubyString = DispatchNode.getUncached().call((Object)this.context.getCoreLibrary().truffleExceptionOperationsModule, "receiver_string", receiver);
        return RubyGuards.getJavaString(rubyString);
    }

    public RubyException argumentErrorOneHashRequired(RubyBaseNode currentNode) {
        return this.argumentError(this.coreStrings().ONE_HASH_REQUIRED.createInstance(currentNode.getContext()), (Node)currentNode, null);
    }

    public RubyException argumentError(String message, Node currentNode) {
        return this.argumentError(message, currentNode, null);
    }

    public RubyException argumentErrorProcWithoutBlock(RubyBaseNode currentNode) {
        return this.argumentError(this.coreStrings().PROC_WITHOUT_BLOCK.createInstance(currentNode.getContext()), (Node)currentNode, null);
    }

    public RubyException argumentErrorTooFewArguments(Node currentNode) {
        return this.argumentError(this.coreStrings().TOO_FEW_ARGUMENTS.createInstance(RubyContext.get(currentNode)), currentNode, null);
    }

    public RubyException argumentErrorTimeIntervalPositive(Node currentNode) {
        return this.argumentError(this.coreStrings().TIME_INTERVAL_MUST_BE_POS.createInstance(RubyContext.get(currentNode)), currentNode, null);
    }

    public RubyException argumentErrorXOutsideOfString(Node currentNode) {
        return this.argumentError(this.coreStrings().X_OUTSIDE_OF_STRING.createInstance(RubyContext.get(currentNode)), currentNode, null);
    }

    public RubyException argumentErrorCantCompressNegativeNumbers(Node currentNode) {
        return this.argumentError(this.coreStrings().CANT_COMPRESS_NEGATIVE.createInstance(RubyContext.get(currentNode)), currentNode, null);
    }

    public RubyException argumentErrorOutOfRange(RubyBaseNode currentNode) {
        return this.argumentError(this.coreStrings().ARGUMENT_OUT_OF_RANGE.createInstance(currentNode.getContext()), (Node)currentNode, null);
    }

    public RubyException argumentErrorNegativeArraySize(RubyBaseNode currentNode) {
        return this.argumentError(this.coreStrings().NEGATIVE_ARRAY_SIZE.createInstance(currentNode.getContext()), (Node)currentNode, null);
    }

    public RubyException argumentErrorCharacterRequired(Node currentNode) {
        return this.argumentError("%c requires a character", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException argumentErrorUnknownKeywords(Object[] keys, Node currentNode) {
        if (keys.length == 1) {
            return this.argumentError("unknown keyword: " + this.inspect(keys[0]), currentNode);
        }
        CharSequence[] names = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            names[i] = this.inspect(keys[i]);
        }
        return this.argumentError("unknown keywords: " + String.join((CharSequence)", ", names), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException argumentErrorInvalidByteSequence(RubyEncoding encoding, Node currentNode) {
        return this.argumentError("invalid byte sequence in " + encoding, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException argumentErrorInvalidRadix(int radix, Node currentNode) {
        return this.argumentError(StringUtils.format("invalid radix %d", radix), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException argumentErrorMissingKeywords(Object[] keys, Node currentNode) {
        if (keys.length == 1) {
            return this.argumentError("missing keyword: " + this.inspect(keys[0]), currentNode);
        }
        CharSequence[] names = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            names[i] = this.inspect(keys[i]);
        }
        return this.argumentError("missing keywords: " + String.join((CharSequence)", ", names), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException argumentError(int passed, int required, Node currentNode) {
        return this.argumentError(StringUtils.format("wrong number of arguments (given %d, expected %d)", passed, required), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException argumentErrorPlus(int passed, int required, Node currentNode) {
        return this.argumentError(StringUtils.format("wrong number of arguments (given %d, expected %d+)", passed, required), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException argumentError(int passed, int required, int optional, Node currentNode) {
        return this.argumentError(StringUtils.format("wrong number of arguments (given %d, expected %d..%d)", passed, required, required + optional), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException argumentErrorMinMaxArity(int passed, int minArity, int maxArity, Node currentNode) {
        if (minArity == maxArity) {
            return this.argumentError(passed, minArity, currentNode);
        }
        if (maxArity < 0) {
            return this.argumentErrorPlus(passed, minArity, currentNode);
        }
        return this.argumentError(passed, minArity, maxArity - minArity, currentNode);
    }

    public RubyException argumentErrorEmptyVarargs(Node currentNode) {
        return this.argumentError(this.coreStrings().WRONG_ARGS_ZERO_PLUS_ONE.createInstance(RubyContext.get(currentNode)), currentNode, null);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException argumentErrorWrongArgumentType(Object object, String expectedType, Node currentNode) {
        String badClassName = LogicalClassNode.getUncached().execute((Object)object).fields.getName();
        return this.argumentError(StringUtils.format("wrong argument type %s (should be %s)", badClassName, expectedType), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException argumentErrorInvalidStringToInteger(String string, Node currentNode) {
        return this.argumentError("invalid value for Integer(): " + string, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException argumentErrorNoReceiver(Node currentNode) {
        return this.argumentError("no receiver is available", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException argumentErrorEncodingAlreadyRegistered(String nameString, Node currentNode) {
        return this.argumentError(StringUtils.format("encoding %s is already registered", nameString), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException argumentError(String message, Node currentNode, Throwable javaThrowable) {
        return this.argumentError(StringOperations.createUTF8String(this.context, this.language, message), currentNode, javaThrowable);
    }

    public RubyException argumentError(RubyString message, Node currentNode, Throwable javaThrowable) {
        RubyClass exceptionClass = this.context.getCoreLibrary().argumentErrorClass;
        return ExceptionOperations.createRubyException(this.context, exceptionClass, (Object)message, currentNode, javaThrowable);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException argumentErrorCantUnfreeze(Object self, Node currentNode) {
        String className = LogicalClassNode.getUncached().execute((Object)self).fields.getName();
        return this.argumentError(StringUtils.format("can't unfreeze %s", className), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException frozenError(Object object, Node currentNode) {
        String className = LogicalClassNode.getUncached().execute((Object)object).fields.getName();
        return this.frozenError(StringUtils.format("can't modify frozen %s: %s", className, this.inspect(object)), currentNode, object);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException frozenError(String message, Node currentNode, Object receiver) {
        RubyClass exceptionClass = this.context.getCoreLibrary().frozenErrorClass;
        RubyString errorMessage = StringOperations.createUTF8String(this.context, this.language, message);
        Backtrace backtrace = this.context.getCallStack().getBacktrace(currentNode);
        Object cause = ThreadNodes.ThreadGetExceptionNode.getLastException(this.language);
        this.showExceptionIfDebug(exceptionClass, (Object)errorMessage, backtrace);
        return new RubyFrozenError(exceptionClass, this.language.frozenErrorShape, (Object)errorMessage, backtrace, cause, receiver);
    }

    public RubyException runtimeErrorClassVariableTopLevel(Node currentNode) {
        return this.runtimeError("class variable access from toplevel", currentNode);
    }

    public RubyException runtimeErrorCoverageNotEnabled(Node currentNode) {
        return this.runtimeError("coverage measurement is not enabled", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException runtimeError(String message, Node currentNode) {
        RubyClass exceptionClass = this.context.getCoreLibrary().runtimeErrorClass;
        RubyString errorMessage = StringOperations.createUTF8String(this.context, this.language, message);
        return ExceptionOperations.createRubyException(this.context, exceptionClass, (Object)errorMessage, currentNode, null);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException runtimeError(String message, Node currentNode, Throwable javaThrowable) {
        RubyClass exceptionClass = this.context.getCoreLibrary().runtimeErrorClass;
        RubyString errorMessage = StringOperations.createUTF8String(this.context, this.language, message);
        return ExceptionOperations.createRubyException(this.context, exceptionClass, (Object)errorMessage, currentNode, javaThrowable);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException runtimeError(String message, Backtrace backtrace) {
        RubyClass exceptionClass = this.context.getCoreLibrary().runtimeErrorClass;
        RubyString errorMessage = StringOperations.createUTF8String(this.context, this.language, message);
        return ExceptionOperations.createRubyException(this.context, exceptionClass, (Object)errorMessage, backtrace);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException systemStackErrorStackLevelTooDeep(Node currentNode, StackOverflowError javaThrowable, boolean showExceptionIfDebug) {
        StackTraceElement[] stackTrace = javaThrowable.getStackTrace();
        String topOfTheStack = stackTrace.length > 0 ? BacktraceFormatter.formatStackTraceElement(stackTrace[0]) : "<empty Java stacktrace>";
        String message = this.coreStrings().STACK_LEVEL_TOO_DEEP + "\n\tfrom " + topOfTheStack;
        Backtrace backtrace = this.context.getCallStack().getBacktrace(currentNode, 0, javaThrowable);
        RubyString messageString = StringOperations.createUTF8String(this.context, this.language, message);
        return ExceptionOperations.createSystemStackError(this.context, (Object)messageString, backtrace, showExceptionIfDebug);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException noMemoryError(Node currentNode, OutOfMemoryError javaThrowable) {
        RubyClass exceptionClass = this.context.getCoreLibrary().noMemoryErrorClass;
        return ExceptionOperations.createRubyException(this.context, exceptionClass, (Object)this.coreStrings().FAILED_TO_ALLOCATE_MEMORY.createInstance(this.context), currentNode, javaThrowable);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException noMatchingPatternError(Object errorMessage, Node currentNode) {
        assert (RubyStringLibrary.getUncached().isRubyString(errorMessage));
        RubyClass exceptionClass = this.context.getCoreLibrary().noMatchingPatternErrorClass;
        return ExceptionOperations.createRubyException(this.context, exceptionClass, errorMessage, currentNode, null);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException mathDomainErrorAcos(Node currentNode) {
        return this.mathDomainError("acos", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException mathDomainErrorAcosh(Node currentNode) {
        return this.mathDomainError("acosh", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException mathDomainErrorAsin(Node currentNode) {
        return this.mathDomainError("asin", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException mathDomainErrorAtanh(Node currentNode) {
        return this.mathDomainError("atanh", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException mathDomainErrorGamma(Node currentNode) {
        return this.mathDomainError("gamma", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException mathDomainErrorLog2(Node currentNode) {
        return this.mathDomainError("log2", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException mathDomainErrorLog10(Node currentNode) {
        return this.mathDomainError("log10", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException mathDomainErrorLog(Node currentNode) {
        return this.mathDomainError("log", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException mathDomainError(String method, Node currentNode) {
        RubyClass exceptionClass = this.context.getCoreLibrary().mathDomainErrorClass;
        RubyString errorMessage = StringOperations.createUTF8String(this.context, this.language, StringUtils.format("Numerical argument is out of domain - \"%s\"", method));
        Backtrace backtrace = this.context.getCallStack().getBacktrace(currentNode);
        return ExceptionOperations.createSystemCallError(this.context, exceptionClass, (Object)errorMessage, this.context.getCoreLibrary().getErrnoValue("EDOM"), backtrace);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException indexError(String message, Node currentNode) {
        RubyClass exceptionClass = this.context.getCoreLibrary().indexErrorClass;
        RubyString errorMessage = StringOperations.createUTF8String(this.context, this.language, message);
        return ExceptionOperations.createRubyException(this.context, exceptionClass, (Object)errorMessage, currentNode, null);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException indexErrorOutOfString(int index, Node currentNode) {
        return this.indexError(StringUtils.format("index %d out of string", index), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException indexTooSmallError(String type, int index, int length, Node currentNode) {
        return this.indexError(StringUtils.format("index %d too small for %s; minimum: -%d", index, type, length), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException negativeLengthError(int length, Node currentNode) {
        return this.indexError(StringUtils.format("negative length (%d)", length), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException indexErrorInvalidIndex(Node currentNode) {
        return this.indexError("invalid index", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException indexErrorInvalidArrayIndexException(InvalidArrayIndexException exception, Node currentNode) {
        return this.indexError("invalid array index " + exception.getInvalidIndex(), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException indexErrorInvalidBufferOffsetException(InvalidBufferOffsetException exception, Node currentNode) {
        return this.indexError("invalid buffer offset " + exception.getByteOffset() + " for buffer of length " + exception.getLength(), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException keyError(String message, Node currentNode) {
        RubyClass exceptionClass = this.context.getCoreLibrary().keyErrorClass;
        RubyString errorMessage = StringOperations.createUTF8String(this.context, this.language, message);
        return ExceptionOperations.createRubyException(this.context, exceptionClass, (Object)errorMessage, currentNode, null);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException keyError(UnknownKeyException exception, Node currentNode) {
        return this.keyError(exception.getMessage(), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException stopIteration(String message, Node currentNode) {
        RubyClass exceptionClass = this.context.getCoreLibrary().stopIterationClass;
        RubyString errorMessage = StringOperations.createUTF8String(this.context, this.language, message);
        return ExceptionOperations.createRubyException(this.context, exceptionClass, (Object)errorMessage, currentNode, null);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException localJumpError(String message, Node currentNode) {
        RubyClass exceptionClass = this.context.getCoreLibrary().localJumpErrorClass;
        RubyString errorMessage = StringOperations.createUTF8String(this.context, this.language, message);
        return ExceptionOperations.createRubyException(this.context, exceptionClass, (Object)errorMessage, currentNode, null);
    }

    public RubyException noBlockGiven(Node currentNode) {
        return this.localJumpError("no block given", currentNode);
    }

    public RubyException breakFromProcClosure(Node currentNode) {
        return this.localJumpError("break from proc-closure", currentNode);
    }

    public RubyException unexpectedReturn(Node currentNode) {
        return this.localJumpError("unexpected return", currentNode);
    }

    public RubyException noBlockToYieldTo(Node currentNode) {
        return this.localJumpError("no block given (yield)", currentNode);
    }

    public RubyException typeErrorCantCreateInstanceOfSingletonClass(Node currentNode) {
        return this.typeError("can't create instance of singleton class", currentNode, null);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException superclassMismatch(String name, Node currentNode) {
        return this.typeError("superclass mismatch for class " + name, currentNode);
    }

    public RubyException typeError(String message, Node currentNode) {
        return this.typeError(message, currentNode, null);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException typeErrorAllocatorUndefinedFor(RubyClass rubyClass, Node currentNode) {
        String className = rubyClass.fields.getName();
        return this.typeError(StringUtils.format("allocator undefined for %s", className), currentNode);
    }

    public RubyException typeErrorCantDefineSingleton(Node currentNode) {
        return this.typeError("can't define singleton", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException typeErrorCantConvertTo(Object from, String toClass, String methodUsed, Object result, Node currentNode) {
        String fromClass = LogicalClassNode.getUncached().execute((Object)from).fields.getName();
        return this.typeError(StringUtils.format("can't convert %s to %s (%s#%s gives %s)", fromClass, toClass, fromClass, methodUsed, LogicalClassNode.getUncached().execute(result).toString()), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException typeErrorCantConvertInto(Object from, String toClass, Node currentNode) {
        return this.typeError(StringUtils.format("can't convert %s into %s", LogicalClassNode.getUncached().execute((Object)from).fields.getName(), toClass), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException typeErrorIsNotA(Object value, String expectedType, Node currentNode) {
        return this.typeErrorIsNotA(this.inspectReceiver(value), expectedType, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException typeErrorIsNotA(String value, String expectedType, Node currentNode) {
        return this.typeError(value + " is not a " + expectedType, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException typeErrorIsNotAOrB(Object value, String expectedTypeA, String expectedTypeB, Node currentNode) {
        return this.typeError(StringUtils.format("%s is not a %s nor a %s", this.inspectReceiver(value), expectedTypeA, expectedTypeB), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException typeErrorIsNotAClassModule(Object value, Node currentNode) {
        return this.typeError(this.inspectReceiver(value) + " is not a class/module", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException typeErrorNoImplicitConversion(Object from, String to, Node currentNode) {
        return this.typeError(StringUtils.format("no implicit conversion of %s into %s", LogicalClassNode.getUncached().execute((Object)from).fields.getName(), to), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException typeErrorBadCoercion(Object from, String to, String coercionMethod, Object coercedTo, Node currentNode) {
        String badClassName = LogicalClassNode.getUncached().execute((Object)from).fields.getName();
        return this.typeError(StringUtils.format("can't convert %s to %s (%s#%s gives %s)", badClassName, to, badClassName, coercionMethod, LogicalClassNode.getUncached().execute((Object)coercedTo).fields.getName()), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException typeErrorCantDump(Object object, Node currentNode) {
        String logicalClass = LogicalClassNode.getUncached().execute((Object)object).fields.getName();
        return this.typeError(StringUtils.format("can't dump %s", logicalClass), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException typeErrorWrongArgumentType(Object object, String expectedType, Node currentNode) {
        String badClassName = LogicalClassNode.getUncached().execute((Object)object).fields.getName();
        return this.typeError(StringUtils.format("wrong argument type %s (expected %s)", badClassName, expectedType), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException typeErrorAlreadyInitializedClass(Node currentNode) {
        return this.typeError("already initialized class", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException typeErrorSubclassSingletonClass(Node currentNode) {
        return this.typeError("can't make subclass of singleton class", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException typeErrorSubclassClass(Node currentNode) {
        return this.typeError("can't make subclass of Class", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException typeErrorSuperclassMustBeClass(Node currentNode) {
        return this.typeError("superclass must be a Class", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException typeErrorInheritUninitializedClass(Node currentNode) {
        return this.typeError("can't inherit uninitialized class", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException typeErrorRescueInvalidClause(Node currentNode) {
        return this.typeError("class or module required for rescue clause", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException typeErrorExpectedProcOrMethodOrUnboundMethod(Object object, Node currentNode) {
        String badClassName = LogicalClassNode.getUncached().execute((Object)object).fields.getName();
        return this.typeError(StringUtils.format("wrong argument type %s (expected Proc/Method/UnboundMethod)", badClassName), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException typeError(String message, Node currentNode, Throwable javaThrowable) {
        RubyClass exceptionClass = this.context.getCoreLibrary().typeErrorClass;
        RubyString errorMessage = StringOperations.createUTF8String(this.context, this.language, message);
        return ExceptionOperations.createRubyException(this.context, exceptionClass, (Object)errorMessage, currentNode, javaThrowable);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException typeErrorUnsupportedTypeException(UnsupportedTypeException exception, Node currentNode) {
        RubyArray rubyArray = ArrayHelpers.createArray(this.context, this.language, exception.getSuppliedValues());
        String formattedValues = RubyGuards.getJavaString(DispatchNode.getUncached().call(rubyArray, "inspect"));
        return this.typeError("unsupported type " + formattedValues, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyNameError nameErrorWrongConstantName(String name, Node currentNode) {
        return this.nameError(StringUtils.format("wrong constant name %s", name), null, name, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException nameErrorConstantNotDefined(RubyModule module, String name, Node currentNode) {
        return this.nameError(StringUtils.format("constant %s not defined", ModuleOperations.constantName(this.context, module, name)), null, name, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyNameError nameErrorUninitializedConstant(RubyModule module, String name, Node currentNode) {
        String message = StringUtils.format("uninitialized constant %s", ModuleOperations.constantNameNoLeadingColon(this.context, module, name));
        return this.nameError(message, module, name, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyNameError nameErrorPrivateConstant(RubyModule module, String name, Node currentNode) {
        return this.nameError(StringUtils.format("private constant %s referenced", ModuleOperations.constantName(this.context, module, name)), module, name, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyNameError nameErrorUninitializedClassVariable(RubyModule module, String name, Node currentNode) {
        return this.nameError(StringUtils.format("uninitialized class variable %s in %s", name, module.fields.getName()), module, name, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyNameError nameErrorInstanceNameNotAllowable(String name, Object receiver, Node currentNode) {
        return this.nameError(StringUtils.format("`%s' is not allowable as an instance variable name", name), receiver, name, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyNameError nameErrorInstanceVariableNotDefined(String name, Object receiver, Node currentNode) {
        return this.nameError(StringUtils.format("instance variable %s not defined", name), receiver, name, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyNameError nameErrorUndefinedMethod(String name, RubyModule module, Node currentNode) {
        return this.nameError(StringUtils.format("undefined method `%s' for %s `%s'", name, module instanceof RubyClass ? "class" : "module", module.fields.getName()), module, name, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyNameError nameErrorUndefinedSingletonMethod(String name, Object receiver, Node currentNode) {
        String className = LogicalClassNode.getUncached().execute((Object)receiver).fields.getName();
        return this.nameError(StringUtils.format("undefined singleton method `%s' for %s", name, className), receiver, name, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyNameError nameErrorMethodNotDefinedIn(RubyModule module, String name, Node currentNode) {
        return this.nameError(StringUtils.format("method `%s' not defined in %s", name, module.fields.getName()), module, name, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyNameError nameErrorPrivateMethod(String name, RubyModule module, Node currentNode) {
        return this.nameError(StringUtils.format("method `%s' for %s is private", name, module.fields.getName()), module, name, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyNameError nameErrorLocalVariableNotDefined(String name, RubyBinding binding, Node currentNode) {
        return this.nameError(StringUtils.format("local variable `%s' not defined for %s", name, binding.toString()), binding, name, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyNameError nameErrorClassVariableNotDefined(String name, RubyModule module, Node currentNode) {
        return this.nameError(StringUtils.format("class variable `%s' not defined for %s", name, module.fields.getName()), module, name, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyNameError nameErrorImportNotFound(String name, Node currentNode) {
        return this.nameError(StringUtils.format("import '%s' not found", name), null, name, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyNameError nameErrorUnknownIdentifierException(UnknownIdentifierException exception, Object receiver, Node currentNode) {
        return this.nameError("Unknown identifier: " + exception.getUnknownIdentifier(), receiver, exception.getUnknownIdentifier(), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyNameError nameError(String message, Object receiver, String name, Node currentNode) {
        RubyString messageString = StringOperations.createUTF8String(this.context, this.language, message);
        RubyClass exceptionClass = this.context.getCoreLibrary().nameErrorClass;
        Backtrace backtrace = this.context.getCallStack().getBacktrace(currentNode);
        Object cause = ThreadNodes.ThreadGetExceptionNode.getLastException(this.language);
        this.showExceptionIfDebug(exceptionClass, (Object)messageString, backtrace);
        return new RubyNameError(this.context.getCoreLibrary().nameErrorClass, this.language.nameErrorShape, (Object)messageString, backtrace, cause, receiver, this.language.getSymbol(name));
    }

    @CompilerDirectives.TruffleBoundary
    public RubyNameError nameErrorFromMethodMissing(ExceptionOperations.ExceptionFormatter formatter, Object receiver, String name, Node currentNode) {
        Backtrace backtrace = this.context.getCallStack().getBacktrace(currentNode, 1);
        Object cause = ThreadNodes.ThreadGetExceptionNode.getLastException(this.language);
        RubyProc formatterProc = formatter.getProc(this.context);
        String message = formatter.getMessage(formatterProc, name, receiver);
        RubyNameError exception = new RubyNameError(this.context.getCoreLibrary().nameErrorClass, this.language.nameErrorShape, message, backtrace, cause, receiver, this.language.getSymbol(name));
        exception.formatter = formatterProc;
        this.showExceptionIfDebug(exception, backtrace);
        return exception;
    }

    @CompilerDirectives.TruffleBoundary
    public RubyNoMethodError noMethodErrorFromMethodMissing(ExceptionOperations.ExceptionFormatter formatter, Object receiver, String name, Object[] args, Node currentNode) {
        RubyArray argsArray = ArrayHelpers.createArray(this.context, this.language, args);
        Backtrace backtrace = this.context.getCallStack().getBacktrace(currentNode, 1);
        Object cause = ThreadNodes.ThreadGetExceptionNode.getLastException(this.language);
        RubyProc formatterProc = formatter.getProc(this.context);
        String message = formatter.getMessage(formatterProc, name, receiver);
        RubyNoMethodError exception = new RubyNoMethodError(this.context.getCoreLibrary().noMethodErrorClass, this.language.noMethodErrorShape, message, backtrace, cause, receiver, this.language.getSymbol(name), argsArray);
        exception.formatter = formatterProc;
        this.showExceptionIfDebug(exception, backtrace);
        return exception;
    }

    @CompilerDirectives.TruffleBoundary
    public RubyNoMethodError noMethodError(String message, Object receiver, String name, Object[] args, Node currentNode) {
        RubyString messageString = StringOperations.createUTF8String(this.context, this.language, message);
        RubyArray argsArray = ArrayHelpers.createArray(this.context, this.language, args);
        RubyClass exceptionClass = this.context.getCoreLibrary().noMethodErrorClass;
        Backtrace backtrace = this.context.getCallStack().getBacktrace(currentNode);
        Object cause = ThreadNodes.ThreadGetExceptionNode.getLastException(this.language);
        this.showExceptionIfDebug(exceptionClass, (Object)messageString, backtrace);
        return new RubyNoMethodError(this.context.getCoreLibrary().noMethodErrorClass, this.language.noMethodErrorShape, (Object)messageString, backtrace, cause, receiver, this.language.getSymbol(name), argsArray);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyNoMethodError noSuperMethodOutsideMethodError(Node currentNode) {
        RubyString messageString = StringOperations.createUTF8String(this.context, this.language, "super called outside of method");
        RubyClass exceptionClass = this.context.getCoreLibrary().nameErrorClass;
        Backtrace backtrace = this.context.getCallStack().getBacktrace(currentNode);
        Object cause = ThreadNodes.ThreadGetExceptionNode.getLastException(this.language);
        this.showExceptionIfDebug(exceptionClass, (Object)messageString, backtrace);
        return new RubyNoMethodError(this.context.getCoreLibrary().noMethodErrorClass, this.language.noMethodErrorShape, (Object)messageString, backtrace, cause, null, this.language.getSymbol("<unknown>"), Nil.INSTANCE);
    }

    public RubyNoMethodError noMethodErrorUnknownIdentifier(Object receiver, String name, Object[] args, UnknownIdentifierException exception, Node currentNode) {
        return this.noMethodError(ExceptionOperations.getMessage((Throwable)exception), receiver, name, args, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException loadError(String message, String path, Node currentNode) {
        RubyString messageString = StringOperations.createUTF8String(this.context, this.language, message);
        RubyClass exceptionClass = this.context.getCoreLibrary().loadErrorClass;
        RubyException loadError = ExceptionOperations.createRubyException(this.context, exceptionClass, (Object)messageString, currentNode, null);
        if ("openssl.so".equals(path)) {
            path = "openssl";
        }
        DynamicObjectLibrary.getUncached().put((DynamicObject)loadError, (Object)"@path", (Object)StringOperations.createUTF8String(this.context, this.language, path));
        return loadError;
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException loadErrorCannotLoad(String name, Node currentNode) {
        return this.loadError(StringUtils.format("cannot load such file -- %s", name), name, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException loadError(IOException exception, String path, Node currentNode) {
        return this.loadError(BacktraceFormatter.formatJavaThrowableMessage(exception), path, currentNode);
    }

    public RubyException zeroDivisionError(Node currentNode) {
        return this.zeroDivisionError(currentNode, null);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException zeroDivisionError(Node currentNode, ArithmeticException exception) {
        RubyClass exceptionClass = this.context.getCoreLibrary().zeroDivisionErrorClass;
        RubyString errorMessage = StringOperations.createUTF8String(this.context, this.language, "divided by 0");
        return ExceptionOperations.createRubyException(this.context, exceptionClass, (Object)errorMessage, currentNode, exception);
    }

    @CompilerDirectives.TruffleBoundary
    public RubySyntaxError syntaxErrorInvalidRetry(Node currentNode) {
        return this.syntaxError("Invalid retry", currentNode, currentNode.getEncapsulatingSourceSection());
    }

    @CompilerDirectives.TruffleBoundary
    public RubySyntaxError syntaxError(String message, Node currentNode, SourceSection sourceLocation) {
        String messageWithFileLine = sourceLocation != null ? this.context.fileLine(sourceLocation) + ": " + message : "(unknown):1: " + message;
        return this.syntaxErrorAlreadyWithFileLine(messageWithFileLine, currentNode, sourceLocation);
    }

    @CompilerDirectives.TruffleBoundary
    public RubySyntaxError syntaxErrorAlreadyWithFileLine(String message, Node currentNode, SourceSection sourceLocation) {
        RubyString messageString = StringOperations.createUTF8String(this.context, this.language, message);
        RubyClass exceptionClass = this.context.getCoreLibrary().syntaxErrorClass;
        Backtrace backtrace = this.context.getCallStack().getBacktrace(currentNode);
        Object cause = ThreadNodes.ThreadGetExceptionNode.getLastException(this.language);
        this.showExceptionIfDebug(exceptionClass, (Object)messageString, backtrace);
        return new RubySyntaxError(exceptionClass, this.language.syntaxErrorShape, (Object)messageString, backtrace, cause, sourceLocation);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException floatDomainError(String value, Node currentNode) {
        RubyClass exceptionClass = this.context.getCoreLibrary().floatDomainErrorClass;
        RubyString errorMessage = StringOperations.createUTF8String(this.context, this.language, value);
        return ExceptionOperations.createRubyException(this.context, exceptionClass, (Object)errorMessage, currentNode, null);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException ioError(String message, Node currentNode) {
        RubyClass exceptionClass = this.context.getCoreLibrary().ioErrorClass;
        RubyString errorMessage = StringOperations.createUTF8String(this.context, this.language, message);
        return ExceptionOperations.createRubyException(this.context, exceptionClass, (Object)errorMessage, currentNode, null);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException ioError(IOException exception, Node currentNode) {
        return this.ioError(BacktraceFormatter.formatJavaThrowableMessage(exception), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException rangeError(long code, RubyEncoding encoding, Node currentNode) {
        return this.rangeError(StringUtils.format("invalid codepoint %x in %s", code, encoding), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException charRangeError(int codepoint, Node currentNode) {
        return this.rangeError(StringUtils.format("%d out of char range", codepoint), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException rangeErrorConvertToInt(long value, Node currentNode) {
        String direction;
        if (value < Integer.MIN_VALUE) {
            direction = "small";
        } else if (value > Integer.MAX_VALUE) {
            direction = "big";
        } else {
            throw CompilerDirectives.shouldNotReachHere((String)"long fitting in int");
        }
        return this.rangeError(StringUtils.format("integer %d too %s to convert to `int'", value, direction), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException rangeError(String message, Node currentNode) {
        RubyClass exceptionClass = this.context.getCoreLibrary().rangeErrorClass;
        RubyString errorMessage = StringOperations.createUTF8String(this.context, this.language, message);
        return ExceptionOperations.createRubyException(this.context, exceptionClass, (Object)errorMessage, currentNode, null);
    }

    public RubyException graalErrorAssertConstantNotConstant(Node currentNode) {
        return this.graalError("value in Primitive.assert_compilation_constant was not constant", currentNode);
    }

    public RubyException graalErrorAssertNotCompiledCompiled(Node currentNode) {
        return this.graalError("call to Primitive.assert_not_compiled was compiled", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    private RubyException graalError(String message, Node currentNode) {
        RubyClass exceptionClass = this.context.getCoreLibrary().graalErrorClass;
        RubyString errorMessage = StringOperations.createUTF8String(this.context, this.language, message);
        return ExceptionOperations.createRubyException(this.context, exceptionClass, (Object)errorMessage, currentNode, null);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException regexpError(String message, Node currentNode) {
        RubyClass exceptionClass = this.context.getCoreLibrary().regexpErrorClass;
        RubyString errorMessage = StringOperations.createUTF8String(this.context, this.language, message);
        return ExceptionOperations.createRubyException(this.context, exceptionClass, (Object)errorMessage, currentNode, null);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException encodingError(Object string, RubyEncoding encoding, Node currentNode) {
        RubyClass exceptionClass = this.context.getCoreLibrary().encodingErrorClass;
        String message = StringUtils.format("invalid symbol in encoding %s :%s", encoding, this.inspect(string));
        RubyString errorMessage = StringOperations.createUTF8String(this.context, this.language, message);
        return ExceptionOperations.createRubyException(this.context, exceptionClass, (Object)errorMessage, currentNode, null);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException encodingCompatibilityErrorIncompatible(RubyEncoding a, RubyEncoding b, Node currentNode) {
        return this.encodingCompatibilityError(StringUtils.format("incompatible character encodings: %s and %s", a, b), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException encodingCompatibilityErrorRegexpIncompatible(RubyEncoding a, RubyEncoding b, Node currentNode) {
        return this.encodingCompatibilityError(StringUtils.format("incompatible encoding regexp match (%s regexp with %s string)", a, b), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException encodingCompatibilityErrorIncompatibleWithOperation(RubyEncoding encoding, Node currentNode) {
        return this.encodingCompatibilityError(StringUtils.format("incompatible encoding with this operation: %s", encoding), currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException encodingCompatibilityError(String message, Node currentNode) {
        RubyClass exceptionClass = this.context.getCoreLibrary().encodingCompatibilityErrorClass;
        RubyString errorMessage = StringOperations.createUTF8String(this.context, this.language, message);
        return ExceptionOperations.createRubyException(this.context, exceptionClass, (Object)errorMessage, currentNode, null);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException encodingUndefinedConversionError(Node currentNode) {
        RubyClass exceptionClass = this.context.getCoreLibrary().encodingUndefinedConversionErrorClass;
        return ExceptionOperations.createRubyException(this.context, exceptionClass, (Object)this.coreStrings().REPLACEMENT_CHARACTER_SETUP_FAILED.createInstance(this.context), currentNode, null);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException fiberError(String message, Node currentNode) {
        RubyClass exceptionClass = this.context.getCoreLibrary().fiberErrorClass;
        RubyString errorMessage = StringOperations.createUTF8String(this.context, this.language, message);
        return ExceptionOperations.createRubyException(this.context, exceptionClass, (Object)errorMessage, currentNode, null);
    }

    public RubyException deadFiberCalledError(Node currentNode) {
        return this.fiberError("dead fiber called", currentNode);
    }

    public RubyException yieldFromRootFiberError(Node currentNode) {
        return this.fiberError("can't yield from root fiber", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException threadError(String message, Node currentNode) {
        RubyClass exceptionClass = this.context.getCoreLibrary().threadErrorClass;
        RubyString errorMessage = StringOperations.createUTF8String(this.context, this.language, message);
        return ExceptionOperations.createRubyException(this.context, exceptionClass, (Object)errorMessage, currentNode, null);
    }

    public RubyException threadErrorKilledThread(Node currentNode) {
        return this.threadError("killed thread", currentNode);
    }

    public RubyException threadErrorRecursiveLocking(Node currentNode) {
        return this.threadError("deadlock; recursive locking", currentNode);
    }

    public RubyException threadErrorUnlockNotLocked(Node currentNode) {
        return this.threadError("Attempt to unlock a mutex which is not locked", currentNode);
    }

    public RubyException threadErrorAlreadyLocked(Node currentNode) {
        return this.threadError("Attempt to unlock a mutex which is locked by another thread", currentNode);
    }

    public RubyException threadErrorQueueFull(Node currentNode) {
        return this.threadError("queue full", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException securityError(String message, Node currentNode) {
        RubyClass exceptionClass = this.context.getCoreLibrary().securityErrorClass;
        RubyString errorMessage = StringOperations.createUTF8String(this.context, this.language, message);
        return ExceptionOperations.createRubyException(this.context, exceptionClass, (Object)errorMessage, currentNode, null);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException ffiNullPointerError(String message, Node currentNode) {
        RubyClass exceptionClass = this.context.getCoreLibrary().truffleFFINullPointerErrorClass;
        RubyString errorMessage = StringOperations.createUTF8String(this.context, this.language, message);
        return ExceptionOperations.createRubyException(this.context, exceptionClass, (Object)errorMessage, currentNode, null);
    }

    @CompilerDirectives.TruffleBoundary
    public RubySystemExit systemExit(int exitStatus, Node currentNode) {
        RubyString message = StringOperations.createUTF8String(this.context, this.language, "exit");
        RubyClass exceptionClass = this.context.getCoreLibrary().systemExitClass;
        Backtrace backtrace = this.context.getCallStack().getBacktrace(currentNode);
        Object cause = ThreadNodes.ThreadGetExceptionNode.getLastException(this.language);
        this.showExceptionIfDebug(exceptionClass, (Object)message, backtrace);
        return new RubySystemExit(exceptionClass, this.language.systemExitShape, (Object)message, backtrace, cause, exitStatus);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException closedQueueError(String message, Node currentNode) {
        RubyClass exceptionClass = this.context.getCoreLibrary().closedQueueErrorClass;
        RubyString errorMessage = StringOperations.createUTF8String(this.context, this.language, message);
        return ExceptionOperations.createRubyException(this.context, exceptionClass, (Object)errorMessage, currentNode, null);
    }

    public RubyException closedQueueError(Node currentNode) {
        return this.closedQueueError("queue closed", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyException unsupportedMessageError(String message, Node currentNode) {
        RubyClass exceptionClass = this.context.getCoreLibrary().unsupportedMessageErrorClass;
        RubyString errorMessage = StringOperations.createUTF8String(this.context, this.language, message);
        return ExceptionOperations.createRubyException(this.context, exceptionClass, (Object)errorMessage, currentNode, null);
    }

    private CoreStrings coreStrings() {
        return this.language.coreStrings;
    }
}

