/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.encoding;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Objects;
import java.util.Set;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.truffleruby.RubyContext;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.kernel.KernelNodes;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.string.FrozenStringLiterals;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.string.TStringConstants;
import org.truffleruby.language.ImmutableRubyObjectNotCopyable;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.objects.ObjectGraph;
import org.truffleruby.language.objects.ObjectGraphNode;

@ExportLibrary(value=InteropLibrary.class)
public final class RubyEncoding
extends ImmutableRubyObjectNotCopyable
implements ObjectGraphNode,
Comparable<RubyEncoding> {
    public final Encoding jcoding;
    public final TruffleString.Encoding tencoding;
    public final ImmutableRubyString name;
    public final int index;
    public final boolean isDummy;
    public final boolean isAsciiCompatible;
    public final boolean isFixedWidth;
    public final boolean isSingleByte;
    public final boolean isUnicode;

    public RubyEncoding(Encoding jcoding, ImmutableRubyString name, int index) {
        TruffleString.Encoding tencoding;
        assert (name.getEncodingUncached() == Encodings.US_ASCII);
        this.jcoding = Objects.requireNonNull(jcoding);
        try {
            tencoding = TStringUtils.jcodingToTEncoding(jcoding);
        }
        catch (IllegalArgumentException e) {
            if (jcoding.isDummy()) {
                tencoding = TStringUtils.jcodingToTEncoding((Encoding)ASCIIEncoding.INSTANCE);
            }
            throw e;
        }
        this.tencoding = Objects.requireNonNull(tencoding);
        this.name = Objects.requireNonNull(name);
        this.index = index;
        this.isDummy = jcoding.isDummy();
        this.isAsciiCompatible = jcoding.isAsciiCompatible();
        this.isFixedWidth = jcoding.isFixedWidth();
        this.isSingleByte = jcoding.isSingleByte();
        this.isUnicode = jcoding.isUnicode();
    }

    public RubyEncoding(int index) {
        this.jcoding = (Encoding)Objects.requireNonNull(USASCIIEncoding.INSTANCE);
        this.tencoding = Objects.requireNonNull(TruffleString.Encoding.US_ASCII);
        this.name = Objects.requireNonNull(FrozenStringLiterals.createStringAndCacheLater(TStringConstants.US_ASCII, this));
        this.index = index;
        Encoding jcoding = this.jcoding;
        this.isDummy = jcoding.isDummy();
        this.isAsciiCompatible = jcoding.isAsciiCompatible();
        this.isFixedWidth = jcoding.isFixedWidth();
        this.isSingleByte = jcoding.isSingleByte();
        this.isUnicode = jcoding.isUnicode();
    }

    @Override
    public void getAdjacentObjects(Set<Object> reachable) {
        ObjectGraph.addProperty(reachable, this.name);
    }

    public String toString() {
        return this.jcoding.toString();
    }

    @ExportMessage
    protected Object toDisplayString(boolean allowSideEffects, @Cached DispatchNode dispatchNode, @Cached KernelNodes.ToSNode kernelToSNode) {
        if (allowSideEffects) {
            return dispatchNode.call(this, "inspect");
        }
        return kernelToSNode.execute(this);
    }

    @ExportMessage
    protected boolean hasMetaObject() {
        return true;
    }

    @ExportMessage
    protected RubyClass getMetaObject(@CachedLibrary(value="this") InteropLibrary node) {
        return RubyContext.get((Node)node).getCoreLibrary().encodingClass;
    }

    @Override
    public int compareTo(RubyEncoding o) {
        if (this.index != o.index) {
            return this.index - o.index;
        }
        return this.name.tstring.compareBytesUncached((AbstractTruffleString)o.name.tstring, Encodings.US_ASCII.tencoding);
    }
}

