/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.encoding;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import org.jcodings.EncodingDB;
import org.jcodings.util.CaseInsensitiveBytesHash;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.cast.ToRubyEncodingNode;
import org.truffleruby.core.encoding.EncodingNodesFactory;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.StringGuards;
import org.truffleruby.interop.ToJavaStringNode;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.yield.CallBlockNode;

@CoreModule(value="Encoding", isClass=true)
public abstract class EncodingNodes {

    @Primitive(name="encoding_unicode_emoji_version")
    public static abstract class UnicodeEmojiVersionNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyString getUnicodeEmojiVersion(@Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            return this.createString(fromJavaStringNode, "13.1", Encodings.UTF_8);
        }
    }

    @Primitive(name="encoding_unicode_version")
    public static abstract class UnicodeVersionNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyString getUnicodeVersion(@Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            return this.createString(fromJavaStringNode, "13.0.0", Encodings.UTF_8);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class CheckEncodingNode
    extends RubyBaseNode {
        public abstract RubyEncoding execute(Node var1, Object var2, Object var3);

        @Specialization
        static RubyEncoding checkEncoding(Node node, Object first, Object second, @Cached ToRubyEncodingNode toRubyEncodingNode, @Cached NegotiateCompatibleEncodingNode negotiateCompatibleEncodingNode, @Cached InlinedBranchProfile errorProfile) {
            RubyEncoding secondEncoding;
            RubyEncoding firstEncoding = toRubyEncodingNode.execute(node, first);
            RubyEncoding negotiatedEncoding = negotiateCompatibleEncodingNode.execute(node, first, firstEncoding, second, secondEncoding = toRubyEncodingNode.execute(node, second));
            if (negotiatedEncoding == null) {
                errorProfile.enter(node);
                throw new RaiseException(CheckEncodingNode.getContext(node), CheckEncodingNode.coreExceptions(node).encodingCompatibilityErrorIncompatible(firstEncoding, secondEncoding, node));
            }
            return negotiatedEncoding;
        }
    }

    @Primitive(name="encoding_ensure_compatible")
    public static abstract class EncodingCheckEncodingNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyEncoding checkEncoding(Object first, Object second, @Cached CheckEncodingNode checkEncodingNode) {
            return checkEncodingNode.execute(this, first, second);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class CheckStringEncodingNode
    extends RubyBaseNode {
        public abstract RubyEncoding executeCheckEncoding(Node var1, AbstractTruffleString var2, RubyEncoding var3, AbstractTruffleString var4, RubyEncoding var5);

        @Specialization
        static RubyEncoding checkEncoding(Node node, AbstractTruffleString first, RubyEncoding firstEncoding, AbstractTruffleString second, RubyEncoding secondEncoding, @Cached InlinedBranchProfile errorProfile, @Cached NegotiateCompatibleStringEncodingNode negotiateCompatibleEncodingNode) {
            RubyEncoding negotiatedEncoding = negotiateCompatibleEncodingNode.execute(node, first, firstEncoding, second, secondEncoding);
            if (negotiatedEncoding == null) {
                errorProfile.enter(node);
                throw new RaiseException(CheckStringEncodingNode.getContext(node), CheckStringEncodingNode.coreExceptions(node).encodingCompatibilityErrorIncompatible(firstEncoding, secondEncoding, node));
            }
            return negotiatedEncoding;
        }
    }

    @Primitive(name="encoding_ensure_compatible_str")
    public static abstract class CheckStringEncodingPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"libFirst.isRubyString(first)", "libSecond.isRubyString(second)"}, limit="1")
        static RubyEncoding checkEncodingStringString(Object first, Object second, @Cached RubyStringLibrary libFirst, @Cached RubyStringLibrary libSecond, @Cached InlinedBranchProfile errorProfile, @Cached NegotiateCompatibleStringEncodingNode negotiateCompatibleStringEncodingNode, @Bind(value="this") Node node) {
            RubyEncoding firstEncoding = libFirst.getEncoding(first);
            RubyEncoding secondEncoding = libSecond.getEncoding(second);
            RubyEncoding negotiatedEncoding = negotiateCompatibleStringEncodingNode.execute(node, libFirst.getTString(first), firstEncoding, libSecond.getTString(second), secondEncoding);
            if (negotiatedEncoding == null) {
                errorProfile.enter(node);
                throw new RaiseException(CheckStringEncodingPrimitiveNode.getContext(node), CheckStringEncodingPrimitiveNode.coreExceptions(node).encodingCompatibilityErrorIncompatible(firstEncoding, secondEncoding, node));
            }
            return negotiatedEncoding;
        }
    }

    @Primitive(name="encoding_get_encoding_index")
    public static abstract class GetEncodingIndexNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        int getIndex(RubyEncoding encoding) {
            return encoding.index;
        }
    }

    @Primitive(name="encoding_get_encoding_by_index", lowerFixnum={0})
    public static abstract class GetEncodingObjectByIndexNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"isSingleContext()", "index == cachedIndex"}, limit="getCacheLimit()")
        RubyEncoding getEncoding(int index, @Cached(value="index") int cachedIndex, @Cached(value="getContext().getEncodingManager().getRubyEncoding(index)") RubyEncoding cachedEncoding) {
            return cachedEncoding;
        }

        @Specialization(replaces={"getEncoding"})
        RubyEncoding getEncodingUncached(int index) {
            return this.getContext().getEncodingManager().getRubyEncoding(index);
        }

        protected int getCacheLimit() {
            return this.getLanguage().options.ENCODING_LOADED_CLASSES_CACHE;
        }
    }

    @Primitive(name="encoding_create_dummy")
    public static abstract class DummyEncodingNode
    extends EncodingCreationNode {
        @Specialization(guards={"strings.isRubyString(nameObject)"}, limit="1")
        static RubyArray createDummyEncoding(Object nameObject, @Cached RubyStringLibrary strings, @Cached ToJavaStringNode toJavaStringNode, @Bind(value="this") Node node) {
            String name = toJavaStringNode.execute(node, nameObject);
            RubyEncoding newEncoding = DummyEncodingNode.createDummy(node, name);
            return DummyEncodingNode.setIndexOrRaiseError(node, name, newEncoding);
        }

        @CompilerDirectives.TruffleBoundary
        private static RubyEncoding createDummy(Node node, String name) {
            return DummyEncodingNode.getContext(node).getEncodingManager().createDummyEncoding(name);
        }
    }

    @Primitive(name="encoding_replicate")
    public static abstract class EncodingReplicateNode
    extends EncodingCreationNode {
        @Specialization(guards={"strings.isRubyString(nameObject)"}, limit="1")
        static RubyArray encodingReplicate(RubyEncoding object, Object nameObject, @Cached RubyStringLibrary strings, @Cached ToJavaStringNode toJavaStringNode, @Bind(value="this") Node node) {
            String name = toJavaStringNode.execute(node, nameObject);
            RubyEncoding newEncoding = EncodingReplicateNode.replicate(node, name, object);
            return EncodingReplicateNode.setIndexOrRaiseError(node, name, newEncoding);
        }

        @CompilerDirectives.TruffleBoundary
        private static RubyEncoding replicate(Node node, String name, RubyEncoding encoding) {
            return EncodingReplicateNode.getContext(node).getEncodingManager().replicateEncoding(encoding, name);
        }
    }

    public static abstract class EncodingCreationNode
    extends PrimitiveArrayArgumentsNode {
        public static RubyArray setIndexOrRaiseError(Node node, String name, RubyEncoding newEncoding) {
            if (newEncoding == null) {
                throw new RaiseException(EncodingCreationNode.getContext(node), EncodingCreationNode.coreExceptions(node).argumentErrorEncodingAlreadyRegistered(name, node));
            }
            int index = newEncoding.index;
            return EncodingCreationNode.createArray(node, new Object[]{newEncoding, index});
        }
    }

    @Primitive(name="encoding_get_object_encoding")
    public static abstract class EncodingGetObjectEncodingNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object getObjectEncoding(Object object, @Cached ToRubyEncodingNode toRubyEncodingNode, @Cached InlinedConditionProfile nullProfile) {
            RubyEncoding rubyEncoding = toRubyEncodingNode.execute(this, object);
            if (nullProfile.profile((Node)this, rubyEncoding == null)) {
                return nil;
            }
            return rubyEncoding;
        }
    }

    @Primitive(name="encoding_set_default_internal")
    public static abstract class SetDefaultInternalNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyEncoding setDefaultInternal(RubyEncoding encoding) {
            this.getContext().getEncodingManager().setDefaultInternalEncoding(encoding);
            return encoding;
        }

        @Specialization
        Object noDefaultInternal(Nil encoding) {
            this.getContext().getEncodingManager().setDefaultInternalEncoding(null);
            return nil;
        }
    }

    @Primitive(name="encoding_set_default_external")
    public static abstract class SetDefaultExternalNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyEncoding setDefaultExternal(RubyEncoding encoding) {
            this.getContext().getEncodingManager().setDefaultExternalEncoding(encoding);
            return encoding;
        }

        @Specialization
        RubyEncoding noDefaultExternal(Nil encoding) {
            throw new RaiseException(this.getContext(), this.coreExceptions().argumentError("default external can not be nil", this));
        }
    }

    @Primitive(name="encoding_get_default_encoding")
    public static abstract class GetDefaultEncodingNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object getDefaultEncoding(Object name) {
            RubyEncoding encoding = this.getEncoding(RubyGuards.getJavaString(name));
            if (encoding == null) {
                return nil;
            }
            return encoding;
        }

        @CompilerDirectives.TruffleBoundary
        private RubyEncoding getEncoding(String name) {
            switch (name) {
                case "internal": {
                    return this.getContext().getEncodingManager().getDefaultInternalEncoding();
                }
                case "external": 
                case "filesystem": {
                    return this.getContext().getEncodingManager().getDefaultExternalEncoding();
                }
                case "locale": {
                    return this.getContext().getEncodingManager().getLocaleEncoding();
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    public static abstract class GetActualEncodingNode
    extends RubyBaseNode {
        public abstract RubyEncoding execute(AbstractTruffleString var1, RubyEncoding var2);

        @Specialization(guards={"!encoding.isDummy"})
        RubyEncoding getActualEncoding(AbstractTruffleString tstring, RubyEncoding encoding) {
            return encoding;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"encoding.isDummy"})
        RubyEncoding getActualEncodingDummy(AbstractTruffleString tstring, RubyEncoding encoding, @Cached TruffleString.ReadByteNode readByteNode) {
            if (encoding.isUnicode) {
                TruffleString.Encoding enc = encoding.tencoding;
                int byteLength = tstring.byteLength(enc);
                if (encoding == Encodings.UTF16_DUMMY && byteLength >= 2) {
                    int c0 = readByteNode.execute(tstring, 0, enc);
                    int c1 = readByteNode.execute(tstring, 1, enc);
                    if (c0 == 254 && c1 == 255) {
                        return Encodings.UTF16BE;
                    }
                    if (c0 == 255 && c1 == 254) {
                        return Encodings.UTF16LE;
                    }
                    return Encodings.BINARY;
                }
                if (encoding == Encodings.UTF32_DUMMY && byteLength >= 4) {
                    int c0 = readByteNode.execute(tstring, 0, enc);
                    int c1 = readByteNode.execute(tstring, 1, enc);
                    int c2 = readByteNode.execute(tstring, 2, enc);
                    int c3 = readByteNode.execute(tstring, 3, enc);
                    if (c0 == 0 && c1 == 0 && c2 == 254 && c3 == 255) {
                        return Encodings.UTF32BE;
                    }
                    if (c3 == 0 && c2 == 0 && c1 == 254 && c0 == 255) {
                        return Encodings.UTF32LE;
                    }
                    return Encodings.BINARY;
                }
            }
            return encoding;
        }
    }

    @Primitive(name="get_actual_encoding")
    public static abstract class GetActualEncodingPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"libString.isRubyString(string)"}, limit="1")
        RubyEncoding getActualEncoding(Object string, @Cached GetActualEncodingNode getActualEncodingNode, @Cached RubyStringLibrary libString) {
            return getActualEncodingNode.execute(libString.getTString(string), libString.getEncoding(string));
        }
    }

    @Primitive(name="encoding_is_unicode")
    public static abstract class IsUnicodeNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        boolean isUnicode(RubyEncoding encoding) {
            return encoding.isUnicode;
        }
    }

    @Primitive(name="encoding_each_alias")
    public static abstract class EachAliasNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private CallBlockNode yieldNode = CallBlockNode.create();
        @Node.Child
        private TruffleString.FromByteArrayNode fromByteArrayNode = TruffleString.FromByteArrayNode.create();

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object eachAlias(RubyProc block) {
            CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntryIterator iterator = EncodingDB.getAliases().entryIterator();
            while (iterator.hasNext()) {
                CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry entry = iterator.next();
                RubyString aliasName = this.createString(this.fromByteArrayNode, ArrayUtils.extractRange(entry.bytes, entry.p, entry.end), Encodings.US_ASCII);
                this.yieldNode.yield(block, new Object[]{aliasName, Encodings.getBuiltInEncoding(((EncodingDB.Entry)entry.value).getEncoding())});
            }
            return nil;
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object allocate(RubyClass rubyClass) {
            throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorAllocatorUndefinedFor(rubyClass, this));
        }
    }

    @CoreMethod(names={"name", "to_s"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        ImmutableRubyString toS(RubyEncoding encoding) {
            return encoding.name;
        }
    }

    @CoreMethod(names={"dummy?"})
    public static abstract class DummyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isDummy(RubyEncoding encoding) {
            return encoding.isDummy;
        }
    }

    @CoreMethod(names={"locale_charmap"}, onSingleton=true)
    public static abstract class LocaleCharacterMapNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        ImmutableRubyString localeCharacterMap() {
            RubyEncoding rubyEncoding = this.getContext().getEncodingManager().getLocaleEncoding();
            return rubyEncoding.name;
        }
    }

    @CoreMethod(names={"list"}, onSingleton=true)
    public static abstract class ListNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyArray list() {
            return this.createArray(this.getContext().getEncodingManager().getEncodingList());
        }
    }

    @Primitive(name="strings_compatible?")
    public static abstract class AreStringsCompatibleNode
    extends PrimitiveArrayArgumentsNode {
        public static AreStringsCompatibleNode create() {
            return EncodingNodesFactory.AreStringsCompatibleNodeFactory.create(null);
        }

        @Specialization
        Object areCompatible(Object first, Object second, @Cached RubyStringLibrary libFirst, @Cached RubyStringLibrary libSecond, @Cached NegotiateCompatibleStringEncodingNode negotiateCompatibleStringEncodingNode, @Cached InlinedConditionProfile noNegotiatedEncodingProfile) {
            RubyEncoding negotiatedEncoding = negotiateCompatibleStringEncodingNode.execute(this, libFirst.getTString(first), libFirst.getEncoding(first), libSecond.getTString(second), libSecond.getEncoding(second));
            if (noNegotiatedEncodingProfile.profile((Node)this, negotiatedEncoding == null)) {
                return nil;
            }
            return negotiatedEncoding;
        }
    }

    @Primitive(name="encoding_compatible?")
    public static abstract class CompatibleQueryNode
    extends PrimitiveArrayArgumentsNode {
        public static CompatibleQueryNode create() {
            return EncodingNodesFactory.CompatibleQueryNodeFactory.create(null);
        }

        @Specialization
        Object isCompatible(Object first, Object second, @Cached NegotiateCompatibleEncodingNode negotiateCompatibleEncodingNode, @Cached ToRubyEncodingNode toRubyEncodingNode, @Cached InlinedConditionProfile noNegotiatedEncodingProfile) {
            RubyEncoding secondEncoding;
            RubyEncoding firstEncoding = toRubyEncodingNode.execute(this, first);
            RubyEncoding negotiatedEncoding = negotiateCompatibleEncodingNode.execute(this, first, firstEncoding, second, secondEncoding = toRubyEncodingNode.execute(this, second));
            if (noNegotiatedEncodingProfile.profile((Node)this, negotiatedEncoding == null)) {
                return nil;
            }
            return negotiatedEncoding;
        }
    }

    @GenerateCached(value=false)
    @GenerateInline
    public static abstract class NegotiateCompatibleEncodingNode
    extends RubyBaseNode {
        public abstract RubyEncoding execute(Node var1, Object var2, RubyEncoding var3, Object var4, RubyEncoding var5);

        @Specialization(guards={"firstEncoding == cachedEncoding", "secondEncoding == cachedEncoding", "cachedEncoding != null"}, limit="getCacheLimit()")
        static RubyEncoding negotiateSameEncodingCached(Object first, RubyEncoding firstEncoding, Object second, RubyEncoding secondEncoding, @Cached(value="firstEncoding") RubyEncoding cachedEncoding) {
            return cachedEncoding;
        }

        @Specialization(guards={"firstEncoding == secondEncoding", "firstEncoding != null"}, replaces={"negotiateSameEncodingCached"})
        static RubyEncoding negotiateSameEncodingUncached(Object first, RubyEncoding firstEncoding, Object second, RubyEncoding secondEncoding) {
            return firstEncoding;
        }

        @Specialization(guards={"libFirst.isRubyString(first)", "libSecond.isRubyString(second)"})
        static RubyEncoding negotiateStringStringEncoding(Node node, Object first, RubyEncoding firstEncoding, Object second, RubyEncoding secondEncoding, @Cached @Cached.Shared RubyStringLibrary libFirst, @Cached @Cached.Shared RubyStringLibrary libSecond, @Cached NegotiateCompatibleStringEncodingNode negotiateNode) {
            return negotiateNode.execute(node, libFirst.getTString(first), firstEncoding, libSecond.getTString(second), secondEncoding);
        }

        @Specialization(guards={"libFirst.isRubyString(first)", "isNotRubyString(second)", "codeRange == codeRangeCached", "firstEncoding == firstEncodingCached", "secondEncoding == secondEncodingCached", "firstEncodingCached != secondEncodingCached"}, limit="getCacheLimit()")
        static RubyEncoding negotiateStringObjectCached(Object first, RubyEncoding firstEncoding, Object second, RubyEncoding secondEncoding, @Cached @Cached.Shared RubyStringLibrary libFirst, @Cached(value="firstEncoding") RubyEncoding firstEncodingCached, @Cached(value="secondEncoding") RubyEncoding secondEncodingCached, @Cached(inline=false) @Cached.Shared TruffleString.GetByteCodeRangeNode codeRangeNode, @Bind(value="getCodeRange(codeRangeNode, first, libFirst)") TruffleString.CodeRange codeRange, @Cached(value="codeRange") TruffleString.CodeRange codeRangeCached, @Cached(value="negotiateStringObjectUncached(first, firstEncoding, second, secondEncoding, codeRangeNode, libFirst)") RubyEncoding negotiatedEncoding) {
            return negotiatedEncoding;
        }

        @Specialization(guards={"libFirst.isRubyString(first)", "firstEncoding != secondEncoding", "isNotRubyString(second)"}, replaces={"negotiateStringObjectCached"})
        static RubyEncoding negotiateStringObjectUncached(Object first, RubyEncoding firstEncoding, Object second, RubyEncoding secondEncoding, @Cached(inline=false) @Cached.Shared TruffleString.GetByteCodeRangeNode codeRangeNode, @Cached @Cached.Shared RubyStringLibrary libFirst) {
            if (secondEncoding == null) {
                return null;
            }
            if (!firstEncoding.isAsciiCompatible || !secondEncoding.isAsciiCompatible) {
                return null;
            }
            if (secondEncoding == Encodings.US_ASCII) {
                return firstEncoding;
            }
            if (NegotiateCompatibleEncodingNode.getCodeRange(codeRangeNode, first, libFirst) == TruffleString.CodeRange.ASCII) {
                return secondEncoding;
            }
            return null;
        }

        @Specialization(guards={"libSecond.isRubyString(second)", "firstEncoding != secondEncoding", "isNotRubyString(first)"})
        static RubyEncoding negotiateObjectString(Object first, RubyEncoding firstEncoding, Object second, RubyEncoding secondEncoding, @Cached @Cached.Shared RubyStringLibrary libSecond, @Cached(inline=false) @Cached.Shared TruffleString.GetByteCodeRangeNode codeRangeNode) {
            return NegotiateCompatibleEncodingNode.negotiateStringObjectUncached(second, secondEncoding, first, firstEncoding, codeRangeNode, libSecond);
        }

        @Specialization(guards={"firstEncoding != secondEncoding", "isNotRubyString(first)", "isNotRubyString(second)", "firstEncoding != null", "secondEncoding != null", "firstEncoding == firstEncodingCached", "secondEncoding == secondEncodingCached"}, limit="getCacheLimit()")
        static RubyEncoding negotiateObjectObjectCached(Object first, RubyEncoding firstEncoding, Object second, RubyEncoding secondEncoding, @Cached(value="firstEncoding") RubyEncoding firstEncodingCached, @Cached(value="secondEncoding") RubyEncoding secondEncodingCached, @Cached(value="areCompatible(firstEncodingCached, secondEncodingCached)") RubyEncoding negotiatedEncoding) {
            return negotiatedEncoding;
        }

        @Specialization(guards={"firstEncoding != secondEncoding", "isNotRubyString(first)", "isNotRubyString(second)"}, replaces={"negotiateObjectObjectCached"})
        static RubyEncoding negotiateObjectObjectUncached(Object first, RubyEncoding firstEncoding, Object second, RubyEncoding secondEncoding) {
            return NegotiateCompatibleEncodingNode.areCompatible(firstEncoding, secondEncoding);
        }

        @CompilerDirectives.TruffleBoundary
        protected static RubyEncoding areCompatible(RubyEncoding enc1, RubyEncoding enc2) {
            assert (enc1 != enc2);
            if (enc1 == null || enc2 == null) {
                return null;
            }
            if (!enc1.isAsciiCompatible || !enc2.isAsciiCompatible) {
                return null;
            }
            if (enc2 == Encodings.US_ASCII) {
                return enc1;
            }
            if (enc1 == Encodings.US_ASCII) {
                return enc2;
            }
            return null;
        }

        protected static TruffleString.CodeRange getCodeRange(TruffleString.GetByteCodeRangeNode codeRangeNode, Object string, RubyStringLibrary libString) {
            return codeRangeNode.execute(libString.getTString(string), libString.getTEncoding(string));
        }

        protected int getCacheLimit() {
            return this.getLanguage().options.ENCODING_COMPATIBLE_QUERY_CACHE;
        }
    }

    @ImportStatic(value={TruffleString.CodeRange.class})
    @GenerateCached(value=false)
    @GenerateInline
    public static abstract class NegotiateCompatibleStringEncodingNode
    extends RubyBaseNode {
        protected static final int NUMBER_OF_STANDARD_ENCODINGS = 3;

        public abstract RubyEncoding execute(Node var1, AbstractTruffleString var2, RubyEncoding var3, AbstractTruffleString var4, RubyEncoding var5);

        @Specialization(guards={"firstEncoding == cachedEncoding", "secondEncoding == cachedEncoding"}, limit="getCacheLimit()")
        static RubyEncoding negotiateSameEncodingCached(AbstractTruffleString first, RubyEncoding firstEncoding, AbstractTruffleString second, RubyEncoding secondEncoding, @Cached(value="firstEncoding") RubyEncoding cachedEncoding) {
            assert (first.isCompatibleToUncached(firstEncoding.tencoding) && second.isCompatibleToUncached(secondEncoding.tencoding));
            return cachedEncoding;
        }

        @Specialization(guards={"firstEncoding == secondEncoding"}, replaces={"negotiateSameEncodingCached"})
        static RubyEncoding negotiateSameEncodingUncached(AbstractTruffleString first, RubyEncoding firstEncoding, AbstractTruffleString second, RubyEncoding secondEncoding) {
            assert (first.isCompatibleToUncached(firstEncoding.tencoding) && second.isCompatibleToUncached(secondEncoding.tencoding));
            return firstEncoding;
        }

        @Specialization(guards={"firstEncoding != secondEncoding", "firstEncoding == cachedEncoding", "isStandardEncoding(cachedEncoding)", "codeRangeNode.execute(second, secondEncoding.tencoding) == ASCII"}, limit="NUMBER_OF_STANDARD_ENCODINGS")
        static RubyEncoding negotiateStandardEncodingAndCr7Bit(AbstractTruffleString first, RubyEncoding firstEncoding, AbstractTruffleString second, RubyEncoding secondEncoding, @Cached(inline=false) @Cached.Shared TruffleString.GetByteCodeRangeNode codeRangeNode, @Cached(value="firstEncoding") RubyEncoding cachedEncoding) {
            return cachedEncoding;
        }

        @Specialization(guards={"firstEncoding != secondEncoding", "first.isEmpty() == isFirstEmpty", "second.isEmpty() == isSecondEmpty", "cachedFirstEncoding == firstEncoding", "cachedSecondEncoding == secondEncoding", "firstCodeRange == firstCodeRangeCached", "secondCodeRange == secondCodeRangeCached"}, limit="getCacheLimit()")
        static RubyEncoding negotiateEncodingCached(AbstractTruffleString first, RubyEncoding firstEncoding, AbstractTruffleString second, RubyEncoding secondEncoding, @Cached(value="first.isEmpty()") boolean isFirstEmpty, @Cached(value="second.isEmpty()") boolean isSecondEmpty, @Cached(inline=false) @Cached.Shared TruffleString.GetByteCodeRangeNode codeRangeNode, @Bind(value="codeRangeNode.execute(first, firstEncoding.tencoding)") TruffleString.CodeRange firstCodeRange, @Bind(value="codeRangeNode.execute(second, secondEncoding.tencoding)") TruffleString.CodeRange secondCodeRange, @Cached(value="firstCodeRange") TruffleString.CodeRange firstCodeRangeCached, @Cached(value="secondCodeRange") TruffleString.CodeRange secondCodeRangeCached, @Cached(value="firstEncoding") RubyEncoding cachedFirstEncoding, @Cached(value="secondEncoding") RubyEncoding cachedSecondEncoding, @Cached(value="compatibleEncodingForStrings(first, firstEncoding, second, secondEncoding, codeRangeNode)") RubyEncoding negotiatedEncoding) {
            assert (first.isCompatibleToUncached(firstEncoding.tencoding) && second.isCompatibleToUncached(secondEncoding.tencoding));
            return negotiatedEncoding;
        }

        @Specialization(guards={"firstEncoding != secondEncoding"}, replaces={"negotiateEncodingCached"})
        static RubyEncoding negotiateEncodingUncached(AbstractTruffleString first, RubyEncoding firstEncoding, AbstractTruffleString second, RubyEncoding secondEncoding, @Cached(inline=false) @Cached.Shared TruffleString.GetByteCodeRangeNode codeRangeNode) {
            assert (first.isCompatibleToUncached(firstEncoding.tencoding) && second.isCompatibleToUncached(secondEncoding.tencoding));
            return NegotiateCompatibleStringEncodingNode.compatibleEncodingForStrings(first, firstEncoding, second, secondEncoding, codeRangeNode);
        }

        @CompilerDirectives.TruffleBoundary
        protected static RubyEncoding compatibleEncodingForStrings(AbstractTruffleString first, RubyEncoding firstEncoding, AbstractTruffleString second, RubyEncoding secondEncoding, TruffleString.GetByteCodeRangeNode codeRangeNode) {
            assert (firstEncoding != secondEncoding) : "this method assumes the encodings are different";
            if (second.isEmpty()) {
                return firstEncoding;
            }
            if (first.isEmpty()) {
                return firstEncoding.isAsciiCompatible && StringGuards.is7Bit(second, secondEncoding, codeRangeNode) ? firstEncoding : secondEncoding;
            }
            if (!firstEncoding.isAsciiCompatible || !secondEncoding.isAsciiCompatible) {
                return null;
            }
            if (StringGuards.is7Bit(second, secondEncoding, codeRangeNode)) {
                return firstEncoding;
            }
            if (StringGuards.is7Bit(first, firstEncoding, codeRangeNode)) {
                return secondEncoding;
            }
            return null;
        }

        protected int getCacheLimit() {
            return this.getLanguage().options.ENCODING_COMPATIBLE_QUERY_CACHE;
        }

        @Idempotent
        protected boolean isStandardEncoding(RubyEncoding encoding) {
            return encoding == Encodings.UTF_8 || encoding == Encodings.US_ASCII || encoding == Encodings.BINARY;
        }
    }

    @CoreMethod(names={"ascii_compatible?"})
    public static abstract class AsciiCompatibleNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isAsciiCompatible(RubyEncoding encoding) {
            return encoding.isAsciiCompatible;
        }
    }
}

