/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.constant;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.truffleruby.core.module.ModuleOperations;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.WarnNode;

public final class WarnAlreadyInitializedNode
extends RubyBaseNode {
    @Node.Child
    private WarnNode warnNode = new WarnNode();

    public boolean shouldWarn() {
        return this.warnNode.shouldWarn();
    }

    @CompilerDirectives.TruffleBoundary
    public void warnAlreadyInitialized(RubyModule module, String name, SourceSection sourceSection, SourceSection previousSourceSection) {
        assert (this.shouldWarn());
        String constName = ModuleOperations.constantNameNoLeadingColon(this.getContext(), module, name);
        this.warnNode.warningMessage(sourceSection, "already initialized constant " + constName);
        if (previousSourceSection != null) {
            this.warnNode.warningMessage(previousSourceSection, "previous definition of " + name + " was here");
        }
    }
}

