/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.truffleruby.core.numeric.RubyBignum;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.utils.Utils;

@GenerateUncached
@GenerateInline(inlineByDefault=true)
public abstract class ToLongNode
extends RubyBaseNode {
    public abstract long execute(Node var1, Object var2);

    public final long executeCached(Object object) {
        return this.execute(this, object);
    }

    @Specialization
    static long coerceInt(int value) {
        return value;
    }

    @Specialization
    static long coerceLong(long value) {
        return value;
    }

    @Specialization
    static long coerceRubyBignum(Node node, RubyBignum value) {
        throw new RaiseException(ToLongNode.getContext(node), ToLongNode.coreExceptions(node).rangeError("bignum too big to convert into `long'", node));
    }

    @Specialization
    static long coerceDouble(Node node, double value, @Cached InlinedBranchProfile errorProfile) {
        if (-9.223372036854776E18 <= value && value < 9.223372036854776E18) {
            return (long)value;
        }
        errorProfile.enter(node);
        throw new RaiseException(ToLongNode.getContext(node), ToLongNode.coreExceptions(node).rangeError(Utils.concat("float ", value, " out of range of integer"), node));
    }

    @Specialization
    static long coerceNil(Node node, Nil nil) {
        throw new RaiseException(ToLongNode.getContext(node), ToLongNode.coreExceptions(node).typeError("no implicit conversion from nil to integer", node));
    }

    @Fallback
    static long coerceObject(Node node, Object object, @Cached(inline=false) DispatchNode toIntNode, @Cached(inline=false) ToLongNode fitNode) {
        Object coerced = toIntNode.call((Object)ToLongNode.coreLibrary((Node)node).truffleTypeModule, "rb_to_int_fallback", object);
        return fitNode.executeCached(coerced);
    }
}

