/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.array.ArrayDupNode;
import org.truffleruby.core.array.ArrayDupNodeGen;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.cast.SplatCastNodeGen;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.dispatch.DispatchNode;

@NodeChild(value="childNode", type=RubyNode.class)
public abstract class SplatCastNode
extends RubyContextSourceNode {
    private final NilBehavior nilBehavior;
    private final RubySymbol conversionMethod;
    @CompilerDirectives.CompilationFinal
    private boolean copy = true;
    @Node.Child
    private ArrayDupNode dup;
    @Node.Child
    private DispatchNode toA;

    public SplatCastNode(RubyLanguage language, NilBehavior nilBehavior, boolean useToAry) {
        this.nilBehavior = nilBehavior;
        this.conversionMethod = useToAry ? language.coreSymbols.TO_ARY : language.coreSymbols.TO_A;
    }

    public SplatCastNode(NilBehavior nilBehavior, RubySymbol conversionMethod) {
        this.nilBehavior = nilBehavior;
        this.conversionMethod = conversionMethod;
    }

    public abstract Object execute(Object var1);

    public abstract RubyNode getChildNode();

    public void doNotCopy() {
        this.copy = false;
    }

    @Specialization
    Object splatNil(Nil nil) {
        switch (this.nilBehavior) {
            case EMPTY_ARRAY: {
                return this.createEmptyArray();
            }
            case ARRAY_WITH_NIL: {
                return this.createArray(new Object[]{nil});
            }
            case CONVERT: {
                return this.callToA(nil);
            }
            case NIL: {
                return nil;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Specialization
    RubyArray splat(RubyArray array) {
        if (this.copy) {
            return this.executeDup(array);
        }
        return array;
    }

    @Specialization(guards={"!isNil(object)", "!isRubyArray(object)"})
    RubyArray splat(Object object, @Cached DispatchNode toArrayNode) {
        Object array = toArrayNode.call(this.coreLibrary().truffleTypeModule, "rb_check_convert_type", object, (Object)this.coreLibrary().arrayClass, (Object)this.conversionMethod);
        if (array == nil) {
            return this.createArray(new Object[]{object});
        }
        if (this.copy) {
            return this.executeDup((RubyArray)array);
        }
        return (RubyArray)array;
    }

    private Object callToA(Object nil) {
        if (this.toA == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toA = (DispatchNode)this.insert(DispatchNode.create());
        }
        return this.toA.call(nil, "to_a");
    }

    private RubyArray executeDup(RubyArray array) {
        if (this.dup == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.dup = (ArrayDupNode)this.insert(ArrayDupNodeGen.create());
        }
        return this.dup.executeDup(array);
    }

    @Override
    public RubyNode cloneUninitialized() {
        RubyNode childCopy = this.getChildNode() == null ? null : this.getChildNode().cloneUninitialized();
        SplatCastNode copy = SplatCastNodeGen.create(this.nilBehavior, this.conversionMethod, childCopy);
        return copy.copyFlags(this);
    }

    public static enum NilBehavior {
        EMPTY_ARRAY,
        ARRAY_WITH_NIL,
        NIL,
        CONVERT;

    }
}

