/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.truffleruby.core.cast.HashCastNodeGen;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchConfiguration;
import org.truffleruby.language.dispatch.DispatchNode;

public abstract class HashCastNode
extends RubyBaseNode {
    public abstract RubyHash execute(Object var1);

    @Specialization
    RubyHash castHash(RubyHash hash) {
        return hash;
    }

    @Specialization(guards={"!isRubyHash(object)"})
    RubyHash cast(Object object, @Cached InlinedBranchProfile errorProfile, @Cached DispatchNode toHashNode) {
        Object result = toHashNode.call(DispatchConfiguration.PRIVATE_RETURN_MISSING, object, "to_hash");
        if (result == DispatchNode.MISSING) {
            errorProfile.enter((Node)this);
            throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorNoImplicitConversion(object, "Hash", this));
        }
        if (!RubyGuards.isRubyHash(result)) {
            errorProfile.enter((Node)this);
            throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorCantConvertTo(object, "Hash", "to_hash", result, this));
        }
        return (RubyHash)result;
    }

    @NodeChild(value="childNode", type=RubyNode.class)
    public static abstract class HashCastASTNode
    extends RubyContextSourceNode {
        protected abstract RubyNode getChildNode();

        @Specialization
        RubyHash cast(Object object, @Cached HashCastNode hashCastNode) {
            return hashCastNode.execute(object);
        }

        @Override
        public void doExecuteVoid(VirtualFrame frame) {
            this.getChildNode().doExecuteVoid(frame);
        }

        @Override
        public RubyNode cloneUninitialized() {
            HashCastASTNode copy = HashCastNodeGen.HashCastASTNodeGen.create(this.getChildNode().cloneUninitialized());
            return copy.copyFlags(this);
        }
    }
}

