/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.truffleruby.core.numeric.BigIntegerOps;
import org.truffleruby.core.numeric.FixnumOrBignumNode;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.control.RaiseException;

@GenerateCached(value=false)
@GenerateInline
public abstract class FloatToIntegerNode
extends RubyBaseNode {
    public abstract Object execute(Node var1, double var2);

    @Specialization
    static Object fixnumOrBignum(Node node, double value, @Cached FixnumOrBignumNode fixnumOrBignumNode, @Cached InlinedBranchProfile errorProfile, @Cached InlinedConditionProfile longFromDoubleProfile, @Cached InlinedConditionProfile integerFromDoubleProfile) {
        if (integerFromDoubleProfile.profile(node, value > -2.147483648E9 && value < 2.147483647E9)) {
            return (int)value;
        }
        if (longFromDoubleProfile.profile(node, value > -9.223372036854776E18 && value < 9.223372036854776E18)) {
            return (long)value;
        }
        if (Double.isInfinite(value)) {
            errorProfile.enter(node);
            throw new RaiseException(FloatToIntegerNode.getContext(node), FloatToIntegerNode.coreExceptions(node).floatDomainError("Infinity", node));
        }
        if (Double.isNaN(value)) {
            errorProfile.enter(node);
            throw new RaiseException(FloatToIntegerNode.getContext(node), FloatToIntegerNode.coreExceptions(node).floatDomainError("NaN", node));
        }
        return fixnumOrBignumNode.execute(node, BigIntegerOps.fromDouble(value));
    }
}

