/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.cast;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.concurrent.TimeUnit;
import org.truffleruby.core.cast.ToLongNode;
import org.truffleruby.language.NotProvided;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;

public abstract class DurationToNanoSecondsNode
extends RubyBaseNode {
    public abstract long execute(Object var1);

    @Specialization
    long noDuration(NotProvided duration) {
        return Long.MAX_VALUE;
    }

    @Specialization
    long duration(long duration, @Cached @Cached.Shared InlinedConditionProfile durationLessThanZeroProfile) {
        return DurationToNanoSecondsNode.validate(this, TimeUnit.SECONDS.toNanos(duration), durationLessThanZeroProfile);
    }

    @Specialization
    long duration(double duration, @Cached @Cached.Shared InlinedConditionProfile durationLessThanZeroProfile) {
        return DurationToNanoSecondsNode.validate(this, (long)(duration * 1.0E9), durationLessThanZeroProfile);
    }

    @Fallback
    static long duration(Object duration, @Cached DispatchNode durationToNanoSeconds, @Cached @Cached.Shared InlinedConditionProfile durationLessThanZeroProfile, @Cached ToLongNode toLongNode, @Bind(value="this") Node node) {
        Object nanoseconds = durationToNanoSeconds.call((Object)DurationToNanoSecondsNode.coreLibrary((Node)node).truffleKernelOperationsModule, "convert_duration_to_nanoseconds", duration);
        return DurationToNanoSecondsNode.validate(node, toLongNode.execute(node, nanoseconds), durationLessThanZeroProfile);
    }

    private static long validate(Node node, long durationInNanos, InlinedConditionProfile durationLessThanZeroProfile) {
        if (durationLessThanZeroProfile.profile(node, durationInNanos < 0L)) {
            throw new RaiseException(DurationToNanoSecondsNode.getContext(node), DurationToNanoSecondsNode.coreExceptions(node).argumentErrorTimeIntervalPositive(node));
        }
        return durationInNanos;
    }
}

