/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.binding;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.core.binding.RubyBinding;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.RubyArguments;

public final class SetBindingFrameForEvalNode
extends RubyContextSourceNode {
    @Node.Child
    RubyNode body;
    private final FrameDescriptor descriptor;

    public SetBindingFrameForEvalNode(FrameDescriptor descriptor, RubyNode body) {
        this.descriptor = descriptor;
        this.body = body;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        assert (frame.getFrameDescriptor() == this.descriptor);
        assert (RubyArguments.getRawArgumentsCount((Frame)frame) == 1);
        RubyBinding binding = (RubyBinding)RubyArguments.getArgument((Frame)frame, 0);
        assert (RubyArguments.getDeclarationFrame((Frame)frame) == binding.getFrame());
        assert (binding.getFrame().getFrameDescriptor() != this.descriptor);
        binding.setFrame(frame.materialize());
        return this.body.execute(frame);
    }

    @Override
    public RubyNode cloneUninitialized() {
        SetBindingFrameForEvalNode copy = new SetBindingFrameForEvalNode(this.descriptor, this.body.cloneUninitialized());
        return copy.copyFlags(this);
    }
}

