/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.binding;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.truffleruby.Layouts;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.array.ArrayHelpers;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.binding.BindingNodesFactory;
import org.truffleruby.core.binding.RubyBinding;
import org.truffleruby.core.cast.NameToJavaStringNode;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.locals.FindDeclarationVariableNodes;
import org.truffleruby.language.locals.FrameDescriptorNamesIterator;
import org.truffleruby.language.locals.WriteFrameSlotNode;
import org.truffleruby.language.locals.WriteFrameSlotNodeGen;
import org.truffleruby.parser.BlockDescriptorInfo;
import org.truffleruby.parser.TranslatorEnvironment;

@CoreModule(value="Binding", isClass=true)
public abstract class BindingNodes {
    static final int NEW_VAR_INDEX = 1;

    public static RubyBinding createBinding(RubyContext context, RubyLanguage language, MaterializedFrame frame) {
        return BindingNodes.createBinding(context, language, frame, null);
    }

    public static RubyBinding createBinding(RubyContext context, RubyLanguage language, MaterializedFrame frame, SourceSection sourceSection) {
        return new RubyBinding(context.getCoreLibrary().bindingClass, language.bindingShape, frame, sourceSection);
    }

    @CompilerDirectives.TruffleBoundary
    public static FrameDescriptor newFrameDescriptor(RubyBinding binding) {
        FrameDescriptor parentDescriptor = binding.getFrame().getFrameDescriptor();
        BlockDescriptorInfo ref = new BlockDescriptorInfo(parentDescriptor);
        return TranslatorEnvironment.newFrameDescriptorBuilderForBlock(ref).build();
    }

    @CompilerDirectives.TruffleBoundary
    public static FrameDescriptor newFrameDescriptor(FrameDescriptor parentDescriptor, String name) {
        assert (name != null && !name.isEmpty());
        BlockDescriptorInfo ref = new BlockDescriptorInfo(parentDescriptor);
        FrameDescriptor.Builder builder = TranslatorEnvironment.newFrameDescriptorBuilderForBlock(ref);
        int index = builder.addSlot(FrameSlotKind.Illegal, (Object)name, null);
        if (index != 1) {
            throw CompilerDirectives.shouldNotReachHere((String)"new binding variable not at index 1");
        }
        return builder.build();
    }

    public static FrameDescriptor getFrameDescriptor(RubyBinding binding) {
        return binding.getFrame().getFrameDescriptor();
    }

    public static MaterializedFrame newFrame(RubyBinding binding, FrameDescriptor frameDescriptor) {
        MaterializedFrame parentFrame = binding.getFrame();
        MaterializedFrame newFrame = BindingNodes.newFrame(parentFrame, frameDescriptor);
        binding.setFrame(newFrame);
        return newFrame;
    }

    public static MaterializedFrame newFrame(MaterializedFrame parent, FrameDescriptor descriptor) {
        return Truffle.getRuntime().createVirtualFrame(RubyArguments.pack(parent, null, RubyArguments.getMethod((Frame)parent), RubyArguments.getDeclarationContext((Frame)parent), null, RubyArguments.getSelf((Frame)parent), RubyArguments.getBlock((Frame)parent), RubyArguments.getDescriptor((Frame)parent), RubyArguments.getRawArguments((Frame)parent)), descriptor).materialize();
    }

    public static void insertAncestorFrame(RubyBinding binding, MaterializedFrame ancestorFrame) {
        MaterializedFrame frame = FindDeclarationVariableNodes.getOuterDeclarationFrame(binding.getFrame());
        RubyArguments.setDeclarationFrame((Frame)frame, ancestorFrame);
        BindingNodes.newFrame(binding, BindingNodes.newFrameDescriptor(binding));
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean assignsNewUserVariables(FrameDescriptor descriptor) {
        for (Object identifier : FrameDescriptorNamesIterator.iterate(descriptor)) {
            if (BindingNodes.isHiddenVariable(identifier)) continue;
            return true;
        }
        return false;
    }

    public static boolean isHiddenVariable(Object name) {
        if (name instanceof String) {
            return BindingNodes.isHiddenVariable((String)name);
        }
        return true;
    }

    @Idempotent
    static boolean isHiddenVariable(String name) {
        assert (!name.isEmpty());
        char first = name.charAt(0);
        return first == '$' || first == Layouts.TEMP_PREFIX_CHAR;
    }

    @Primitive(name="create_empty_binding")
    public static abstract class CreateEmptyBindingNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyBinding binding(VirtualFrame frame) {
            RubyBinding binding = BindingNodes.createBinding(this.getContext(), this.getLanguage(), frame.materialize(), this.getEncapsulatingSourceSection());
            MaterializedFrame newFrame = BindingNodes.newFrame(binding, this.getLanguage().emptyDeclarationDescriptor);
            RubyArguments.setDeclarationFrame((Frame)newFrame, null);
            return binding;
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object allocate(RubyClass rubyClass) {
            throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorAllocatorUndefinedFor(rubyClass, this));
        }
    }

    @CoreMethod(names={"source_location"})
    public static abstract class SourceLocationNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object sourceLocation(RubyBinding binding, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            SourceSection sourceSection = binding.sourceSection;
            return this.getLanguage().rubySourceLocation(this.getContext(), sourceSection, fromJavaStringNode, this);
        }
    }

    @CoreMethod(names={"receiver"})
    public static abstract class ReceiverNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object receiver(RubyBinding binding) {
            return RubyArguments.getSelf((Frame)binding.getFrame());
        }
    }

    @Primitive(name="local_variable_names")
    @ImportStatic(value={BindingNodes.class})
    public static abstract class LocalVariablesNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"getFrameDescriptor(binding) == cachedFrameDescriptor"}, limit="getCacheLimit()")
        RubyArray localVariablesCached(RubyBinding binding, @Cached(value="getFrameDescriptor(binding)") FrameDescriptor cachedFrameDescriptor, @Cached(value="listLocalVariablesAsSymbols(getContext(), binding.getFrame())") RubyArray names) {
            return names;
        }

        @Specialization(replaces={"localVariablesCached"})
        RubyArray localVariables(RubyBinding binding) {
            return this.listLocalVariablesAsSymbols(this.getContext(), binding.getFrame());
        }

        @CompilerDirectives.TruffleBoundary
        public RubyArray listLocalVariablesAsSymbols(RubyContext context, MaterializedFrame frame) {
            LinkedHashSet<Object> names = new LinkedHashSet<Object>();
            while (frame != null) {
                this.addNamesFromFrame((Frame)frame, names);
                frame = RubyArguments.getDeclarationFrame((Frame)frame);
            }
            return ArrayHelpers.createArray(context, this.getLanguage(), names.toArray());
        }

        private void addNamesFromFrame(Frame frame, Set<Object> names) {
            for (Object identifier : FrameDescriptorNamesIterator.iterate(frame.getFrameDescriptor())) {
                if (BindingNodes.isHiddenVariable(identifier)) continue;
                names.add(this.getSymbol((String)identifier));
            }
        }

        @CompilerDirectives.TruffleBoundary
        public static List<String> listLocalVariablesWithDuplicates(MaterializedFrame frame, String receiverName) {
            ArrayList<String> members = new ArrayList<String>();
            MaterializedFrame currentFrame = frame;
            while (currentFrame != null) {
                FrameDescriptor frameDescriptor = currentFrame.getFrameDescriptor();
                for (Object identifier : FrameDescriptorNamesIterator.iterate(frameDescriptor)) {
                    if (BindingNodes.isHiddenVariable(identifier)) continue;
                    members.add((String)identifier);
                }
                if (receiverName != null) {
                    members.add(receiverName);
                }
                currentFrame = RubyArguments.getDeclarationFrame((Frame)currentFrame);
            }
            return members;
        }

        protected int getCacheLimit() {
            return this.getLanguage().options.BINDING_LOCAL_VARIABLE_CACHE;
        }
    }

    @GenerateUncached
    @ImportStatic(value={BindingNodes.class, FindDeclarationVariableNodes.class})
    @GenerateCached(value=false)
    @GenerateInline
    public static abstract class LocalVariableSetNode
    extends RubyBaseNode {
        public abstract Object execute(Node var1, RubyBinding var2, String var3, Object var4);

        @Specialization(guards={"name == cachedName", "!isHiddenVariable(cachedName)", "getFrameDescriptor(binding) == cachedFrameDescriptor", "cachedFrameSlot != null"}, limit="getCacheLimit()")
        static Object localVariableSetCached(RubyBinding binding, String name, Object value, @Cached(value="name") String cachedName, @Cached(value="getFrameDescriptor(binding)") FrameDescriptor cachedFrameDescriptor, @Cached(value="findFrameSlotOrNull(name, binding.getFrame())") FindDeclarationVariableNodes.FrameSlotAndDepth cachedFrameSlot, @Cached(value="createWriteNode(cachedFrameSlot.slot)") WriteFrameSlotNode writeLocalVariableNode) {
            MaterializedFrame frame = RubyArguments.getDeclarationFrame(binding.getFrame(), cachedFrameSlot.depth);
            writeLocalVariableNode.executeWrite((Frame)frame, value);
            return value;
        }

        @Specialization(guards={"name == cachedName", "!isHiddenVariable(cachedName)", "getFrameDescriptor(binding) == cachedFrameDescriptor", "cachedFrameSlot == null"}, limit="getCacheLimit()")
        static Object localVariableSetNewCached(RubyBinding binding, String name, Object value, @Cached(value="name") String cachedName, @Cached(value="getFrameDescriptor(binding)") FrameDescriptor cachedFrameDescriptor, @Cached(value="findFrameSlotOrNull(name, binding.getFrame())") FindDeclarationVariableNodes.FrameSlotAndDepth cachedFrameSlot, @Cached(value="newFrameDescriptor(cachedFrameDescriptor, name)") FrameDescriptor newDescriptor, @Cached(value="createWriteNode(NEW_VAR_INDEX)") WriteFrameSlotNode writeLocalVariableNode) {
            MaterializedFrame frame = BindingNodes.newFrame(binding, newDescriptor);
            writeLocalVariableNode.executeWrite((Frame)frame, value);
            return value;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isHiddenVariable(name)"}, replaces={"localVariableSetCached", "localVariableSetNewCached"})
        static Object localVariableSetUncached(RubyBinding binding, String name, Object value) {
            int slot;
            MaterializedFrame frame = binding.getFrame();
            FindDeclarationVariableNodes.FrameSlotAndDepth frameSlot = FindDeclarationVariableNodes.findFrameSlotOrNull(name, (Frame)frame);
            if (frameSlot != null) {
                frame = RubyArguments.getDeclarationFrame(frame, frameSlot.depth);
                slot = frameSlot.slot;
            } else {
                FrameDescriptor newDescriptor = BindingNodes.newFrameDescriptor(BindingNodes.getFrameDescriptor(binding), name);
                frame = BindingNodes.newFrame(binding, newDescriptor);
                assert (newDescriptor.getSlotName(1) == name);
                slot = 1;
            }
            frame.setObject(slot, value);
            return value;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isHiddenVariable(name)"})
        static Object localVariableSetLastLine(Node node, RubyBinding binding, String name, Object value) {
            throw new RaiseException(LocalVariableSetNode.getContext(node), (RubyException)LocalVariableSetNode.coreExceptions(node).nameError("Bad local variable name", binding, name, node));
        }

        protected static WriteFrameSlotNode createWriteNode(int frameSlot) {
            return WriteFrameSlotNodeGen.create(frameSlot);
        }

        protected int getCacheLimit() {
            return this.getLanguage().options.BINDING_LOCAL_VARIABLE_CACHE;
        }
    }

    @CoreMethod(names={"local_variable_set"}, required=2)
    @ReportPolymorphism
    public static abstract class BindingLocalVariableSetNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object localVariableSet(RubyBinding binding, Object nameObject, Object value, @Cached NameToJavaStringNode nameToJavaStringNode, @Cached LocalVariableSetNode localVariableSetNode) {
            String name = nameToJavaStringNode.execute(this, nameObject);
            return localVariableSetNode.execute(this, binding, name, value);
        }
    }

    @GenerateUncached
    @ImportStatic(value={BindingNodes.class})
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class LocalVariableGetNode
    extends RubyBaseNode {
        public abstract Object execute(Node var1, RubyBinding var2, String var3);

        @Specialization(guards={"!isHiddenVariable(name)"})
        static Object localVariableGet(Node node, RubyBinding binding, String name, @Cached FindDeclarationVariableNodes.FindAndReadDeclarationVariableNode readNode) {
            MaterializedFrame frame = binding.getFrame();
            Object result = readNode.execute((Frame)frame, node, name, null);
            if (result == null) {
                throw new RaiseException(LocalVariableGetNode.getContext(node), (RubyException)LocalVariableGetNode.coreExceptions(node).nameErrorLocalVariableNotDefined(name, binding, node));
            }
            return result;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isHiddenVariable(name)"})
        static Object localVariableGetLastLine(Node node, RubyBinding binding, String name) {
            throw new RaiseException(LocalVariableGetNode.getContext(node), (RubyException)LocalVariableGetNode.coreExceptions(node).nameError("Bad local variable name", binding, name, node));
        }
    }

    @CoreMethod(names={"local_variable_get"}, required=1)
    @ImportStatic(value={BindingNodes.class})
    public static abstract class BindingLocalVariableGetNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object localVariableGet(RubyBinding binding, Object nameObject, @Cached NameToJavaStringNode nameToJavaStringNode, @Cached LocalVariableGetNode localVariableGetNode) {
            String name = nameToJavaStringNode.execute(this, nameObject);
            return localVariableGetNode.execute(this, binding, name);
        }
    }

    @ImportStatic(value={BindingNodes.class, FindDeclarationVariableNodes.class})
    @GenerateCached(value=false)
    @GenerateInline
    public static abstract class LocalVariableDefinedNode
    extends RubyBaseNode {
        public abstract boolean execute(Node var1, RubyBinding var2, String var3);

        @Specialization(guards={"name == cachedName", "!isHiddenVariable(cachedName)", "getFrameDescriptor(binding) == descriptor"}, limit="getCacheLimit()")
        static boolean localVariableDefinedCached(RubyBinding binding, String name, @Cached(value="name") String cachedName, @Cached(value="getFrameDescriptor(binding)") FrameDescriptor descriptor, @Cached(value="findFrameSlotOrNull(name, binding.getFrame())") FindDeclarationVariableNodes.FrameSlotAndDepth cachedFrameSlot) {
            return cachedFrameSlot != null;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isHiddenVariable(name)"}, replaces={"localVariableDefinedCached"})
        static boolean localVariableDefinedUncached(RubyBinding binding, String name) {
            return FindDeclarationVariableNodes.findFrameSlotOrNull(name, (Frame)binding.getFrame()) != null;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isHiddenVariable(name)"})
        static boolean localVariableDefinedLastLine(Node node, RubyBinding binding, String name) {
            throw new RaiseException(LocalVariableDefinedNode.getContext(node), (RubyException)LocalVariableDefinedNode.coreExceptions(node).nameError("Bad local variable name", binding, name, node));
        }

        protected int getCacheLimit() {
            return this.getLanguage().options.BINDING_LOCAL_VARIABLE_CACHE;
        }
    }

    @CoreMethod(names={"local_variable_defined?"}, required=1)
    @ImportStatic(value={BindingNodes.class, FindDeclarationVariableNodes.class})
    public static abstract class BindingLocalVariableDefinedNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean localVariableDefined(RubyBinding binding, Object nameObject, @Cached NameToJavaStringNode nameToJavaStringNode, @Cached LocalVariableDefinedNode localVariableDefinedNode) {
            String name = nameToJavaStringNode.execute(this, nameObject);
            return localVariableDefinedNode.execute(this, binding, name);
        }
    }

    @ImportStatic(value={BindingNodes.class, FindDeclarationVariableNodes.class})
    @GenerateUncached
    public static abstract class HasLocalVariableNode
    extends RubyBaseNode {
        @NeverDefault
        public static HasLocalVariableNode create() {
            return BindingNodesFactory.HasLocalVariableNodeGen.create();
        }

        public abstract boolean execute(RubyBinding var1, String var2);

        @Specialization(guards={"name == cachedName", "getFrameDescriptor(binding) == descriptor"}, limit="getCacheLimit()")
        boolean localVariableDefinedCached(RubyBinding binding, String name, @Cached(value="name") String cachedName, @Cached(value="getFrameDescriptor(binding)") FrameDescriptor descriptor, @Cached(value="findFrameSlotOrNull(name, binding.getFrame())") FindDeclarationVariableNodes.FrameSlotAndDepth cachedFrameSlot) {
            return cachedFrameSlot != null;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(replaces={"localVariableDefinedCached"})
        boolean localVariableDefinedUncached(RubyBinding binding, String name) {
            return FindDeclarationVariableNodes.findFrameSlotOrNull(name, (Frame)binding.getFrame()) != null;
        }

        protected int getCacheLimit() {
            return this.getLanguage().options.BINDING_LOCAL_VARIABLE_CACHE;
        }
    }

    @CoreMethod(names={"dup", "clone"})
    public static abstract class DupNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyBinding dup(RubyBinding binding) {
            return new RubyBinding(this.coreLibrary().bindingClass, this.getLanguage().bindingShape, binding.getFrame(), binding.sourceSection);
        }
    }
}

