/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array.library;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.utilities.FinalBitSet;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.concurrent.locks.Lock;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.core.array.library.DoubleArrayStore;
import org.truffleruby.core.array.library.IntegerArrayStore;
import org.truffleruby.core.array.library.LongArrayStore;
import org.truffleruby.core.array.library.ObjectArrayStore;

@GeneratedBy(value=ArrayStoreLibrary.class)
final class ArrayStoreLibraryGen
extends LibraryFactory<ArrayStoreLibrary> {
    private static final Class<ArrayStoreLibrary> LIBRARY_CLASS = ArrayStoreLibraryGen.lazyLibraryClass();
    private static final Message READ = new MessageImpl("read", 0, false, Object.class, Object.class, Integer.TYPE);
    private static final Message ACCEPTS_VALUE = new MessageImpl("acceptsValue", 1, false, Boolean.TYPE, Object.class, Object.class);
    private static final Message ACCEPTS_ALL_VALUES = new MessageImpl("acceptsAllValues", 2, false, Boolean.TYPE, Object.class, Object.class);
    private static final Message IS_MUTABLE = new MessageImpl("isMutable", 3, false, Boolean.TYPE, Object.class);
    private static final Message IS_NATIVE = new MessageImpl("isNative", 4, false, Boolean.TYPE, Object.class);
    private static final Message IS_PRIMITIVE = new MessageImpl("isPrimitive", 5, false, Boolean.TYPE, Object.class);
    private static final Message IS_SHARED = new MessageImpl("isShared", 6, false, Boolean.TYPE, Object.class);
    private static final Message INITIAL_STORE = new MessageImpl("initialStore", 7, false, Object.class, Object.class);
    private static final Message BACKING_STORE = new MessageImpl("backingStore", 8, false, Object.class, Object.class);
    private static final Message MAKE_SHARED = new MessageImpl("makeShared", 9, false, Object.class, Object.class, Integer.TYPE);
    private static final Message SHARE_ELEMENTS = new MessageImpl("shareElements", 10, false, Void.TYPE, Object.class, Integer.TYPE, Integer.TYPE);
    private static final Message TO_STRING = new MessageImpl("toString", 11, false, String.class, Object.class);
    private static final Message WRITE = new MessageImpl("write", 12, false, Void.TYPE, Object.class, Integer.TYPE, Object.class);
    private static final Message CAPACITY = new MessageImpl("capacity", 13, false, Integer.TYPE, Object.class);
    private static final Message EXPAND = new MessageImpl("expand", 14, false, Object.class, Object.class, Integer.TYPE);
    private static final Message EXTRACT_RANGE = new MessageImpl("extractRange", 15, false, Object.class, Object.class, Integer.TYPE, Integer.TYPE);
    private static final Message EXTRACT_RANGE_AND_UNSHARE = new MessageImpl("extractRangeAndUnshare", 16, false, Object.class, Object.class, Integer.TYPE, Integer.TYPE);
    private static final Message BOXED_COPY_OF_RANGE = new MessageImpl("boxedCopyOfRange", 17, false, Object[].class, Object.class, Integer.TYPE, Integer.TYPE);
    private static final Message COPY_CONTENTS = new MessageImpl("copyContents", 18, false, Void.TYPE, Object.class, Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE);
    private static final Message CLEAR = new MessageImpl("clear", 19, false, Void.TYPE, Object.class, Integer.TYPE, Integer.TYPE);
    private static final Message FILL = new MessageImpl("fill", 20, false, Void.TYPE, Object.class, Integer.TYPE, Integer.TYPE, Object.class);
    private static final Message TO_JAVA_ARRAY_COPY = new MessageImpl("toJavaArrayCopy", 21, false, Object.class, Object.class, Integer.TYPE);
    private static final Message SORT = new MessageImpl("sort", 22, false, Void.TYPE, Object.class, Integer.TYPE);
    private static final Message GET_ITERABLE = new MessageImpl("getIterable", 23, false, Iterable.class, Object.class, Integer.TYPE, Integer.TYPE);
    private static final Message GENERALIZE_FOR_VALUE = new MessageImpl("generalizeForValue", 24, false, ArrayStoreLibrary.ArrayAllocator.class, Object.class, Object.class);
    private static final Message GENERALIZE_FOR_STORE = new MessageImpl("generalizeForStore", 25, false, ArrayStoreLibrary.ArrayAllocator.class, Object.class, Object.class);
    private static final Message GENERALIZE_FOR_SHARING = new MessageImpl("generalizeForSharing", 26, false, ArrayStoreLibrary.ArrayAllocator.class, Object.class);
    private static final Message ALLOCATE_FOR_NEW_VALUE = new MessageImpl("allocateForNewValue", 27, false, Object.class, Object.class, Object.class, Integer.TYPE);
    private static final Message ALLOCATE_FOR_NEW_STORE = new MessageImpl("allocateForNewStore", 28, false, Object.class, Object.class, Object.class, Integer.TYPE);
    private static final Message UNSHARED_ALLOCATE_FOR_NEW_STORE = new MessageImpl("unsharedAllocateForNewStore", 29, false, Object.class, Object.class, Object.class, Integer.TYPE);
    private static final Message ALLOCATOR = new MessageImpl("allocator", 30, false, ArrayStoreLibrary.ArrayAllocator.class, Object.class);
    private static final Message UNSHARED_ALLOCATOR = new MessageImpl("unsharedAllocator", 31, false, ArrayStoreLibrary.ArrayAllocator.class, Object.class);
    private static final Message IS_DEFAULT_VALUE = new MessageImpl("isDefaultValue", 32, false, Boolean.TYPE, Object.class, Object.class);
    private static final ArrayStoreLibraryGen INSTANCE = new ArrayStoreLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private ArrayStoreLibraryGen() {
        super(LIBRARY_CLASS, Collections.unmodifiableList(Arrays.asList(READ, ACCEPTS_VALUE, ACCEPTS_ALL_VALUES, IS_MUTABLE, IS_NATIVE, IS_PRIMITIVE, IS_SHARED, INITIAL_STORE, BACKING_STORE, MAKE_SHARED, SHARE_ELEMENTS, TO_STRING, WRITE, CAPACITY, EXPAND, EXTRACT_RANGE, EXTRACT_RANGE_AND_UNSHARE, BOXED_COPY_OF_RANGE, COPY_CONTENTS, CLEAR, FILL, TO_JAVA_ARRAY_COPY, SORT, GET_ITERABLE, GENERALIZE_FOR_VALUE, GENERALIZE_FOR_STORE, GENERALIZE_FOR_SHARING, ALLOCATE_FOR_NEW_VALUE, ALLOCATE_FOR_NEW_STORE, UNSHARED_ALLOCATE_FOR_NEW_STORE, ALLOCATOR, UNSHARED_ALLOCATOR, IS_DEFAULT_VALUE)));
    }

    protected Class<?> getDefaultClass(Object receiver) {
        if (receiver instanceof int[]) {
            return IntegerArrayStore.class;
        }
        if (receiver instanceof long[]) {
            return LongArrayStore.class;
        }
        if (receiver instanceof double[]) {
            return DoubleArrayStore.class;
        }
        if (receiver instanceof Object[]) {
            return ObjectArrayStore.class;
        }
        return ArrayStoreLibrary.class;
    }

    protected ArrayStoreLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    protected FinalBitSet createMessageBitSet(Message ... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf((BitSet)bitSet);
    }

    protected ArrayStoreLibrary createDelegate(ArrayStoreLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        ArrayStoreLibrary lib = (ArrayStoreLibrary)originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0: {
                return lib.read(receiver, (Integer)args[offset]);
            }
            case 1: {
                return lib.acceptsValue(receiver, args[offset]);
            }
            case 2: {
                return lib.acceptsAllValues(receiver, args[offset]);
            }
            case 3: {
                return lib.isMutable(receiver);
            }
            case 4: {
                return lib.isNative(receiver);
            }
            case 5: {
                return lib.isPrimitive(receiver);
            }
            case 6: {
                return lib.isShared(receiver);
            }
            case 7: {
                return lib.initialStore(receiver);
            }
            case 8: {
                return lib.backingStore(receiver);
            }
            case 9: {
                return lib.makeShared(receiver, (Integer)args[offset]);
            }
            case 10: {
                lib.shareElements(receiver, (Integer)args[offset], (Integer)args[offset + 1]);
                return null;
            }
            case 11: {
                return lib.toString(receiver);
            }
            case 12: {
                lib.write(receiver, (Integer)args[offset], args[offset + 1]);
                return null;
            }
            case 13: {
                return lib.capacity(receiver);
            }
            case 14: {
                return lib.expand(receiver, (Integer)args[offset]);
            }
            case 15: {
                return lib.extractRange(receiver, (Integer)args[offset], (Integer)args[offset + 1]);
            }
            case 16: {
                return lib.extractRangeAndUnshare(receiver, (Integer)args[offset], (Integer)args[offset + 1]);
            }
            case 17: {
                return lib.boxedCopyOfRange(receiver, (Integer)args[offset], (Integer)args[offset + 1]);
            }
            case 18: {
                lib.copyContents(receiver, (Integer)args[offset], args[offset + 1], (Integer)args[offset + 2], (Integer)args[offset + 3]);
                return null;
            }
            case 19: {
                lib.clear(receiver, (Integer)args[offset], (Integer)args[offset + 1]);
                return null;
            }
            case 20: {
                lib.fill(receiver, (Integer)args[offset], (Integer)args[offset + 1], args[offset + 2]);
                return null;
            }
            case 21: {
                return lib.toJavaArrayCopy(receiver, (Integer)args[offset]);
            }
            case 22: {
                lib.sort(receiver, (Integer)args[offset]);
                return null;
            }
            case 23: {
                return lib.getIterable(receiver, (Integer)args[offset], (Integer)args[offset + 1]);
            }
            case 24: {
                return lib.generalizeForValue(receiver, args[offset]);
            }
            case 25: {
                return lib.generalizeForStore(receiver, args[offset]);
            }
            case 26: {
                return lib.generalizeForSharing(receiver);
            }
            case 27: {
                return lib.allocateForNewValue(receiver, args[offset], (Integer)args[offset + 1]);
            }
            case 28: {
                return lib.allocateForNewStore(receiver, args[offset], (Integer)args[offset + 1]);
            }
            case 29: {
                return lib.unsharedAllocateForNewStore(receiver, args[offset], (Integer)args[offset + 1]);
            }
            case 30: {
                return lib.allocator(receiver);
            }
            case 31: {
                return lib.unsharedAllocator(receiver);
            }
            case 32: {
                return lib.isDefaultValue(receiver, args[offset]);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    protected ArrayStoreLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    protected ArrayStoreLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    private static Class<ArrayStoreLibrary> lazyLibraryClass() {
        try {
            return Class.forName("org.truffleruby.core.array.library.ArrayStoreLibrary", false, ArrayStoreLibraryGen.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    static {
        LibraryExport.register(LIBRARY_CLASS, (LibraryExport[])new LibraryExport[]{new Default()});
        LibraryFactory.register(LIBRARY_CLASS, (LibraryFactory)INSTANCE);
    }

    @GeneratedBy(value=ArrayStoreLibrary.class)
    private static final class Proxy
    extends ArrayStoreLibrary {
        @Node.Child
        private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public Object read(Object receiver_, int index) {
            try {
                return this.lib.send(receiver_, READ, new Object[]{index});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public boolean acceptsValue(Object receiver_, Object value) {
            try {
                return (Boolean)this.lib.send(receiver_, ACCEPTS_VALUE, new Object[]{value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public boolean acceptsAllValues(Object receiver_, Object otherStore) {
            try {
                return (Boolean)this.lib.send(receiver_, ACCEPTS_ALL_VALUES, new Object[]{otherStore});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public boolean isMutable(Object receiver_) {
            try {
                return (Boolean)this.lib.send(receiver_, IS_MUTABLE, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public boolean isNative(Object receiver_) {
            try {
                return (Boolean)this.lib.send(receiver_, IS_NATIVE, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public boolean isPrimitive(Object receiver_) {
            try {
                return (Boolean)this.lib.send(receiver_, IS_PRIMITIVE, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public boolean isShared(Object receiver_) {
            try {
                return (Boolean)this.lib.send(receiver_, IS_SHARED, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object initialStore(Object receiver_) {
            try {
                return this.lib.send(receiver_, INITIAL_STORE, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object backingStore(Object receiver_) {
            try {
                return this.lib.send(receiver_, BACKING_STORE, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object makeShared(Object receiver_, int size) {
            try {
                return this.lib.send(receiver_, MAKE_SHARED, new Object[]{size});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void shareElements(Object receiver_, int start, int end) {
            try {
                this.lib.send(receiver_, SHARE_ELEMENTS, new Object[]{start, end});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public String toString(Object receiver_) {
            try {
                return (String)this.lib.send(receiver_, TO_STRING, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void write(Object receiver_, int index, Object value) {
            try {
                this.lib.send(receiver_, WRITE, new Object[]{index, value});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int capacity(Object receiver_) {
            try {
                return (Integer)this.lib.send(receiver_, CAPACITY, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object expand(Object receiver_, int capacity) {
            try {
                return this.lib.send(receiver_, EXPAND, new Object[]{capacity});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object extractRange(Object receiver_, int start, int end) {
            try {
                return this.lib.send(receiver_, EXTRACT_RANGE, new Object[]{start, end});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object extractRangeAndUnshare(Object receiver_, int start, int end) {
            try {
                return this.lib.send(receiver_, EXTRACT_RANGE_AND_UNSHARE, new Object[]{start, end});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object[] boxedCopyOfRange(Object receiver_, int start, int length) {
            try {
                return (Object[])this.lib.send(receiver_, BOXED_COPY_OF_RANGE, new Object[]{start, length});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void copyContents(Object receiver_, int srcStart, Object dest, int destStart, int length) {
            try {
                this.lib.send(receiver_, COPY_CONTENTS, new Object[]{srcStart, dest, destStart, length});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void clear(Object receiver_, int start, int length) {
            try {
                this.lib.send(receiver_, CLEAR, new Object[]{start, length});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void fill(Object receiver_, int start, int length, Object value) {
            try {
                this.lib.send(receiver_, FILL, new Object[]{start, length, value});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object toJavaArrayCopy(Object receiver_, int length) {
            try {
                return this.lib.send(receiver_, TO_JAVA_ARRAY_COPY, new Object[]{length});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void sort(Object receiver_, int size) {
            try {
                this.lib.send(receiver_, SORT, new Object[]{size});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Iterable<Object> getIterable(Object receiver_, int start, int length) {
            try {
                return (Iterable)this.lib.send(receiver_, GET_ITERABLE, new Object[]{start, length});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public ArrayStoreLibrary.ArrayAllocator generalizeForValue(Object receiver_, Object newValue) {
            try {
                return (ArrayStoreLibrary.ArrayAllocator)this.lib.send(receiver_, GENERALIZE_FOR_VALUE, new Object[]{newValue});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public ArrayStoreLibrary.ArrayAllocator generalizeForStore(Object receiver_, Object newStore) {
            try {
                return (ArrayStoreLibrary.ArrayAllocator)this.lib.send(receiver_, GENERALIZE_FOR_STORE, new Object[]{newStore});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public ArrayStoreLibrary.ArrayAllocator generalizeForSharing(Object receiver_) {
            try {
                return (ArrayStoreLibrary.ArrayAllocator)this.lib.send(receiver_, GENERALIZE_FOR_SHARING, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object allocateForNewValue(Object receiver_, Object newValue, int length) {
            try {
                return this.lib.send(receiver_, ALLOCATE_FOR_NEW_VALUE, new Object[]{newValue, length});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object allocateForNewStore(Object receiver_, Object newStore, int length) {
            try {
                return this.lib.send(receiver_, ALLOCATE_FOR_NEW_STORE, new Object[]{newStore, length});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object unsharedAllocateForNewStore(Object receiver_, Object newStore, int length) {
            try {
                return this.lib.send(receiver_, UNSHARED_ALLOCATE_FOR_NEW_STORE, new Object[]{newStore, length});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public ArrayStoreLibrary.ArrayAllocator allocator(Object receiver_) {
            try {
                return (ArrayStoreLibrary.ArrayAllocator)this.lib.send(receiver_, ALLOCATOR, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public ArrayStoreLibrary.ArrayAllocator unsharedAllocator(Object receiver_) {
            try {
                return (ArrayStoreLibrary.ArrayAllocator)this.lib.send(receiver_, UNSHARED_ALLOCATOR, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public boolean isDefaultValue(Object receiver_, Object value) {
            try {
                return (Boolean)this.lib.send(receiver_, IS_DEFAULT_VALUE, new Object[]{value});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        public boolean accepts(Object receiver_) {
            return this.lib.accepts(receiver_);
        }
    }

    @GeneratedBy(value=ArrayStoreLibrary.class)
    private static final class Delegate
    extends ArrayStoreLibrary {
        @Node.Child
        private ArrayStoreLibrary delegateLibrary;

        Delegate(ArrayStoreLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public Object read(Object receiver_, int index) {
            if (ArrayStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)0)) {
                Object delegate = ArrayStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ArrayStoreLibrary)ArrayStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).read(delegate, index);
            }
            return this.delegateLibrary.read(receiver_, index);
        }

        @Override
        public boolean acceptsValue(Object receiver_, Object value) {
            if (ArrayStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)1)) {
                Object delegate = ArrayStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ArrayStoreLibrary)ArrayStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).acceptsValue(delegate, value);
            }
            return this.delegateLibrary.acceptsValue(receiver_, value);
        }

        @Override
        public boolean acceptsAllValues(Object receiver_, Object otherStore) {
            if (ArrayStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)2)) {
                Object delegate = ArrayStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ArrayStoreLibrary)ArrayStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).acceptsAllValues(delegate, otherStore);
            }
            return this.delegateLibrary.acceptsAllValues(receiver_, otherStore);
        }

        @Override
        public boolean isMutable(Object receiver_) {
            if (ArrayStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)3)) {
                Object delegate = ArrayStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ArrayStoreLibrary)ArrayStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).isMutable(delegate);
            }
            return this.delegateLibrary.isMutable(receiver_);
        }

        @Override
        public boolean isNative(Object receiver_) {
            if (ArrayStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)4)) {
                Object delegate = ArrayStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ArrayStoreLibrary)ArrayStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).isNative(delegate);
            }
            return this.delegateLibrary.isNative(receiver_);
        }

        @Override
        public boolean isPrimitive(Object receiver_) {
            if (ArrayStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)5)) {
                Object delegate = ArrayStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ArrayStoreLibrary)ArrayStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).isPrimitive(delegate);
            }
            return this.delegateLibrary.isPrimitive(receiver_);
        }

        @Override
        public boolean isShared(Object receiver_) {
            if (ArrayStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)6)) {
                Object delegate = ArrayStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ArrayStoreLibrary)ArrayStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).isShared(delegate);
            }
            return this.delegateLibrary.isShared(receiver_);
        }

        @Override
        public Object initialStore(Object receiver_) {
            if (ArrayStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)7)) {
                Object delegate = ArrayStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ArrayStoreLibrary)ArrayStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).initialStore(delegate);
            }
            return this.delegateLibrary.initialStore(receiver_);
        }

        @Override
        public Object backingStore(Object receiver_) {
            if (ArrayStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)8)) {
                Object delegate = ArrayStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ArrayStoreLibrary)ArrayStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).backingStore(delegate);
            }
            return this.delegateLibrary.backingStore(receiver_);
        }

        @Override
        public Object makeShared(Object receiver_, int size) {
            if (ArrayStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)9)) {
                Object delegate = ArrayStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ArrayStoreLibrary)ArrayStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).makeShared(delegate, size);
            }
            return this.delegateLibrary.makeShared(receiver_, size);
        }

        @Override
        public void shareElements(Object receiver_, int start, int end) {
            if (ArrayStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)10)) {
                Object delegate = ArrayStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((ArrayStoreLibrary)ArrayStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).shareElements(delegate, start, end);
                return;
            }
            this.delegateLibrary.shareElements(receiver_, start, end);
        }

        @Override
        public String toString(Object receiver_) {
            if (ArrayStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)11)) {
                Object delegate = ArrayStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ArrayStoreLibrary)ArrayStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).toString(delegate);
            }
            return this.delegateLibrary.toString(receiver_);
        }

        @Override
        public void write(Object receiver_, int index, Object value) {
            if (ArrayStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)12)) {
                Object delegate = ArrayStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((ArrayStoreLibrary)ArrayStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).write(delegate, index, value);
                return;
            }
            this.delegateLibrary.write(receiver_, index, value);
        }

        @Override
        public int capacity(Object receiver_) {
            if (ArrayStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)13)) {
                Object delegate = ArrayStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ArrayStoreLibrary)ArrayStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).capacity(delegate);
            }
            return this.delegateLibrary.capacity(receiver_);
        }

        @Override
        public Object expand(Object receiver_, int capacity) {
            if (ArrayStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)14)) {
                Object delegate = ArrayStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ArrayStoreLibrary)ArrayStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).expand(delegate, capacity);
            }
            return this.delegateLibrary.expand(receiver_, capacity);
        }

        @Override
        public Object extractRange(Object receiver_, int start, int end) {
            if (ArrayStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)15)) {
                Object delegate = ArrayStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ArrayStoreLibrary)ArrayStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).extractRange(delegate, start, end);
            }
            return this.delegateLibrary.extractRange(receiver_, start, end);
        }

        @Override
        public Object extractRangeAndUnshare(Object receiver_, int start, int end) {
            if (ArrayStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)16)) {
                Object delegate = ArrayStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ArrayStoreLibrary)ArrayStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).extractRangeAndUnshare(delegate, start, end);
            }
            return this.delegateLibrary.extractRangeAndUnshare(receiver_, start, end);
        }

        @Override
        public Object[] boxedCopyOfRange(Object receiver_, int start, int length) {
            if (ArrayStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)17)) {
                Object delegate = ArrayStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ArrayStoreLibrary)ArrayStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).boxedCopyOfRange(delegate, start, length);
            }
            return this.delegateLibrary.boxedCopyOfRange(receiver_, start, length);
        }

        @Override
        public void copyContents(Object receiver_, int srcStart, Object dest, int destStart, int length) {
            if (ArrayStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)18)) {
                Object delegate = ArrayStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((ArrayStoreLibrary)ArrayStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).copyContents(delegate, srcStart, dest, destStart, length);
                return;
            }
            this.delegateLibrary.copyContents(receiver_, srcStart, dest, destStart, length);
        }

        @Override
        public void clear(Object receiver_, int start, int length) {
            if (ArrayStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)19)) {
                Object delegate = ArrayStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((ArrayStoreLibrary)ArrayStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).clear(delegate, start, length);
                return;
            }
            this.delegateLibrary.clear(receiver_, start, length);
        }

        @Override
        public void fill(Object receiver_, int start, int length, Object value) {
            if (ArrayStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)20)) {
                Object delegate = ArrayStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((ArrayStoreLibrary)ArrayStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).fill(delegate, start, length, value);
                return;
            }
            this.delegateLibrary.fill(receiver_, start, length, value);
        }

        @Override
        public Object toJavaArrayCopy(Object receiver_, int length) {
            if (ArrayStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)21)) {
                Object delegate = ArrayStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ArrayStoreLibrary)ArrayStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).toJavaArrayCopy(delegate, length);
            }
            return this.delegateLibrary.toJavaArrayCopy(receiver_, length);
        }

        @Override
        public void sort(Object receiver_, int size) {
            if (ArrayStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)22)) {
                Object delegate = ArrayStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((ArrayStoreLibrary)ArrayStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).sort(delegate, size);
                return;
            }
            this.delegateLibrary.sort(receiver_, size);
        }

        @Override
        public Iterable<Object> getIterable(Object receiver_, int start, int length) {
            if (ArrayStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)23)) {
                Object delegate = ArrayStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ArrayStoreLibrary)ArrayStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getIterable(delegate, start, length);
            }
            return this.delegateLibrary.getIterable(receiver_, start, length);
        }

        @Override
        public ArrayStoreLibrary.ArrayAllocator generalizeForValue(Object receiver_, Object newValue) {
            if (ArrayStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)24)) {
                Object delegate = ArrayStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ArrayStoreLibrary)ArrayStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).generalizeForValue(delegate, newValue);
            }
            return this.delegateLibrary.generalizeForValue(receiver_, newValue);
        }

        @Override
        public ArrayStoreLibrary.ArrayAllocator generalizeForStore(Object receiver_, Object newStore) {
            if (ArrayStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)25)) {
                Object delegate = ArrayStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ArrayStoreLibrary)ArrayStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).generalizeForStore(delegate, newStore);
            }
            return this.delegateLibrary.generalizeForStore(receiver_, newStore);
        }

        @Override
        public ArrayStoreLibrary.ArrayAllocator generalizeForSharing(Object receiver_) {
            if (ArrayStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)26)) {
                Object delegate = ArrayStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ArrayStoreLibrary)ArrayStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).generalizeForSharing(delegate);
            }
            return this.delegateLibrary.generalizeForSharing(receiver_);
        }

        @Override
        public Object allocateForNewValue(Object receiver_, Object newValue, int length) {
            if (ArrayStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)27)) {
                Object delegate = ArrayStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ArrayStoreLibrary)ArrayStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).allocateForNewValue(delegate, newValue, length);
            }
            return this.delegateLibrary.allocateForNewValue(receiver_, newValue, length);
        }

        @Override
        public Object allocateForNewStore(Object receiver_, Object newStore, int length) {
            if (ArrayStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)28)) {
                Object delegate = ArrayStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ArrayStoreLibrary)ArrayStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).allocateForNewStore(delegate, newStore, length);
            }
            return this.delegateLibrary.allocateForNewStore(receiver_, newStore, length);
        }

        @Override
        public Object unsharedAllocateForNewStore(Object receiver_, Object newStore, int length) {
            if (ArrayStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)29)) {
                Object delegate = ArrayStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ArrayStoreLibrary)ArrayStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).unsharedAllocateForNewStore(delegate, newStore, length);
            }
            return this.delegateLibrary.unsharedAllocateForNewStore(receiver_, newStore, length);
        }

        @Override
        public ArrayStoreLibrary.ArrayAllocator allocator(Object receiver_) {
            if (ArrayStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)30)) {
                Object delegate = ArrayStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ArrayStoreLibrary)ArrayStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).allocator(delegate);
            }
            return this.delegateLibrary.allocator(receiver_);
        }

        @Override
        public ArrayStoreLibrary.ArrayAllocator unsharedAllocator(Object receiver_) {
            if (ArrayStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)31)) {
                Object delegate = ArrayStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ArrayStoreLibrary)ArrayStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).unsharedAllocator(delegate);
            }
            return this.delegateLibrary.unsharedAllocator(receiver_);
        }

        @Override
        public boolean isDefaultValue(Object receiver_, Object value) {
            if (ArrayStoreLibraryGen.isDelegated((Library)this.delegateLibrary, (int)32)) {
                Object delegate = ArrayStoreLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((ArrayStoreLibrary)ArrayStoreLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).isDefaultValue(delegate, value);
            }
            return this.delegateLibrary.isDefaultValue(receiver_, value);
        }

        public boolean accepts(Object receiver_) {
            return this.delegateLibrary.accepts(receiver_);
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }
    }

    @GeneratedBy(value=ArrayStoreLibrary.class)
    private static final class CachedDispatchFirst
    extends CachedDispatch {
        private final int limit_;

        CachedDispatchFirst(ArrayStoreLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        public NodeCost getCost() {
            if (this.library instanceof CachedToUncachedDispatch) {
                return NodeCost.MEGAMORPHIC;
            }
            CachedDispatch current = this;
            int count = 0;
            do {
                if (current.library == null) continue;
                ++count;
            } while ((current = current.next) != null);
            return NodeCost.fromCount((int)count);
        }
    }

    @GeneratedBy(value=ArrayStoreLibrary.class)
    private static abstract class CachedDispatch
    extends ArrayStoreLibrary {
        @Node.Child
        ArrayStoreLibrary library;
        @Node.Child
        CachedDispatch next;

        CachedDispatch(ArrayStoreLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @Override
        @ExplodeLoop
        public Object read(Object receiver_, int index) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.read(receiver_, index);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public boolean acceptsValue(Object receiver_, Object value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.acceptsValue(receiver_, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public boolean acceptsAllValues(Object receiver_, Object otherStore) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.acceptsAllValues(receiver_, otherStore);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public boolean isMutable(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.isMutable(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public boolean isNative(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.isNative(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public boolean isPrimitive(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.isPrimitive(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public boolean isShared(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.isShared(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object initialStore(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.initialStore(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object backingStore(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.backingStore(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object makeShared(Object receiver_, int size) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.makeShared(receiver_, size);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void shareElements(Object receiver_, int start, int end) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.shareElements(receiver_, start, end);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public String toString(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.toString(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void write(Object receiver_, int index, Object value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.write(receiver_, index, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int capacity(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.capacity(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object expand(Object receiver_, int capacity) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.expand(receiver_, capacity);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object extractRange(Object receiver_, int start, int end) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.extractRange(receiver_, start, end);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object extractRangeAndUnshare(Object receiver_, int start, int end) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.extractRangeAndUnshare(receiver_, start, end);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object[] boxedCopyOfRange(Object receiver_, int start, int length) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.boxedCopyOfRange(receiver_, start, length);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void copyContents(Object receiver_, int srcStart, Object dest, int destStart, int length) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.copyContents(receiver_, srcStart, dest, destStart, length);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void clear(Object receiver_, int start, int length) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.clear(receiver_, start, length);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void fill(Object receiver_, int start, int length, Object value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.fill(receiver_, start, length, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object toJavaArrayCopy(Object receiver_, int length) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.toJavaArrayCopy(receiver_, length);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void sort(Object receiver_, int size) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.sort(receiver_, size);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Iterable<Object> getIterable(Object receiver_, int start, int length) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getIterable(receiver_, start, length);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public ArrayStoreLibrary.ArrayAllocator generalizeForValue(Object receiver_, Object newValue) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.generalizeForValue(receiver_, newValue);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public ArrayStoreLibrary.ArrayAllocator generalizeForStore(Object receiver_, Object newStore) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.generalizeForStore(receiver_, newStore);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public ArrayStoreLibrary.ArrayAllocator generalizeForSharing(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.generalizeForSharing(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object allocateForNewValue(Object receiver_, Object newValue, int length) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.allocateForNewValue(receiver_, newValue, length);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object allocateForNewStore(Object receiver_, Object newStore, int length) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.allocateForNewStore(receiver_, newStore, length);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object unsharedAllocateForNewStore(Object receiver_, Object newStore, int length) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.unsharedAllocateForNewStore(receiver_, newStore, length);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public ArrayStoreLibrary.ArrayAllocator allocator(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.allocator(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public ArrayStoreLibrary.ArrayAllocator unsharedAllocator(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.unsharedAllocator(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public boolean isDefaultValue(Object receiver_, Object value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    ArrayStoreLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.isDefaultValue(receiver_, value);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void specialize(Object receiver_) {
            Lock lock = this.getLock();
            lock.lock();
            try {
                CachedDispatch current = this;
                ArrayStoreLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = (ArrayStoreLibrary)this.insert((Node)((ArrayStoreLibrary)INSTANCE.create(receiver_)));
                } else {
                    int count = 0;
                    do {
                        ArrayStoreLibrary currentLibrary;
                        if ((currentLibrary = current.library) != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        ++count;
                    } while ((current = current.next) != null);
                    if (count >= this.getLimit()) {
                        this.library = (ArrayStoreLibrary)this.insert((Node)new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext((ArrayStoreLibrary)INSTANCE.create(receiver_), this.next));
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    @GeneratedBy(value=ArrayStoreLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch
    extends ArrayStoreLibrary {
        private UncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object read(Object receiver_, int index) {
            return ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).read(receiver_, index);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean acceptsValue(Object receiver_, Object value) {
            return ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).acceptsValue(receiver_, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean acceptsAllValues(Object receiver_, Object otherStore) {
            return ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).acceptsAllValues(receiver_, otherStore);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isMutable(Object receiver_) {
            return ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).isMutable(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isNative(Object receiver_) {
            return ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).isNative(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isPrimitive(Object receiver_) {
            return ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).isPrimitive(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isShared(Object receiver_) {
            return ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).isShared(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object initialStore(Object receiver_) {
            return ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).initialStore(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object backingStore(Object receiver_) {
            return ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).backingStore(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object makeShared(Object receiver_, int size) {
            return ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).makeShared(receiver_, size);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void shareElements(Object receiver_, int start, int end) {
            ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).shareElements(receiver_, start, end);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public String toString(Object receiver_) {
            return ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).toString(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void write(Object receiver_, int index, Object value) {
            ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).write(receiver_, index, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int capacity(Object receiver_) {
            return ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).capacity(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object expand(Object receiver_, int capacity) {
            return ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).expand(receiver_, capacity);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object extractRange(Object receiver_, int start, int end) {
            return ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).extractRange(receiver_, start, end);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object extractRangeAndUnshare(Object receiver_, int start, int end) {
            return ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).extractRangeAndUnshare(receiver_, start, end);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object[] boxedCopyOfRange(Object receiver_, int start, int length) {
            return ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).boxedCopyOfRange(receiver_, start, length);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void copyContents(Object receiver_, int srcStart, Object dest, int destStart, int length) {
            ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).copyContents(receiver_, srcStart, dest, destStart, length);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void clear(Object receiver_, int start, int length) {
            ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).clear(receiver_, start, length);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void fill(Object receiver_, int start, int length, Object value) {
            ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).fill(receiver_, start, length, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object toJavaArrayCopy(Object receiver_, int length) {
            return ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).toJavaArrayCopy(receiver_, length);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void sort(Object receiver_, int size) {
            ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).sort(receiver_, size);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Iterable<Object> getIterable(Object receiver_, int start, int length) {
            return ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).getIterable(receiver_, start, length);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public ArrayStoreLibrary.ArrayAllocator generalizeForValue(Object receiver_, Object newValue) {
            return ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).generalizeForValue(receiver_, newValue);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public ArrayStoreLibrary.ArrayAllocator generalizeForStore(Object receiver_, Object newStore) {
            return ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).generalizeForStore(receiver_, newStore);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public ArrayStoreLibrary.ArrayAllocator generalizeForSharing(Object receiver_) {
            return ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).generalizeForSharing(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object allocateForNewValue(Object receiver_, Object newValue, int length) {
            return ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).allocateForNewValue(receiver_, newValue, length);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object allocateForNewStore(Object receiver_, Object newStore, int length) {
            return ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).allocateForNewStore(receiver_, newStore, length);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object unsharedAllocateForNewStore(Object receiver_, Object newStore, int length) {
            return ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).unsharedAllocateForNewStore(receiver_, newStore, length);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public ArrayStoreLibrary.ArrayAllocator allocator(Object receiver_) {
            return ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).allocator(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public ArrayStoreLibrary.ArrayAllocator unsharedAllocator(Object receiver_) {
            return ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).unsharedAllocator(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isDefaultValue(Object receiver_, Object value) {
            return ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).isDefaultValue(receiver_, value);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean accepts(Object receiver_) {
            return true;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=ArrayStoreLibrary.class)
    private static class MessageImpl
    extends Message {
        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?> ... parameters) {
            super(LIBRARY_CLASS, name, index, deprecated, returnType, (Class[])parameters);
        }
    }

    @GeneratedBy(value=ArrayStoreLibrary.class)
    private static final class Default
    extends LibraryExport<ArrayStoreLibrary> {
        private Default() {
            super(ArrayStoreLibrary.class, Object.class, false, false, 0);
        }

        protected ArrayStoreLibrary createUncached(Object receiver) {
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected ArrayStoreLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(value=ArrayStoreLibrary.class)
        @DenyReplace
        private static final class Uncached
        extends ArrayStoreLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = this.dynamicDispatch_.dispatch(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object read(Object receiver, int index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean acceptsValue(Object receiver, Object value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.acceptsValue(receiver, value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean acceptsAllValues(Object receiver, Object otherStore) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.acceptsAllValues(receiver, otherStore);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isMutable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.isMutable(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isNative(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.isNative(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isPrimitive(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.isPrimitive(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isShared(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.isShared(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object initialStore(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.initialStore(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object backingStore(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.backingStore(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object makeShared(Object receiver, int size) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.makeShared(receiver, size);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void shareElements(Object receiver, int start, int end) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.shareElements(receiver, start, end);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public String toString(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void write(Object receiver, int index, Object value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.write(receiver, index, value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int capacity(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object expand(Object receiver, int capacity) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object extractRange(Object receiver, int start, int end) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.extractRange(receiver, start, end);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object extractRangeAndUnshare(Object receiver, int start, int end) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.extractRangeAndUnshare(receiver, start, end);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object[] boxedCopyOfRange(Object receiver, int start, int length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void copyContents(Object receiver, int srcStart, Object dest, int destStart, int length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void clear(Object receiver, int start, int length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void fill(Object receiver, int start, int length, Object value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.fill(receiver, start, length, value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object toJavaArrayCopy(Object receiver, int length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void sort(Object receiver, int size) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.sort(receiver, size);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Iterable<Object> getIterable(Object receiver, int start, int length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public ArrayStoreLibrary.ArrayAllocator generalizeForValue(Object receiver, Object newValue) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public ArrayStoreLibrary.ArrayAllocator generalizeForStore(Object receiver, Object newStore) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public ArrayStoreLibrary.ArrayAllocator generalizeForSharing(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object allocateForNewValue(Object receiver, Object newValue, int length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object allocateForNewStore(Object receiver, Object newStore, int length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object unsharedAllocateForNewStore(Object receiver, Object newStore, int length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.unsharedAllocateForNewStore(receiver, newStore, length);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public ArrayStoreLibrary.ArrayAllocator allocator(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public ArrayStoreLibrary.ArrayAllocator unsharedAllocator(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.unsharedAllocator(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isDefaultValue(Object receiver, Object value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }
        }

        @GeneratedBy(value=ArrayStoreLibrary.class)
        private static final class Cached
        extends ArrayStoreLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.create(receiver)));
                this.dynamicDispatchTarget_ = ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver)).dispatch(receiver);
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object read(Object receiver, int index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            public boolean acceptsValue(Object receiver, Object value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.acceptsValue(this.dynamicDispatch_.cast(receiver), value);
            }

            @Override
            public boolean acceptsAllValues(Object receiver, Object otherStore) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.acceptsAllValues(this.dynamicDispatch_.cast(receiver), otherStore);
            }

            @Override
            public boolean isMutable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.isMutable(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public boolean isNative(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.isNative(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public boolean isPrimitive(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.isPrimitive(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public boolean isShared(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.isShared(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public Object initialStore(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.initialStore(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public Object backingStore(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.backingStore(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public Object makeShared(Object receiver, int size) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.makeShared(this.dynamicDispatch_.cast(receiver), size);
            }

            @Override
            public void shareElements(Object receiver, int start, int end) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.shareElements(this.dynamicDispatch_.cast(receiver), start, end);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public String toString(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            public void write(Object receiver, int index, Object value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.write(this.dynamicDispatch_.cast(receiver), index, value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int capacity(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object expand(Object receiver, int capacity) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            public Object extractRange(Object receiver, int start, int end) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.extractRange(this.dynamicDispatch_.cast(receiver), start, end);
            }

            @Override
            public Object extractRangeAndUnshare(Object receiver, int start, int end) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.extractRangeAndUnshare(this.dynamicDispatch_.cast(receiver), start, end);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object[] boxedCopyOfRange(Object receiver, int start, int length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void copyContents(Object receiver, int srcStart, Object dest, int destStart, int length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void clear(Object receiver, int start, int length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            public void fill(Object receiver, int start, int length, Object value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.fill(this.dynamicDispatch_.cast(receiver), start, length, value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object toJavaArrayCopy(Object receiver, int length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            public void sort(Object receiver, int size) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.sort(this.dynamicDispatch_.cast(receiver), size);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Iterable<Object> getIterable(Object receiver, int start, int length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public ArrayStoreLibrary.ArrayAllocator generalizeForValue(Object receiver, Object newValue) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public ArrayStoreLibrary.ArrayAllocator generalizeForStore(Object receiver, Object newStore) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public ArrayStoreLibrary.ArrayAllocator generalizeForSharing(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object allocateForNewValue(Object receiver, Object newValue, int length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object allocateForNewStore(Object receiver, Object newStore, int length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            public Object unsharedAllocateForNewStore(Object receiver, Object newStore, int length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.unsharedAllocateForNewStore(this.dynamicDispatch_.cast(receiver), newStore, length);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public ArrayStoreLibrary.ArrayAllocator allocator(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            public ArrayStoreLibrary.ArrayAllocator unsharedAllocator(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.unsharedAllocator(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isDefaultValue(Object receiver, Object value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }
        }
    }

    @GeneratedBy(value=ArrayStoreLibrary.class)
    private static final class CachedDispatchNext
    extends CachedDispatch {
        CachedDispatchNext(ArrayStoreLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }

    @GeneratedBy(value=ArrayStoreLibrary.class)
    private static final class CachedToUncachedDispatch
    extends ArrayStoreLibrary {
        private CachedToUncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object read(Object receiver_, int index) {
            assert (ArrayStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).read(receiver_, index);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean acceptsValue(Object receiver_, Object value) {
            assert (ArrayStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).acceptsValue(receiver_, value);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean acceptsAllValues(Object receiver_, Object otherStore) {
            assert (ArrayStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).acceptsAllValues(receiver_, otherStore);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isMutable(Object receiver_) {
            assert (ArrayStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).isMutable(receiver_);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isNative(Object receiver_) {
            assert (ArrayStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).isNative(receiver_);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isPrimitive(Object receiver_) {
            assert (ArrayStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).isPrimitive(receiver_);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isShared(Object receiver_) {
            assert (ArrayStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).isShared(receiver_);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object initialStore(Object receiver_) {
            assert (ArrayStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).initialStore(receiver_);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object backingStore(Object receiver_) {
            assert (ArrayStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).backingStore(receiver_);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object makeShared(Object receiver_, int size) {
            assert (ArrayStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).makeShared(receiver_, size);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void shareElements(Object receiver_, int start, int end) {
            assert (ArrayStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).shareElements(receiver_, start, end);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public String toString(Object receiver_) {
            assert (ArrayStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                String string = ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).toString(receiver_);
                return string;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void write(Object receiver_, int index, Object value) {
            assert (ArrayStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).write(receiver_, index, value);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public int capacity(Object receiver_) {
            assert (ArrayStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                int n = ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).capacity(receiver_);
                return n;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object expand(Object receiver_, int capacity) {
            assert (ArrayStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).expand(receiver_, capacity);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object extractRange(Object receiver_, int start, int end) {
            assert (ArrayStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).extractRange(receiver_, start, end);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object extractRangeAndUnshare(Object receiver_, int start, int end) {
            assert (ArrayStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).extractRangeAndUnshare(receiver_, start, end);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object[] boxedCopyOfRange(Object receiver_, int start, int length) {
            assert (ArrayStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object[] objectArray = ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).boxedCopyOfRange(receiver_, start, length);
                return objectArray;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void copyContents(Object receiver_, int srcStart, Object dest, int destStart, int length) {
            assert (ArrayStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).copyContents(receiver_, srcStart, dest, destStart, length);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void clear(Object receiver_, int start, int length) {
            assert (ArrayStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).clear(receiver_, start, length);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void fill(Object receiver_, int start, int length, Object value) {
            assert (ArrayStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).fill(receiver_, start, length, value);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object toJavaArrayCopy(Object receiver_, int length) {
            assert (ArrayStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).toJavaArrayCopy(receiver_, length);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void sort(Object receiver_, int size) {
            assert (ArrayStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).sort(receiver_, size);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Iterable<Object> getIterable(Object receiver_, int start, int length) {
            assert (ArrayStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Iterable<Object> iterable = ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).getIterable(receiver_, start, length);
                return iterable;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public ArrayStoreLibrary.ArrayAllocator generalizeForValue(Object receiver_, Object newValue) {
            assert (ArrayStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ArrayStoreLibrary.ArrayAllocator arrayAllocator = ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).generalizeForValue(receiver_, newValue);
                return arrayAllocator;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public ArrayStoreLibrary.ArrayAllocator generalizeForStore(Object receiver_, Object newStore) {
            assert (ArrayStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ArrayStoreLibrary.ArrayAllocator arrayAllocator = ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).generalizeForStore(receiver_, newStore);
                return arrayAllocator;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public ArrayStoreLibrary.ArrayAllocator generalizeForSharing(Object receiver_) {
            assert (ArrayStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ArrayStoreLibrary.ArrayAllocator arrayAllocator = ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).generalizeForSharing(receiver_);
                return arrayAllocator;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object allocateForNewValue(Object receiver_, Object newValue, int length) {
            assert (ArrayStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).allocateForNewValue(receiver_, newValue, length);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object allocateForNewStore(Object receiver_, Object newStore, int length) {
            assert (ArrayStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).allocateForNewStore(receiver_, newStore, length);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object unsharedAllocateForNewStore(Object receiver_, Object newStore, int length) {
            assert (ArrayStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).unsharedAllocateForNewStore(receiver_, newStore, length);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public ArrayStoreLibrary.ArrayAllocator allocator(Object receiver_) {
            assert (ArrayStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ArrayStoreLibrary.ArrayAllocator arrayAllocator = ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).allocator(receiver_);
                return arrayAllocator;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public ArrayStoreLibrary.ArrayAllocator unsharedAllocator(Object receiver_) {
            assert (ArrayStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ArrayStoreLibrary.ArrayAllocator arrayAllocator = ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).unsharedAllocator(receiver_);
                return arrayAllocator;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isDefaultValue(Object receiver_, Object value) {
            assert (ArrayStoreLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((ArrayStoreLibrary)INSTANCE.getUncached(receiver_)).isDefaultValue(receiver_, value);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }
    }
}

