/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array.library;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.library.GenerateLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.array.library.DelegatedArrayStorage;
import org.truffleruby.core.array.library.DoubleArrayStore;
import org.truffleruby.core.array.library.IntegerArrayStore;
import org.truffleruby.core.array.library.LongArrayStore;
import org.truffleruby.core.array.library.ObjectArrayStore;
import org.truffleruby.core.array.library.SharedArrayStorage;
import org.truffleruby.core.array.library.ZeroLengthArrayStore;

@GenerateLibrary
@GenerateLibrary.DefaultExport.Repeat(value={@GenerateLibrary.DefaultExport(value=IntegerArrayStore.class), @GenerateLibrary.DefaultExport(value=LongArrayStore.class), @GenerateLibrary.DefaultExport(value=DoubleArrayStore.class), @GenerateLibrary.DefaultExport(value=ObjectArrayStore.class)})
public abstract class ArrayStoreLibrary
extends Library {
    private static final Object INITIAL_STORE = ZeroLengthArrayStore.ZERO_LENGTH_STORE;
    private static final ArrayAllocator INITIAL_ALLOCATOR = ZeroLengthArrayStore.ZERO_LENGTH_ALLOCATOR;
    private static final Object SHARED_INITIAL_STORE = new SharedArrayStorage(ZeroLengthArrayStore.ZERO_LENGTH_STORE);
    private static final ArrayAllocator SHARED_INITIAL_ALLOCATOR = SharedArrayStorage.SHARED_ZERO_LENGTH_ARRAY_ALLOCATOR;
    private static final LibraryFactory<ArrayStoreLibrary> FACTORY = LibraryFactory.resolve(ArrayStoreLibrary.class);

    public static ArrayStoreLibrary createDispatched(RubyLanguage language) {
        return (ArrayStoreLibrary)FACTORY.createDispatched(language.options.ARRAY_STRATEGY_CACHE);
    }

    public static ArrayStoreLibrary create(Object store) {
        return (ArrayStoreLibrary)FACTORY.create(store);
    }

    public static ArrayStoreLibrary getUncached() {
        CompilerAsserts.neverPartOfCompilation((String)"uncached libraries must not be used in PE code");
        return (ArrayStoreLibrary)FACTORY.getUncached();
    }

    public static ArrayStoreLibrary getUncached(Object store) {
        CompilerAsserts.neverPartOfCompilation((String)"uncached libraries must not be used in PE code");
        return (ArrayStoreLibrary)FACTORY.getUncached(store);
    }

    public static Object initialStorage(boolean shared) {
        if (shared) {
            return SHARED_INITIAL_STORE;
        }
        return INITIAL_STORE;
    }

    public static ArrayAllocator initialAllocator(boolean shared) {
        if (shared) {
            return SHARED_INITIAL_ALLOCATOR;
        }
        return INITIAL_ALLOCATOR;
    }

    public static ArrayAllocator allocatorForValue(Object value) {
        if (value instanceof Integer) {
            return IntegerArrayStore.INTEGER_ARRAY_ALLOCATOR;
        }
        if (value instanceof Long) {
            return LongArrayStore.LONG_ARRAY_ALLOCATOR;
        }
        if (value instanceof Double) {
            return DoubleArrayStore.DOUBLE_ARRAY_ALLOCATOR;
        }
        return ObjectArrayStore.OBJECT_ARRAY_ALLOCATOR;
    }

    public abstract Object read(Object var1, int var2);

    @GenerateLibrary.Abstract(ifExported={"write", "acceptsAllValues", "isMutable", "fill"})
    public boolean acceptsValue(Object store, Object value) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"write", "acceptsValue", "isMutable", "fill"})
    public boolean acceptsAllValues(Object store, Object otherStore) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"write", "acceptsValue", "acceptsAllValues", "fill"})
    public boolean isMutable(Object store) {
        return false;
    }

    public boolean isNative(Object store) {
        return false;
    }

    @GenerateLibrary.Abstract(ifExported={"sort"})
    public boolean isPrimitive(Object store) {
        return false;
    }

    public boolean isShared(Object store) {
        return false;
    }

    public Object initialStore(Object store) {
        return INITIAL_STORE;
    }

    public Object backingStore(Object store) {
        return store;
    }

    public Object makeShared(Object store, int size) {
        return new SharedArrayStorage(store);
    }

    public void shareElements(Object store, int start, int end) {
        assert (this.isPrimitive(store));
    }

    public abstract String toString(Object var1);

    @GenerateLibrary.Abstract(ifExported={"acceptsValue", "acceptsAllValues", "isMutable", "fill"})
    public void write(Object store, int index, Object value) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnsupportedOperationException();
    }

    public abstract int capacity(Object var1);

    public abstract Object expand(Object var1, int var2);

    public Object extractRange(Object store, int start, int end) {
        return new DelegatedArrayStorage(store, start, end - start);
    }

    public Object extractRangeAndUnshare(Object store, int start, int end) {
        return this.extractRange(store, start, end);
    }

    public abstract Object[] boxedCopyOfRange(Object var1, int var2, int var3);

    public abstract void copyContents(Object var1, int var2, Object var3, int var4, int var5);

    public abstract void clear(Object var1, int var2, int var3);

    @GenerateLibrary.Abstract(ifExported={"write"})
    public void fill(Object store, int start, int length, Object value) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        assert (this.acceptsValue(store, value));
        throw new UnsupportedOperationException();
    }

    public abstract Object toJavaArrayCopy(Object var1, int var2);

    @GenerateLibrary.Abstract(ifExported={"isPrimitive"})
    public void sort(Object store, int size) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnsupportedOperationException();
    }

    public abstract Iterable<Object> getIterable(Object var1, int var2, int var3);

    public abstract ArrayAllocator generalizeForValue(Object var1, Object var2);

    public abstract ArrayAllocator generalizeForStore(Object var1, Object var2);

    public abstract ArrayAllocator generalizeForSharing(Object var1);

    public abstract Object allocateForNewValue(Object var1, Object var2, int var3);

    public abstract Object allocateForNewStore(Object var1, Object var2, int var3);

    public Object unsharedAllocateForNewStore(Object store, Object newStore, int length) {
        return this.allocateForNewStore(store, newStore, length);
    }

    public abstract ArrayAllocator allocator(Object var1);

    public ArrayAllocator unsharedAllocator(Object store) {
        return this.allocator(store);
    }

    public abstract boolean isDefaultValue(Object var1, Object var2);

    public final Node getNode() {
        boolean adoptable = this.isAdoptable();
        CompilerAsserts.partialEvaluationConstant((boolean)adoptable);
        if (adoptable) {
            return this;
        }
        return EncapsulatingNodeReference.getCurrent().get();
    }

    public static abstract class ArrayAllocator {
        public abstract Object allocate(int var1);

        public abstract boolean accepts(Object var1);

        public abstract boolean specializesFor(Object var1);

        public abstract boolean isDefaultValue(Object var1);

        public boolean isShared() {
            return false;
        }
    }
}

