/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.LoopConditionProfile;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import org.truffleruby.RubyLanguage;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyGuards;

public abstract class ArrayUtils {
    public static final Object[] EMPTY_ARRAY = new Object[0];
    public static final byte[] EMPTY_BYTES = new byte[0];

    public static boolean assertValidElements(Object[] array, int start, int count) {
        assert (start <= array.length);
        assert (start + count <= array.length);
        for (int i = start; i < start + count; ++i) {
            Object element = array[i];
            assert (element != null) : ArrayUtils.nullElementAt(array, i);
            assert (RubyGuards.assertIsValidRubyValue(element));
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    private static String nullElementAt(Object[] array, int index) {
        return "null element in Object[] at index " + index + ": " + Arrays.toString(array);
    }

    public static byte[] extractRange(byte[] source, int start, int end) {
        assert (ArrayUtils.assertExtractRangeArgs(source, start, end));
        int length = end - start;
        byte[] result = new byte[length];
        System.arraycopy(source, start, result, 0, length);
        return result;
    }

    public static int[] extractRange(int[] source, int start, int end) {
        assert (ArrayUtils.assertExtractRangeArgs(source, start, end));
        int length = end - start;
        int[] result = new int[length];
        System.arraycopy(source, start, result, 0, length);
        return result;
    }

    public static long[] extractRange(long[] source, int start, int end) {
        assert (ArrayUtils.assertExtractRangeArgs(source, start, end));
        int length = end - start;
        long[] result = new long[length];
        System.arraycopy(source, start, result, 0, length);
        return result;
    }

    public static double[] extractRange(double[] source, int start, int end) {
        assert (ArrayUtils.assertExtractRangeArgs(source, start, end));
        int length = end - start;
        double[] result = new double[length];
        System.arraycopy(source, start, result, 0, length);
        return result;
    }

    public static Object[] extractRange(Object[] source, int start, int end) {
        assert (ArrayUtils.assertExtractRangeArgs(source, start, end));
        int length = end - start;
        Object[] result = new Object[length];
        System.arraycopy(source, start, result, 0, length);
        return result;
    }

    private static boolean assertExtractRangeArgs(Object source, int start, int end) {
        assert (source != null);
        assert (start >= 0);
        assert (start <= Array.getLength(source));
        assert (end >= start);
        assert (end <= Array.getLength(source));
        return true;
    }

    public static boolean contains(int[] array, int value) {
        for (int element : array) {
            if (element != value) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean contains(T[] array, T value) {
        for (T element : array) {
            if (element != value) continue;
            return true;
        }
        return false;
    }

    public static int capacity(RubyLanguage language, int current, int needed) {
        if (needed == 0) {
            return 0;
        }
        assert (current < needed);
        if (needed < language.options.ARRAY_UNINITIALIZED_SIZE) {
            return language.options.ARRAY_UNINITIALIZED_SIZE;
        }
        int newCapacity = current << 1;
        if (newCapacity >= needed) {
            return newCapacity;
        }
        return needed;
    }

    public static int capacityForOneMore(RubyLanguage language, int current) {
        if (current < language.options.ARRAY_UNINITIALIZED_SIZE) {
            return language.options.ARRAY_UNINITIALIZED_SIZE;
        }
        return current << 1;
    }

    public static long capacityForOneMore(RubyLanguage language, long current) {
        if (current < (long)language.options.ARRAY_UNINITIALIZED_SIZE) {
            return language.options.ARRAY_UNINITIALIZED_SIZE;
        }
        return current << 1;
    }

    public static void arraycopy(Object[] src, int srcPos, Object[] dest, int destPos, int length) {
        System.arraycopy(src, srcPos, dest, destPos, length);
    }

    public static Object[] copyOf(Object[] array, int newLength) {
        Object[] copy = new Object[newLength];
        System.arraycopy(array, 0, copy, 0, Math.min(array.length, newLength));
        return copy;
    }

    public static int[] grow(int[] array, int newLength) {
        assert (newLength >= array.length);
        int[] copy = new int[newLength];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static long[] grow(long[] array, int newLength) {
        assert (newLength >= array.length);
        long[] copy = new long[newLength];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static double[] grow(double[] array, int newLength) {
        assert (newLength >= array.length);
        double[] copy = new double[newLength];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static Object[] grow(Object[] array, int newLength) {
        assert (newLength >= array.length);
        Object[] copy = new Object[newLength];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static Object[] copy(Object[] array) {
        Object[] copy = new Object[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static Object[] unshift(Object[] array, Object element) {
        Object[] newArray = new Object[1 + array.length];
        newArray[0] = element;
        ArrayUtils.arraycopy(array, 0, newArray, 1, array.length);
        return newArray;
    }

    public static Object[] append(Object[] array, Object element) {
        Object[] newArray = ArrayUtils.grow(array, array.length + 1);
        newArray[array.length] = element;
        return newArray;
    }

    public static Object getLast(Object[] array) {
        assert (array.length >= 1);
        return array[array.length - 1];
    }

    public static void setLast(Object[] array, Object value) {
        assert (array.length >= 1);
        array[array.length - 1] = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fill(Object[] array, int from, int to, Object value, Node node, LoopConditionProfile loopProfile) {
        assert (from <= to);
        int i = from;
        try {
            while (loopProfile.inject(i < to)) {
                array[i] = value;
                TruffleSafepoint.poll((Node)node);
                ++i;
            }
        }
        finally {
            RubyBaseNode.profileAndReportLoopCount(node, loopProfile, i - from);
        }
    }

    public static boolean regionEquals(byte[] first, int firstStart, byte[] second, int secondStart, int size) {
        return com.oracle.truffle.api.ArrayUtils.regionEqualsWithOrMask((byte[])first, (int)firstStart, (byte[])second, (int)secondStart, (int)size, null);
    }

    public static int memchr(byte[] array, int start, int size, byte find) {
        return com.oracle.truffle.api.ArrayUtils.indexOf((byte[])array, (int)start, (int)(start + size), (byte[])new byte[]{find});
    }

    @CompilerDirectives.TruffleBoundary
    public static void sort(Object[] elements, int length) {
        Arrays.sort(elements, 0, length);
    }

    @CompilerDirectives.TruffleBoundary
    public static List<Object> asList(Object[] array) {
        return Arrays.asList(array);
    }
}

