/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;

public final class ArrayPatternLengthCheckNode
extends RubyContextSourceNode {
    @Node.Child
    RubyNode currentValueToMatch;
    final int patternLength;
    final boolean hasRest;
    final ConditionProfile isArrayProfile = ConditionProfile.create();

    public ArrayPatternLengthCheckNode(int patternLength, RubyNode currentValueToMatch, boolean hasRest) {
        this.currentValueToMatch = currentValueToMatch;
        this.patternLength = patternLength;
        this.hasRest = hasRest;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object matchArray = this.currentValueToMatch.execute(frame);
        if (this.isArrayProfile.profile(matchArray instanceof RubyArray)) {
            long size = ((RubyArray)matchArray).getArraySize();
            if (this.hasRest) {
                return (long)this.patternLength <= size;
            }
            return (long)this.patternLength == size;
        }
        return false;
    }

    @Override
    public RubyNode cloneUninitialized() {
        return new ArrayPatternLengthCheckNode(this.patternLength, this.currentValueToMatch.cloneUninitialized(), this.hasRest).copyFlags(this);
    }
}

