/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.CoreLibrary;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.objects.AllocationTracing;

public abstract class ArrayLiteralNode
extends RubyContextSourceNode {
    @Node.Children
    protected final RubyNode[] values;
    protected final RubyLanguage language;

    public static ArrayLiteralNode create(RubyLanguage language, RubyNode[] values) {
        return new UninitialisedArrayLiteralNode(language, values);
    }

    public ArrayLiteralNode(RubyLanguage language, RubyNode[] values) {
        this.language = language;
        this.values = values;
    }

    protected RubyArray makeGeneric(VirtualFrame frame, Object[] alreadyExecuted) {
        ObjectArrayLiteralNode newNode = new ObjectArrayLiteralNode(this.language, this.values);
        newNode.copyFlags(this);
        this.replace(newNode);
        Object[] executedValues = new Object[this.values.length];
        for (int n = 0; n < this.values.length; ++n) {
            executedValues[n] = n < alreadyExecuted.length ? alreadyExecuted[n] : this.values[n].execute(frame);
        }
        return this.cachedCreateArray(executedValues, executedValues.length);
    }

    protected RubyArray cachedCreateArray(Object store, int size) {
        RubyArray array = this.createArray(store, size);
        AllocationTracing.trace(array, this);
        return array;
    }

    @Override
    public final RubyNode cloneUninitialized() {
        UninitialisedArrayLiteralNode copy = new UninitialisedArrayLiteralNode(this.language, ArrayLiteralNode.cloneUninitialized(this.values));
        return copy.copyFlags(this);
    }

    @Override
    public abstract RubyArray execute(VirtualFrame var1);

    @Override
    @ExplodeLoop
    public void doExecuteVoid(VirtualFrame frame) {
        for (RubyNode value : this.values) {
            value.doExecuteVoid(frame);
        }
    }

    @Override
    @ExplodeLoop
    public Object isDefined(VirtualFrame frame, RubyLanguage language, RubyContext context) {
        for (RubyNode value : this.values) {
            if (value.isDefined(frame, language, context) != nil) continue;
            return nil;
        }
        return super.isDefined(frame, language, context);
    }

    public int getSize() {
        return this.values.length;
    }

    private static final class UninitialisedArrayLiteralNode
    extends ArrayLiteralNode {
        public UninitialisedArrayLiteralNode(RubyLanguage language, RubyNode[] values) {
            super(language, values);
        }

        @Override
        public RubyArray execute(VirtualFrame frame) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object[] executedValues = new Object[this.values.length];
            for (int n = 0; n < this.values.length; ++n) {
                executedValues[n] = this.values[n].execute(frame);
            }
            RubyArray array = this.cachedCreateArray(this.storeSpecialisedFromObjects(executedValues), executedValues.length);
            Object store = array.getStore();
            ArrayLiteralNode newNode = store == ArrayStoreLibrary.initialStorage(false) ? new EmptyArrayLiteralNode(this.language, this.values) : (store instanceof int[] ? new IntegerArrayLiteralNode(this.language, this.values) : (store instanceof long[] ? new LongArrayLiteralNode(this.language, this.values) : (store instanceof double[] ? new FloatArrayLiteralNode(this.language, this.values) : new ObjectArrayLiteralNode(this.language, this.values))));
            newNode.copyFlags(this);
            this.replace(newNode);
            return array;
        }

        public Object storeSpecialisedFromObjects(Object ... objects) {
            int n;
            Object[] store;
            if (objects.length == 0) {
                return ArrayStoreLibrary.initialStorage(false);
            }
            boolean canUseInteger = true;
            boolean canUseLong = true;
            boolean canUseDouble = true;
            for (Object object : objects) {
                if (object instanceof Integer) {
                    canUseDouble = false;
                    continue;
                }
                if (object instanceof Long) {
                    canUseInteger = canUseInteger && CoreLibrary.fitsIntoInteger((Long)object);
                    canUseDouble = false;
                    continue;
                }
                if (object instanceof Double) {
                    canUseInteger = false;
                    canUseLong = false;
                    continue;
                }
                canUseInteger = false;
                canUseLong = false;
                canUseDouble = false;
            }
            if (canUseInteger) {
                store = new int[objects.length];
                for (n = 0; n < objects.length; ++n) {
                    Object object = objects[n];
                    if (object instanceof Integer) {
                        store[n] = (Integer)object;
                        continue;
                    }
                    if (object instanceof Long) {
                        store[n] = (int)((Long)object).longValue();
                        continue;
                    }
                    throw CompilerDirectives.shouldNotReachHere();
                }
                return store;
            }
            if (canUseLong) {
                store = new long[objects.length];
                for (n = 0; n < objects.length; ++n) {
                    Object object = objects[n];
                    if (object instanceof Integer) {
                        store[n] = (int)((long)((Integer)object).intValue());
                        continue;
                    }
                    if (object instanceof Long) {
                        store[n] = (int)((Long)object).longValue();
                        continue;
                    }
                    throw CompilerDirectives.shouldNotReachHere();
                }
                return store;
            }
            if (canUseDouble) {
                store = new double[objects.length];
                for (n = 0; n < objects.length; ++n) {
                    store[n] = (int)CoreLibrary.toDouble(objects[n], nil);
                }
                return store;
            }
            return objects;
        }
    }

    private static final class ObjectArrayLiteralNode
    extends ArrayLiteralNode {
        public ObjectArrayLiteralNode(RubyLanguage language, RubyNode[] values) {
            super(language, values);
        }

        @Override
        @ExplodeLoop
        public RubyArray execute(VirtualFrame frame) {
            Object[] executedValues = new Object[this.values.length];
            for (int n = 0; n < this.values.length; ++n) {
                executedValues[n] = this.values[n].execute(frame);
            }
            return this.cachedCreateArray(executedValues, this.values.length);
        }
    }

    private static final class LongArrayLiteralNode
    extends ArrayLiteralNode {
        public LongArrayLiteralNode(RubyLanguage language, RubyNode[] values) {
            super(language, values);
        }

        @Override
        @ExplodeLoop
        public RubyArray execute(VirtualFrame frame) {
            long[] executedValues = new long[this.values.length];
            for (int n = 0; n < this.values.length; ++n) {
                Object value = this.values[n].execute(frame);
                if (!(value instanceof Long)) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return this.makeGeneric(frame, executedValues, n, value);
                }
                executedValues[n] = (Long)value;
            }
            return this.cachedCreateArray(executedValues, this.values.length);
        }

        private RubyArray makeGeneric(VirtualFrame frame, long[] executedValues, int n, Object value) {
            Object[] executedObjects = new Object[n + 1];
            for (int i = 0; i < n; ++i) {
                executedObjects[i] = executedValues[i];
            }
            executedObjects[n] = value;
            return this.makeGeneric(frame, executedObjects);
        }
    }

    private static final class IntegerArrayLiteralNode
    extends ArrayLiteralNode {
        public IntegerArrayLiteralNode(RubyLanguage language, RubyNode[] values) {
            super(language, values);
        }

        @Override
        @ExplodeLoop
        public RubyArray execute(VirtualFrame frame) {
            int[] executedValues = new int[this.values.length];
            for (int n = 0; n < this.values.length; ++n) {
                Object value = this.values[n].execute(frame);
                if (!(value instanceof Integer)) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return this.makeGeneric(frame, executedValues, n, value);
                }
                executedValues[n] = (Integer)value;
            }
            return this.cachedCreateArray(executedValues, this.values.length);
        }

        private RubyArray makeGeneric(VirtualFrame frame, int[] executedValues, int n, Object value) {
            Object[] executedObjects = new Object[n + 1];
            for (int i = 0; i < n; ++i) {
                executedObjects[i] = executedValues[i];
            }
            executedObjects[n] = value;
            return this.makeGeneric(frame, executedObjects);
        }
    }

    private static final class FloatArrayLiteralNode
    extends ArrayLiteralNode {
        public FloatArrayLiteralNode(RubyLanguage language, RubyNode[] values) {
            super(language, values);
        }

        @Override
        @ExplodeLoop
        public RubyArray execute(VirtualFrame frame) {
            double[] executedValues = new double[this.values.length];
            for (int n = 0; n < this.values.length; ++n) {
                Object value = this.values[n].execute(frame);
                if (!(value instanceof Double)) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return this.makeGeneric(frame, executedValues, n, value);
                }
                executedValues[n] = (Double)value;
            }
            return this.cachedCreateArray(executedValues, this.values.length);
        }

        private RubyArray makeGeneric(VirtualFrame frame, double[] executedValues, int n, Object value) {
            Object[] executedObjects = new Object[n + 1];
            for (int i = 0; i < n; ++i) {
                executedObjects[i] = executedValues[i];
            }
            executedObjects[n] = value;
            return this.makeGeneric(frame, executedObjects);
        }
    }

    private static final class EmptyArrayLiteralNode
    extends ArrayLiteralNode {
        public EmptyArrayLiteralNode(RubyLanguage language, RubyNode[] values) {
            super(language, values);
        }

        @Override
        public RubyArray execute(VirtualFrame frame) {
            return this.cachedCreateArray(ArrayStoreLibrary.initialStorage(false), 0);
        }
    }
}

