/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.array.ArrayCopyOnWriteNode;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.ArrayIndexNodesFactory;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;

@CoreModule(value="Truffle::ArrayIndex", isClass=false)
public abstract class ArrayIndexNodes {

    @ImportStatic(value={ArrayGuards.class})
    public static abstract class ReadSliceNormalizedNode
    extends RubyBaseNode {
        public abstract Object executeReadSlice(RubyArray var1, int var2, int var3);

        @Specialization(guards={"!indexInBounds(array, index)"})
        Object readIndexOutOfBounds(RubyArray array, int index, int length) {
            return nil;
        }

        @Specialization(guards={"length < 0"})
        Object readNegativeLength(RubyArray array, int index, int length) {
            return nil;
        }

        @Specialization(guards={"indexInBounds(array, index)", "length >= 0"})
        RubyArray readInBounds(RubyArray array, int index, int length, @Cached ArrayCopyOnWriteNode cowNode, @Cached ConditionProfile endsInBoundsProfile) {
            int size = array.size;
            int end = endsInBoundsProfile.profile(index + length <= size) ? length : size - index;
            Object slice = cowNode.execute(array, index, end);
            return this.createArray(slice, end);
        }

        protected static boolean indexInBounds(RubyArray array, int index) {
            return index >= 0 && index <= array.size;
        }
    }

    @ImportStatic(value={ArrayGuards.class})
    @ReportPolymorphism
    public static abstract class ReadNormalizedNode
    extends PrimitiveArrayArgumentsNode {
        @NeverDefault
        public static ReadNormalizedNode create() {
            return ArrayIndexNodesFactory.ReadNormalizedNodeFactory.create(null);
        }

        public static ReadNormalizedNode create(RubyNode array, RubyNode index) {
            return ArrayIndexNodesFactory.ReadNormalizedNodeFactory.create(new RubyNode[]{array, index});
        }

        public abstract Object executeRead(RubyArray var1, int var2);

        @Specialization(guards={"isInBounds(array, index)"}, limit="storageStrategyLimit()")
        Object readInBounds(RubyArray array, int index, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores) {
            return stores.read(store, index);
        }

        @Specialization(guards={"!isInBounds(array, index)"})
        Object readOutOfBounds(RubyArray array, int index) {
            return nil;
        }

        protected static boolean isInBounds(RubyArray array, int index) {
            return index >= 0 && index < array.size;
        }
    }

    @NodeChild(value="arrayNode", type=RubyNode.class)
    @ImportStatic(value={ArrayGuards.class})
    @ReportPolymorphism
    public static abstract class ReadConstantIndexNode
    extends RubyContextSourceNode {
        private final int index;

        public static ReadConstantIndexNode create(RubyNode array, int index) {
            return ArrayIndexNodesFactory.ReadConstantIndexNodeGen.create(index, array);
        }

        protected ReadConstantIndexNode(int index) {
            this.index = index;
        }

        public abstract RubyNode getArrayNode();

        @Specialization(limit="storageStrategyLimit()")
        Object readInBounds(RubyArray array, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores, @Cached ConditionProfile isInBounds) {
            int size = array.size;
            int normalizedIndex = this.index >= 0 ? this.index : size + this.index;
            if (isInBounds.profile(0 <= normalizedIndex && normalizedIndex < size)) {
                return stores.read(store, normalizedIndex);
            }
            return nil;
        }

        @Override
        public RubyNode cloneUninitialized() {
            ReadConstantIndexNode copy = ReadConstantIndexNode.create(this.getArrayNode().cloneUninitialized(), this.index);
            return copy.copyFlags(this);
        }
    }
}

