/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.array;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.language.RubyBaseNode;

@ImportStatic(value={ArrayGuards.class})
public abstract class ArrayCopyOnWriteNode
extends RubyBaseNode {
    public abstract Object execute(RubyArray var1, int var2, int var3);

    @Specialization(guards={"stores.isMutable(store)"}, limit="storageStrategyLimit()")
    Object extractFromMutableArray(RubyArray array, int start, int length, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores) {
        int size = array.size;
        Object cowStore = stores.extractRange(store, 0, size);
        Object range = stores.extractRangeAndUnshare(store, start, start + length);
        array.setStore(cowStore);
        return range;
    }

    @Specialization(guards={"!stores.isMutable(store)"}, limit="storageStrategyLimit()")
    Object extractFromNonMutableArray(RubyArray array, int start, int length, @Bind(value="array.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores) {
        Object range = stores.extractRangeAndUnshare(store, start, start + length);
        return range;
    }
}

