/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core;

import com.oracle.truffle.api.CompilerDirectives;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.SuppressFBWarnings;
import org.truffleruby.core.DummyNode;
import org.truffleruby.core.thread.RubyThread;
import org.truffleruby.core.thread.ThreadManager;
import org.truffleruby.language.control.RaiseException;

public abstract class ReferenceProcessingService<R extends PhantomProcessingReference<R, T>, T> {
    private R first = null;
    protected final ReferenceQueue<Object> processingQueue;

    public ReferenceProcessingService(ReferenceQueue<Object> processingQueue) {
        this.processingQueue = processingQueue;
    }

    protected void processReference(RubyContext context, RubyLanguage language, PhantomProcessingReference<?, ?> reference) {
        this.remove(reference);
    }

    protected void runCatchingErrors(RubyContext context, RubyLanguage language, ReferenceRunner<R> action, R reference) {
        try {
            action.accept(context, language, reference);
        }
        catch (RaiseException e) {
            context.getCoreExceptions().showExceptionIfDebug(e.getException());
        }
    }

    protected synchronized void remove(R ref) {
        if (((PhantomProcessingReference)ref).getNext() == ref) {
            return;
        }
        if (this.first == ref) {
            this.first = ((PhantomProcessingReference)ref).getNext() != null ? ((PhantomProcessingReference)ref).getNext() : null;
        }
        Object next = ((PhantomProcessingReference)ref).getNext();
        Object prev = ((PhantomProcessingReference)ref).getPrevious();
        if (next != null) {
            ((PhantomProcessingReference)next).setPrevious(prev);
        }
        if (prev != null) {
            ((PhantomProcessingReference)prev).setNext(next);
        }
        ((PhantomProcessingReference)ref).remove();
    }

    protected synchronized void add(R newRef) {
        if (this.first != null) {
            ((PhantomProcessingReference)newRef).setNext(this.first);
            ((PhantomProcessingReference)this.first).setPrevious(newRef);
        }
        this.first = newRef;
    }

    @SuppressFBWarnings(value={"IS"})
    protected R getFirst() {
        return this.first;
    }

    public static abstract class PhantomProcessingReference<R extends PhantomProcessingReference<R, T>, T>
    extends PhantomReference<T> {
        private R next;
        private R previous;
        private ReferenceProcessingService<R, T> service;

        public PhantomProcessingReference(T object, ReferenceQueue<? super Object> queue, ReferenceProcessingService<R, T> service) {
            super(object, queue);
            this.service = service;
        }

        public R getPrevious() {
            return this.previous;
        }

        public void setPrevious(R previous) {
            this.previous = previous;
        }

        public R getNext() {
            return this.next;
        }

        public void setNext(R next) {
            this.next = next;
        }

        public void remove() {
            this.next = this;
            this.previous = this;
        }

        public ReferenceProcessingService<R, T> service() {
            return this.service;
        }
    }

    public static interface ReferenceRunner<T> {
        public void accept(RubyContext var1, RubyLanguage var2, T var3);
    }

    public static final class ReferenceProcessor {
        final ReferenceQueue<Object> processingQueue = new ReferenceQueue();
        private RubyThread processingThread;
        private final RubyContext context;
        private static final String THREAD_NAME = "Ruby-reference-processor";

        public ReferenceProcessor(RubyContext context) {
            this.context = context;
        }

        void processReferenceQueue(ReferenceProcessingService<?, ?> service) {
            if (this.processOnMainThread()) {
                this.drainReferenceQueues();
            } else if (this.processingThread == null && !this.context.isPreInitializing() && this.context.isInitialized() && !this.context.isFinalizing()) {
                this.createProcessingThread(service);
            }
        }

        public boolean processOnMainThread() {
            return this.context.getOptions().SINGLE_THREADED || this.context.hasOtherPublicLanguages();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private void createProcessingThread(ReferenceProcessingService<?, ?> service) {
            RubyThread newThread;
            ThreadManager threadManager = this.context.getThreadManager();
            RubyLanguage language = this.context.getLanguageSlow();
            ReferenceProcessor referenceProcessor = this;
            synchronized (referenceProcessor) {
                if (this.processingThread != null) {
                    return;
                }
                this.processingThread = newThread = threadManager.createBootThread(THREAD_NAME);
            }
            String sharingReason = "creating Ruby-reference-processor thread for " + service.getClass().getSimpleName();
            threadManager.initialize(newThread, DummyNode.INSTANCE, THREAD_NAME, sharingReason, () -> {
                while (true) {
                    PhantomProcessingReference reference = threadManager.runUntilResult(DummyNode.INSTANCE, () -> (PhantomProcessingReference)this.processingQueue.remove());
                    reference.service().processReference(this.context, language, reference);
                }
            });
        }

        @CompilerDirectives.TruffleBoundary
        void drainReferenceQueues() {
            PhantomProcessingReference reference;
            RubyLanguage language = this.context.getLanguageSlow();
            while ((reference = (PhantomProcessingReference)this.processingQueue.poll()) != null) {
                reference.service().processReference(this.context, language, reference);
            }
        }
    }
}

