/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.collections;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NeverDefault;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.truffleruby.annotations.SuppressFBWarnings;
import org.truffleruby.collections.ConcurrentOperations;

public final class SharedIndicesMap {
    private final AtomicInteger nextIndex = new AtomicInteger(0);
    private final ConcurrentHashMap<String, Integer> nameToIndex = new ConcurrentHashMap();

    @CompilerDirectives.TruffleBoundary
    public int lookup(String name) {
        return ConcurrentOperations.getOrCompute(this.nameToIndex, name, k -> this.nextIndex.getAndIncrement());
    }

    public int size() {
        return this.nextIndex.get();
    }

    public static final class LanguageArray<T>
    extends LazyDataArray<T> {
        public LanguageArray(SharedIndicesMap sharedIndicesMap, IntFunction<T[]> newArray, Supplier<T> createWhenAbsent) {
            super(sharedIndicesMap, newArray, createWhenAbsent);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public T get(int index) {
            return super.get(index);
        }
    }

    public static final class ContextArray<T>
    extends LazyDataArray<T> {
        public ContextArray(SharedIndicesMap sharedIndicesMap, IntFunction<T[]> newArray, Supplier<T> createWhenAbsent) {
            super(sharedIndicesMap, newArray, createWhenAbsent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        public T addIfAbsent(int index, T value) {
            assert (value != null);
            assert (index <= this.sharedIndicesMap.size());
            ContextArray contextArray = this;
            synchronized (contextArray) {
                this.growIfNeeded(index);
                Object prev = this.data[index];
                if (prev == null) {
                    this.data[index] = value;
                    return value;
                }
                return (T)prev;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        public T set(int index, T value) {
            assert (value != null);
            assert (index <= this.sharedIndicesMap.size());
            ContextArray contextArray = this;
            synchronized (contextArray) {
                this.growIfNeeded(index);
                Object prev = this.data[index];
                this.data[index] = value;
                return (T)prev;
            }
        }
    }

    private static class LazyDataArray<T> {
        protected final SharedIndicesMap sharedIndicesMap;
        protected final Supplier<T> createWhenAbsent;
        protected T[] data;

        protected LazyDataArray(SharedIndicesMap sharedIndicesMap, IntFunction<T[]> newArray, Supplier<T> createWhenAbsent) {
            this.sharedIndicesMap = sharedIndicesMap;
            this.createWhenAbsent = createWhenAbsent;
            this.data = newArray.apply(sharedIndicesMap.size());
        }

        @NeverDefault
        public T get(int index) {
            T value;
            CompilerAsserts.partialEvaluationConstant((int)index);
            assert (index <= this.sharedIndicesMap.size());
            T[] localData = this.data;
            if (index < localData.length && (value = localData[index]) != null) {
                return value;
            }
            return this.getSlowPath(index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        protected T getSlowPath(int index) {
            LazyDataArray lazyDataArray = this;
            synchronized (lazyDataArray) {
                this.growIfNeeded(index);
                T prev = this.data[index];
                if (prev == null) {
                    T value = this.createWhenAbsent.get();
                    this.data[index] = Objects.requireNonNull(value);
                    return value;
                }
                return prev;
            }
        }

        @CompilerDirectives.TruffleBoundary
        @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"})
        public boolean contains(int index) {
            assert (index <= this.sharedIndicesMap.size());
            T[] localData = this.data;
            return index < localData.length && localData[index] != null;
        }

        @CompilerDirectives.TruffleBoundary
        public Collection<String> keys() {
            ArrayList<String> keys = new ArrayList<String>();
            for (Map.Entry<String, Integer> entry : this.sharedIndicesMap.nameToIndex.entrySet()) {
                int index = entry.getValue();
                if (!this.contains(index)) continue;
                keys.add(entry.getKey());
            }
            return keys;
        }

        @CompilerDirectives.TruffleBoundary
        public Collection<T> values() {
            ArrayList<T> values = new ArrayList<T>();
            for (T element : this.data) {
                if (element == null) continue;
                values.add(element);
            }
            return values;
        }

        @CompilerDirectives.TruffleBoundary
        protected void growIfNeeded(int index) {
            if (index >= this.data.length) {
                this.grow();
            }
        }

        @CompilerDirectives.TruffleBoundary
        private void grow() {
            int newSize = Math.max(this.sharedIndicesMap.size(), this.data.length << 1);
            this.data = Arrays.copyOf(this.data, newSize);
        }
    }
}

