/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.collections;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import org.truffleruby.collections.ConcurrentWeakKeysMap;

public final class ConcurrentWeakSet<E>
extends ConcurrentWeakKeysMap<E, Boolean>
implements Iterable<E> {
    @CompilerDirectives.TruffleBoundary
    public boolean add(E element) {
        return this.put(element, Boolean.TRUE) == null;
    }

    @CompilerDirectives.TruffleBoundary
    public Object[] toArray() {
        return this.keys().toArray();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public WeakSetIterator<E> iterator() {
        return new WeakSetIterator(((ConcurrentHashMap.KeySetView)this.map.keySet()).iterator());
    }

    private static final class WeakSetIterator<E>
    implements Iterator<E> {
        private final Iterator<ConcurrentWeakKeysMap.WeakKeyReference<E>> keysIterator;
        private E nextElement;

        private WeakSetIterator(Iterator<ConcurrentWeakKeysMap.WeakKeyReference<E>> keysIterator) {
            this.keysIterator = keysIterator;
            this.computeNext();
        }

        private void computeNext() {
            while (this.keysIterator.hasNext()) {
                Object element = this.keysIterator.next().get();
                if (element == null) continue;
                this.nextElement = element;
                return;
            }
            this.nextElement = null;
        }

        @Override
        public boolean hasNext() {
            return this.nextElement != null;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public E next() {
            E element = this.nextElement;
            if (element == null) {
                throw new NoSuchElementException();
            }
            this.computeNext();
            return element;
        }
    }
}

