/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.cext;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import java.lang.ref.Cleaner;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.SuppressFBWarnings;
import org.truffleruby.cext.IDToSymbolNode;
import org.truffleruby.cext.IsNativeObjectNode;
import org.truffleruby.cext.SymbolToIDNode;
import org.truffleruby.cext.UnwrapNode;
import org.truffleruby.cext.ValueWrapper;
import org.truffleruby.cext.WrapNode;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.ImmutableRubyObject;
import org.truffleruby.language.NotProvided;
import org.truffleruby.language.RubyBaseNode;

@SuppressFBWarnings(value={"VO"})
public final class ValueWrapperManager {
    static final long UNSET_HANDLE = -2L;
    public static final int FALSE_HANDLE = 0;
    public static final int TRUE_HANDLE = 6;
    public static final int NIL_HANDLE = 2;
    public static final int UNDEF_HANDLE = 10;
    public static final long IMMEDIATE_MASK = 3L;
    public static final long LONG_TAG = 1L;
    public static final long OBJECT_TAG = 0L;
    public static final long MIN_FIXNUM_VALUE = -4611686018427387904L;
    public static final long MAX_FIXNUM_VALUE = 0x3FFFFFFFFFFFFFFFL;
    public final ValueWrapper trueWrapper = new ValueWrapper(true, 6L, null);
    public final ValueWrapper falseWrapper = new ValueWrapper(false, 0L, null);
    public final ValueWrapper undefWrapper = new ValueWrapper(NotProvided.INSTANCE, 10L, null);
    private volatile HandleBlockWeakReference[] blockMap = new HandleBlockWeakReference[0];
    private final AtomicLong counter = new AtomicLong();
    private static final long ADDRESS_ALIGN_BITS = 3L;
    private static final int BLOCK_BITS = 15;
    private static final int BLOCK_SIZE = 4096;
    private static final int BLOCK_BYTE_SIZE = 32768;
    private static final long BLOCK_MASK = -32768L;
    private static final long OFFSET_MASK = 32767L;
    public static final long ALLOCATION_BASE = 841328705388150784L;

    public static HandleBlockHolder getBlockHolder(RubyContext context, RubyLanguage language) {
        return language.getCurrentFiber().handleData;
    }

    public ValueWrapper longWrapper(long value) {
        return new ValueWrapper(value, -2L, null);
    }

    public ValueWrapper doubleWrapper(double value) {
        return new ValueWrapper(value, -2L, null);
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized HandleBlock addToBlockMap(RubyContext context, RubyLanguage language) {
        HandleBlock block = new HandleBlock(context, language, this);
        int blockIndex = block.getIndex();
        HandleBlockWeakReference[] map = ValueWrapperManager.growMapIfRequired(this.blockMap, blockIndex);
        this.blockMap = map;
        map[blockIndex] = new HandleBlockWeakReference(block);
        return block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public HandleBlock addToSharedBlockMap(RubyContext context, RubyLanguage language) {
        RubyLanguage rubyLanguage = language;
        synchronized (rubyLanguage) {
            HandleBlock block = new HandleBlock(context, language, this);
            int blockIndex = block.getIndex();
            HandleBlockWeakReference[] map = ValueWrapperManager.growMapIfRequired(language.handleBlockSharedMap, blockIndex);
            language.handleBlockSharedMap = map;
            map[blockIndex] = new HandleBlockWeakReference(block);
            return block;
        }
    }

    private static HandleBlockWeakReference[] growMapIfRequired(HandleBlockWeakReference[] map, int blockIndex) {
        if (blockIndex + 1 > map.length) {
            HandleBlockWeakReference[] copy = new HandleBlockWeakReference[blockIndex + 1];
            System.arraycopy(map, 0, copy, 0, map.length);
            map = copy;
        }
        return map;
    }

    public ValueWrapper getWrapperFromHandleMap(long handle, RubyLanguage language) {
        int index = HandleBlock.getHandleIndex(handle);
        HandleBlock block = this.getBlockFromMap(index, language);
        if (block == null) {
            return null;
        }
        return block.getWrapper(handle);
    }

    private HandleBlock getBlockFromMap(int index, RubyLanguage language) {
        HandleBlockWeakReference[] blockMap = this.blockMap;
        HandleBlockWeakReference[] sharedMap = language.handleBlockSharedMap;
        Reference ref = null;
        if (index >= 0 && index < blockMap.length) {
            ref = blockMap[index];
        }
        if (ref == null && index >= 0 && index < sharedMap.length) {
            ref = sharedMap[index];
        }
        if (ref == null) {
            return null;
        }
        return (HandleBlock)ref.get();
    }

    public void freeAllBlocksInMap() {
        HandleBlockWeakReference[] map;
        for (HandleBlockWeakReference ref : map = this.blockMap) {
            HandleBlock block;
            if (ref == null || (block = (HandleBlock)ref.get()) == null) continue;
            block.cleanable.clean();
        }
    }

    public void cleanup(RubyContext context, HandleBlockHolder holder) {
        holder.handleBlock = null;
    }

    protected void recordHandleAllocation() {
        this.counter.incrementAndGet();
    }

    public long totalHandleAllocations() {
        return this.counter.get();
    }

    public static HandleBlock allocateNewBlock(RubyContext context, RubyLanguage language) {
        HandleBlockHolder holder = ValueWrapperManager.getBlockHolder(context, language);
        HandleBlock block = holder.handleBlock;
        holder.handleBlock = block = context.getValueWrapperManager().addToBlockMap(context, language);
        return block;
    }

    public static boolean isTaggedLong(long handle) {
        return (handle & 1L) == 1L;
    }

    public static boolean isTaggedObject(long handle) {
        return handle != 0L && (handle & 3L) == 0L;
    }

    public static boolean isMallocAligned(long handle) {
        return handle != 0L && (handle & 7L) == 0L;
    }

    public static boolean isWrapper(Object value) {
        return value instanceof ValueWrapper;
    }

    public static long untagTaggedLong(long handle) {
        return handle >> 1;
    }

    public static final class HandleBlock {
        private final long base;
        private final ValueWrapperWeakReference[] wrappers;
        private int count;
        private Cleaner.Cleanable cleanable;

        private HandleBlock() {
            this.base = 0L;
            this.cleanable = null;
            this.wrappers = null;
        }

        public HandleBlock(RubyContext context, RubyLanguage language, ValueWrapperManager manager) {
            long base;
            HandleBlockAllocator allocator = language.handleBlockAllocator;
            this.base = base = allocator.getFreeBlock();
            this.wrappers = new ValueWrapperWeakReference[4096];
            this.count = 0;
            this.cleanable = language.cleaner.register(this, HandleBlock.makeCleaner(manager, base, allocator));
        }

        private static Runnable makeCleaner(ValueWrapperManager manager, long base, HandleBlockAllocator allocator) {
            return () -> {
                manager.blockMap[(int)(base - 841328705388150784L >> 15)] = null;
                allocator.addFreeBlock(base);
            };
        }

        public long getBase() {
            return this.base;
        }

        public int getIndex() {
            return (int)(this.base - 841328705388150784L >> 15);
        }

        public ValueWrapper getWrapper(long handle) {
            int offset = (int)(handle & 0x7FFFL) >> 3;
            return (ValueWrapper)this.wrappers[offset].get();
        }

        public boolean isFull() {
            return this.count == 4096;
        }

        public long setHandleOnWrapper(ValueWrapper wrapper) {
            long handle = this.getBase() + (long)this.count * 8L;
            wrapper.setHandle(handle, this);
            this.wrappers[this.count] = new ValueWrapperWeakReference(wrapper);
            ++this.count;
            return handle;
        }

        public static int getHandleIndex(long handle) {
            return (int)(handle - 841328705388150784L >> 15);
        }
    }

    public static final class HandleBlockWeakReference
    extends WeakReference<HandleBlock> {
        HandleBlockWeakReference(HandleBlock referent) {
            super(referent);
        }
    }

    public static final class HandleBlockHolder {
        private HandleBlock handleBlock = null;
        private HandleBlock sharedHandleBlock = null;
    }

    @ExportLibrary(value=InteropLibrary.class)
    @GenerateUncached
    public static final class ToNativeObjectFunction
    implements TruffleObject {
        @ExportMessage
        protected boolean isExecutable() {
            return true;
        }

        @ExportMessage
        protected Object execute(Object[] arguments, @CachedLibrary(limit="1") InteropLibrary values) throws UnsupportedMessageException {
            values.toNative(arguments[0]);
            return values.asPointer(arguments[0]);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    @GenerateUncached
    public static final class IsNativeObjectFunction
    implements TruffleObject {
        @ExportMessage
        protected boolean isExecutable() {
            return true;
        }

        @ExportMessage
        protected Object execute(Object[] arguments, @Cached IsNativeObjectNode isNativeObjectNode, @Bind(value="$node") Node node) {
            return isNativeObjectNode.execute(node, arguments[0]);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    @GenerateUncached
    public static final class WrapperFunction
    implements TruffleObject {
        @ExportMessage
        protected boolean isExecutable() {
            return true;
        }

        @ExportMessage
        protected Object execute(Object[] arguments, @Cached WrapNode wrapNode) {
            return wrapNode.execute(arguments[0]);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    @GenerateUncached
    public static final class Symbol2IDFunction
    implements TruffleObject {
        @ExportMessage
        protected boolean isExecutable() {
            return true;
        }

        @ExportMessage
        public Object execute(Object[] arguments, @Cached UnwrapNode unwrapNode, @Cached SymbolToIDNode symbolTOIDNode, @Bind(value="$node") Node node) {
            return symbolTOIDNode.execute(unwrapNode.execute(node, arguments[0]));
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    @GenerateUncached
    public static final class ID2SymbolFunction
    implements TruffleObject {
        @ExportMessage
        protected boolean isExecutable() {
            return true;
        }

        @ExportMessage
        public RubySymbol execute(Object[] arguments, @Cached IDToSymbolNode unwrapIDNode) {
            return unwrapIDNode.execute(arguments[0]);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    @GenerateUncached
    public static final class UnwrapperFunction
    implements TruffleObject {
        @ExportMessage
        protected boolean isExecutable() {
            return true;
        }

        @ExportMessage
        protected Object execute(Object[] arguments, @Cached UnwrapNode unwrapNode, @Bind(value="$node") Node node) {
            return unwrapNode.execute(node, arguments[0]);
        }
    }

    @GenerateUncached
    public static abstract class AllocateHandleNode
    extends RubyBaseNode {
        private static final Set<ValueWrapper> keepAlive = ConcurrentHashMap.newKeySet();

        public abstract long execute(ValueWrapper var1);

        @Specialization(guards={"!isSharedObject(wrapper)"})
        long allocateHandleOnKnownThread(ValueWrapper wrapper) {
            if (this.getContext().getOptions().CEXTS_KEEP_HANDLES_ALIVE) {
                AllocateHandleNode.keepAlive(wrapper);
            }
            return this.allocateHandle(wrapper, this.getContext(), this.getLanguage(), ValueWrapperManager.getBlockHolder(this.getContext(), this.getLanguage()), false);
        }

        @Specialization(guards={"isSharedObject(wrapper)"})
        long allocateSharedHandleOnKnownThread(ValueWrapper wrapper) {
            if (this.getContext().getOptions().CEXTS_KEEP_HANDLES_ALIVE) {
                AllocateHandleNode.keepAlive(wrapper);
            }
            return this.allocateHandle(wrapper, this.getContext(), this.getLanguage(), ValueWrapperManager.getBlockHolder(this.getContext(), this.getLanguage()), true);
        }

        @CompilerDirectives.TruffleBoundary
        protected static void keepAlive(ValueWrapper wrapper) {
            keepAlive.add(wrapper);
        }

        protected long allocateHandle(ValueWrapper wrapper, RubyContext context, RubyLanguage language, HandleBlockHolder holder, boolean shared) {
            HandleBlock block = shared ? holder.sharedHandleBlock : holder.handleBlock;
            if (context.getOptions().CEXTS_TO_NATIVE_COUNT) {
                context.getValueWrapperManager().recordHandleAllocation();
            }
            if (context.getOptions().BACKTRACE_ON_TO_NATIVE) {
                context.getDefaultBacktraceFormatter().printBacktraceOnEnvStderr("ValueWrapper#toNative: ", this);
            }
            if (block == null || block.isFull()) {
                if (shared) {
                    holder.sharedHandleBlock = block = context.getValueWrapperManager().addToSharedBlockMap(context, language);
                } else {
                    holder.handleBlock = block = context.getValueWrapperManager().addToBlockMap(context, language);
                }
            }
            return block.setHandleOnWrapper(wrapper);
        }

        protected static boolean isSharedObject(ValueWrapper wrapper) {
            return wrapper.getObject() instanceof ImmutableRubyObject;
        }
    }

    public static final class ValueWrapperWeakReference
    extends WeakReference<ValueWrapper> {
        ValueWrapperWeakReference(ValueWrapper referent) {
            super(referent);
        }
    }

    public static final class HandleBlockAllocator {
        private long nextBlock = 841328705388150784L;
        private FreeHandleBlock firstFreeBlock = null;

        public synchronized long getFreeBlock() {
            if (this.firstFreeBlock != null) {
                FreeHandleBlock block = this.firstFreeBlock;
                this.firstFreeBlock = block.next;
                return block.start;
            }
            long block = this.nextBlock;
            this.nextBlock += 32768L;
            return block;
        }

        public synchronized void addFreeBlock(long blockBase) {
            this.firstFreeBlock = new FreeHandleBlock(blockBase, this.firstFreeBlock);
        }
    }

    protected static final class FreeHandleBlock {
        public final long start;
        public final FreeHandleBlock next;

        public FreeHandleBlock(long start, FreeHandleBlock next) {
            this.start = start;
            this.next = next;
        }
    }
}

