/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.cext;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.truffleruby.RubyLanguage;
import org.truffleruby.cext.ValueWrapperManager;
import org.truffleruby.core.MarkingServiceNodes;
import org.truffleruby.debug.VariableNamesObject;
import org.truffleruby.interop.TranslateInteropExceptionNode;

@ExportLibrary(value=InteropLibrary.class)
public final class ValueWrapper
implements TruffleObject {
    private final Object object;
    private volatile long handle;
    private volatile ValueWrapperManager.HandleBlock handleBlock;

    public ValueWrapper(Object object, long handle, ValueWrapperManager.HandleBlock handleBlock) {
        this.object = object;
        this.handle = handle;
        this.handleBlock = handleBlock;
    }

    public Object getObject() {
        return this.object;
    }

    public long getHandle() {
        return this.handle;
    }

    public void setHandle(long handle, ValueWrapperManager.HandleBlock handleBlock) {
        this.handle = handle;
        this.handleBlock = handleBlock;
    }

    @ExportMessage
    protected boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    protected Class<RubyLanguage> getLanguage() {
        return RubyLanguage.class;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        if (this.object != null) {
            return this.object.toString();
        }
        assert (ValueWrapperManager.isTaggedLong(this.handle));
        return Long.toString(ValueWrapperManager.untagTaggedLong(this.handle));
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    protected String toDisplayString(boolean allowSideEffects) {
        if (this.object != null) {
            InteropLibrary interop = InteropLibrary.getUncached();
            try {
                return "VALUE: " + interop.asString(interop.toDisplayString(this.object, allowSideEffects));
            }
            catch (UnsupportedMessageException e) {
                throw TranslateInteropExceptionNode.executeUncached((InteropException)((Object)e));
            }
        }
        return "VALUE: " + this.toString();
    }

    @ExportMessage
    protected boolean isPointer() {
        return this.handle != -2L;
    }

    @ExportMessage
    static void toNative(ValueWrapper wrapper, @Cached ValueWrapperManager.AllocateHandleNode createNativeHandleNode, @Cached @Cached.Exclusive InlinedBranchProfile createHandleProfile, @Bind(value="$node") Node node) {
        if (!wrapper.isPointer()) {
            createHandleProfile.enter(node);
            createNativeHandleNode.execute(wrapper);
        }
    }

    @ExportMessage
    static long asPointer(ValueWrapper wrapper, @Cached MarkingServiceNodes.KeepAliveNode keepAliveNode, @Cached @Cached.Exclusive InlinedBranchProfile taggedObjectProfile, @Bind(value="$node") Node node) {
        long handle = wrapper.getHandle();
        assert (handle != -2L);
        if (ValueWrapperManager.isTaggedObject(handle)) {
            taggedObjectProfile.enter(node);
            keepAliveNode.execute(wrapper);
        }
        return handle;
    }

    @ExportMessage
    protected boolean hasMembers() {
        return true;
    }

    @ExportMessage
    protected Object getMembers(boolean includeInternal) {
        return new VariableNamesObject(new String[]{"value"});
    }

    @ExportMessage
    protected boolean isMemberReadable(String member) {
        return "value".equals(member);
    }

    @ExportMessage
    static Object readMember(ValueWrapper wrapper, String member, @Cached @Cached.Exclusive InlinedBranchProfile errorProfile, @Bind(value="$node") Node node) throws UnknownIdentifierException {
        if ("value".equals(member)) {
            return wrapper.object;
        }
        errorProfile.enter(node);
        throw UnknownIdentifierException.create((String)member);
    }
}

