/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.cext;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.truffleruby.cext.UnwrapNode;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.core.symbol.CoreSymbols;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.control.RaiseException;

@GenerateUncached
@ReportPolymorphism
public abstract class IDToSymbolNode
extends RubyBaseNode {
    public abstract RubySymbol execute(Object var1);

    @Specialization(guards={"isStaticSymbol(value)"})
    RubySymbol unwrapStaticSymbol(long value, @Cached InlinedBranchProfile errorProfile) {
        int index = CoreSymbols.idToIndex(value);
        RubySymbol symbol = this.getLanguage().coreSymbols.STATIC_SYMBOLS[index];
        if (symbol == null) {
            errorProfile.enter((Node)this);
            throw new RaiseException(this.getContext(), this.coreExceptions().runtimeError(StringUtils.format("invalid static ID2SYM id: %d", value), this));
        }
        return symbol;
    }

    @Specialization(guards={"!isStaticSymbol(value)"})
    RubySymbol unwrapDynamicSymbol(Object value, @Cached UnwrapNode unwrapNode) {
        return (RubySymbol)unwrapNode.execute(this, value);
    }

    public static boolean isStaticSymbol(Object value) {
        if (!(value instanceof Long)) {
            return false;
        }
        return CoreSymbols.isStaticSymbol((Long)value);
    }
}

