/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.cext;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import org.truffleruby.RubyLanguage;
import org.truffleruby.interop.TranslateInteropExceptionNode;
import org.truffleruby.language.RubyGuards;

@ExportLibrary(value=InteropLibrary.class)
public final class DataHolder
implements TruffleObject {
    private Object pointer;
    private final Object marker;
    private Object free;

    public DataHolder(Object pointer, Object marker, Object free) {
        assert (RubyGuards.isForeignObject(pointer));
        assert (RubyGuards.isForeignObject(marker));
        assert (RubyGuards.isForeignObject(free));
        this.pointer = pointer;
        this.marker = marker;
        this.free = free;
    }

    public Object getPointer() {
        return this.pointer;
    }

    public void setPointer(Object pointer) {
        assert (RubyGuards.isForeignObject(pointer));
        this.pointer = pointer;
    }

    public Object getMarker() {
        return this.marker;
    }

    public Object getFree() {
        return this.free;
    }

    public void setFree(Object free) {
        assert (RubyGuards.isForeignObject(free));
        this.free = free;
    }

    @ExportMessage
    protected boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    protected Class<RubyLanguage> getLanguage() {
        return RubyLanguage.class;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.pointer.toString();
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    protected String toDisplayString(boolean allowSideEffects) {
        InteropLibrary interop = InteropLibrary.getUncached();
        try {
            return "DATA_HOLDER: " + interop.asString(interop.toDisplayString(this.pointer, allowSideEffects));
        }
        catch (UnsupportedMessageException e) {
            throw TranslateInteropExceptionNode.executeUncached((InteropException)((Object)e));
        }
    }
}

