/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.frame.VirtualFrame;
import java.util.Arrays;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.control.RaiseException;

public final class ReRaiseInlinedExceptionNode
extends RubyContextSourceNode {
    public final NodeFactory<? extends RubyBaseNode> nodeFactory;

    public ReRaiseInlinedExceptionNode(NodeFactory<? extends RubyBaseNode> nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object[] arguments = frame.getArguments();
        if (arguments.length != 1 || !(arguments[0] instanceof RaiseException)) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw CompilerDirectives.shouldNotReachHere((String)("CallTarget of always-inlined builtin should be called with a single RaiseException argument, but was called with: " + Arrays.toString(arguments)));
        }
        RaiseException raiseException = (RaiseException)arguments[0];
        RubyException rubyException = raiseException.getException();
        rubyException.backtrace = this.getContext().getCallStack().getBacktrace(this);
        throw new RaiseException(this.getContext(), rubyException);
    }

    @Override
    public RubyNode cloneUninitialized() {
        throw CompilerDirectives.shouldNotReachHere((String)(((Object)((Object)this)).getClass() + " should never be split"));
    }
}

