/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.aot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.source.Source;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.truffleruby.core.CoreLibrary;
import org.truffleruby.language.loader.ResourceLoader;
import org.truffleruby.parser.RubyDeferredWarnings;
import org.truffleruby.parser.RubySource;
import org.truffleruby.parser.TranslatorDriver;
import org.truffleruby.parser.ast.RootParseNode;
import org.truffleruby.parser.parser.ParserConfiguration;
import org.truffleruby.parser.scope.StaticScope;
import org.truffleruby.shared.options.OptionsCatalog;

public final class ParserCache {
    public static final Map<String, RootParseNode> INSTANCE;

    private static RubySource loadSource(String feature) {
        try {
            Source source = ResourceLoader.loadResource(feature, (Boolean)OptionsCatalog.CORE_AS_INTERNAL_KEY.getDefaultValue());
            return new RubySource(source, feature);
        }
        catch (IOException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    private static RootParseNode parse(RubySource source) {
        StaticScope staticScope = new StaticScope(StaticScope.Type.LOCAL, null);
        ParserConfiguration parserConfiguration = new ParserConfiguration(null, false, true, false);
        RubyDeferredWarnings rubyWarnings = new RubyDeferredWarnings();
        RootParseNode rootParseNode = TranslatorDriver.parseToJRubyAST(null, source, staticScope, parserConfiguration, rubyWarnings);
        if (!rubyWarnings.warnings.isEmpty()) {
            throw new RuntimeException("Core files should not emit warnings: " + String.join((CharSequence)"\n", rubyWarnings.warnings.stream().map(w -> w.getWarningMessage()).collect(Collectors.toList())));
        }
        return rootParseNode;
    }

    static {
        if (TruffleOptions.AOT) {
            String defaultCoreLibraryPath = (String)OptionsCatalog.CORE_LOAD_PATH_KEY.getDefaultValue();
            HashMap<String, RootParseNode> cache = new HashMap<String, RootParseNode>();
            for (String coreFile : CoreLibrary.CORE_FILES) {
                String path = (defaultCoreLibraryPath + coreFile).intern();
                RubySource source = ParserCache.loadSource(path);
                cache.put(path, ParserCache.parse(source));
            }
            INSTANCE = cache;
        } else {
            INSTANCE = null;
        }
    }
}

