/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.shell;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import org.graalvm.polyglot.Context;

abstract class ConsoleHandler {
    ConsoleHandler() {
    }

    public final String readLine() {
        return this.readLine(true);
    }

    public abstract String readLine(boolean var1);

    public abstract void setPrompt(String var1);

    public void setContext(Context context) {
    }

    public void setupReader(BooleanSupplier shouldRecord, IntSupplier getSize, Consumer<String> addItem, IntFunction<String> getItem, BiConsumer<Integer, String> setItem, IntConsumer removeItem, Runnable clear, Function<String, List<String>> completer) {
    }

    public InputStream createInputStream() {
        return new InputStream(){
            byte[] buffer = null;
            int pos = 0;

            @Override
            public int read() throws IOException {
                if (this.pos < 0) {
                    this.pos = 0;
                    return -1;
                }
                if (this.buffer == null) {
                    assert (this.pos == 0);
                    String line = ConsoleHandler.this.readLine(false);
                    if (line == null) {
                        return -1;
                    }
                    this.buffer = line.getBytes(StandardCharsets.UTF_8);
                }
                if (this.pos == this.buffer.length) {
                    this.buffer = null;
                    this.pos = -1;
                    return 10;
                }
                return this.buffer[this.pos++];
            }
        };
    }

    public int getTerminalWidth() {
        return 80;
    }

    public int getTerminalHeight() {
        return 25;
    }
}

