// CheckStyle: start generated
package com.oracle.graal.python.runtime;

import com.oracle.truffle.api.TruffleOptionDescriptors;
import com.oracle.truffle.api.dsl.GeneratedBy;
import java.util.Iterator;
import java.util.List;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionStability;
import org.graalvm.polyglot.SandboxPolicy;

@GeneratedBy(PythonOptions.class)
final class PythonOptionsOptionDescriptors implements TruffleOptionDescriptors {

    @Override
    public OptionDescriptor get(String optionName) {
        switch (optionName) {
            case "python.AlwaysRunExcepthook" :
                return OptionDescriptor.newBuilder(PythonOptions.AlwaysRunExcepthook, "python.AlwaysRunExcepthook").deprecated(false).help("This option is set by the Python launcher to tell the language it can print exceptions directly").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            case "python.AttributeAccessInlineCacheMaxDepth" :
                return OptionDescriptor.newBuilder(PythonOptions.AttributeAccessInlineCacheMaxDepth, "python.AttributeAccessInlineCacheMaxDepth").deprecated(false).help("").usageSyntax("<maxDepth>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "python.BackgroundGCTask" :
                return OptionDescriptor.newBuilder(PythonOptions.BackgroundGCTask, "python.BackgroundGCTask").deprecated(false).help("Whether the background GC task should be enabled (default) or not.").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "python.BackgroundGCTaskInterval" :
                return OptionDescriptor.newBuilder(PythonOptions.BackgroundGCTaskInterval, "python.BackgroundGCTaskInterval").deprecated(false).help("Specifies the interval (ms) for the background GC task to monitor the resident set size (RSS)").usageSyntax("<time>").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "python.BackgroundGCTaskMinimum" :
                return OptionDescriptor.newBuilder(PythonOptions.BackgroundGCTaskMinimum, "python.BackgroundGCTaskMinimum").deprecated(false).help("The minimum RSS memory (in megabytes) to start calling System.gc(). (default: 4 GB).").usageSyntax("<megabytes>").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "python.BackgroundGCTaskThreshold" :
                return OptionDescriptor.newBuilder(PythonOptions.BackgroundGCTaskThreshold, "python.BackgroundGCTaskThreshold").deprecated(false).help("The percentage increase in RSS memory between System.gc() calls. Low percentage will trigger System.gc() more often. (default: 30).").usageSyntax("<limit>").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "python.BaseExecutable" :
                return OptionDescriptor.newBuilder(PythonOptions.BaseExecutable, "python.BaseExecutable").deprecated(false).help("The sys._base_executable path. Set by the launcher, but may need to be overridden in certain special situations.").usageSyntax("<path>").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            case "python.BuiltinsInliningMaxCallerSize" :
                return OptionDescriptor.newBuilder(PythonOptions.BuiltinsInliningMaxCallerSize, "python.BuiltinsInliningMaxCallerSize").deprecated(false).help("Stop inlining of builtins if caller's cumulative tree size would exceed this limit").usageSyntax("<limit>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "python.CAPI" :
                return OptionDescriptor.newBuilder(PythonOptions.CAPI, "python.CAPI").deprecated(false).help("Set the location of C API home. Overrides any environment variables or Java options.").usageSyntax("<path>").category(OptionCategory.INTERNAL).stability(OptionStability.STABLE).build();
            case "python.CallSiteInlineCacheMaxDepth" :
                return OptionDescriptor.newBuilder(PythonOptions.CallSiteInlineCacheMaxDepth, "python.CallSiteInlineCacheMaxDepth").deprecated(false).help("").usageSyntax("<maxDepth>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "python.CatchAllExceptions" :
                return OptionDescriptor.newBuilder(PythonOptions.CatchAllExceptions, "python.CatchAllExceptions").deprecated(false).help("Enable catching all Exceptions in generic try-catch statements.").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "python.CatchGraalPythonExceptionForUnitTesting" :
                return OptionDescriptor.newBuilder(PythonOptions.CatchGraalPythonExceptionForUnitTesting, "python.CatchGraalPythonExceptionForUnitTesting").deprecated(false).help("").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "python.CheckHashPycsMode" :
                return OptionDescriptor.newBuilder(PythonOptions.CheckHashPycsMode, "python.CheckHashPycsMode").deprecated(false).help("Value of the --check-hash-based-pycs command line option- 'default' means the 'check_source' flag in hash-based pycs  determines invalidation- 'always' causes the interpreter to hash the source file for  invalidation regardless of value of 'check_source' bit- 'never' causes the interpreter to always assume hash-based pycs are  validThe default value is 'default'.See PEP 552 'Deterministic pycs' for more details.").usageSyntax("default|always|never").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            case "python.CompressionModulesBackend" :
                return OptionDescriptor.newBuilder(PythonOptions.CompressionModulesBackend, "python.CompressionModulesBackend").deprecated(false).help("Choose the backend for the Zlib, Bz2, and LZMA modules.").usageSyntax("java|native").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            case "python.CoreHome" :
                return OptionDescriptor.newBuilder(PythonOptions.CoreHome, "python.CoreHome").deprecated(false).help("Set the location of what is usually lib/graalpy<graalvm_major>.<graalvm_minor>. Overrides any environment variables or Java options.").usageSyntax("<path>").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            case "python.DisableFrozenModules" :
                return OptionDescriptor.newBuilder(PythonOptions.DisableFrozenModules, "python.DisableFrozenModules").deprecated(false).help("Disables using frozen modules.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "python.DontWriteBytecodeFlag" :
                return OptionDescriptor.newBuilder(PythonOptions.DontWriteBytecodeFlag, "python.DontWriteBytecodeFlag").deprecated(false).help("Equivalent to the Python -B flag. Don't write bytecode files.").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            case "python.EagerlyMaterializeInstrumentationNodes" :
                return OptionDescriptor.newBuilder(PythonOptions.EagerlyMaterializeInstrumentationNodes, "python.EagerlyMaterializeInstrumentationNodes").deprecated(false).help("Makes bytecode instrumentation node materialization eager instead of lazy.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "python.EmulateJython" :
                return OptionDescriptor.newBuilder(PythonOptions.EmulateJython, "python.EmulateJython").deprecated(false).help("Emulate some Jython features that can cause performance degradation").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            case "python.EnableDebuggingBuiltins" :
                return OptionDescriptor.newBuilder(PythonOptions.EnableDebuggingBuiltins, "python.EnableDebuggingBuiltins").deprecated(false).help("Enable built-in functions on the __graalpython__ module that are useful for debugging.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "python.EnableForcedSplits" :
                return OptionDescriptor.newBuilder(PythonOptions.EnableForcedSplits, "python.EnableForcedSplits").deprecated(false).help("Enable forced splitting (of builtins). Default false.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "python.Executable" :
                return OptionDescriptor.newBuilder(PythonOptions.Executable, "python.Executable").deprecated(false).help("The sys.executable path. Set by the launcher, but may need to be overridden in certain special situations.").usageSyntax("<path>").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            case "python.ExecutableList" :
                return OptionDescriptor.newBuilder(PythonOptions.ExecutableList, "python.ExecutableList").deprecated(false).help("The executed command list as string joined by the executable list separator char. This must always correspond to the real, valid command list used to run GraalPy.").usageSyntax("<cmdPart>[🏆<cmdPart>]").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "python.ExposeInternalSources" :
                return OptionDescriptor.newBuilder(PythonOptions.ExposeInternalSources, "python.ExposeInternalSources").deprecated(false).help("Expose internal sources as normal sources, so they will show up in the debugger and stacks").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "python.ForceImportSite" :
                return OptionDescriptor.newBuilder(PythonOptions.ForceImportSite, "python.ForceImportSite").deprecated(false).help("Force to automatically import site.py module.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            case "python.ForceInitializeSourceSections" :
                return OptionDescriptor.newBuilder(PythonOptions.ForceInitializeSourceSections, "python.ForceInitializeSourceSections").deprecated(false).help("Eagerly initialize source sections.").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "python.ForceInlineGeneratorCalls" :
                return OptionDescriptor.newBuilder(PythonOptions.ForceInlineGeneratorCalls, "python.ForceInlineGeneratorCalls").deprecated(false).help("").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "python.ForceSharingForInnerContexts" :
                return OptionDescriptor.newBuilder(PythonOptions.ForceSharingForInnerContexts, "python.ForceSharingForInnerContexts").deprecated(false).help("Forces AST sharing for inner contexts.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "python.HashSeed" :
                return OptionDescriptor.newBuilder(PythonOptions.HashSeed, "python.HashSeed").deprecated(false).help("Equivalent to setting PYTHONHASHSEED environment variable").usageSyntax("random|[0,4294967295]").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            case "python.IgnoreEnvironmentFlag" :
                return OptionDescriptor.newBuilder(PythonOptions.IgnoreEnvironmentFlag, "python.IgnoreEnvironmentFlag").deprecated(false).help("Equivalent to the Python -E flag. Ignore PYTHON* environment variables.").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            case "python.InitialLocale" :
                return OptionDescriptor.newBuilder(PythonOptions.InitialLocale, "python.InitialLocale").deprecated(false).help("Sets the language and territory, which will be used for initial locale. Format: 'language[_territory]', e.g., 'en_GB'. Leave empty to use the JVM default locale.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            case "python.InitialNativeMemory" :
                return OptionDescriptor.newBuilder(PythonOptions.InitialNativeMemory, "python.InitialNativeMemory").deprecated(false).help("Initial native memory heap size that triggers a GC (default: 256 MB).").usageSyntax("<bytes>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "python.InputFilePath" :
                return OptionDescriptor.newBuilder(PythonOptions.InputFilePath, "python.InputFilePath").deprecated(false).help("Used by the launcher to pass the path to be executed").usageSyntax("<path>").category(OptionCategory.INTERNAL).stability(OptionStability.STABLE).build();
            case "python.InspectFlag" :
                return OptionDescriptor.newBuilder(PythonOptions.InspectFlag, "python.InspectFlag").deprecated(false).help("Equivalent to the Python -i flag. Inspect interactively after running a script.").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            case "python.InstallSignalHandlers" :
                return OptionDescriptor.newBuilder(PythonOptions.InstallSignalHandlers, "python.InstallSignalHandlers").deprecated(false).help("Install default signal handlers on startup").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            case "python.IntMaxStrDigits" :
                return OptionDescriptor.newBuilder(PythonOptions.IntMaxStrDigits, "python.IntMaxStrDigits").deprecated(false).help("Equivalent to the Python -X int_max_str_digits option.").usageSyntax("").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            case "python.IsolateFlag" :
                return OptionDescriptor.newBuilder(PythonOptions.IsolateFlag, "python.IsolateFlag").deprecated(false).help("Equivalent to the Python -I flag. Isolate from the users environment by not adding the cwd to the path").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            case "python.IsolateNativeModules" :
                return OptionDescriptor.newBuilder(PythonOptions.IsolateNativeModules, "python.IsolateNativeModules").deprecated(false).help("Whether the context should isolate its loading of C extension modules. This allows more than one context to access C extensions. Note that all contexts in the operating system process must set this option to true to cooperatively allow this feature to work.").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build();
            case "python.LazyStrings" :
                return OptionDescriptor.newBuilder(PythonOptions.LazyStrings, "python.LazyStrings").deprecated(false).help("Switch on/off using lazy strings for performance reasons. Default true.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "python.MaxNativeMemory" :
                return OptionDescriptor.newBuilder(PythonOptions.MaxNativeMemory, "python.MaxNativeMemory").deprecated(false).help("Max native memory heap size (default: 8 GB).").usageSyntax("<bytes>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "python.NoAsyncActions" :
                return OptionDescriptor.newBuilder(PythonOptions.NoAsyncActions, "python.NoAsyncActions").deprecated(false).help("Disable weakref callback processing, signal handling, and other periodic async actions.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "python.NoSiteFlag" :
                return OptionDescriptor.newBuilder(PythonOptions.NoSiteFlag, "python.NoSiteFlag").deprecated(false).help("Equivalent to the Python -S flag. Don't imply 'import site' on initialization.").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            case "python.NoUserSiteFlag" :
                return OptionDescriptor.newBuilder(PythonOptions.NoUserSiteFlag, "python.NoUserSiteFlag").deprecated(false).help("Equivalent to the Python -s flag. Don't add user site directory to sys.path.").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            case "python.NodeRecursionLimit" :
                return OptionDescriptor.newBuilder(PythonOptions.NodeRecursionLimit, "python.NodeRecursionLimit").deprecated(false).help("").usageSyntax("<limit>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "python.OrigArgv" :
                return OptionDescriptor.newBuilder(PythonOptions.OrigArgv, "python.OrigArgv").deprecated(false).help("The list of the original command line arguments passed to the Python executable.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "python.OverallocateLiteralLists" :
                return OptionDescriptor.newBuilder(PythonOptions.OverallocateLiteralLists, "python.OverallocateLiteralLists").deprecated(false).help("Propagate append operations to lists created as literals back to where they were created, to inform overallocation to avoid having to grow them later.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "python.ParserLogFiles" :
                return OptionDescriptor.newBuilder(PythonOptions.ParserLogFiles, "python.ParserLogFiles").deprecated(false).help("Prints path to parsed files").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "python.ParserStatistics" :
                return OptionDescriptor.newBuilder(PythonOptions.ParserStatistics, "python.ParserStatistics").deprecated(false).help("Prints parser time statistics after number of parsed files, set by this option. 0 or <0 means no statistics are printed.").usageSyntax("<numFiles>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "python.PosixModuleBackend" :
                return OptionDescriptor.newBuilder(PythonOptions.PosixModuleBackend, "python.PosixModuleBackend").deprecated(false).help("Choose the backend for the POSIX module.").usageSyntax("java|native").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            case "python.PyCachePrefix" :
                return OptionDescriptor.newBuilder(PythonOptions.PyCachePrefix, "python.PyCachePrefix").deprecated(false).help("If this is set, GraalPy will write .pyc files in a mirror directory tree at this path, instead of in __pycache__ directories within the source tree. Equivalent to setting the PYTHONPYCACHEPREFIX environment variable for the standard launcher.").usageSyntax("<path>").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            case "python.PythonGC" :
                return OptionDescriptor.newBuilder(PythonOptions.PythonGC, "python.PythonGC").deprecated(false).help("Whether the Python GC should be enabled (default) or not.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "python.PythonHome" :
                return OptionDescriptor.newBuilder(PythonOptions.PythonHome, "python.PythonHome").deprecated(false).help("Set the home of Python. Equivalent of GRAAL_PYTHONHOME env variable. Determines default values for the CoreHome, StdLibHome, SysBasePrefix, SysPrefix.").usageSyntax("<path>").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            case "python.PythonOptimizeFlag" :
                return OptionDescriptor.newBuilder(PythonOptions.PythonOptimizeFlag, "python.PythonOptimizeFlag").deprecated(false).help("Remove assert statements and any code conditional on the value of __debug__.").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            case "python.PythonPath" :
                return OptionDescriptor.newBuilder(PythonOptions.PythonPath, "python.PythonPath").deprecated(false).help("Equivalent to setting the PYTHONPATH environment variable for the standard launcher. ':'-separated list of directories prefixed to the default module search path.").usageSyntax("<path>[:<path>]").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            case "python.QuietFlag" :
                return OptionDescriptor.newBuilder(PythonOptions.QuietFlag, "python.QuietFlag").deprecated(false).help("Equivalent to the Python -q flag. Don't  print version and copyright messages on interactive startup.").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            case "python.RunViaLauncher" :
                return OptionDescriptor.newBuilder(PythonOptions.RunViaLauncher, "python.RunViaLauncher").deprecated(false).help("Set by the launcher to true (false means that GraalPy is being embedded in an application).").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "python.SafePathFlag" :
                return OptionDescriptor.newBuilder(PythonOptions.SafePathFlag, "python.SafePathFlag").deprecated(false).help("Equivalent to the Python -P flag. Don't prepend a potentially unsafe path to sys.path").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            case "python.Sha3ModuleBackend" :
                return OptionDescriptor.newBuilder(PythonOptions.Sha3ModuleBackend, "python.Sha3ModuleBackend").deprecated(false).help("Choose the backend for the Sha3 module.").usageSyntax("java|native").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            case "python.StandardStreamEncoding" :
                return OptionDescriptor.newBuilder(PythonOptions.StandardStreamEncoding, "python.StandardStreamEncoding").deprecated(false).help("Equivalent to setting the PYTHONIOENCODING environment variable for the standard launcher.").usageSyntax("<Encoding>[:<errors>]").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            case "python.StdLibHome" :
                return OptionDescriptor.newBuilder(PythonOptions.StdLibHome, "python.StdLibHome").deprecated(false).help("Set the location of lib/python3.12. Overrides any environment variables or Java options.").usageSyntax("<path>").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            case "python.SysBasePrefix" :
                return OptionDescriptor.newBuilder(PythonOptions.SysBasePrefix, "python.SysBasePrefix").deprecated(false).help("Set the location of sys.base_prefix. Overrides any environment variables or Java options.").usageSyntax("<path>").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            case "python.SysPrefix" :
                return OptionDescriptor.newBuilder(PythonOptions.SysPrefix, "python.SysPrefix").deprecated(false).help("Set the location of sys.prefix. Overrides any environment variables or Java options.").usageSyntax("<path>").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            case "python.TRegexUsesSREFallback" :
                return OptionDescriptor.newBuilder(PythonOptions.TRegexUsesSREFallback, "python.TRegexUsesSREFallback").deprecated(false).help("Use the CPython sre engine as a fallback to the TRegex engine.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "python.TerminalHeight" :
                return OptionDescriptor.newBuilder(PythonOptions.TerminalHeight, "python.TerminalHeight").deprecated(false).help("Set by the launcher to the terminal height.").usageSyntax("<height>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "python.TerminalIsInteractive" :
                return OptionDescriptor.newBuilder(PythonOptions.TerminalIsInteractive, "python.TerminalIsInteractive").deprecated(false).help("Set by the launcher if an interactive console is used to run Python.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "python.TerminalWidth" :
                return OptionDescriptor.newBuilder(PythonOptions.TerminalWidth, "python.TerminalWidth").deprecated(false).help("Set by the launcher to the terminal width.").usageSyntax("<width>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "python.TraceNativeMemory" :
                return OptionDescriptor.newBuilder(PythonOptions.TraceNativeMemory, "python.TraceNativeMemory").deprecated(false).help("Enable tracing of native memory (ATTENTION: this will have significant impact on CExt execution performance).").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "python.TraceNativeMemoryCalls" :
                return OptionDescriptor.newBuilder(PythonOptions.TraceNativeMemoryCalls, "python.TraceNativeMemoryCalls").deprecated(false).help("If native memory tracing is enabled, also capture stack.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "python.UnbufferedIO" :
                return OptionDescriptor.newBuilder(PythonOptions.UnbufferedIO, "python.UnbufferedIO").deprecated(false).help("Equivalent to the Python -u flag. Force stdout and stderr to be unbuffered.").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            case "python.UseNativePrimitiveStorageStrategy" :
                return OptionDescriptor.newBuilder(PythonOptions.UseNativePrimitiveStorageStrategy, "python.UseNativePrimitiveStorageStrategy").deprecated(false).help("If true, uses native storage strategy for primitive types").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "python.UsePanama" :
                return OptionDescriptor.newBuilder(PythonOptions.UsePanama, "python.UsePanama").deprecated(false).help("Use the panama backend for NFI.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "python.UseReprForPrintString" :
                return OptionDescriptor.newBuilder(PythonOptions.UseReprForPrintString, "python.UseReprForPrintString").deprecated(false).help("Embedder option: what to print in response to PythonLanguage#toString.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "python.VariableArgumentInlineCacheLimit" :
                return OptionDescriptor.newBuilder(PythonOptions.VariableArgumentInlineCacheLimit, "python.VariableArgumentInlineCacheLimit").deprecated(false).help("").usageSyntax("<limit>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "python.VariableArgumentReadUnrollingLimit" :
                return OptionDescriptor.newBuilder(PythonOptions.VariableArgumentReadUnrollingLimit, "python.VariableArgumentReadUnrollingLimit").deprecated(false).help("").usageSyntax("<limit>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "python.VenvlauncherCommand" :
                return OptionDescriptor.newBuilder(PythonOptions.VenvlauncherCommand, "python.VenvlauncherCommand").deprecated(false).help("Option used by the venvlauncher to pass on the launcher target command").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            case "python.VerboseFlag" :
                return OptionDescriptor.newBuilder(PythonOptions.VerboseFlag, "python.VerboseFlag").deprecated(false).help("Equivalent to the Python -v flag. Turn on verbose mode.").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            case "python.WarnDefaultEncodingFlag" :
                return OptionDescriptor.newBuilder(PythonOptions.WarnDefaultEncodingFlag, "python.WarnDefaultEncodingFlag").deprecated(false).help("Equivalent to the Python -X warn_default_encoding flag. Enable opt-in EncodingWarning for 'encoding=None'").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            case "python.WarnExperimentalFeatures" :
                return OptionDescriptor.newBuilder(PythonOptions.WarnExperimentalFeatures, "python.WarnExperimentalFeatures").deprecated(false).help("Print warnings when using experimental features at runtime.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build();
            case "python.WarnOptions" :
                return OptionDescriptor.newBuilder(PythonOptions.WarnOptions, "python.WarnOptions").deprecated(false).help("Equivalent to setting the PYTHONWARNINGS environment variable for the standard launcher.").usageSyntax("<action>[:<message>[:<category>[:<module>[:<line>]]]][,<action>[:<message>[:<category>[:<module>[:<line>]]]]]").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            case "python.WithCachedSources" :
                return OptionDescriptor.newBuilder(PythonOptions.WithCachedSources, "python.WithCachedSources").deprecated(false).help("Determines wether context startup tries to re-use previously cached sources of the core library.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "python.WithJavaStacktrace" :
                return OptionDescriptor.newBuilder(PythonOptions.WithJavaStacktrace, "python.WithJavaStacktrace").deprecated(false).help("Print the Java stacktrace for exceptions. Possible modes:    0   Do not print any Java stacktraces.    1   Print Java stacktrace for Java exceptions only (default).    2   Print Java stacktrace for Python exceptions only (ATTENTION: this will have a notable performance impact).    3   Combines 1 and 2.").usageSyntax("0|1|2|3").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "python.WithTRegex" :
                return OptionDescriptor.newBuilder(PythonOptions.WithTRegex, "python.WithTRegex").deprecated(false).help("Use the optimized TRegex engine. Default true").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
        }
        return null;
    }

    @Override
    public SandboxPolicy getSandboxPolicy(String optionName) {
        assert get(optionName) != null : "Unknown option " + optionName;
        return SandboxPolicy.TRUSTED;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return List.of(
            OptionDescriptor.newBuilder(PythonOptions.AlwaysRunExcepthook, "python.AlwaysRunExcepthook").deprecated(false).help("This option is set by the Python launcher to tell the language it can print exceptions directly").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.AttributeAccessInlineCacheMaxDepth, "python.AttributeAccessInlineCacheMaxDepth").deprecated(false).help("").usageSyntax("<maxDepth>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.BackgroundGCTask, "python.BackgroundGCTask").deprecated(false).help("Whether the background GC task should be enabled (default) or not.").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.BackgroundGCTaskInterval, "python.BackgroundGCTaskInterval").deprecated(false).help("Specifies the interval (ms) for the background GC task to monitor the resident set size (RSS)").usageSyntax("<time>").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.BackgroundGCTaskMinimum, "python.BackgroundGCTaskMinimum").deprecated(false).help("The minimum RSS memory (in megabytes) to start calling System.gc(). (default: 4 GB).").usageSyntax("<megabytes>").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.BackgroundGCTaskThreshold, "python.BackgroundGCTaskThreshold").deprecated(false).help("The percentage increase in RSS memory between System.gc() calls. Low percentage will trigger System.gc() more often. (default: 30).").usageSyntax("<limit>").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.BaseExecutable, "python.BaseExecutable").deprecated(false).help("The sys._base_executable path. Set by the launcher, but may need to be overridden in certain special situations.").usageSyntax("<path>").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.BuiltinsInliningMaxCallerSize, "python.BuiltinsInliningMaxCallerSize").deprecated(false).help("Stop inlining of builtins if caller's cumulative tree size would exceed this limit").usageSyntax("<limit>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.CAPI, "python.CAPI").deprecated(false).help("Set the location of C API home. Overrides any environment variables or Java options.").usageSyntax("<path>").category(OptionCategory.INTERNAL).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.CallSiteInlineCacheMaxDepth, "python.CallSiteInlineCacheMaxDepth").deprecated(false).help("").usageSyntax("<maxDepth>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.CatchAllExceptions, "python.CatchAllExceptions").deprecated(false).help("Enable catching all Exceptions in generic try-catch statements.").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.CatchGraalPythonExceptionForUnitTesting, "python.CatchGraalPythonExceptionForUnitTesting").deprecated(false).help("").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.CheckHashPycsMode, "python.CheckHashPycsMode").deprecated(false).help("Value of the --check-hash-based-pycs command line option- 'default' means the 'check_source' flag in hash-based pycs  determines invalidation- 'always' causes the interpreter to hash the source file for  invalidation regardless of value of 'check_source' bit- 'never' causes the interpreter to always assume hash-based pycs are  validThe default value is 'default'.See PEP 552 'Deterministic pycs' for more details.").usageSyntax("default|always|never").category(OptionCategory.USER).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.CompressionModulesBackend, "python.CompressionModulesBackend").deprecated(false).help("Choose the backend for the Zlib, Bz2, and LZMA modules.").usageSyntax("java|native").category(OptionCategory.USER).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.CoreHome, "python.CoreHome").deprecated(false).help("Set the location of what is usually lib/graalpy<graalvm_major>.<graalvm_minor>. Overrides any environment variables or Java options.").usageSyntax("<path>").category(OptionCategory.USER).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.DisableFrozenModules, "python.DisableFrozenModules").deprecated(false).help("Disables using frozen modules.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.DontWriteBytecodeFlag, "python.DontWriteBytecodeFlag").deprecated(false).help("Equivalent to the Python -B flag. Don't write bytecode files.").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.EagerlyMaterializeInstrumentationNodes, "python.EagerlyMaterializeInstrumentationNodes").deprecated(false).help("Makes bytecode instrumentation node materialization eager instead of lazy.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.EmulateJython, "python.EmulateJython").deprecated(false).help("Emulate some Jython features that can cause performance degradation").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.EnableDebuggingBuiltins, "python.EnableDebuggingBuiltins").deprecated(false).help("Enable built-in functions on the __graalpython__ module that are useful for debugging.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.EnableForcedSplits, "python.EnableForcedSplits").deprecated(false).help("Enable forced splitting (of builtins). Default false.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.Executable, "python.Executable").deprecated(false).help("The sys.executable path. Set by the launcher, but may need to be overridden in certain special situations.").usageSyntax("<path>").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.ExecutableList, "python.ExecutableList").deprecated(false).help("The executed command list as string joined by the executable list separator char. This must always correspond to the real, valid command list used to run GraalPy.").usageSyntax("<cmdPart>[🏆<cmdPart>]").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.ExposeInternalSources, "python.ExposeInternalSources").deprecated(false).help("Expose internal sources as normal sources, so they will show up in the debugger and stacks").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.ForceImportSite, "python.ForceImportSite").deprecated(false).help("Force to automatically import site.py module.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.ForceInitializeSourceSections, "python.ForceInitializeSourceSections").deprecated(false).help("Eagerly initialize source sections.").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.ForceInlineGeneratorCalls, "python.ForceInlineGeneratorCalls").deprecated(false).help("").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.ForceSharingForInnerContexts, "python.ForceSharingForInnerContexts").deprecated(false).help("Forces AST sharing for inner contexts.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.HashSeed, "python.HashSeed").deprecated(false).help("Equivalent to setting PYTHONHASHSEED environment variable").usageSyntax("random|[0,4294967295]").category(OptionCategory.USER).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.IgnoreEnvironmentFlag, "python.IgnoreEnvironmentFlag").deprecated(false).help("Equivalent to the Python -E flag. Ignore PYTHON* environment variables.").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.InitialLocale, "python.InitialLocale").deprecated(false).help("Sets the language and territory, which will be used for initial locale. Format: 'language[_territory]', e.g., 'en_GB'. Leave empty to use the JVM default locale.").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.InitialNativeMemory, "python.InitialNativeMemory").deprecated(false).help("Initial native memory heap size that triggers a GC (default: 256 MB).").usageSyntax("<bytes>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.InputFilePath, "python.InputFilePath").deprecated(false).help("Used by the launcher to pass the path to be executed").usageSyntax("<path>").category(OptionCategory.INTERNAL).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.InspectFlag, "python.InspectFlag").deprecated(false).help("Equivalent to the Python -i flag. Inspect interactively after running a script.").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.InstallSignalHandlers, "python.InstallSignalHandlers").deprecated(false).help("Install default signal handlers on startup").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.IntMaxStrDigits, "python.IntMaxStrDigits").deprecated(false).help("Equivalent to the Python -X int_max_str_digits option.").usageSyntax("").category(OptionCategory.USER).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.IsolateFlag, "python.IsolateFlag").deprecated(false).help("Equivalent to the Python -I flag. Isolate from the users environment by not adding the cwd to the path").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.IsolateNativeModules, "python.IsolateNativeModules").deprecated(false).help("Whether the context should isolate its loading of C extension modules. This allows more than one context to access C extensions. Note that all contexts in the operating system process must set this option to true to cooperatively allow this feature to work.").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.LazyStrings, "python.LazyStrings").deprecated(false).help("Switch on/off using lazy strings for performance reasons. Default true.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.MaxNativeMemory, "python.MaxNativeMemory").deprecated(false).help("Max native memory heap size (default: 8 GB).").usageSyntax("<bytes>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.NoAsyncActions, "python.NoAsyncActions").deprecated(false).help("Disable weakref callback processing, signal handling, and other periodic async actions.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.NoSiteFlag, "python.NoSiteFlag").deprecated(false).help("Equivalent to the Python -S flag. Don't imply 'import site' on initialization.").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.NoUserSiteFlag, "python.NoUserSiteFlag").deprecated(false).help("Equivalent to the Python -s flag. Don't add user site directory to sys.path.").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.NodeRecursionLimit, "python.NodeRecursionLimit").deprecated(false).help("").usageSyntax("<limit>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.OrigArgv, "python.OrigArgv").deprecated(false).help("The list of the original command line arguments passed to the Python executable.").usageSyntax("").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.OverallocateLiteralLists, "python.OverallocateLiteralLists").deprecated(false).help("Propagate append operations to lists created as literals back to where they were created, to inform overallocation to avoid having to grow them later.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.ParserLogFiles, "python.ParserLogFiles").deprecated(false).help("Prints path to parsed files").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.ParserStatistics, "python.ParserStatistics").deprecated(false).help("Prints parser time statistics after number of parsed files, set by this option. 0 or <0 means no statistics are printed.").usageSyntax("<numFiles>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.PosixModuleBackend, "python.PosixModuleBackend").deprecated(false).help("Choose the backend for the POSIX module.").usageSyntax("java|native").category(OptionCategory.USER).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.PyCachePrefix, "python.PyCachePrefix").deprecated(false).help("If this is set, GraalPy will write .pyc files in a mirror directory tree at this path, instead of in __pycache__ directories within the source tree. Equivalent to setting the PYTHONPYCACHEPREFIX environment variable for the standard launcher.").usageSyntax("<path>").category(OptionCategory.USER).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.PythonGC, "python.PythonGC").deprecated(false).help("Whether the Python GC should be enabled (default) or not.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.PythonHome, "python.PythonHome").deprecated(false).help("Set the home of Python. Equivalent of GRAAL_PYTHONHOME env variable. Determines default values for the CoreHome, StdLibHome, SysBasePrefix, SysPrefix.").usageSyntax("<path>").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.PythonOptimizeFlag, "python.PythonOptimizeFlag").deprecated(false).help("Remove assert statements and any code conditional on the value of __debug__.").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.PythonPath, "python.PythonPath").deprecated(false).help("Equivalent to setting the PYTHONPATH environment variable for the standard launcher. ':'-separated list of directories prefixed to the default module search path.").usageSyntax("<path>[:<path>]").category(OptionCategory.USER).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.QuietFlag, "python.QuietFlag").deprecated(false).help("Equivalent to the Python -q flag. Don't  print version and copyright messages on interactive startup.").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.RunViaLauncher, "python.RunViaLauncher").deprecated(false).help("Set by the launcher to true (false means that GraalPy is being embedded in an application).").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.SafePathFlag, "python.SafePathFlag").deprecated(false).help("Equivalent to the Python -P flag. Don't prepend a potentially unsafe path to sys.path").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.Sha3ModuleBackend, "python.Sha3ModuleBackend").deprecated(false).help("Choose the backend for the Sha3 module.").usageSyntax("java|native").category(OptionCategory.USER).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.StandardStreamEncoding, "python.StandardStreamEncoding").deprecated(false).help("Equivalent to setting the PYTHONIOENCODING environment variable for the standard launcher.").usageSyntax("<Encoding>[:<errors>]").category(OptionCategory.USER).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.StdLibHome, "python.StdLibHome").deprecated(false).help("Set the location of lib/python3.12. Overrides any environment variables or Java options.").usageSyntax("<path>").category(OptionCategory.USER).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.SysBasePrefix, "python.SysBasePrefix").deprecated(false).help("Set the location of sys.base_prefix. Overrides any environment variables or Java options.").usageSyntax("<path>").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.SysPrefix, "python.SysPrefix").deprecated(false).help("Set the location of sys.prefix. Overrides any environment variables or Java options.").usageSyntax("<path>").category(OptionCategory.USER).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.TRegexUsesSREFallback, "python.TRegexUsesSREFallback").deprecated(false).help("Use the CPython sre engine as a fallback to the TRegex engine.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.TerminalHeight, "python.TerminalHeight").deprecated(false).help("Set by the launcher to the terminal height.").usageSyntax("<height>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.TerminalIsInteractive, "python.TerminalIsInteractive").deprecated(false).help("Set by the launcher if an interactive console is used to run Python.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.TerminalWidth, "python.TerminalWidth").deprecated(false).help("Set by the launcher to the terminal width.").usageSyntax("<width>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.TraceNativeMemory, "python.TraceNativeMemory").deprecated(false).help("Enable tracing of native memory (ATTENTION: this will have significant impact on CExt execution performance).").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.TraceNativeMemoryCalls, "python.TraceNativeMemoryCalls").deprecated(false).help("If native memory tracing is enabled, also capture stack.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.UnbufferedIO, "python.UnbufferedIO").deprecated(false).help("Equivalent to the Python -u flag. Force stdout and stderr to be unbuffered.").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.UseNativePrimitiveStorageStrategy, "python.UseNativePrimitiveStorageStrategy").deprecated(false).help("If true, uses native storage strategy for primitive types").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.UsePanama, "python.UsePanama").deprecated(false).help("Use the panama backend for NFI.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.UseReprForPrintString, "python.UseReprForPrintString").deprecated(false).help("Embedder option: what to print in response to PythonLanguage#toString.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.VariableArgumentInlineCacheLimit, "python.VariableArgumentInlineCacheLimit").deprecated(false).help("").usageSyntax("<limit>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.VariableArgumentReadUnrollingLimit, "python.VariableArgumentReadUnrollingLimit").deprecated(false).help("").usageSyntax("<limit>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.VenvlauncherCommand, "python.VenvlauncherCommand").deprecated(false).help("Option used by the venvlauncher to pass on the launcher target command").usageSyntax("").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.VerboseFlag, "python.VerboseFlag").deprecated(false).help("Equivalent to the Python -v flag. Turn on verbose mode.").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.WarnDefaultEncodingFlag, "python.WarnDefaultEncodingFlag").deprecated(false).help("Equivalent to the Python -X warn_default_encoding flag. Enable opt-in EncodingWarning for 'encoding=None'").usageSyntax("true|false").category(OptionCategory.USER).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.WarnExperimentalFeatures, "python.WarnExperimentalFeatures").deprecated(false).help("Print warnings when using experimental features at runtime.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.WarnOptions, "python.WarnOptions").deprecated(false).help("Equivalent to setting the PYTHONWARNINGS environment variable for the standard launcher.").usageSyntax("<action>[:<message>[:<category>[:<module>[:<line>]]]][,<action>[:<message>[:<category>[:<module>[:<line>]]]]]").category(OptionCategory.USER).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(PythonOptions.WithCachedSources, "python.WithCachedSources").deprecated(false).help("Determines wether context startup tries to re-use previously cached sources of the core library.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.WithJavaStacktrace, "python.WithJavaStacktrace").deprecated(false).help("Print the Java stacktrace for exceptions. Possible modes:    0   Do not print any Java stacktraces.    1   Print Java stacktrace for Java exceptions only (default).    2   Print Java stacktrace for Python exceptions only (ATTENTION: this will have a notable performance impact).    3   Combines 1 and 2.").usageSyntax("0|1|2|3").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(PythonOptions.WithTRegex, "python.WithTRegex").deprecated(false).help("Use the optimized TRegex engine. Default true").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build())
        .iterator();
    }

}
