// CheckStyle: start generated
package com.oracle.graal.python.nodes.util;

import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNodeGen;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.RequiredField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;

/**
 * Debug Info: <pre>
 *   Specialization {@link CastToJavaShortNode#fromShort}
 *     Activation probability: 0.23929
 *     With/without class size: 6/0 bytes
 *   Specialization {@link CastToJavaShortNode#fromInt}
 *     Activation probability: 0.20714
 *     With/without class size: 6/0 bytes
 *   Specialization {@link CastToJavaShortNode#fromLong}
 *     Activation probability: 0.17500
 *     With/without class size: 6/0 bytes
 *   Specialization {@link CastToJavaShortNode#fromPInt}
 *     Activation probability: 0.14286
 *     With/without class size: 5/0 bytes
 *   Specialization {@link CastToJavaShortNode#fromIntErr}
 *     Activation probability: 0.11071
 *     With/without class size: 5/0 bytes
 *   Specialization {@link CastToJavaShortNode#fromLongErr}
 *     Activation probability: 0.07857
 *     With/without class size: 5/0 bytes
 *   Specialization {@link CastToJavaShortNode#fromPIntErr}
 *     Activation probability: 0.04643
 *     With/without class size: 4/0 bytes
 * </pre> */
@GeneratedBy(CastToJavaShortNode.class)
@SuppressWarnings("javadoc")
public final class CastToJavaShortNodeGen {

    private static final Uncached UNCACHED = new Uncached();

    @TruffleBoundary
    private static UnsupportedSpecializationException newUnsupportedSpecializationException2(Node thisNode_, Object arg0Value, Object arg1Value) {
        return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value);
    }

    @NeverDefault
    public static CastToJavaShortNode getUncached() {
        return CastToJavaShortNodeGen.UNCACHED;
    }

    /**
     * Required Fields: <ul>
     * <li>{@link Inlined#state_0_}
     * </ul> */
    @NeverDefault
    public static CastToJavaShortNode inline(@RequiredField(bits = 11, value = StateField.class) InlineTarget target) {
        return new CastToJavaShortNodeGen.Inlined(target);
    }

    @GeneratedBy(CastToJavaShortNode.class)
    @DenyReplace
    private static final class Inlined extends CastToJavaShortNode implements UnadoptableNode {

        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link CastToJavaShortNode#fromShort}
         *   1: SpecializationActive {@link CastToJavaShortNode#fromInt}
         *   2: SpecializationExcluded {@link CastToJavaShortNode#fromInt}
         *   3: SpecializationActive {@link CastToJavaShortNode#fromIntErr}
         *   4: SpecializationActive {@link CastToJavaShortNode#fromLong}
         *   5: SpecializationExcluded {@link CastToJavaShortNode#fromLong}
         *   6: SpecializationActive {@link CastToJavaShortNode#fromLongErr}
         *   7: SpecializationActive {@link CastToJavaShortNode#fromPInt}
         *   8: SpecializationExcluded {@link CastToJavaShortNode#fromPInt}
         *   9: SpecializationActive {@link CastToJavaShortNode#fromPIntErr}
         *   10: InlinedCache
         *        Specialization: {@link CastToJavaShortNode#fromIntErr}
         *        Parameter: {@link PRaiseNode} raiseNode
         *        Inline method: {@link PRaiseNodeGen#inline}
         * </pre> */
        private final StateField state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link CastToJavaShortNode#fromIntErr}
         *   Parameter: {@link PRaiseNode} raiseNode
         *   Inline method: {@link PRaiseNodeGen#inline}</pre> */
        private final PRaiseNode raiseNode;

        private Inlined(InlineTarget target) {
            assert target.getTargetClass().isAssignableFrom(CastToJavaShortNode.class);
            this.state_0_ = target.getState(0, 11);
            this.raiseNode = PRaiseNodeGen.inline(InlineTarget.create(PRaiseNode.class, state_0_.subUpdater(10, 1)));
        }

        @Override
        public short execute(Node arg0Value, Object arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if ((state_0 & 0b1011011011) != 0 /* is SpecializationActive[CastToJavaShortNode.fromShort(short)] || SpecializationActive[CastToJavaShortNode.fromInt(int)] || SpecializationActive[CastToJavaShortNode.fromLong(long)] || SpecializationActive[CastToJavaShortNode.fromPInt(PInt)] || SpecializationActive[CastToJavaShortNode.fromIntErr(Node, int, PRaiseNode)] || SpecializationActive[CastToJavaShortNode.fromLongErr(Node, long, PRaiseNode)] || SpecializationActive[CastToJavaShortNode.fromPIntErr(Node, PInt, PRaiseNode)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[CastToJavaShortNode.fromShort(short)] */ && arg1Value instanceof Short) {
                    short arg1Value_ = (short) arg1Value;
                    return CastToJavaShortNode.fromShort(arg1Value_);
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[CastToJavaShortNode.fromInt(int)] */ && arg1Value instanceof Integer) {
                    int arg1Value_ = (int) arg1Value;
                    try {
                        return CastToJavaShortNode.fromInt(arg1Value_);
                    } catch (OverflowException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_.get(arg0Value);
                        state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[CastToJavaShortNode.fromInt(int)] */;
                        state_0 = state_0 | 0b100 /* add SpecializationExcluded  */;
                        this.state_0_.set(arg0Value, state_0);
                        return executeAndSpecialize(arg0Value, arg1Value_);
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[CastToJavaShortNode.fromLong(long)] */ && arg1Value instanceof Long) {
                    long arg1Value_ = (long) arg1Value;
                    try {
                        return CastToJavaShortNode.fromLong(arg1Value_);
                    } catch (OverflowException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_.get(arg0Value);
                        state_0 = state_0 & 0xffffffef /* remove SpecializationActive[CastToJavaShortNode.fromLong(long)] */;
                        state_0 = state_0 | 0b100000 /* add SpecializationExcluded  */;
                        this.state_0_.set(arg0Value, state_0);
                        return executeAndSpecialize(arg0Value, arg1Value_);
                    }
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[CastToJavaShortNode.fromPInt(PInt)] */ && arg1Value instanceof PInt) {
                    PInt arg1Value_ = (PInt) arg1Value;
                    try {
                        return CastToJavaShortNode.fromPInt(arg1Value_);
                    } catch (ArithmeticException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_.get(arg0Value);
                        state_0 = state_0 & 0xffffff7f /* remove SpecializationActive[CastToJavaShortNode.fromPInt(PInt)] */;
                        state_0 = state_0 | 0b100000000 /* add SpecializationExcluded  */;
                        this.state_0_.set(arg0Value, state_0);
                        return executeAndSpecialize(arg0Value, arg1Value_);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[CastToJavaShortNode.fromIntErr(Node, int, PRaiseNode)] */ && arg1Value instanceof Integer) {
                    int arg1Value_ = (int) arg1Value;
                    return CastToJavaShortNode.fromIntErr(arg0Value, arg1Value_, this.raiseNode);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[CastToJavaShortNode.fromLongErr(Node, long, PRaiseNode)] */ && arg1Value instanceof Long) {
                    long arg1Value_ = (long) arg1Value;
                    return CastToJavaShortNode.fromLongErr(arg0Value, arg1Value_, this.raiseNode);
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[CastToJavaShortNode.fromPIntErr(Node, PInt, PRaiseNode)] */ && arg1Value instanceof PInt) {
                    PInt arg1Value_ = (PInt) arg1Value;
                    return CastToJavaShortNode.fromPIntErr(arg0Value, arg1Value_, this.raiseNode);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        @Override
        public short execute(Node arg0Value, int arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if ((state_0 & 0b1010) != 0 /* is SpecializationActive[CastToJavaShortNode.fromInt(int)] || SpecializationActive[CastToJavaShortNode.fromIntErr(Node, int, PRaiseNode)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[CastToJavaShortNode.fromInt(int)] */) {
                    try {
                        return CastToJavaShortNode.fromInt(arg1Value);
                    } catch (OverflowException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_.get(arg0Value);
                        state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[CastToJavaShortNode.fromInt(int)] */;
                        state_0 = state_0 | 0b100 /* add SpecializationExcluded  */;
                        this.state_0_.set(arg0Value, state_0);
                        return executeAndSpecialize(arg0Value, arg1Value);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[CastToJavaShortNode.fromIntErr(Node, int, PRaiseNode)] */) {
                    return CastToJavaShortNode.fromIntErr(arg0Value, arg1Value, this.raiseNode);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        @Override
        public short execute(Node arg0Value, long arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if ((state_0 & 0b1010000) != 0 /* is SpecializationActive[CastToJavaShortNode.fromLong(long)] || SpecializationActive[CastToJavaShortNode.fromLongErr(Node, long, PRaiseNode)] */) {
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[CastToJavaShortNode.fromLong(long)] */) {
                    try {
                        return CastToJavaShortNode.fromLong(arg1Value);
                    } catch (OverflowException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_.get(arg0Value);
                        state_0 = state_0 & 0xffffffef /* remove SpecializationActive[CastToJavaShortNode.fromLong(long)] */;
                        state_0 = state_0 | 0b100000 /* add SpecializationExcluded  */;
                        this.state_0_.set(arg0Value, state_0);
                        return executeAndSpecialize(arg0Value, arg1Value);
                    }
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[CastToJavaShortNode.fromLongErr(Node, long, PRaiseNode)] */) {
                    return CastToJavaShortNode.fromLongErr(arg0Value, arg1Value, this.raiseNode);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        @Override
        public short execute(Node arg0Value, short arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[CastToJavaShortNode.fromShort(short)] */) {
                return CastToJavaShortNode.fromShort(arg1Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private short executeAndSpecialize(Node arg0Value, Object arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if (arg1Value instanceof Short) {
                short arg1Value_ = (short) arg1Value;
                state_0 = state_0 | 0b1 /* add SpecializationActive[CastToJavaShortNode.fromShort(short)] */;
                this.state_0_.set(arg0Value, state_0);
                return CastToJavaShortNode.fromShort(arg1Value_);
            }
            if (((state_0 & 0b1000)) == 0 /* is-not SpecializationActive[CastToJavaShortNode.fromIntErr(Node, int, PRaiseNode)] */ && ((state_0 & 0b100)) == 0 /* is-not SpecializationExcluded  */ && arg1Value instanceof Integer) {
                int arg1Value_ = (int) arg1Value;
                state_0 = state_0 | 0b10 /* add SpecializationActive[CastToJavaShortNode.fromInt(int)] */;
                this.state_0_.set(arg0Value, state_0);
                try {
                    return CastToJavaShortNode.fromInt(arg1Value_);
                } catch (OverflowException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_.get(arg0Value);
                    state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[CastToJavaShortNode.fromInt(int)] */;
                    state_0 = state_0 | 0b100 /* add SpecializationExcluded  */;
                    this.state_0_.set(arg0Value, state_0);
                    return executeAndSpecialize(arg0Value, arg1Value_);
                }
            }
            if (((state_0 & 0b1000000)) == 0 /* is-not SpecializationActive[CastToJavaShortNode.fromLongErr(Node, long, PRaiseNode)] */ && ((state_0 & 0b100000)) == 0 /* is-not SpecializationExcluded  */ && arg1Value instanceof Long) {
                long arg1Value_ = (long) arg1Value;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[CastToJavaShortNode.fromLong(long)] */;
                this.state_0_.set(arg0Value, state_0);
                try {
                    return CastToJavaShortNode.fromLong(arg1Value_);
                } catch (OverflowException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_.get(arg0Value);
                    state_0 = state_0 & 0xffffffef /* remove SpecializationActive[CastToJavaShortNode.fromLong(long)] */;
                    state_0 = state_0 | 0b100000 /* add SpecializationExcluded  */;
                    this.state_0_.set(arg0Value, state_0);
                    return executeAndSpecialize(arg0Value, arg1Value_);
                }
            }
            if (((state_0 & 0b1000000000)) == 0 /* is-not SpecializationActive[CastToJavaShortNode.fromPIntErr(Node, PInt, PRaiseNode)] */ && ((state_0 & 0b100000000)) == 0 /* is-not SpecializationExcluded  */ && arg1Value instanceof PInt) {
                PInt arg1Value_ = (PInt) arg1Value;
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[CastToJavaShortNode.fromPInt(PInt)] */;
                this.state_0_.set(arg0Value, state_0);
                try {
                    return CastToJavaShortNode.fromPInt(arg1Value_);
                } catch (ArithmeticException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_.get(arg0Value);
                    state_0 = state_0 & 0xffffff7f /* remove SpecializationActive[CastToJavaShortNode.fromPInt(PInt)] */;
                    state_0 = state_0 | 0b100000000 /* add SpecializationExcluded  */;
                    this.state_0_.set(arg0Value, state_0);
                    return executeAndSpecialize(arg0Value, arg1Value_);
                }
            }
            if (arg1Value instanceof Integer) {
                int arg1Value_ = (int) arg1Value;
                state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[CastToJavaShortNode.fromInt(int)] */;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[CastToJavaShortNode.fromIntErr(Node, int, PRaiseNode)] */;
                this.state_0_.set(arg0Value, state_0);
                return CastToJavaShortNode.fromIntErr(arg0Value, arg1Value_, this.raiseNode);
            }
            if (arg1Value instanceof Long) {
                long arg1Value_ = (long) arg1Value;
                state_0 = state_0 & 0xffffffef /* remove SpecializationActive[CastToJavaShortNode.fromLong(long)] */;
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[CastToJavaShortNode.fromLongErr(Node, long, PRaiseNode)] */;
                this.state_0_.set(arg0Value, state_0);
                return CastToJavaShortNode.fromLongErr(arg0Value, arg1Value_, this.raiseNode);
            }
            if (arg1Value instanceof PInt) {
                PInt arg1Value_ = (PInt) arg1Value;
                state_0 = state_0 & 0xffffff7f /* remove SpecializationActive[CastToJavaShortNode.fromPInt(PInt)] */;
                state_0 = state_0 | 0b1000000000 /* add SpecializationActive[CastToJavaShortNode.fromPIntErr(Node, PInt, PRaiseNode)] */;
                this.state_0_.set(arg0Value, state_0);
                return CastToJavaShortNode.fromPIntErr(arg0Value, arg1Value_, this.raiseNode);
            }
            throw newUnsupportedSpecializationException2(this, arg0Value, arg1Value);
        }

    }
    @GeneratedBy(CastToJavaShortNode.class)
    @DenyReplace
    private static final class Uncached extends CastToJavaShortNode implements UnadoptableNode {

        @TruffleBoundary
        @Override
        public short execute(Node arg0Value, Object arg1Value) {
            if (arg1Value instanceof Short) {
                short arg1Value_ = (short) arg1Value;
                return CastToJavaShortNode.fromShort(arg1Value_);
            }
            if (arg1Value instanceof Integer) {
                int arg1Value_ = (int) arg1Value;
                try {
                    return CastToJavaShortNode.fromInt(arg1Value_);
                } catch (OverflowException ex) {
                }
            }
            if (arg1Value instanceof Long) {
                long arg1Value_ = (long) arg1Value;
                try {
                    return CastToJavaShortNode.fromLong(arg1Value_);
                } catch (OverflowException ex) {
                }
            }
            if (arg1Value instanceof PInt) {
                PInt arg1Value_ = (PInt) arg1Value;
                try {
                    return CastToJavaShortNode.fromPInt(arg1Value_);
                } catch (ArithmeticException ex) {
                }
            }
            if (arg1Value instanceof Integer) {
                int arg1Value_ = (int) arg1Value;
                return CastToJavaShortNode.fromIntErr(arg0Value, arg1Value_, (PRaiseNode.getUncached()));
            }
            if (arg1Value instanceof Long) {
                long arg1Value_ = (long) arg1Value;
                return CastToJavaShortNode.fromLongErr(arg0Value, arg1Value_, (PRaiseNode.getUncached()));
            }
            if (arg1Value instanceof PInt) {
                PInt arg1Value_ = (PInt) arg1Value;
                return CastToJavaShortNode.fromPIntErr(arg0Value, arg1Value_, (PRaiseNode.getUncached()));
            }
            throw newUnsupportedSpecializationException2(this, arg0Value, arg1Value);
        }

        @TruffleBoundary
        @Override
        public short execute(Node arg0Value, int arg1Value) {
            try {
                return CastToJavaShortNode.fromInt(arg1Value);
            } catch (OverflowException ex) {
            }
            return CastToJavaShortNode.fromIntErr(arg0Value, arg1Value, (PRaiseNode.getUncached()));
        }

        @TruffleBoundary
        @Override
        public short execute(Node arg0Value, long arg1Value) {
            try {
                return CastToJavaShortNode.fromLong(arg1Value);
            } catch (OverflowException ex) {
            }
            return CastToJavaShortNode.fromLongErr(arg0Value, arg1Value, (PRaiseNode.getUncached()));
        }

        @TruffleBoundary
        @Override
        public short execute(Node arg0Value, short arg1Value) {
            return CastToJavaShortNode.fromShort(arg1Value);
        }

    }
}
